/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.DefaultComparator;
import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.template.TemplateSequenceModel;
import java.util.Iterator;
import java.util.function.Function;

public class SequenceContainsBuiltIn
extends ExpressionEvaluatingBuiltIn {
    @Override
    public Object get(Environment env, BuiltInExpression caller, Object model) {
        if (!(model instanceof TemplateSequenceModel) && !(model instanceof Iterable)) {
            throw TemplateNode.invalidTypeException(model, caller.getTarget(), env, "sequence or collection");
        }
        return new SequenceContainsFunction(model);
    }

    static class SequenceContainsFunction
    implements Function<Object, Boolean> {
        final Iterable collection;

        SequenceContainsFunction(Object seqModel) {
            if (!(seqModel instanceof Iterable)) {
                throw new AssertionError();
            }
            this.collection = (Iterable)seqModel;
        }

        @Override
        public Boolean apply(Object arg) {
            Object compareToThis = arg;
            DefaultComparator modelComparator = new DefaultComparator(Environment.getCurrentEnvironment());
            Iterator it = this.collection.iterator();
            while (it.hasNext()) {
                if (!modelComparator.areEqual(it.next(), compareToThis)) continue;
                return true;
            }
            return false;
        }
    }
}

