/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.variables.InvalidReferenceException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class NumericalCast
extends ExpressionEvaluatingBuiltIn {
    private static final BigDecimal half = new BigDecimal("0.5");
    private static final MathContext mc = new MathContext(0, RoundingMode.FLOOR);

    @Override
    public Object get(Environment env, BuiltInExpression caller, Object model) {
        try {
            return this.getNumber((Number)model, caller.getName());
        }
        catch (ClassCastException cce) {
            throw TemplateNode.invalidTypeException(model, caller.getTarget(), env, "number");
        }
        catch (NullPointerException npe) {
            throw new InvalidReferenceException("Undefined number", env);
        }
    }

    private Number getNumber(Number num, String builtInName) {
        if (builtInName == "int") {
            return num.intValue();
        }
        if (builtInName == "double") {
            return num.doubleValue();
        }
        if (builtInName == "long") {
            return num.longValue();
        }
        if (builtInName == "float") {
            return Float.valueOf(num.floatValue());
        }
        if (builtInName == "byte") {
            return num.byteValue();
        }
        if (builtInName == "short") {
            return num.shortValue();
        }
        if (builtInName == "floor") {
            return BigDecimal.valueOf(num.doubleValue()).divide(BigDecimal.ONE, 0, RoundingMode.FLOOR);
        }
        if (builtInName == "ceiling") {
            return BigDecimal.valueOf(num.doubleValue()).divide(BigDecimal.ONE, 0, RoundingMode.CEILING);
        }
        if (builtInName == "round") {
            return BigDecimal.valueOf(num.doubleValue()).add(half, mc).divide(BigDecimal.ONE, 0, RoundingMode.FLOOR);
        }
        throw new InternalError("The only numerical cast built-ins available are ?int, ?long, ?short, ?byte, ?float, ?double, ?floor, ?ceiling, and ?round.");
    }
}

