/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.variables.Wrap;
import freemarker.core.variables.WrappedNode;
import java.util.ArrayList;

public abstract class NodeFunctions
extends ExpressionEvaluatingBuiltIn {
    @Override
    public Object get(Environment env, BuiltInExpression caller, Object model) {
        if (!(model instanceof WrappedNode)) {
            throw TemplateNode.invalidTypeException(model, caller.getTarget(), env, "node");
        }
        return this.apply(env, (WrappedNode)model);
    }

    public abstract Object apply(Environment var1, WrappedNode var2);

    public static class Ancestors
    extends NodeFunctions {
        @Override
        public Object apply(Environment env, WrappedNode node) {
            ArrayList<WrappedNode> result = new ArrayList<WrappedNode>();
            for (WrappedNode parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
                result.add(parent);
            }
            return result;
        }
    }

    public static class NodeType
    extends NodeFunctions {
        @Override
        public Object apply(Environment env, WrappedNode node) {
            String nt = node.getNodeType();
            return nt == null ? Wrap.JAVA_NULL : nt;
        }
    }

    public static class NodeNamespace
    extends NodeFunctions {
        @Override
        public Object apply(Environment env, WrappedNode node) {
            String ns = node.getNodeNamespace();
            return ns == null ? Wrap.JAVA_NULL : ns;
        }
    }

    public static class NodeName
    extends NodeFunctions {
        @Override
        public Object apply(Environment env, WrappedNode node) {
            return node.getNodeName();
        }
    }

    public static class Root
    extends NodeFunctions {
        @Override
        public Object apply(Environment env, WrappedNode node) {
            WrappedNode parent;
            while ((parent = node.getParentNode()) != null) {
                node = parent;
            }
            return node;
        }
    }

    public static class Children
    extends NodeFunctions {
        @Override
        public Object apply(Environment env, WrappedNode node) {
            return node.getChildNodes();
        }
    }

    public static class Parent
    extends NodeFunctions {
        @Override
        public Object apply(Environment env, WrappedNode node) {
            return node.getParentNode();
        }
    }
}

