/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateHashModel;
import java.util.ArrayList;
import java.util.Map;

public abstract class HashBuiltin
extends ExpressionEvaluatingBuiltIn {
    @Override
    public Object get(Environment env, BuiltInExpression caller, Object lhs) {
        if (!(lhs instanceof TemplateHashModel) && !Wrap.isMap(lhs)) {
            throw TemplateNode.invalidTypeException(lhs, caller.getTarget(), env, "hash");
        }
        return this.apply(Wrap.unwrap(lhs));
    }

    public abstract Iterable apply(Object var1);

    public static class Values
    extends HashBuiltin {
        @Override
        public Iterable apply(Object hash) {
            if (hash instanceof TemplateHashModel) {
                return ((TemplateHashModel)hash).values();
            }
            return new ArrayList(((Map)hash).values());
        }
    }

    public static class Keys
    extends HashBuiltin {
        @Override
        public Iterable apply(Object hash) {
            if (hash instanceof Map) {
                return new ArrayList(((Map)hash).keySet());
            }
            return ((TemplateHashModel)hash).keys();
        }
    }
}

