/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.ParentheticalExpression;
import freemarker.core.variables.InvalidReferenceException;
import freemarker.core.variables.VarArgsFunction;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateHashModel;
import java.util.Map;

public abstract class ExistenceBuiltIn
implements BuiltIn {
    @Override
    public Object get(Environment env, BuiltInExpression caller) {
        Expression target = caller.getTarget();
        try {
            return this.apply(target.evaluate(env));
        }
        catch (InvalidReferenceException e) {
            if (!(target instanceof ParentheticalExpression)) {
                throw e;
            }
            return this.apply(null);
        }
    }

    public abstract Object apply(Object var1);

    private static class FirstDefined
    implements VarArgsFunction {
        static final FirstDefined INSTANCE = new FirstDefined();

        private FirstDefined() {
        }

        public Object apply(Object ... args) {
            for (Object arg : args) {
                if (arg == null || arg == Wrap.JAVA_NULL) continue;
                return arg;
            }
            return null;
        }
    }

    public static class IsDefinedBuiltIn
    extends ExistenceBuiltIn {
        @Override
        public Object apply(Object model) {
            return model != null;
        }
    }

    public static class HasContentBuiltIn
    extends ExistenceBuiltIn {
        @Override
        public Object apply(Object value) {
            if (value == null || value == Wrap.JAVA_NULL || value == Wrap.NOTHING) {
                return false;
            }
            if (Wrap.isIterable(value)) {
                return Wrap.asIterator(value).hasNext();
            }
            if (value instanceof Map) {
                return !((Map)value).isEmpty();
            }
            if (value instanceof TemplateHashModel) {
                return !((TemplateHashModel)value).isEmpty();
            }
            return value.toString().length() > 0;
        }
    }

    public static class ExistsBuiltIn
    extends ExistenceBuiltIn {
        @Override
        public Object apply(Object model) {
            return model != null && model != Wrap.JAVA_NULL;
        }
    }

    public static class IfExistsBuiltIn
    extends ExistenceBuiltIn {
        @Override
        public Object apply(Object model) {
            return model == null || model == Wrap.JAVA_NULL ? Wrap.NOTHING : model;
        }
    }

    public static final class DefaultBuiltIn
    extends ExistenceBuiltIn {
        @Override
        public Object apply(Object value) {
            if (value == null || value == Wrap.JAVA_NULL) {
                return FirstDefined.INSTANCE;
            }
            return arg -> value;
        }
    }
}

