/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.variables.Wrap;

public class DefaultComparator {
    private final ArithmeticEngine arithmeticEngine;

    public DefaultComparator(Environment env) {
        this.arithmeticEngine = env.getArithmeticEngine();
    }

    public boolean areEqual(Object left, Object right) {
        if (left == Wrap.JAVA_NULL || right == Wrap.JAVA_NULL) {
            return left == right;
        }
        left = Wrap.unwrap(left);
        right = Wrap.unwrap(right);
        if (left instanceof Number && right instanceof Number) {
            return this.arithmeticEngine.compareNumbers((Number)left, (Number)right) == 0;
        }
        return left.equals(right);
    }
}

