/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.variables.DateWrapper;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.VarArgsFunction;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class DateTime
extends ExpressionEvaluatingBuiltIn {
    private final int dateType;

    public DateTime(int dateType) {
        this.dateType = dateType;
    }

    @Override
    public Object get(Environment env, BuiltInExpression caller, Object model) {
        if (model instanceof TemplateDateModel) {
            TemplateDateModel dmodel = (TemplateDateModel)model;
            int dtype = dmodel.getDateType();
            if (this.dateType == dtype) {
                return dmodel;
            }
            if (dtype == 0 || dtype == 3) {
                return new DateWrapper(dmodel.getAsDate(), this.dateType);
            }
            throw new TemplateException("Cannot convert " + TemplateDateModel.TYPE_NAMES.get(dtype) + " into " + TemplateDateModel.TYPE_NAMES.get(this.dateType), env);
        }
        return new DateParser(model.toString(), this.dateType, caller, env);
    }

    static class DateParser
    implements TemplateDateModel,
    VarArgsFunction,
    TemplateHashModel {
        private final String text;
        private final Environment env;
        private final DateFormat defaultFormat;
        private BuiltInExpression caller;
        private int dateType;
        private Date cachedValue;

        DateParser(String text, int dateType, BuiltInExpression caller, Environment env) {
            this.text = text;
            this.env = env;
            this.caller = caller;
            this.dateType = dateType;
            this.defaultFormat = env.getDateFormatObject(dateType);
        }

        @Override
        public Date getAsDate() {
            if (this.cachedValue == null) {
                this.cachedValue = this.parse(this.defaultFormat);
            }
            return this.cachedValue;
        }

        @Override
        public int getDateType() {
            return this.dateType;
        }

        @Override
        public Object get(String pattern) {
            return new DateWrapper(this.parse(this.env.getDateFormatObject(this.dateType, pattern)), this.dateType);
        }

        public Object apply(Object ... arguments) {
            if (arguments.length != 1) {
                throw new EvaluationException("string?" + this.caller.getName() + "(...) requires exactly 1 argument.");
            }
            return this.get((String)arguments[0]);
        }

        private Date parse(DateFormat df) {
            try {
                return df.parse(this.text);
            }
            catch (ParseException e) {
                String mess = "Error: " + this.caller.getLocation() + "\nExpecting a date here, found: " + this.text;
                throw new EvaluationException(mess);
            }
        }
    }
}

