// Generated by ${generated_by}. Do not edit.
// ReSharper disable InconsistentNaming
[#var csPackage = globals.getPreprocessorSymbol('cs.package', settings.parserPackage) ]
namespace ${csPackage} {
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Text;

    public class BitSet {
        private const uint BitsInWord = 64;

        private readonly int _nints;
        private readonly int _nbits;
        private readonly ulong[] _words;

        public int Length => _nbits;

        public BitSet(int bits) {
            _nbits = bits;
            _nints = (int) Math.Ceiling((double) bits / BitsInWord);
            _words = new ulong[_nints];
        }

        public bool IsEmpty {
            get {
                for (var i = 0; i < _nints; i++) {
                    if (_words[i] != 0) {
                        return false;
                    }
                }
                return true;
            }
        }

        public void Clear(int from = -1, int to = -1) {
            if (from < 0) {
                for (var i = 0; i < _nints; i++) {
                    _words[i] = 0;
                }
            }
            else {
                Debug.Assert(from < _nbits);
                Debug.Assert(to <= _nbits);
                Debug.Assert(from < to);
                var idx1 = from / BitsInWord;
                var bit1 = from % BitsInWord;
                var idx2 = --to / BitsInWord;
                var bit2 = to % BitsInWord;

                if ((idx1 == idx2) && (bit1 == bit2)) {
                    // just 1 bit to do
                    var mask1 = 1UL << (int) bit1;
                    _words[idx1] &= ~mask1;
                }
                else if (idx1 == idx2) {
                    // just one int to do
                    var mask1 = (1UL << (int) bit1) - 1;
                    var mask2 = (~((1UL << (int) bit2) - 1)) << 1;
                    _words[idx1] &= (mask1 | mask2);
                }
                else {
                    var mask1 = (1UL << (int) bit1) - 1;
                    var mask2 = (~((1UL << (int) bit2) - 1)) << 1;
                    _words[idx1] &= mask1;
                    _words[idx2] &= mask2;
                    // any in between first and last get zeroed
                    while (++idx1 < idx2) {
                        _words[idx1] = 0;
                    }
                }
            }
        }

        public void Set(int pos, bool value = true) {
            Debug.Assert(pos >= 0 && pos < _nbits);
            var idx = pos / BitsInWord;
            var bit = pos % BitsInWord;
            var mask = 1UL << (int) bit;
            if (value) {
                _words[idx] |= mask;
            }
            else {
                _words[idx] &= ~mask;
            }
        }

        public int NextSetBit(int pos) {
            Debug.Assert(pos >= 0);
            if (pos >= _nbits) {
                return -1;
            }
            var idx = pos / BitsInWord;
            var bit = pos % BitsInWord;
            var mask = 1UL << (int) bit;
            if ((_words[idx] & mask) != 0) {
                return pos;
            }
            for (;;) {
                var v = (long) (_words[idx] & ~(mask - 1));
                if (v == 0) {
                    idx++;
                    if (idx >= _nints) {
                        return -1;
                    }
                    mask = 1;
                    continue;
                }
                v &= -v;
                var uv = (ulong) v;
                int result = 0;
                while (uv != 1) {
                    result++;
                    uv >>= 1;
                }
                return result + (int) (BitsInWord * idx);
            }
        }

        public int PreviousSetBit(int pos) {
            Debug.Assert(pos < _nbits);
            if (pos < 0) {
                return -1;
            }

            var idx = pos / BitsInWord;
            var bit = pos % BitsInWord;
            var mask = 1UL << (int) bit;
            if ((_words[idx] & mask) != 0) {
                return pos;
            }
            mask = (bit == (BitsInWord - 1)) ? 0 : ~((mask << 1) - 1);
            for (;;) {
                var v = _words[idx] & ~mask;  // mask off higher bits
                if (v == 0) {
                    idx--;
                    if (idx < 0) {
                        return -1;
                    }
                    mask = 0;
                    continue;
                }
                int result = 0;
                while ((v >>= 1) != 0) {
                    result++;
                }
                return result + (int) (BitsInWord * idx);
            }
        }

        public bool this[int pos] {
            get {
                Debug.Assert(pos >= 0 && pos < _nbits, $"out of range: {pos} (should be in 0 .. {_nbits})");
                var idx = pos / BitsInWord;
                var bit = pos % BitsInWord;
                var mask = 1UL << (int) bit;
                return (_words[idx] & mask) != 0;
            }
        }
    }

[#var ENSURE_FINAL_EOL = settings.ensureFinalEOL?string("true", "false")]
[#var PRESERVE_LINE_ENDINGS = settings.preserveLineEndings?string("true","false")]
[#var JAVA_UNICODE_ESCAPE = settings.javaUnicodeEscape?string("true", "false")]

    public static class Utils {

        public static void AddRange<T>(this IList<T> list1, IEnumerable<T> list2) {
            foreach (var item in list2) {
                list1.Add(item);
            }
        }

        public static void AddRange<T>(this ListAdapter<T> list1, IEnumerable<T> list2) {
            foreach (var item in list2) {
                list1.Add(item);
            }
        }

        public static HashSet<T> EnumSet<T>(params T[] values) where T : struct, Enum {
            var result = new HashSet<T>();

            foreach(T v in values) {
                result.Add(v);
            }
            return result;
        }

        public static int MaxOf(params int[] values) {
            int result = 0;

            foreach (int i in values) {
                if (result < i) {
                    result = i;
                }
            }
            return result;
        }

        internal static string DisplayChar(int ch) {
            if (ch == '\'') return "\'\\'\'";
            if (ch == '\\') return "\'\\\\\'";
            if (ch == '\t') return "\'\\t\'";
            if (ch == '\r') return "\'\\r\'";
            if (ch == '\n') return "\'\\n\'";
            if (ch == '\f') return "\'\\f\'";
            if (ch == ' ') return "\' \'";
            char c = (char) ch;
            if (c < 128 && !char.IsWhiteSpace(c) && !char.IsControl(c)) return $"\'{c}\'";
            return "0x" + ch.ToString("X4");
        }

        internal static string AddEscapes(string str) {
            StringBuilder result = new StringBuilder();
            foreach (char ch in str) {
                switch (ch) {
                case '\b':
                    result.Append("\\b");
                    continue;
                case '\t':
                    result.Append("\\t");
                    continue;
                case '\n':
                    result.Append("\\n");
                    continue;
                case '\f':
                    result.Append("\\f");
                    continue;
                case '\r':
                    result.Append("\\r");
                    continue;
                case '\"':
                    result.Append("\\\"");
                    continue;
                case '\'':
                    result.Append("\\\'");
                    continue;
                case '\\':
                    result.Append("\\\\");
                    continue;
                default:
                    if (char.IsControl(ch)) {
                        string s = ((int) ch).ToString("X4");
                        result.Append("\\u");
                        result.Append(s);
                    } else {
                        result.Append(ch);
                    }
                    continue;
                }
            }
            return result.ToString();
        }

        internal static T Pop<T>(this IList<T> list) {
            int n = list.Count - 1;
            Debug.Assert(n >= 0);
            var result = list[n];
            list.RemoveAt(n);
            return result;
        }

        private static readonly Dictionary<TokenType[], HashSet<TokenType>> SetCache = new Dictionary<TokenType[], HashSet<TokenType>>();

        public static HashSet<TokenType> GetOrMakeSet(params TokenType[] types) {
            HashSet<TokenType> result;

            if (SetCache.ContainsKey(types)) {
                result = SetCache[types];
            }
            else {
                result = EnumSet(types);
                SetCache[types] = result;
            }
            return result;
        }

        public static void AddRange<T>(this HashSet<T> set, IEnumerable<T> source) {
            foreach(T item in source) {
                set.Add(item);
            }
        }
    }

[#if unwanted!false]
    public enum LogLevel {
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        CRITICAL
    }

    public class LogInfo {
        public LogLevel Level { get; private set; }
        public string Message { get; private set; }
        public object[] Arguments { get; private set; }

        public LogInfo(LogLevel level, string message, params object[] arguments) {
            Level = level;
            Message = message;
            Arguments = arguments;
        }

        public string Format() {
            return (Arguments.Length == 0) ? Message : string.Format(Message, Arguments);
        }
    }

    internal class Unsubscriber<T> : IDisposable {
        private IList<IObserver<T>>_observers;
        private IObserver<T> _observer;

        public Unsubscriber(IList<IObserver<T>> observers, IObserver<T> observer) {
            _observers = observers;
            _observer = observer;
        }

        public void Dispose() {
            if (_observer != null && _observers.Contains(_observer)) {
                _observers.Remove(_observer);
            }
        }
   }

[/#if]
    //
    // Emulation of the Java interface / implementation
    //
    public interface Iterator<T> {
        bool HasNext();
        bool HasPrevious();
        T Next();
        T Previous();
    }

    internal class ListIterator<T> : Iterator<T> {
        private readonly IList<T> _list;
        private readonly int _count;
        private int _pos;

        public ListIterator(IList<T> list, int pos = 0) {
            _list = list;
            _count = list.Count;
            Debug.Assert(pos <= _count);
            _pos = pos;
        }

        public bool HasNext() => _pos < _count;

        public bool HasPrevious() => _pos > 0;

        public T Next() {
            Debug.Assert(HasNext());
            return _list[_pos++];
        }

        public T Previous() {
            Debug.Assert(HasPrevious());
            return _list[--_pos];
        }
    }

    internal class ForwardIterator<T> {
        private readonly ListIterator<T> _iter1, _iter2;

        public ForwardIterator(IList<T> list1, IList<T> list2) {
            _iter1 = new ListIterator<T>(list1);
            _iter2 = new ListIterator<T>(list2);
        }

        public bool HasNext()  => _iter1.HasNext() || _iter2.HasNext();

        public T Next() => _iter1.HasNext() ? _iter1.Next() : _iter2.Next();

        public bool HasPrevious() => _iter2.HasPrevious() || _iter1.HasPrevious();

        public T Previous() => _iter2.HasPrevious()  ? _iter2.Previous() : _iter1.Previous();
    }

    internal class BackwardIterator<T> {
        private readonly ListIterator<T> _iter1, _iter2;

        public BackwardIterator(IList<T> list1, IList<T> list2) {
            _iter1 = new ListIterator<T>(list1, list1.Count);
            _iter2 = new ListIterator<T>(list2, list2.Count);
        }

        public bool HasNext()  => _iter2.HasPrevious() || _iter1.HasPrevious();

        public T Next() => _iter2.HasPrevious() ? _iter2.Previous() : _iter1.Previous();

        public bool HasPrevious() => _iter1.HasNext() || _iter2.HasNext();

        public T Previous() => _iter1.HasNext()  ? _iter1.Next() : _iter2.Next();
    }

    public class GenWrapper<T> : Iterator<T> {
        private IEnumerator<T> enumerator;
        private bool hasNext;

        public GenWrapper(IEnumerable<T> e) {
            enumerator = e.GetEnumerator();
            hasNext = enumerator.MoveNext();
        }

        public bool HasNext() {
            return hasNext;
        }

        public bool HasPrevious() {
            return false;
        }

        public T Next() {
            T result = enumerator.Current;
            hasNext = enumerator.MoveNext();
            return result;
        }

        public T Previous() {
            return default(T);
        }
    }

    public class ListAdapter<T> : List<T> {
        public ListAdapter() {}
        public ListAdapter(int capacity) {}
        public ListAdapter(IEnumerable<T> other) : base(other) {}

        public void Remove(int index) {
            RemoveAt(index);
        }
    }

/*
    public class SetAdapter<T> : HashSet<T> {
        public SetAdapter() : base() {}
        public SetAdapter(IEnumerable<T> source) : base(source) {}
        public void AddRange(IEnumerable<T> source) {
            foreach(T item in source) {
                Add(item);
            }
        }
    }
 */
/*

# Any stuff below is for debugging only ... to be deleted later
[#var cases = [
  "a = b ? c : d",
  "currentLookaheadToken || lastConsumedToken",
  "TokenType.STRICTFP",
  "!(getToken(1).getImage().equals(\"yield\")&&isInProduction(\"SwitchExpression\"))",
  "foo.toString()",
  "lhs.isAssignableTo()",
  "lhs.isMethodCall()||lhs.isConstructorInvocation()||lhs.isAllocation()",
  "isParserTolerant()||permissibleModifiers.contains(getToken(1).getType())",
  "currentLookaheadToken==null&&!((Expression)peekNode()).isAssignableTo()",
  "currentLookaheadToken!=null||((Expression)peekNode()).isAssignableTo()",
  "getToken(1).getType()!=TokenType._DEFAULT"
] ]
[#list cases as case]
# "${case}" -> ${globals.translateString(case)}
[/#list]
[#-- list globals.sortedNodeClassNames as cn]
# ${cn}
[/#list --]
*/
}
