/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.python;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.congocc.parser.Node;
import org.congocc.parser.TokenSource;
import org.congocc.parser.python.InvalidToken;
import org.congocc.parser.python.PythonToken;
import org.congocc.parser.python.ast.DedentToken;
import org.congocc.parser.python.ast.IndentToken;

public class PythonLexer
extends TokenSource {
    private PythonToken danglingIndentation;
    private int bracketNesting;
    private int parenthesesNesting;
    private int braceNesting;
    private List<Integer> indentationStack = PythonLexer.initIndentationStack();
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<PythonToken.TokenType> activeTokenTypes = EnumSet.allOf(PythonToken.TokenType.class);
    static final EnumSet<PythonToken.TokenType> regularTokens = EnumSet.of(PythonToken.TokenType.EOF, new PythonToken.TokenType[]{PythonToken.TokenType.NEWLINE, PythonToken.TokenType.ASSIGN, PythonToken.TokenType.AT, PythonToken.TokenType.COLON, PythonToken.TokenType.COMMA, PythonToken.TokenType.EQ, PythonToken.TokenType.LBRACE, PythonToken.TokenType.RBRACE, PythonToken.TokenType.LBRACKET, PythonToken.TokenType.RBRACKET, PythonToken.TokenType.LPAREN, PythonToken.TokenType.RPAREN, PythonToken.TokenType.SEMICOLON, PythonToken.TokenType.STAR, PythonToken.TokenType.STAR_STAR, PythonToken.TokenType.MINUSASSIGN, PythonToken.TokenType.PLUSASSIGN, PythonToken.TokenType.STARASSIGN, PythonToken.TokenType.ATASSIGN, PythonToken.TokenType.SLASHASSIGN, PythonToken.TokenType.REMASSIGN, PythonToken.TokenType.ANDASSIGN, PythonToken.TokenType.ORASSIGN, PythonToken.TokenType.XORASSIGN, PythonToken.TokenType.LSHIFTASSIGN, PythonToken.TokenType.RSHIFTASSIGN, PythonToken.TokenType.STARSTARASSIGN, PythonToken.TokenType.SLASHSLASHASSIGN, PythonToken.TokenType.BIT_AND, PythonToken.TokenType.BIT_OR, PythonToken.TokenType.XOR, PythonToken.TokenType.TILDE, PythonToken.TokenType.COLONEQUALS, PythonToken.TokenType.DOT, PythonToken.TokenType.ELLIPSIS, PythonToken.TokenType.LE, PythonToken.TokenType.GE, PythonToken.TokenType.NE, PythonToken.TokenType.GT, PythonToken.TokenType.LT, PythonToken.TokenType.MINUS, PythonToken.TokenType.PLUS, PythonToken.TokenType.SLASH, PythonToken.TokenType.SLASHSLASH, PythonToken.TokenType.PERCENT, PythonToken.TokenType.LSHIFT, PythonToken.TokenType.RSHIFT, PythonToken.TokenType.HOOK, PythonToken.TokenType.RARROW, PythonToken.TokenType.AND, PythonToken.TokenType.AS, PythonToken.TokenType._ASSERT, PythonToken.TokenType.ASYNC, PythonToken.TokenType.AWAIT, PythonToken.TokenType.BREAK, PythonToken.TokenType.CASE, PythonToken.TokenType.CLASS, PythonToken.TokenType.CONTINUE, PythonToken.TokenType.DEF, PythonToken.TokenType.DEL, PythonToken.TokenType.EXCEPT, PythonToken.TokenType.FINALLY, PythonToken.TokenType.FOR, PythonToken.TokenType.FROM, PythonToken.TokenType.GLOBAL, PythonToken.TokenType.IF, PythonToken.TokenType.IN, PythonToken.TokenType.IS, PythonToken.TokenType.ELIF, PythonToken.TokenType.ELSE, PythonToken.TokenType.FALSE, PythonToken.TokenType.IMPORT, PythonToken.TokenType.LAMBDA, PythonToken.TokenType.MATCH, PythonToken.TokenType.NONLOCAL, PythonToken.TokenType.NONE, PythonToken.TokenType.NOT, PythonToken.TokenType.OR, PythonToken.TokenType.PASS, PythonToken.TokenType.PEG_PARSER, PythonToken.TokenType.RAISE, PythonToken.TokenType.RETURN, PythonToken.TokenType.TRUE, PythonToken.TokenType.TRY, PythonToken.TokenType.WHILE, PythonToken.TokenType.WITH, PythonToken.TokenType.YIELD, PythonToken.TokenType.DECNUMBER, PythonToken.TokenType.BADDECNUMBER, PythonToken.TokenType.HEXNUMBER, PythonToken.TokenType.OCTNUMBER, PythonToken.TokenType.BINNUMBER, PythonToken.TokenType.FLOAT, PythonToken.TokenType.COMPLEX, PythonToken.TokenType.STRING_LITERAL, PythonToken.TokenType.NAME, PythonToken.TokenType.BADNAME});
    static final EnumSet<PythonToken.TokenType> unparsedTokens = EnumSet.of(PythonToken.TokenType.CONTINUE_LINE, PythonToken.TokenType.COMMENT);
    static final EnumSet<PythonToken.TokenType> skippedTokens = EnumSet.of(PythonToken.TokenType.SPACE);
    private static final EnumSet<PythonToken.TokenType> moreTokens = EnumSet.noneOf(PythonToken.TokenType.class);
    private static NfaFunction[] nfaFunctions;

    private static List<Integer> initIndentationStack() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(1);
        return result;
    }

    private PythonToken tokenHook$PythonLexer_ccc$32$29(PythonToken tok) {
        int indentation;
        boolean lineJoiningOn = this.bracketNesting > 0 || this.parenthesesNesting > 0 || this.braceNesting > 0;
        PythonToken.TokenType type = tok.getType();
        switch (type) {
            case LBRACE: {
                ++this.braceNesting;
                break;
            }
            case RBRACE: {
                --this.braceNesting;
                break;
            }
            case LPAREN: {
                ++this.parenthesesNesting;
                break;
            }
            case RPAREN: {
                --this.parenthesesNesting;
                break;
            }
            case LBRACKET: {
                ++this.bracketNesting;
                break;
            }
            case RBRACKET: {
                --this.bracketNesting;
                break;
            }
            case NEWLINE: {
                if (lineJoiningOn || tok.startsLine()) {
                    tok.setUnparsed(true);
                }
                return tok;
            }
        }
        if (this.danglingIndentation != null) {
            tok.preInsert(this.danglingIndentation);
        }
        if (lineJoiningOn || tok.isUnparsed() || this.danglingIndentation == null && !tok.startsLine()) {
            return tok;
        }
        this.danglingIndentation = null;
        int beginColumn = tok.getBeginColumn();
        if (beginColumn > (indentation = this.indentationStack.get(this.indentationStack.size() - 1).intValue())) {
            this.indentationStack.add(beginColumn);
            return IndentToken.makeIndentToken(tok, this, this.indentationStack);
        }
        if (beginColumn < indentation) {
            return this.handleDedent(tok, beginColumn);
        }
        return tok;
    }

    private PythonToken handleDedent(PythonToken tok, int offset) {
        int dedentIndex = this.indentationStack.indexOf(offset);
        if (dedentIndex < 0) {
            InvalidToken invalidDedent = new InvalidToken(this, 0, 0);
            invalidDedent.setImage("Invalid Dedent");
            tok.preInsert(invalidDedent);
            return invalidDedent;
        }
        PythonToken firstDedent = null;
        for (int i = this.indentationStack.size() - 1; i > dedentIndex; --i) {
            int dedentAmount = this.indentationStack.get(i) - this.indentationStack.get(i - 1);
            this.indentationStack.remove(i);
            PythonToken dedent = DedentToken.makeDedentToken(tok, this, this.indentationStack, dedentAmount);
            if (firstDedent != null) continue;
            firstDedent = dedent;
        }
        return firstDedent;
    }

    private void resetTokenHook$PythonLexer_ccc$85$17(PythonToken tok) {
        this.parenthesesNesting = 0;
        this.bracketNesting = 0;
        this.braceNesting = 0;
        if (tok.getType() == PythonToken.TokenType.INDENT || tok.getType() == PythonToken.TokenType.DEDENT) {
            this.danglingIndentation = tok;
            this.indentationStack = tok.getIndents();
            return;
        }
        Iterator<PythonToken> toks = tok.precedingTokens();
        while (toks.hasNext()) {
            PythonToken previous = toks.next();
            PythonToken.TokenType prevType = previous.getType();
            switch (prevType) {
                case LBRACE: {
                    ++this.braceNesting;
                    break;
                }
                case RBRACE: {
                    --this.braceNesting;
                    break;
                }
                case LPAREN: {
                    ++this.parenthesesNesting;
                    break;
                }
                case RPAREN: {
                    --this.parenthesesNesting;
                    break;
                }
                case LBRACKET: {
                    ++this.bracketNesting;
                    break;
                }
                case RBRACKET: {
                    --this.bracketNesting;
                    break;
                }
                case INDENT: 
                case DEDENT: {
                    this.indentationStack = previous.getIndents();
                    return;
                }
            }
        }
    }

    public PythonLexer(CharSequence input) {
        this("input", input);
    }

    public PythonLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.PYTHON, 1, 1);
    }

    public PythonLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, false, false, "");
        this.activeTokenTypes.remove(PythonToken.TokenType.MATCH);
        this.activeTokenTypes.remove(PythonToken.TokenType.CASE);
        regularTokens.add(PythonToken.TokenType.INDENT);
        regularTokens.add(PythonToken.TokenType.DEDENT);
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public PythonToken getNextToken(PythonToken tok) {
        if (tok == null) {
            tok = this.tokenizeAt(0);
            this.cacheToken(tok);
            return tok;
        }
        PythonToken cachedToken = tok.nextCachedToken();
        if (cachedToken != null && this.activeTokenTypes != null && !this.activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            PythonToken token = this.tokenizeAt(tok.getEndOffset());
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<PythonToken.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions) {
        if (position >= input.length()) {
            return new MatchInfo(PythonToken.TokenType.EOF, 0);
        }
        int start = position;
        int matchLength = 0;
        PythonToken.TokenType matchedType = PythonToken.TokenType.INVALID;
        BitSet currentStates = new BitSet(585);
        BitSet nextStates = new BitSet(585);
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                PythonToken.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        return new MatchInfo(matchedType, matchLength);
    }

    final PythonToken tokenizeAt(int position) {
        int tokenBeginOffset = position;
        boolean inMore = false;
        StringBuilder invalidChars = null;
        PythonToken matchedToken = null;
        PythonToken.TokenType matchedType = null;
        while (matchedToken == null) {
            if (!inMore) {
                tokenBeginOffset = position;
            }
            MatchInfo matchInfo = PythonLexer.getMatchInfo(this, position, this.activeTokenTypes, nfaFunctions);
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            if (matchedType == PythonToken.TokenType.INVALID) {
                if (invalidChars == null) {
                    invalidChars = new StringBuilder();
                }
                int cp = Character.codePointAt(this, tokenBeginOffset);
                invalidChars.appendCodePoint(cp);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidChars != null) {
                return new InvalidToken(this, tokenBeginOffset - invalidChars.length(), tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = PythonToken.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        matchedToken = this.tokenHook$PythonLexer_ccc$32$29(matchedToken);
        return matchedToken;
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(PythonToken t, LexicalState state) {
        this.resetTokenHook$PythonLexer_ccc$85$17(t);
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(PythonToken t) {
        this.reset(t, null);
    }

    void cacheToken(PythonToken tok) {
        if (tok.isInserted()) {
            PythonToken next = tok.nextCachedToken();
            if (next != null) {
                this.cacheToken(next);
            }
            return;
        }
        this.cacheTokenAt(tok, tok.getBeginOffset());
    }

    @Override
    protected void uncacheTokens(Node.TerminalNode lastToken) {
        super.uncacheTokens(lastToken);
        ((PythonToken)lastToken).unsetAppendedToken();
    }

    static /* synthetic */ NfaFunction[] access$302(NfaFunction[] x0) {
        nfaFunctions = x0;
        return x0;
    }

    static {
        PYTHON.NFA_FUNCTIONS_init();
    }

    private static class PYTHON {
        private static int[] NFA_MOVES_PYTHON_581 = PYTHON.NFA_MOVES_PYTHON_581_init();
        private static int[] NFA_MOVES_PYTHON_582 = PYTHON.NFA_MOVES_PYTHON_582_init();

        private PYTHON() {
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex0(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 12) {
                nextStates.set(137);
            } else if (ch == 32) {
                nextStates.set(137);
            } else if (ch == 33) {
                nextStates.set(85);
            } else if (ch == 34) {
                nextStates.set(62);
                nextStates.set(3);
            } else if (ch == 37) {
                nextStates.set(299);
            } else if (ch == 38) {
                nextStates.set(339);
            } else if (ch == 39) {
                nextStates.set(16);
                nextStates.set(7);
            } else if (ch == 42) {
                nextStates.set(238);
                nextStates.set(274);
                nextStates.set(287);
            } else if (ch == 43) {
                nextStates.set(252);
            } else if (ch == 45) {
                nextStates.set(297);
                nextStates.set(318);
            } else if (ch == 46) {
                nextStates.set(72);
                nextStates.set(159);
                nextStates.set(240);
            } else if (ch == 47) {
                nextStates.set(70);
                nextStates.set(271);
                nextStates.set(325);
            } else if (ch == 48) {
                nextStates.set(228);
                nextStates.set(306);
                nextStates.set(345);
                nextStates.set(354);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(9);
                nextStates.set(49);
                nextStates.set(125);
                nextStates.set(214);
                nextStates.set(217);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(303);
            } else if (ch == 58) {
                nextStates.set(284);
            } else if (ch == 60) {
                nextStates.set(183);
                nextStates.set(302);
                nextStates.set(327);
            } else if (ch == 61) {
                nextStates.set(112);
            } else if (ch == 62) {
                nextStates.set(176);
                nextStates.set(281);
                nextStates.set(310);
            } else if (ch == 63) {
                nextStates.set(295);
            } else if (ch == 64) {
                nextStates.set(79);
            } else if (ch == 66) {
                nextStates.set(36);
                nextStates.set(59);
                nextStates.set(111);
                nextStates.set(119);
                nextStates.set(131);
                nextStates.set(151);
                nextStates.set(165);
                nextStates.set(182);
                nextStates.set(166);
                nextStates.set(320);
                nextStates.set(329);
                nextStates.set(40);
            } else if (ch == 70) {
                nextStates.set(57);
                nextStates.set(60);
                nextStates.set(92);
                nextStates.set(118);
                nextStates.set(123);
                nextStates.set(6);
                nextStates.set(61);
                nextStates.set(210);
                nextStates.set(280);
                nextStates.set(2);
                nextStates.set(309);
                nextStates.set(15);
                nextStates.set(334);
            } else if (ch == 78) {
                nextStates.set(200);
            } else if (ch == 82) {
                nextStates.set(1);
                nextStates.set(15);
                nextStates.set(35);
                nextStates.set(138);
                nextStates.set(175);
                nextStates.set(2);
                nextStates.set(208);
                nextStates.set(234);
                nextStates.set(269);
                nextStates.set(270);
                nextStates.set(276);
                nextStates.set(283);
                nextStates.set(285);
                nextStates.set(294);
                nextStates.set(61);
                nextStates.set(298);
                nextStates.set(314);
                nextStates.set(6);
                nextStates.set(337);
                nextStates.set(353);
            } else if (ch == 84) {
                nextStates.set(315);
            } else if (ch == 85) {
                nextStates.set(61);
                nextStates.set(15);
                nextStates.set(2);
                nextStates.set(6);
            } else if (ch == 92) {
                nextStates.set(352);
            } else if (ch == 94) {
                nextStates.set(296);
            } else if (ch == 95) {
                nextStates.set(254);
            } else if (ch == 97) {
                nextStates.set(95);
                nextStates.set(113);
                nextStates.set(133);
                nextStates.set(330);
                nextStates.set(341);
            } else if (ch == 98) {
                nextStates.set(31);
                nextStates.set(39);
                nextStates.set(186);
                nextStates.set(119);
                nextStates.set(40);
                nextStates.set(233);
                nextStates.set(166);
                nextStates.set(273);
                nextStates.set(319);
                nextStates.set(321);
                nextStates.set(328);
                nextStates.set(336);
                nextStates.set(36);
            } else if (ch == 99) {
                nextStates.set(24);
                nextStates.set(134);
                nextStates.set(290);
            } else if (ch == 100) {
                nextStates.set(81);
                nextStates.set(322);
            } else if (ch == 101) {
                nextStates.set(177);
                nextStates.set(203);
                nextStates.set(311);
            } else if (ch == 102) {
                nextStates.set(5);
                nextStates.set(86);
                nextStates.set(93);
                nextStates.set(15);
                nextStates.set(122);
                nextStates.set(139);
                nextStates.set(150);
                nextStates.set(180);
                nextStates.set(191);
                nextStates.set(226);
                nextStates.set(286);
                nextStates.set(6);
                nextStates.set(2);
                nextStates.set(326);
                nextStates.set(61);
            } else if (ch == 103) {
                nextStates.set(195);
            } else if (ch == 105) {
                nextStates.set(97);
                nextStates.set(124);
                nextStates.set(140);
                nextStates.set(239);
            } else if (ch == 108) {
                nextStates.set(247);
            } else if (ch == 109) {
                nextStates.set(107);
            } else if (ch == 110) {
                nextStates.set(152);
                nextStates.set(300);
            } else if (ch == 111) {
                nextStates.set(148);
            } else if (ch == 112) {
                nextStates.set(145);
            } else if (ch == 114) {
                nextStates.set(71);
                nextStates.set(15);
                nextStates.set(80);
                nextStates.set(94);
                nextStates.set(98);
                nextStates.set(102);
                nextStates.set(132);
                nextStates.set(185);
                nextStates.set(209);
                nextStates.set(227);
                nextStates.set(232);
                nextStates.set(2);
                nextStates.set(267);
                nextStates.set(268);
                nextStates.set(61);
                nextStates.set(277);
                nextStates.set(278);
                nextStates.set(279);
                nextStates.set(6);
                nextStates.set(324);
                nextStates.set(338);
                nextStates.set(340);
            } else if (ch == 116) {
                nextStates.set(288);
            } else if (ch == 117) {
                nextStates.set(61);
                nextStates.set(2);
                nextStates.set(6);
                nextStates.set(15);
            } else if (ch == 119) {
                nextStates.set(187);
                nextStates.set(235);
            } else if (ch == 121) {
                nextStates.set(161);
            } else if (ch == 124) {
                nextStates.set(194);
            }
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && ch <= 65535) {
                nextStates.set(253);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BADNAME)) {
                    type = PythonToken.TokenType.BADNAME;
                }
            }
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && PythonLexer.checkIntervals(PYTHON.NFA_MOVES_PYTHON_581, ch)) {
                nextStates.set(225);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.NAME)) {
                    type = PythonToken.TokenType.NAME;
                }
            } else if (ch == 48) {
                nextStates.set(349);
                nextStates.set(335);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DECNUMBER)) {
                    type = PythonToken.TokenType.DECNUMBER;
                }
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(83);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DECNUMBER)) {
                    type = PythonToken.TokenType.DECNUMBER;
                }
            } else if (ch == 37) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.PERCENT)) {
                    type = PythonToken.TokenType.PERCENT;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SLASH)) {
                    type = PythonToken.TokenType.SLASH;
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.PLUS)) {
                    type = PythonToken.TokenType.PLUS;
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.MINUS)) {
                    type = PythonToken.TokenType.MINUS;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.LT)) {
                    type = PythonToken.TokenType.LT;
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.GT)) {
                    type = PythonToken.TokenType.GT;
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DOT)) {
                    type = PythonToken.TokenType.DOT;
                }
            } else if (ch == 126) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.TILDE)) {
                    type = PythonToken.TokenType.TILDE;
                }
            } else if (ch == 94) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.XOR)) {
                    type = PythonToken.TokenType.XOR;
                }
            } else if (ch == 124) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BIT_OR)) {
                    type = PythonToken.TokenType.BIT_OR;
                }
            } else if (ch == 38) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BIT_AND)) {
                    type = PythonToken.TokenType.BIT_AND;
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.STAR)) {
                    type = PythonToken.TokenType.STAR;
                }
            } else if (ch == 59) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SEMICOLON)) {
                    type = PythonToken.TokenType.SEMICOLON;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.RPAREN)) {
                    type = PythonToken.TokenType.RPAREN;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.LPAREN)) {
                    type = PythonToken.TokenType.LPAREN;
                }
            } else if (ch == 93) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.RBRACKET)) {
                    type = PythonToken.TokenType.RBRACKET;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.LBRACKET)) {
                    type = PythonToken.TokenType.LBRACKET;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.RBRACE)) {
                    type = PythonToken.TokenType.RBRACE;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.LBRACE)) {
                    type = PythonToken.TokenType.LBRACE;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.COMMA)) {
                    type = PythonToken.TokenType.COMMA;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.COLON)) {
                    type = PythonToken.TokenType.COLON;
                }
            } else if (ch == 64) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.AT)) {
                    type = PythonToken.TokenType.AT;
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.ASSIGN)) {
                    type = PythonToken.TokenType.ASSIGN;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.NEWLINE)) {
                    type = PythonToken.TokenType.NEWLINE;
                }
            } else if (ch == 35) {
                nextStates.set(149);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.COMMENT)) {
                    type = PythonToken.TokenType.COMMENT;
                }
            } else if (ch == 12) {
                nextStates.set(58);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SPACE)) {
                    type = PythonToken.TokenType.SPACE;
                }
            } else if (ch == 32) {
                nextStates.set(58);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SPACE)) {
                    type = PythonToken.TokenType.SPACE;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex1(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(2);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex2(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(3);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex3(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(3);
            } else if (ch == 92) {
                nextStates.set(4);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex4(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(3);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex5(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(6);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex6(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(7);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex7(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(7);
            } else if (ch == 92) {
                nextStates.set(8);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex8(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(7);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex9(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(9);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(11);
            } else if (ch == 95) {
                nextStates.set(10);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex10(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(9);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex11(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(12);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(13);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex12(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(13);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex13(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(13);
            } else if (ch == 95) {
                nextStates.set(14);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex14(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(13);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex15(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(16);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex16(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(17);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex17(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(18);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex18(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(18);
            } else if (ch == 39) {
                nextStates.set(19);
                nextStates.set(22);
            }
            if (ch == 92) {
                nextStates.set(20);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex19(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(18);
            } else if (ch == 39) {
                nextStates.set(21);
            }
            if (ch == 92) {
                nextStates.set(20);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex20(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(18);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex21(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(18);
            }
            if (ch == 92) {
                nextStates.set(20);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex22(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(23);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex23(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex24(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(25);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex25(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(26);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex26(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(27);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex27(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(28);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex28(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(29);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex29(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(30);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex30(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.CONTINUE))) {
                type = PythonToken.TokenType.CONTINUE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex31(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(32);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex32(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(33);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex33(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(34);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex34(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 107 && (validTypes == null || validTypes.contains(PythonToken.TokenType.BREAK))) {
                type = PythonToken.TokenType.BREAK;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex35(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(36);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex36(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(37);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex37(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(37);
            } else if (ch == 92) {
                nextStates.set(38);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex38(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 127) {
                nextStates.set(37);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex39(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(40);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex40(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(41);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex41(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(42);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex42(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(43);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex43(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(43);
            } else if (ch == 39) {
                nextStates.set(44);
                nextStates.set(47);
            }
            if (ch == 92) {
                nextStates.set(45);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex44(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(43);
            } else if (ch == 39) {
                nextStates.set(46);
            }
            if (ch == 92) {
                nextStates.set(45);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex45(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 127) {
                nextStates.set(43);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex46(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(43);
            }
            if (ch == 92) {
                nextStates.set(45);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex47(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(48);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex48(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex49(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(49);
            } else if (ch == 95) {
                nextStates.set(56);
            } else if (ch == 46) {
                nextStates.set(50);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex50(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(51);
            } else if (ch == 95) {
                nextStates.set(55);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(50);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex51(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(52);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(53);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex52(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(53);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex53(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(54);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(53);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex54(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(53);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex55(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(50);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex56(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(49);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex57(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(2);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex58(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 12) {
                nextStates.set(58);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SPACE)) {
                    type = PythonToken.TokenType.SPACE;
                }
            } else if (ch == 32) {
                nextStates.set(58);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SPACE)) {
                    type = PythonToken.TokenType.SPACE;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex59(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(36);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex60(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(15);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex61(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(62);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex62(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(63);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex63(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(64);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex64(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(64);
            } else if (ch == 34) {
                nextStates.set(65);
                nextStates.set(68);
            }
            if (ch == 92) {
                nextStates.set(67);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex65(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(64);
            } else if (ch == 34) {
                nextStates.set(66);
            }
            if (ch == 92) {
                nextStates.set(67);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex66(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(64);
            }
            if (ch == 92) {
                nextStates.set(67);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex67(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(64);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex68(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(69);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex69(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex70(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.SLASHASSIGN))) {
                type = PythonToken.TokenType.SLASHASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex71(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(2);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex72(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(73);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex73(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(73);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(75);
            } else if (ch == 95) {
                nextStates.set(74);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex74(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(73);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex75(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(78);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(76);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex76(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(76);
            } else if (ch == 95) {
                nextStates.set(77);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex77(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(76);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex78(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(76);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex79(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ATASSIGN))) {
                type = PythonToken.TokenType.ATASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex80(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(36);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex81(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(82);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex82(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(PythonToken.TokenType.DEF))) {
                type = PythonToken.TokenType.DEF;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex83(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(84);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(83);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DECNUMBER)) {
                    type = PythonToken.TokenType.DECNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.DECNUMBER))) {
                type = PythonToken.TokenType.DECNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex84(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(83);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DECNUMBER)) {
                    type = PythonToken.TokenType.DECNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex85(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.NE))) {
                type = PythonToken.TokenType.NE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex86(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(87);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex87(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(88);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex88(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(89);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex89(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(90);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex90(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(91);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex91(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(PythonToken.TokenType.FINALLY))) {
                type = PythonToken.TokenType.FINALLY;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex92(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(61);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex93(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(61);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex94(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(15);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex95(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(96);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex96(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(PythonToken.TokenType.AND))) {
                type = PythonToken.TokenType.AND;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex97(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(PythonToken.TokenType.IN))) {
                type = PythonToken.TokenType.IN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex98(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(99);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex99(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(100);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex100(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(101);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex101(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.RAISE))) {
                type = PythonToken.TokenType.RAISE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex102(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(103);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex103(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(104);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex104(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(105);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex105(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(106);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex106(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(PythonToken.TokenType.RETURN))) {
                type = PythonToken.TokenType.RETURN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex107(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(108);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex108(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(109);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex109(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(110);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex110(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(PythonToken.TokenType.MATCH))) {
                type = PythonToken.TokenType.MATCH;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex111(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(40);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex112(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.EQ))) {
                type = PythonToken.TokenType.EQ;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex113(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(114);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex114(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(115);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex115(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(116);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex116(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(117);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex117(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(PythonToken.TokenType._ASSERT))) {
                type = PythonToken.TokenType._ASSERT;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex118(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(15);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex119(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(120);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex120(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(120);
            } else if (ch == 92) {
                nextStates.set(121);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex121(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 127) {
                nextStates.set(120);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex122(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(6);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex123(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(6);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex124(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(PythonToken.TokenType.IF))) {
                type = PythonToken.TokenType.IF;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex125(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(125);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(127);
            } else if (ch == 95) {
                nextStates.set(126);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex126(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(125);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex127(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(128);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(129);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex128(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(129);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex129(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(130);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(129);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex130(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(129);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex131(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(119);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex132(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(40);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex133(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(PythonToken.TokenType.AS))) {
                type = PythonToken.TokenType.AS;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex134(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(135);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex135(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(136);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex136(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.CASE))) {
                type = PythonToken.TokenType.CASE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex137(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 12) {
                nextStates.set(137);
            } else if (ch == 32) {
                nextStates.set(137);
            } else if (ch == 10 && (validTypes == null || validTypes.contains(PythonToken.TokenType.NEWLINE))) {
                type = PythonToken.TokenType.NEWLINE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex138(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(36);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex139(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(2);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex140(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(141);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex141(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(142);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex142(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(143);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex143(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(144);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex144(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(PythonToken.TokenType.IMPORT))) {
                type = PythonToken.TokenType.IMPORT;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex145(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(146);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex146(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(147);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex147(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(PythonToken.TokenType.PASS))) {
                type = PythonToken.TokenType.PASS;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex148(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(PythonToken.TokenType.OR))) {
                type = PythonToken.TokenType.OR;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex149(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(149);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.COMMENT)) {
                    type = PythonToken.TokenType.COMMENT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex150(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(15);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex151(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(119);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex152(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(153);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex153(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(154);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex154(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(155);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex155(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(156);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex156(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(157);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex157(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(158);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex158(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(PythonToken.TokenType.NONLOCAL))) {
                type = PythonToken.TokenType.NONLOCAL;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex159(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 46) {
                nextStates.set(160);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex160(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 46 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ELLIPSIS))) {
                type = PythonToken.TokenType.ELLIPSIS;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex161(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(162);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex162(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(163);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex163(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(164);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex164(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(PythonToken.TokenType.YIELD))) {
                type = PythonToken.TokenType.YIELD;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex165(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(166);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex166(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(167);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex167(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(168);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex168(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(169);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex169(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(169);
            } else if (ch == 34) {
                nextStates.set(170);
                nextStates.set(173);
            }
            if (ch == 92) {
                nextStates.set(172);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex170(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(171);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex171(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex172(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 127) {
                nextStates.set(169);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex173(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(169);
            } else if (ch == 34) {
                nextStates.set(174);
            }
            if (ch == 92) {
                nextStates.set(172);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex174(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(169);
            }
            if (ch == 92) {
                nextStates.set(172);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex175(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(6);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex176(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(PythonToken.TokenType.RSHIFT))) {
                type = PythonToken.TokenType.RSHIFT;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex177(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(178);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex178(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(179);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex179(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ELIF))) {
                type = PythonToken.TokenType.ELIF;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex180(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(181);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex181(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(PythonToken.TokenType.FOR))) {
                type = PythonToken.TokenType.FOR;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex182(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(166);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex183(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 60) {
                nextStates.set(184);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex184(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.LSHIFTASSIGN))) {
                type = PythonToken.TokenType.LSHIFTASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex185(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(15);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex186(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(36);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex187(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(188);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex188(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(189);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex189(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(190);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex190(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.WHILE))) {
                type = PythonToken.TokenType.WHILE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex191(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(192);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex192(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(193);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex193(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 109 && (validTypes == null || validTypes.contains(PythonToken.TokenType.FROM))) {
                type = PythonToken.TokenType.FROM;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex194(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ORASSIGN))) {
                type = PythonToken.TokenType.ORASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex195(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(196);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex196(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(197);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex197(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(198);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex198(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(199);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex199(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(PythonToken.TokenType.GLOBAL))) {
                type = PythonToken.TokenType.GLOBAL;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex200(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(201);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex201(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(202);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex202(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.NONE))) {
                type = PythonToken.TokenType.NONE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex203(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 120) {
                nextStates.set(204);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex204(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(205);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex205(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(206);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex206(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(207);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex207(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(PythonToken.TokenType.EXCEPT))) {
                type = PythonToken.TokenType.EXCEPT;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex208(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(6);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex209(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(2);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex210(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(211);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex211(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(212);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex212(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(213);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex213(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.FALSE))) {
                type = PythonToken.TokenType.FALSE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex214(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(216);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(215);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BADDECNUMBER)) {
                    type = PythonToken.TokenType.BADDECNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex215(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(216);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(215);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BADDECNUMBER)) {
                    type = PythonToken.TokenType.BADDECNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.BADDECNUMBER))) {
                type = PythonToken.TokenType.BADDECNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex216(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(215);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BADDECNUMBER)) {
                    type = PythonToken.TokenType.BADDECNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex217(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 46) {
                nextStates.set(219);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(217);
            } else if (ch == 95) {
                nextStates.set(218);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex218(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(217);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex219(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(219);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(220);
            } else if (ch == 95) {
                nextStates.set(224);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex220(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(221);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(222);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex221(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(222);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex222(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(222);
            } else if (ch == 95) {
                nextStates.set(223);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex223(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(222);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex224(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(219);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex225(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && PythonLexer.checkIntervals(PYTHON.NFA_MOVES_PYTHON_582, ch)) {
                nextStates.set(225);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.NAME)) {
                    type = PythonToken.TokenType.NAME;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex226(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(61);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex227(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(6);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex228(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(229);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex229(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(231);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(230);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.HEXNUMBER)) {
                    type = PythonToken.TokenType.HEXNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex230(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(231);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(230);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.HEXNUMBER)) {
                    type = PythonToken.TokenType.HEXNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.HEXNUMBER))) {
                type = PythonToken.TokenType.HEXNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex231(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(230);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.HEXNUMBER)) {
                    type = PythonToken.TokenType.HEXNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex232(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(166);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex233(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(40);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex234(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(61);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex235(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(236);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex236(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(237);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex237(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(PythonToken.TokenType.WITH))) {
                type = PythonToken.TokenType.WITH;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex238(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STARASSIGN))) {
                type = PythonToken.TokenType.STARASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex239(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(PythonToken.TokenType.IS))) {
                type = PythonToken.TokenType.IS;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex240(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(241);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex241(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(243);
            } else if (ch == 95) {
                nextStates.set(242);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(241);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex242(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(241);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex243(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(246);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(244);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex244(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(245);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(244);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex245(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(244);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex246(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(244);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex247(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(248);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex248(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(249);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex249(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(250);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex250(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 100) {
                nextStates.set(251);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex251(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97 && (validTypes == null || validTypes.contains(PythonToken.TokenType.LAMBDA))) {
                type = PythonToken.TokenType.LAMBDA;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex252(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.PLUSASSIGN))) {
                type = PythonToken.TokenType.PLUSASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex253(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && ch <= 65535) {
                nextStates.set(253);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BADNAME)) {
                    type = PythonToken.TokenType.BADNAME;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex254(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(255);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex255(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(256);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex256(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(257);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex257(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 103) {
                nextStates.set(258);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex258(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(259);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex259(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(260);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex260(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(261);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex261(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(262);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex262(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(263);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex263(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(264);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex264(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(265);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex265(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(266);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex266(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95 && (validTypes == null || validTypes.contains(PythonToken.TokenType.PEG_PARSER))) {
                type = PythonToken.TokenType.PEG_PARSER;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex267(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(36);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex268(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(166);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex269(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(166);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex270(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(40);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex271(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 47) {
                nextStates.set(272);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex272(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.SLASHSLASHASSIGN))) {
                type = PythonToken.TokenType.SLASHSLASHASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex273(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(36);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex274(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 42) {
                nextStates.set(275);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex275(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STARSTARASSIGN))) {
                type = PythonToken.TokenType.STARSTARASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex276(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(166);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex277(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(40);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex278(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(6);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex279(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(61);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex280(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(6);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex281(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 62) {
                nextStates.set(282);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex282(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.RSHIFTASSIGN))) {
                type = PythonToken.TokenType.RSHIFTASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex283(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(119);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex284(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.COLONEQUALS))) {
                type = PythonToken.TokenType.COLONEQUALS;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex285(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(40);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex286(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(2);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex287(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 42 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STAR_STAR))) {
                type = PythonToken.TokenType.STAR_STAR;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex288(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(289);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex289(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(PythonToken.TokenType.TRY))) {
                type = PythonToken.TokenType.TRY;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex290(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(291);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex291(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(292);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex292(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(293);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex293(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(PythonToken.TokenType.CLASS))) {
                type = PythonToken.TokenType.CLASS;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex294(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(2);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex295(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 32 && (validTypes == null || validTypes.contains(PythonToken.TokenType.HOOK))) {
                type = PythonToken.TokenType.HOOK;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex296(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.XORASSIGN))) {
                type = PythonToken.TokenType.XORASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex297(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(PythonToken.TokenType.RARROW))) {
                type = PythonToken.TokenType.RARROW;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex298(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(61);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex299(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.REMASSIGN))) {
                type = PythonToken.TokenType.REMASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex300(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(301);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex301(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(PythonToken.TokenType.NOT))) {
                type = PythonToken.TokenType.NOT;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex302(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.LE))) {
                type = PythonToken.TokenType.LE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex303(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(303);
            } else if (ch == 76 || ch == 108) {
                nextStates.set(304);
            } else if (ch == 95) {
                nextStates.set(305);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex304(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex305(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(303);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex306(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(307);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.OCTNUMBER)) {
                    type = PythonToken.TokenType.OCTNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex307(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(308);
            } else if (ch >= 48 && ch <= 55) {
                nextStates.set(307);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.OCTNUMBER)) {
                    type = PythonToken.TokenType.OCTNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.OCTNUMBER))) {
                type = PythonToken.TokenType.OCTNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex308(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(307);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.OCTNUMBER)) {
                    type = PythonToken.TokenType.OCTNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex309(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(2);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex310(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.GE))) {
                type = PythonToken.TokenType.GE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex311(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(312);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex312(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(313);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex313(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ELSE))) {
                type = PythonToken.TokenType.ELSE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex314(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(15);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex315(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(316);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex316(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(317);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex317(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.TRUE))) {
                type = PythonToken.TokenType.TRUE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex318(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.MINUSASSIGN))) {
                type = PythonToken.TokenType.MINUSASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex319(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(166);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex320(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(36);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex321(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(119);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex322(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(323);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex323(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(PythonToken.TokenType.DEL))) {
                type = PythonToken.TokenType.DEL;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex324(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(119);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex325(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 47 && (validTypes == null || validTypes.contains(PythonToken.TokenType.SLASHSLASH))) {
                type = PythonToken.TokenType.SLASHSLASH;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex326(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(15);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex327(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 60 && (validTypes == null || validTypes.contains(PythonToken.TokenType.LSHIFT))) {
                type = PythonToken.TokenType.LSHIFT;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex328(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(166);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex329(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(40);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex330(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 119) {
                nextStates.set(331);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex331(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(332);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex332(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(333);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex333(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(PythonToken.TokenType.AWAIT))) {
                type = PythonToken.TokenType.AWAIT;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex334(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(61);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex335(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 48) {
                nextStates.set(335);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DECNUMBER)) {
                    type = PythonToken.TokenType.DECNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex336(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(119);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex337(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(15);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex338(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(61);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex339(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ANDASSIGN))) {
                type = PythonToken.TokenType.ANDASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex340(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(119);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex341(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(342);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex342(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 121) {
                nextStates.set(343);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex343(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(344);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex344(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 99 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ASYNC))) {
                type = PythonToken.TokenType.ASYNC;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex345(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 48) {
                nextStates.set(348);
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(346);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex346(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(346);
            } else if (ch == 76 || ch == 108) {
                nextStates.set(304);
            } else if (ch == 95) {
                nextStates.set(347);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex347(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(346);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex348(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 48) {
                nextStates.set(348);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex349(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(350);
            } else if (ch == 48 || ch == 49) {
                nextStates.set(351);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BINNUMBER)) {
                    type = PythonToken.TokenType.BINNUMBER;
                }
            } else if (ch == 66 || ch == 98) {
                nextStates.set(351);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BINNUMBER)) {
                    type = PythonToken.TokenType.BINNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.BINNUMBER))) {
                type = PythonToken.TokenType.BINNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex350(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(351);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BINNUMBER)) {
                    type = PythonToken.TokenType.BINNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex351(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(350);
            } else if (ch == 48 || ch == 49) {
                nextStates.set(351);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BINNUMBER)) {
                    type = PythonToken.TokenType.BINNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.BINNUMBER))) {
                type = PythonToken.TokenType.BINNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex352(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 10 && (validTypes == null || validTypes.contains(PythonToken.TokenType.CONTINUE_LINE))) {
                type = PythonToken.TokenType.CONTINUE_LINE;
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex353(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(119);
            }
            return type;
        }

        private static PythonToken.TokenType getNfaNamePYTHONIndex354(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 48) {
                nextStates.set(354);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static int[] NFA_MOVES_PYTHON_581_init() {
            return new int[]{65, 90, 95, 95, 97, 122, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 318, 321, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 891, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1488, 1514, 1519, 1522, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2048, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2208, 2228, 2230, 2247, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2545, 2556, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3294, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3634, 3648, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3762, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5900, 5902, 5905, 5920, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6108, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6987, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8305, 8305, 8319, 8319, 8336, 8348, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 40956, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42943, 42946, 42954, 42997, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64605, 64612, 64829, 64848, 64911, 64914, 64967, 65008, 65017, 65137, 65137, 65139, 65139, 65143, 65143, 65145, 65145, 65147, 65147, 65149, 65149, 65151, 65276, 65313, 65338, 65345, 65370, 65382, 65437, 65440, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 67072, 67382, 67392, 67413, 67424, 67431, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69552, 69572, 69600, 69622, 69635, 69687, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72384, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73728, 74649, 74752, 74862, 74880, 75075, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110592, 110878, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 123136, 123180, 123191, 123197, 123214, 123214, 123584, 123627, 124928, 125124, 125184, 125251, 125259, 125259, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173789, 173824, 177972, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static int[] NFA_MOVES_PYTHON_582_init() {
            return new int[]{48, 57, 65, 90, 95, 95, 97, 122, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 318, 321, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 891, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1552, 1562, 1568, 1641, 1646, 1747, 1749, 1756, 1759, 1768, 1770, 1788, 1791, 1791, 1808, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2045, 2048, 2093, 2112, 2139, 2144, 2154, 2208, 2228, 2230, 2247, 2259, 2273, 2275, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2545, 2556, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3294, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3648, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5900, 5902, 5908, 5920, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6108, 6109, 6112, 6121, 6155, 6157, 6160, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6848, 6912, 6987, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7673, 7675, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 40956, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42943, 42946, 42954, 42997, 43047, 43052, 43052, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64605, 64612, 64829, 64848, 64911, 64914, 64967, 65008, 65017, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65137, 65137, 65139, 65139, 65143, 65143, 65145, 65145, 65147, 65147, 65149, 65149, 65151, 65276, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 67072, 67382, 67392, 67413, 67424, 67431, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69743, 69759, 69818, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72384, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73728, 74649, 74752, 74862, 74880, 75075, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110592, 110878, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 119141, 119145, 119149, 119154, 119163, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123584, 123641, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173789, 173824, 177972, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917760, 917999};
        }

        private static void NFA_FUNCTIONS_init() {
            PythonLexer.access$302(new NfaFunction[]{PYTHON::getNfaNamePYTHONIndex0, PYTHON::getNfaNamePYTHONIndex1, PYTHON::getNfaNamePYTHONIndex2, PYTHON::getNfaNamePYTHONIndex3, PYTHON::getNfaNamePYTHONIndex4, PYTHON::getNfaNamePYTHONIndex5, PYTHON::getNfaNamePYTHONIndex6, PYTHON::getNfaNamePYTHONIndex7, PYTHON::getNfaNamePYTHONIndex8, PYTHON::getNfaNamePYTHONIndex9, PYTHON::getNfaNamePYTHONIndex10, PYTHON::getNfaNamePYTHONIndex11, PYTHON::getNfaNamePYTHONIndex12, PYTHON::getNfaNamePYTHONIndex13, PYTHON::getNfaNamePYTHONIndex14, PYTHON::getNfaNamePYTHONIndex15, PYTHON::getNfaNamePYTHONIndex16, PYTHON::getNfaNamePYTHONIndex17, PYTHON::getNfaNamePYTHONIndex18, PYTHON::getNfaNamePYTHONIndex19, PYTHON::getNfaNamePYTHONIndex20, PYTHON::getNfaNamePYTHONIndex21, PYTHON::getNfaNamePYTHONIndex22, PYTHON::getNfaNamePYTHONIndex23, PYTHON::getNfaNamePYTHONIndex24, PYTHON::getNfaNamePYTHONIndex25, PYTHON::getNfaNamePYTHONIndex26, PYTHON::getNfaNamePYTHONIndex27, PYTHON::getNfaNamePYTHONIndex28, PYTHON::getNfaNamePYTHONIndex29, PYTHON::getNfaNamePYTHONIndex30, PYTHON::getNfaNamePYTHONIndex31, PYTHON::getNfaNamePYTHONIndex32, PYTHON::getNfaNamePYTHONIndex33, PYTHON::getNfaNamePYTHONIndex34, PYTHON::getNfaNamePYTHONIndex35, PYTHON::getNfaNamePYTHONIndex36, PYTHON::getNfaNamePYTHONIndex37, PYTHON::getNfaNamePYTHONIndex38, PYTHON::getNfaNamePYTHONIndex39, PYTHON::getNfaNamePYTHONIndex40, PYTHON::getNfaNamePYTHONIndex41, PYTHON::getNfaNamePYTHONIndex42, PYTHON::getNfaNamePYTHONIndex43, PYTHON::getNfaNamePYTHONIndex44, PYTHON::getNfaNamePYTHONIndex45, PYTHON::getNfaNamePYTHONIndex46, PYTHON::getNfaNamePYTHONIndex47, PYTHON::getNfaNamePYTHONIndex48, PYTHON::getNfaNamePYTHONIndex49, PYTHON::getNfaNamePYTHONIndex50, PYTHON::getNfaNamePYTHONIndex51, PYTHON::getNfaNamePYTHONIndex52, PYTHON::getNfaNamePYTHONIndex53, PYTHON::getNfaNamePYTHONIndex54, PYTHON::getNfaNamePYTHONIndex55, PYTHON::getNfaNamePYTHONIndex56, PYTHON::getNfaNamePYTHONIndex57, PYTHON::getNfaNamePYTHONIndex58, PYTHON::getNfaNamePYTHONIndex59, PYTHON::getNfaNamePYTHONIndex60, PYTHON::getNfaNamePYTHONIndex61, PYTHON::getNfaNamePYTHONIndex62, PYTHON::getNfaNamePYTHONIndex63, PYTHON::getNfaNamePYTHONIndex64, PYTHON::getNfaNamePYTHONIndex65, PYTHON::getNfaNamePYTHONIndex66, PYTHON::getNfaNamePYTHONIndex67, PYTHON::getNfaNamePYTHONIndex68, PYTHON::getNfaNamePYTHONIndex69, PYTHON::getNfaNamePYTHONIndex70, PYTHON::getNfaNamePYTHONIndex71, PYTHON::getNfaNamePYTHONIndex72, PYTHON::getNfaNamePYTHONIndex73, PYTHON::getNfaNamePYTHONIndex74, PYTHON::getNfaNamePYTHONIndex75, PYTHON::getNfaNamePYTHONIndex76, PYTHON::getNfaNamePYTHONIndex77, PYTHON::getNfaNamePYTHONIndex78, PYTHON::getNfaNamePYTHONIndex79, PYTHON::getNfaNamePYTHONIndex80, PYTHON::getNfaNamePYTHONIndex81, PYTHON::getNfaNamePYTHONIndex82, PYTHON::getNfaNamePYTHONIndex83, PYTHON::getNfaNamePYTHONIndex84, PYTHON::getNfaNamePYTHONIndex85, PYTHON::getNfaNamePYTHONIndex86, PYTHON::getNfaNamePYTHONIndex87, PYTHON::getNfaNamePYTHONIndex88, PYTHON::getNfaNamePYTHONIndex89, PYTHON::getNfaNamePYTHONIndex90, PYTHON::getNfaNamePYTHONIndex91, PYTHON::getNfaNamePYTHONIndex92, PYTHON::getNfaNamePYTHONIndex93, PYTHON::getNfaNamePYTHONIndex94, PYTHON::getNfaNamePYTHONIndex95, PYTHON::getNfaNamePYTHONIndex96, PYTHON::getNfaNamePYTHONIndex97, PYTHON::getNfaNamePYTHONIndex98, PYTHON::getNfaNamePYTHONIndex99, PYTHON::getNfaNamePYTHONIndex100, PYTHON::getNfaNamePYTHONIndex101, PYTHON::getNfaNamePYTHONIndex102, PYTHON::getNfaNamePYTHONIndex103, PYTHON::getNfaNamePYTHONIndex104, PYTHON::getNfaNamePYTHONIndex105, PYTHON::getNfaNamePYTHONIndex106, PYTHON::getNfaNamePYTHONIndex107, PYTHON::getNfaNamePYTHONIndex108, PYTHON::getNfaNamePYTHONIndex109, PYTHON::getNfaNamePYTHONIndex110, PYTHON::getNfaNamePYTHONIndex111, PYTHON::getNfaNamePYTHONIndex112, PYTHON::getNfaNamePYTHONIndex113, PYTHON::getNfaNamePYTHONIndex114, PYTHON::getNfaNamePYTHONIndex115, PYTHON::getNfaNamePYTHONIndex116, PYTHON::getNfaNamePYTHONIndex117, PYTHON::getNfaNamePYTHONIndex118, PYTHON::getNfaNamePYTHONIndex119, PYTHON::getNfaNamePYTHONIndex120, PYTHON::getNfaNamePYTHONIndex121, PYTHON::getNfaNamePYTHONIndex122, PYTHON::getNfaNamePYTHONIndex123, PYTHON::getNfaNamePYTHONIndex124, PYTHON::getNfaNamePYTHONIndex125, PYTHON::getNfaNamePYTHONIndex126, PYTHON::getNfaNamePYTHONIndex127, PYTHON::getNfaNamePYTHONIndex128, PYTHON::getNfaNamePYTHONIndex129, PYTHON::getNfaNamePYTHONIndex130, PYTHON::getNfaNamePYTHONIndex131, PYTHON::getNfaNamePYTHONIndex132, PYTHON::getNfaNamePYTHONIndex133, PYTHON::getNfaNamePYTHONIndex134, PYTHON::getNfaNamePYTHONIndex135, PYTHON::getNfaNamePYTHONIndex136, PYTHON::getNfaNamePYTHONIndex137, PYTHON::getNfaNamePYTHONIndex138, PYTHON::getNfaNamePYTHONIndex139, PYTHON::getNfaNamePYTHONIndex140, PYTHON::getNfaNamePYTHONIndex141, PYTHON::getNfaNamePYTHONIndex142, PYTHON::getNfaNamePYTHONIndex143, PYTHON::getNfaNamePYTHONIndex144, PYTHON::getNfaNamePYTHONIndex145, PYTHON::getNfaNamePYTHONIndex146, PYTHON::getNfaNamePYTHONIndex147, PYTHON::getNfaNamePYTHONIndex148, PYTHON::getNfaNamePYTHONIndex149, PYTHON::getNfaNamePYTHONIndex150, PYTHON::getNfaNamePYTHONIndex151, PYTHON::getNfaNamePYTHONIndex152, PYTHON::getNfaNamePYTHONIndex153, PYTHON::getNfaNamePYTHONIndex154, PYTHON::getNfaNamePYTHONIndex155, PYTHON::getNfaNamePYTHONIndex156, PYTHON::getNfaNamePYTHONIndex157, PYTHON::getNfaNamePYTHONIndex158, PYTHON::getNfaNamePYTHONIndex159, PYTHON::getNfaNamePYTHONIndex160, PYTHON::getNfaNamePYTHONIndex161, PYTHON::getNfaNamePYTHONIndex162, PYTHON::getNfaNamePYTHONIndex163, PYTHON::getNfaNamePYTHONIndex164, PYTHON::getNfaNamePYTHONIndex165, PYTHON::getNfaNamePYTHONIndex166, PYTHON::getNfaNamePYTHONIndex167, PYTHON::getNfaNamePYTHONIndex168, PYTHON::getNfaNamePYTHONIndex169, PYTHON::getNfaNamePYTHONIndex170, PYTHON::getNfaNamePYTHONIndex171, PYTHON::getNfaNamePYTHONIndex172, PYTHON::getNfaNamePYTHONIndex173, PYTHON::getNfaNamePYTHONIndex174, PYTHON::getNfaNamePYTHONIndex175, PYTHON::getNfaNamePYTHONIndex176, PYTHON::getNfaNamePYTHONIndex177, PYTHON::getNfaNamePYTHONIndex178, PYTHON::getNfaNamePYTHONIndex179, PYTHON::getNfaNamePYTHONIndex180, PYTHON::getNfaNamePYTHONIndex181, PYTHON::getNfaNamePYTHONIndex182, PYTHON::getNfaNamePYTHONIndex183, PYTHON::getNfaNamePYTHONIndex184, PYTHON::getNfaNamePYTHONIndex185, PYTHON::getNfaNamePYTHONIndex186, PYTHON::getNfaNamePYTHONIndex187, PYTHON::getNfaNamePYTHONIndex188, PYTHON::getNfaNamePYTHONIndex189, PYTHON::getNfaNamePYTHONIndex190, PYTHON::getNfaNamePYTHONIndex191, PYTHON::getNfaNamePYTHONIndex192, PYTHON::getNfaNamePYTHONIndex193, PYTHON::getNfaNamePYTHONIndex194, PYTHON::getNfaNamePYTHONIndex195, PYTHON::getNfaNamePYTHONIndex196, PYTHON::getNfaNamePYTHONIndex197, PYTHON::getNfaNamePYTHONIndex198, PYTHON::getNfaNamePYTHONIndex199, PYTHON::getNfaNamePYTHONIndex200, PYTHON::getNfaNamePYTHONIndex201, PYTHON::getNfaNamePYTHONIndex202, PYTHON::getNfaNamePYTHONIndex203, PYTHON::getNfaNamePYTHONIndex204, PYTHON::getNfaNamePYTHONIndex205, PYTHON::getNfaNamePYTHONIndex206, PYTHON::getNfaNamePYTHONIndex207, PYTHON::getNfaNamePYTHONIndex208, PYTHON::getNfaNamePYTHONIndex209, PYTHON::getNfaNamePYTHONIndex210, PYTHON::getNfaNamePYTHONIndex211, PYTHON::getNfaNamePYTHONIndex212, PYTHON::getNfaNamePYTHONIndex213, PYTHON::getNfaNamePYTHONIndex214, PYTHON::getNfaNamePYTHONIndex215, PYTHON::getNfaNamePYTHONIndex216, PYTHON::getNfaNamePYTHONIndex217, PYTHON::getNfaNamePYTHONIndex218, PYTHON::getNfaNamePYTHONIndex219, PYTHON::getNfaNamePYTHONIndex220, PYTHON::getNfaNamePYTHONIndex221, PYTHON::getNfaNamePYTHONIndex222, PYTHON::getNfaNamePYTHONIndex223, PYTHON::getNfaNamePYTHONIndex224, PYTHON::getNfaNamePYTHONIndex225, PYTHON::getNfaNamePYTHONIndex226, PYTHON::getNfaNamePYTHONIndex227, PYTHON::getNfaNamePYTHONIndex228, PYTHON::getNfaNamePYTHONIndex229, PYTHON::getNfaNamePYTHONIndex230, PYTHON::getNfaNamePYTHONIndex231, PYTHON::getNfaNamePYTHONIndex232, PYTHON::getNfaNamePYTHONIndex233, PYTHON::getNfaNamePYTHONIndex234, PYTHON::getNfaNamePYTHONIndex235, PYTHON::getNfaNamePYTHONIndex236, PYTHON::getNfaNamePYTHONIndex237, PYTHON::getNfaNamePYTHONIndex238, PYTHON::getNfaNamePYTHONIndex239, PYTHON::getNfaNamePYTHONIndex240, PYTHON::getNfaNamePYTHONIndex241, PYTHON::getNfaNamePYTHONIndex242, PYTHON::getNfaNamePYTHONIndex243, PYTHON::getNfaNamePYTHONIndex244, PYTHON::getNfaNamePYTHONIndex245, PYTHON::getNfaNamePYTHONIndex246, PYTHON::getNfaNamePYTHONIndex247, PYTHON::getNfaNamePYTHONIndex248, PYTHON::getNfaNamePYTHONIndex249, PYTHON::getNfaNamePYTHONIndex250, PYTHON::getNfaNamePYTHONIndex251, PYTHON::getNfaNamePYTHONIndex252, PYTHON::getNfaNamePYTHONIndex253, PYTHON::getNfaNamePYTHONIndex254, PYTHON::getNfaNamePYTHONIndex255, PYTHON::getNfaNamePYTHONIndex256, PYTHON::getNfaNamePYTHONIndex257, PYTHON::getNfaNamePYTHONIndex258, PYTHON::getNfaNamePYTHONIndex259, PYTHON::getNfaNamePYTHONIndex260, PYTHON::getNfaNamePYTHONIndex261, PYTHON::getNfaNamePYTHONIndex262, PYTHON::getNfaNamePYTHONIndex263, PYTHON::getNfaNamePYTHONIndex264, PYTHON::getNfaNamePYTHONIndex265, PYTHON::getNfaNamePYTHONIndex266, PYTHON::getNfaNamePYTHONIndex267, PYTHON::getNfaNamePYTHONIndex268, PYTHON::getNfaNamePYTHONIndex269, PYTHON::getNfaNamePYTHONIndex270, PYTHON::getNfaNamePYTHONIndex271, PYTHON::getNfaNamePYTHONIndex272, PYTHON::getNfaNamePYTHONIndex273, PYTHON::getNfaNamePYTHONIndex274, PYTHON::getNfaNamePYTHONIndex275, PYTHON::getNfaNamePYTHONIndex276, PYTHON::getNfaNamePYTHONIndex277, PYTHON::getNfaNamePYTHONIndex278, PYTHON::getNfaNamePYTHONIndex279, PYTHON::getNfaNamePYTHONIndex280, PYTHON::getNfaNamePYTHONIndex281, PYTHON::getNfaNamePYTHONIndex282, PYTHON::getNfaNamePYTHONIndex283, PYTHON::getNfaNamePYTHONIndex284, PYTHON::getNfaNamePYTHONIndex285, PYTHON::getNfaNamePYTHONIndex286, PYTHON::getNfaNamePYTHONIndex287, PYTHON::getNfaNamePYTHONIndex288, PYTHON::getNfaNamePYTHONIndex289, PYTHON::getNfaNamePYTHONIndex290, PYTHON::getNfaNamePYTHONIndex291, PYTHON::getNfaNamePYTHONIndex292, PYTHON::getNfaNamePYTHONIndex293, PYTHON::getNfaNamePYTHONIndex294, PYTHON::getNfaNamePYTHONIndex295, PYTHON::getNfaNamePYTHONIndex296, PYTHON::getNfaNamePYTHONIndex297, PYTHON::getNfaNamePYTHONIndex298, PYTHON::getNfaNamePYTHONIndex299, PYTHON::getNfaNamePYTHONIndex300, PYTHON::getNfaNamePYTHONIndex301, PYTHON::getNfaNamePYTHONIndex302, PYTHON::getNfaNamePYTHONIndex303, PYTHON::getNfaNamePYTHONIndex304, PYTHON::getNfaNamePYTHONIndex305, PYTHON::getNfaNamePYTHONIndex306, PYTHON::getNfaNamePYTHONIndex307, PYTHON::getNfaNamePYTHONIndex308, PYTHON::getNfaNamePYTHONIndex309, PYTHON::getNfaNamePYTHONIndex310, PYTHON::getNfaNamePYTHONIndex311, PYTHON::getNfaNamePYTHONIndex312, PYTHON::getNfaNamePYTHONIndex313, PYTHON::getNfaNamePYTHONIndex314, PYTHON::getNfaNamePYTHONIndex315, PYTHON::getNfaNamePYTHONIndex316, PYTHON::getNfaNamePYTHONIndex317, PYTHON::getNfaNamePYTHONIndex318, PYTHON::getNfaNamePYTHONIndex319, PYTHON::getNfaNamePYTHONIndex320, PYTHON::getNfaNamePYTHONIndex321, PYTHON::getNfaNamePYTHONIndex322, PYTHON::getNfaNamePYTHONIndex323, PYTHON::getNfaNamePYTHONIndex324, PYTHON::getNfaNamePYTHONIndex325, PYTHON::getNfaNamePYTHONIndex326, PYTHON::getNfaNamePYTHONIndex327, PYTHON::getNfaNamePYTHONIndex328, PYTHON::getNfaNamePYTHONIndex329, PYTHON::getNfaNamePYTHONIndex330, PYTHON::getNfaNamePYTHONIndex331, PYTHON::getNfaNamePYTHONIndex332, PYTHON::getNfaNamePYTHONIndex333, PYTHON::getNfaNamePYTHONIndex334, PYTHON::getNfaNamePYTHONIndex335, PYTHON::getNfaNamePYTHONIndex336, PYTHON::getNfaNamePYTHONIndex337, PYTHON::getNfaNamePYTHONIndex338, PYTHON::getNfaNamePYTHONIndex339, PYTHON::getNfaNamePYTHONIndex340, PYTHON::getNfaNamePYTHONIndex341, PYTHON::getNfaNamePYTHONIndex342, PYTHON::getNfaNamePYTHONIndex343, PYTHON::getNfaNamePYTHONIndex344, PYTHON::getNfaNamePYTHONIndex345, PYTHON::getNfaNamePYTHONIndex346, PYTHON::getNfaNamePYTHONIndex347, PYTHON::getNfaNamePYTHONIndex348, PYTHON::getNfaNamePYTHONIndex349, PYTHON::getNfaNamePYTHONIndex350, PYTHON::getNfaNamePYTHONIndex351, PYTHON::getNfaNamePYTHONIndex352, PYTHON::getNfaNamePYTHONIndex353, PYTHON::getNfaNamePYTHONIndex354});
        }
    }

    static interface NfaFunction {
        public PythonToken.TokenType apply(int var1, BitSet var2, EnumSet<PythonToken.TokenType> var3);
    }

    static class MatchInfo {
        PythonToken.TokenType matchedType;
        int matchLength;

        MatchInfo(PythonToken.TokenType matchedType, int matchLength) {
            this.matchedType = matchedType;
            this.matchLength = matchLength;
        }
    }

    public static enum LexicalState {
        PYTHON;

    }
}

