/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser;

import java.util.BitSet;
import java.util.EnumMap;
import java.util.EnumSet;
import org.congocc.parser.InvalidToken;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.TokenSource;

public class CongoCCLexer
extends TokenSource {
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = EnumSet.allOf(Token.TokenType.class);
    private static EnumMap<Token.TokenType, LexicalState> tokenTypeToLexicalStateMap = new EnumMap(Token.TokenType.class);
    static final EnumSet<Token.TokenType> regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType._INJECT, Token.TokenType._INCLUDE, Token.TokenType._FAIL, Token.TokenType._UNCACHE_TOKENS, Token.TokenType._ACTIVE_TOKENS, Token.TokenType._ACTIVATE_TOKENS, Token.TokenType._DEACTIVATE_TOKENS, Token.TokenType._ENSURE, Token.TokenType._SCAN, Token.TokenType._IGNORE_CASE, Token.TokenType._TOKEN, Token.TokenType._CONTEXTUAL_KEYWORD, Token.TokenType._UNPARSED, Token.TokenType._MORE, Token.TokenType._SKIP, Token.TokenType._EOF, Token.TokenType._ATTEMPT, Token.TokenType._RECOVER, Token.TokenType._RECOVER_TO, Token.TokenType._ON_ERROR, Token.TokenType.HASH, Token.TokenType.BACKSLASH, Token.TokenType.RIGHT_ARROW, Token.TokenType.UP_TO_HERE, Token.TokenType._LEXICAL_STATE, Token.TokenType.SINGLE_QUOTE_STRING, Token.TokenType.START_UNPARSED, Token.TokenType.UNPARSED_CONTENT, Token.TokenType.END_UNPARSED, Token.TokenType.CTRL_Z, Token.TokenType.UNDERSCORE, Token.TokenType.ABSTRACT, Token.TokenType._ASSERT, Token.TokenType.BOOLEAN, Token.TokenType.BREAK, Token.TokenType.BYTE, Token.TokenType.CASE, Token.TokenType.CATCH, Token.TokenType.CHAR, Token.TokenType.CLASS, Token.TokenType.CONST, Token.TokenType.CONTINUE, Token.TokenType._DEFAULT, Token.TokenType.DO, Token.TokenType.DOUBLE, Token.TokenType.ELSE, Token.TokenType.ENUM, Token.TokenType.EXTENDS, Token.TokenType.FALSE, Token.TokenType.FINAL, Token.TokenType.FINALLY, Token.TokenType.FLOAT, Token.TokenType.FOR, Token.TokenType.GOTO, Token.TokenType.IF, Token.TokenType.IMPLEMENTS, Token.TokenType._IMPORT, Token.TokenType.INSTANCEOF, Token.TokenType.INT, Token.TokenType.INTERFACE, Token.TokenType.LONG, Token.TokenType.NATIVE, Token.TokenType.NEW, Token.TokenType.NULL, Token.TokenType.PACKAGE, Token.TokenType.PRIVATE, Token.TokenType.PROTECTED, Token.TokenType.PUBLIC, Token.TokenType.RETURN, Token.TokenType.RECORD, Token.TokenType.SHORT, Token.TokenType.STATIC, Token.TokenType.STRICTFP, Token.TokenType.SUPER, Token.TokenType.SWITCH, Token.TokenType.SYNCHRONIZED, Token.TokenType.THIS, Token.TokenType.THROW, Token.TokenType.THROWS, Token.TokenType.TRANSIENT, Token.TokenType.TRUE, Token.TokenType.TRY, Token.TokenType.VAR, Token.TokenType.VOID, Token.TokenType.VOLATILE, Token.TokenType.WHILE, Token.TokenType.YIELD, Token.TokenType.SEALED, Token.TokenType.NON_SEALED, Token.TokenType.PERMITS, Token.TokenType.MODULE, Token.TokenType.EXPORTS, Token.TokenType.OPEN, Token.TokenType.OPENS, Token.TokenType.PROVIDES, Token.TokenType.REQUIRES, Token.TokenType.TO, Token.TokenType.TRANSITIVE, Token.TokenType.USES, Token.TokenType.WITH, Token.TokenType.WHEN, Token.TokenType.CHARACTER_LITERAL, Token.TokenType.STRING_LITERAL, Token.TokenType.TEXT_BLOCK_LITERAL, Token.TokenType.INTEGER_LITERAL, Token.TokenType.LONG_LITERAL, Token.TokenType.FLOATING_POINT_LITERAL, Token.TokenType.LPAREN, Token.TokenType.RPAREN, Token.TokenType.LBRACE, Token.TokenType.RBRACE, Token.TokenType.LBRACKET, Token.TokenType.RBRACKET, Token.TokenType.SEMICOLON, Token.TokenType.COMMA, Token.TokenType.DOT, Token.TokenType.DOUBLE_COLON, Token.TokenType.VAR_ARGS, Token.TokenType.AT, Token.TokenType.ASSIGN, Token.TokenType.GT, Token.TokenType.LT, Token.TokenType.BANG, Token.TokenType.TILDE, Token.TokenType.HOOK, Token.TokenType.COLON, Token.TokenType.EQ, Token.TokenType.LE, Token.TokenType.GE, Token.TokenType.NE, Token.TokenType.SC_OR, Token.TokenType.SC_AND, Token.TokenType.INCR, Token.TokenType.DECR, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.STAR, Token.TokenType.SLASH, Token.TokenType.BIT_AND, Token.TokenType.BIT_OR, Token.TokenType.XOR, Token.TokenType.REM, Token.TokenType.LSHIFT, Token.TokenType.PLUSASSIGN, Token.TokenType.MINUSASSIGN, Token.TokenType.STARASSIGN, Token.TokenType.SLASHASSIGN, Token.TokenType.ANDASSIGN, Token.TokenType.ORASSIGN, Token.TokenType.XORASSIGN, Token.TokenType.REMASSIGN, Token.TokenType.LSHIFTASSIGN, Token.TokenType.RSIGNEDSHIFT, Token.TokenType.RUNSIGNEDSHIFT, Token.TokenType.RSIGNEDSHIFTASSIGN, Token.TokenType.RUNSIGNEDSHIFTASSIGN, Token.TokenType.LAMBDA, Token.TokenType.IDENTIFIER});
    static final EnumSet<Token.TokenType> unparsedTokens = EnumSet.of(Token.TokenType.MULTI_LINE_COMMENT, Token.TokenType.SINGLE_LINE_COMMENT);
    static final EnumSet<Token.TokenType> skippedTokens = EnumSet.of(Token.TokenType.WHITESPACE);
    static final EnumSet<Token.TokenType> moreTokens = EnumSet.of(Token.TokenType.SINGLE_LINE_COMMENT_START, Token.TokenType.MULTI_LINE_COMMENT_START, Token.TokenType.ANY_CHAR);
    private static final EnumMap<LexicalState, NfaFunction[]> functionTableMap;

    public static void keepWhitespace(boolean b) {
        if (b) {
            skippedTokens.remove(Token.TokenType.WHITESPACE);
            unparsedTokens.add(Token.TokenType.WHITESPACE);
        } else {
            skippedTokens.add(Token.TokenType.WHITESPACE);
            unparsedTokens.remove(Token.TokenType.WHITESPACE);
        }
    }

    public CongoCCLexer(CharSequence input) {
        this("input", input);
    }

    public CongoCCLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.JAVA, 1, 1);
    }

    public CongoCCLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, false, true, "\n");
        this.activeTokenTypes.remove(Token.TokenType.PERMITS);
        this.activeTokenTypes.remove(Token.TokenType.TRANSITIVE);
        this.activeTokenTypes.remove(Token.TokenType.YIELD);
        this.activeTokenTypes.remove(Token.TokenType.VAR);
        this.activeTokenTypes.remove(Token.TokenType.RECORD);
        this.activeTokenTypes.remove(Token.TokenType.USES);
        this.activeTokenTypes.remove(Token.TokenType._INCLUDE);
        this.activeTokenTypes.remove(Token.TokenType.WITH);
        this.activeTokenTypes.remove(Token.TokenType.OPEN);
        this.activeTokenTypes.remove(Token.TokenType._EOF);
        this.activeTokenTypes.remove(Token.TokenType.SEALED);
        this.activeTokenTypes.remove(Token.TokenType.MODULE);
        this.activeTokenTypes.remove(Token.TokenType.WHEN);
        this.activeTokenTypes.remove(Token.TokenType.OPENS);
        this.activeTokenTypes.remove(Token.TokenType.NON_SEALED);
        this.activeTokenTypes.remove(Token.TokenType.REQUIRES);
        this.activeTokenTypes.remove(Token.TokenType.PROVIDES);
        this.activeTokenTypes.remove(Token.TokenType.EXPORTS);
        this.activeTokenTypes.remove(Token.TokenType.TO);
        this.activeTokenTypes.remove(Token.TokenType._INJECT);
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        if (tok == null) {
            tok = this.tokenizeAt(0);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && this.activeTokenTypes != null && !this.activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset());
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions) {
        if (position >= input.length()) {
            return new MatchInfo(Token.TokenType.EOF, 0);
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        BitSet currentStates = new BitSet(923);
        BitSet nextStates = new BitSet(923);
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
                if (input instanceof TokenSource) {
                    position = ((TokenSource)input).nextUnignoredOffset(position);
                }
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        return new MatchInfo(matchedType, matchLength);
    }

    final Token tokenizeAt(int position) {
        int tokenBeginOffset = position;
        boolean inMore = false;
        StringBuilder invalidChars = null;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        while (matchedToken == null) {
            NfaFunction[] nfaFunctions = functionTableMap.get((Object)this.lexicalState);
            position = this.nextUnignoredOffset(position);
            if (!inMore) {
                tokenBeginOffset = position;
            }
            MatchInfo matchInfo = CongoCCLexer.getMatchInfo(this, position, this.activeTokenTypes, nfaFunctions);
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            LexicalState newState = tokenTypeToLexicalStateMap.get(matchedType);
            if (newState != null) {
                this.lexicalState = newState;
            }
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidChars == null) {
                    invalidChars = new StringBuilder();
                }
                int cp = Character.codePointAt(this, tokenBeginOffset);
                invalidChars.appendCodePoint(cp);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidChars != null) {
                return new InvalidToken(this, tokenBeginOffset - invalidChars.length(), tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        this.doLexicalStateSwitch(matchedToken.getType());
        matchedToken = this.tokenLexicalActions(matchedToken, matchedType);
        return matchedToken;
    }

    boolean doLexicalStateSwitch(Token.TokenType tokenType) {
        LexicalState newState = tokenTypeToLexicalStateMap.get(tokenType);
        if (newState == null) {
            return false;
        }
        return this.switchTo(newState);
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t, LexicalState state) {
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        } else {
            this.doLexicalStateSwitch(t.getType());
        }
    }

    void reset(Token t) {
        this.reset(t, null);
    }

    private Token tokenLexicalActions(Token matchedToken, Token.TokenType matchedType) {
        switch (matchedType) {
            case CTRL_Z: {
                matchedToken.setType(Token.TokenType.EOF);
                break;
            }
        }
        return matchedToken;
    }

    void cacheToken(Token tok) {
        if (tok.isInserted()) {
            Token next = tok.nextCachedToken();
            if (next != null) {
                this.cacheToken(next);
            }
            return;
        }
        this.cacheTokenAt(tok, tok.getBeginOffset());
    }

    @Override
    protected void uncacheTokens(Node.TerminalNode lastToken) {
        super.uncacheTokens(lastToken);
        ((Token)lastToken).unsetAppendedToken();
    }

    static {
        tokenTypeToLexicalStateMap.put(Token.TokenType.MULTI_LINE_COMMENT, LexicalState.JAVA);
        tokenTypeToLexicalStateMap.put(Token.TokenType.SINGLE_LINE_COMMENT_START, LexicalState.IN_SINGLE_LINE_COMMENT);
        tokenTypeToLexicalStateMap.put(Token.TokenType.MULTI_LINE_COMMENT_START, LexicalState.IN_MULTI_LINE_COMMENT);
        tokenTypeToLexicalStateMap.put(Token.TokenType.SINGLE_LINE_COMMENT, LexicalState.JAVA);
        functionTableMap = new EnumMap(LexicalState.class);
        JAVA.NFA_FUNCTIONS_init();
        IN_UNPARSED_CODE_BLOCK.NFA_FUNCTIONS_init();
        IN_MULTI_LINE_COMMENT.NFA_FUNCTIONS_init();
        IN_SINGLE_LINE_COMMENT.NFA_FUNCTIONS_init();
        JAVA_MODULE.NFA_FUNCTIONS_init();
    }

    private static class JAVA_MODULE {
        private static int[] NFA_MOVES_JAVA_MODULE_1 = JAVA_MODULE.NFA_MOVES_JAVA_MODULE_1_init();
        private static int[] NFA_MOVES_JAVA_MODULE_2 = JAVA_MODULE.NFA_MOVES_JAVA_MODULE_2_init();

        private JAVA_MODULE() {
        }

        private static Token.TokenType getNfaNameJAVA_MODULEIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_JAVA_MODULE_1, ch)) {
                nextStates.set(1);
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    type = Token.TokenType.IDENTIFIER;
                }
            } else if (ch == 26 && (validTypes == null || validTypes.contains(Token.TokenType.CTRL_Z))) {
                type = Token.TokenType.CTRL_Z;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVA_MODULEIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch >= 14 && ch <= 27 || ch == 36 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 127 && ch <= 159 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_JAVA_MODULE_2, ch)) {
                nextStates.set(1);
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    type = Token.TokenType.IDENTIFIER;
                }
            }
            return type;
        }

        private static int[] NFA_MOVES_JAVA_MODULE_1_init() {
            return new int[]{36, 36, 65, 90, 95, 95, 97, 122, 162, 165, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1488, 1514, 1519, 1522, 1547, 1547, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2046, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2160, 2183, 2185, 2190, 2208, 2249, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2547, 2555, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2801, 2801, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3065, 3065, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3165, 3165, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3293, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3647, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5905, 5919, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6107, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6988, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43064, 43064, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65284, 65284, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69488, 69505, 69552, 69572, 69600, 69622, 69635, 69687, 69745, 69746, 69749, 69749, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71488, 71494, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92784, 92862, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 122624, 122654, 123136, 123180, 123191, 123197, 123214, 123214, 123536, 123565, 123584, 123627, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125184, 125251, 125259, 125259, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static int[] NFA_MOVES_JAVA_MODULE_2_init() {
            return new int[]{0, 8, 14, 27, 36, 36, 48, 57, 65, 90, 95, 95, 97, 122, 127, 159, 162, 165, 170, 170, 173, 173, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1536, 1541, 1547, 1547, 1552, 1562, 1564, 1564, 1568, 1641, 1646, 1747, 1749, 1757, 1759, 1768, 1770, 1788, 1791, 1791, 1807, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2093, 2112, 2139, 2144, 2154, 2160, 2183, 2185, 2190, 2192, 2193, 2200, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2547, 2555, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2801, 2801, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3065, 3065, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3132, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3165, 3165, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3293, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3647, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5909, 5919, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6107, 6109, 6112, 6121, 6155, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6862, 6912, 6988, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8203, 8207, 8234, 8238, 8255, 8256, 8276, 8276, 8288, 8292, 8294, 8303, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43047, 43052, 43052, 43064, 43064, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65279, 65279, 65284, 65284, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65529, 65531, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69488, 69509, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69749, 69759, 69818, 69821, 69821, 69826, 69826, 69837, 69837, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71488, 71494, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 78896, 78904, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92784, 92862, 92864, 92873, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 113824, 113827, 118528, 118573, 118576, 118598, 119141, 119145, 119149, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122624, 122654, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123536, 123566, 123584, 123641, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917505, 917505, 917536, 917631, 917760, 917999};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{JAVA_MODULE::getNfaNameJAVA_MODULEIndex0, JAVA_MODULE::getNfaNameJAVA_MODULEIndex1};
            functionTableMap.put(LexicalState.JAVA_MODULE, functions);
        }
    }

    private static class IN_SINGLE_LINE_COMMENT {
        private IN_SINGLE_LINE_COMMENT() {
        }

        private static Token.TokenType getNfaNameIN_SINGLE_LINE_COMMENTIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 13) {
                nextStates.set(1);
            }
            if (ch >= 0 && (validTypes == null || validTypes.contains(Token.TokenType.ANY_CHAR))) {
                type = Token.TokenType.ANY_CHAR;
            }
            if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT)) {
                    type = Token.TokenType.SINGLE_LINE_COMMENT;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT)) {
                    type = Token.TokenType.SINGLE_LINE_COMMENT;
                }
            } else if (ch == 26 && (validTypes == null || validTypes.contains(Token.TokenType.CTRL_Z))) {
                type = Token.TokenType.CTRL_Z;
            }
            return type;
        }

        private static Token.TokenType getNfaNameIN_SINGLE_LINE_COMMENTIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 10 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT))) {
                type = Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_SINGLE_LINE_COMMENT::getNfaNameIN_SINGLE_LINE_COMMENTIndex0, IN_SINGLE_LINE_COMMENT::getNfaNameIN_SINGLE_LINE_COMMENTIndex1};
            functionTableMap.put(LexicalState.IN_SINGLE_LINE_COMMENT, functions);
        }
    }

    private static class IN_MULTI_LINE_COMMENT {
        private IN_MULTI_LINE_COMMENT() {
        }

        private static Token.TokenType getNfaNameIN_MULTI_LINE_COMMENTIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 42) {
                nextStates.set(1);
            }
            if (ch >= 0 && (validTypes == null || validTypes.contains(Token.TokenType.ANY_CHAR))) {
                type = Token.TokenType.ANY_CHAR;
            }
            if (ch == 26 && (validTypes == null || validTypes.contains(Token.TokenType.CTRL_Z))) {
                type = Token.TokenType.CTRL_Z;
            }
            return type;
        }

        private static Token.TokenType getNfaNameIN_MULTI_LINE_COMMENTIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47 && (validTypes == null || validTypes.contains(Token.TokenType.MULTI_LINE_COMMENT))) {
                type = Token.TokenType.MULTI_LINE_COMMENT;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_MULTI_LINE_COMMENT::getNfaNameIN_MULTI_LINE_COMMENTIndex0, IN_MULTI_LINE_COMMENT::getNfaNameIN_MULTI_LINE_COMMENTIndex1};
            functionTableMap.put(LexicalState.IN_MULTI_LINE_COMMENT, functions);
        }
    }

    private static class IN_UNPARSED_CODE_BLOCK {
        private IN_UNPARSED_CODE_BLOCK() {
        }

        private static Token.TokenType getNfaNameIN_UNPARSED_CODE_BLOCKIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(3);
                nextStates.set(2);
            } else if (ch == 26 && (validTypes == null || validTypes.contains(Token.TokenType.CTRL_Z))) {
                type = Token.TokenType.CTRL_Z;
            }
            if (ch >= 0 && ch <= 35 || ch >= 37) {
                nextStates.set(1);
                if (validTypes == null || validTypes.contains(Token.TokenType.UNPARSED_CONTENT)) {
                    type = Token.TokenType.UNPARSED_CONTENT;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameIN_UNPARSED_CODE_BLOCKIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(2);
            } else if (ch >= 0 && ch <= 35 || ch >= 37) {
                nextStates.set(1);
                if (validTypes == null || validTypes.contains(Token.TokenType.UNPARSED_CONTENT)) {
                    type = Token.TokenType.UNPARSED_CONTENT;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameIN_UNPARSED_CODE_BLOCKIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(2);
            }
            if (ch >= 0 && ch <= 124 || ch >= 126) {
                nextStates.set(1);
                if (validTypes == null || validTypes.contains(Token.TokenType.UNPARSED_CONTENT)) {
                    type = Token.TokenType.UNPARSED_CONTENT;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameIN_UNPARSED_CODE_BLOCKIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 125 && (validTypes == null || validTypes.contains(Token.TokenType.END_UNPARSED))) {
                type = Token.TokenType.END_UNPARSED;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_UNPARSED_CODE_BLOCK::getNfaNameIN_UNPARSED_CODE_BLOCKIndex0, IN_UNPARSED_CODE_BLOCK::getNfaNameIN_UNPARSED_CODE_BLOCKIndex1, IN_UNPARSED_CODE_BLOCK::getNfaNameIN_UNPARSED_CODE_BLOCKIndex2, IN_UNPARSED_CODE_BLOCK::getNfaNameIN_UNPARSED_CODE_BLOCKIndex3};
            functionTableMap.put(LexicalState.IN_UNPARSED_CODE_BLOCK, functions);
        }
    }

    private static class JAVA {
        private static int[] NFA_MOVES_JAVA_921 = JAVA.NFA_MOVES_JAVA_921_init();
        private static int[] NFA_MOVES_JAVA_922 = JAVA.NFA_MOVES_JAVA_922_init();

        private JAVA() {
        }

        private static Token.TokenType getNfaNameJAVAIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 33) {
                nextStates.set(555);
            } else if (ch == 34) {
                nextStates.set(10);
                nextStates.set(203);
            } else if (ch == 37) {
                nextStates.set(49);
            } else if (ch == 38) {
                nextStates.set(469);
                nextStates.set(470);
            } else if (ch == 39) {
                nextStates.set(50);
                nextStates.set(288);
            } else if (ch == 42) {
                nextStates.set(560);
            } else if (ch == 43) {
                nextStates.set(63);
                nextStates.set(520);
            } else if (ch == 45) {
                nextStates.set(287);
                nextStates.set(507);
                nextStates.set(659);
            } else if (ch == 46) {
                nextStates.set(34);
                nextStates.set(180);
            } else if (ch == 47) {
                nextStates.set(269);
                nextStates.set(472);
                nextStates.set(564);
            } else if (ch == 48) {
                nextStates.set(71);
                nextStates.set(145);
                nextStates.set(257);
                nextStates.set(390);
                nextStates.set(399);
                nextStates.set(489);
                nextStates.set(538);
                nextStates.set(676);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(127);
                nextStates.set(403);
                nextStates.set(573);
                nextStates.set(628);
            } else if (ch == 58) {
                nextStates.set(572);
            } else if (ch == 60) {
                nextStates.set(43);
                nextStates.set(156);
                nextStates.set(554);
            } else if (ch == 61) {
                nextStates.set(389);
                nextStates.set(524);
                nextStates.set(588);
            } else if (ch == 62) {
                nextStates.set(81);
                nextStates.set(398);
                nextStates.set(471);
                nextStates.set(565);
                nextStates.set(695);
            } else if (ch == 65) {
                nextStates.set(108);
                nextStates.set(166);
                nextStates.set(357);
                nextStates.set(473);
            } else if (ch == 67) {
                nextStates.set(412);
            } else if (ch == 68) {
                nextStates.set(640);
            } else if (ch == 69) {
                nextStates.set(685);
            } else if (ch == 70) {
                nextStates.set(521);
            } else if (ch == 73) {
                nextStates.set(94);
                nextStates.set(274);
                nextStates.set(307);
                nextStates.set(479);
                nextStates.set(606);
            } else if (ch == 76) {
                nextStates.set(451);
            } else if (ch == 77) {
                nextStates.set(439);
            } else if (ch == 79) {
                nextStates.set(581);
            } else if (ch == 82) {
                nextStates.set(1);
                nextStates.set(508);
                nextStates.set(699);
            } else if (ch == 83) {
                nextStates.set(251);
                nextStates.set(339);
                nextStates.set(395);
            } else if (ch == 84) {
                nextStates.set(141);
            } else if (ch == 85) {
                nextStates.set(134);
                nextStates.set(525);
            } else if (ch == 94) {
                nextStates.set(187);
            } else if (ch == 97) {
                nextStates.set(64);
                nextStates.set(665);
            } else if (ch == 98) {
                nextStates.set(157);
                nextStates.set(303);
                nextStates.set(463);
            } else if (ch == 99) {
                nextStates.set(130);
                nextStates.set(225);
                nextStates.set(235);
                nextStates.set(254);
                nextStates.set(378);
                nextStates.set(442);
            } else if (ch == 100) {
                nextStates.set(268);
                nextStates.set(429);
                nextStates.set(546);
            } else if (ch == 101) {
                nextStates.set(119);
                nextStates.set(322);
                nextStates.set(333);
                nextStates.set(620);
            } else if (ch == 102) {
                nextStates.set(270);
                nextStates.set(351);
                nextStates.set(624);
                nextStates.set(663);
                nextStates.set(711);
            } else if (ch == 103) {
                nextStates.set(20);
            } else if (ch == 105) {
                nextStates.set(25);
                nextStates.set(117);
                nextStates.set(369);
                nextStates.set(402);
                nextStates.set(612);
                nextStates.set(687);
            } else if (ch == 108) {
                nextStates.set(218);
            } else if (ch == 109) {
                nextStates.set(122);
            } else if (ch == 110) {
                nextStates.set(182);
                nextStates.set(232);
                nextStates.set(592);
                nextStates.set(697);
            } else if (ch == 111) {
                nextStates.set(435);
                nextStates.set(551);
            } else if (ch == 112) {
                nextStates.set(75);
                nextStates.set(160);
                nextStates.set(188);
                nextStates.set(196);
                nextStates.set(601);
                nextStates.set(705);
            } else if (ch == 114) {
                nextStates.set(261);
                nextStates.set(328);
                nextStates.set(446);
            } else if (ch == 115) {
                nextStates.set(15);
                nextStates.set(83);
                nextStates.set(221);
                nextStates.set(382);
                nextStates.set(503);
                nextStates.set(541);
                nextStates.set(670);
            } else if (ch == 116) {
                nextStates.set(133);
                nextStates.set(242);
                nextStates.set(279);
                nextStates.set(556);
                nextStates.set(561);
                nextStates.set(660);
                nextStates.set(680);
                nextStates.set(692);
            } else if (ch == 117) {
                nextStates.set(656);
            } else if (ch == 118) {
                nextStates.set(23);
                nextStates.set(56);
                nextStates.set(392);
            } else if (ch == 119) {
                nextStates.set(45);
                nextStates.set(113);
                nextStates.set(239);
            } else if (ch == 121) {
                nextStates.set(568);
            } else if (ch == 123) {
                nextStates.set(563);
            } else if (ch == 124) {
                nextStates.set(411);
                nextStates.set(675);
            }
            if (ch == 36 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_JAVA_921, ch)) {
                nextStates.set(623);
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    type = Token.TokenType.IDENTIFIER;
                }
            } else if (ch == 37) {
                if (validTypes == null || validTypes.contains(Token.TokenType.REM)) {
                    type = Token.TokenType.REM;
                }
            } else if (ch == 94) {
                if (validTypes == null || validTypes.contains(Token.TokenType.XOR)) {
                    type = Token.TokenType.XOR;
                }
            } else if (ch == 124) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BIT_OR)) {
                    type = Token.TokenType.BIT_OR;
                }
            } else if (ch == 38) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BIT_AND)) {
                    type = Token.TokenType.BIT_AND;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SLASH)) {
                    type = Token.TokenType.SLASH;
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STAR)) {
                    type = Token.TokenType.STAR;
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MINUS)) {
                    type = Token.TokenType.MINUS;
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PLUS)) {
                    type = Token.TokenType.PLUS;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COLON)) {
                    type = Token.TokenType.COLON;
                }
            } else if (ch == 63) {
                if (validTypes == null || validTypes.contains(Token.TokenType.HOOK)) {
                    type = Token.TokenType.HOOK;
                }
            } else if (ch == 126) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TILDE)) {
                    type = Token.TokenType.TILDE;
                }
            } else if (ch == 33) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BANG)) {
                    type = Token.TokenType.BANG;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LT)) {
                    type = Token.TokenType.LT;
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GT)) {
                    type = Token.TokenType.GT;
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ASSIGN)) {
                    type = Token.TokenType.ASSIGN;
                }
            } else if (ch == 64) {
                if (validTypes == null || validTypes.contains(Token.TokenType.AT)) {
                    type = Token.TokenType.AT;
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOT)) {
                    type = Token.TokenType.DOT;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMA)) {
                    type = Token.TokenType.COMMA;
                }
            } else if (ch == 59) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SEMICOLON)) {
                    type = Token.TokenType.SEMICOLON;
                }
            } else if (ch == 93) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RBRACKET)) {
                    type = Token.TokenType.RBRACKET;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LBRACKET)) {
                    type = Token.TokenType.LBRACKET;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RBRACE)) {
                    type = Token.TokenType.RBRACE;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LBRACE)) {
                    type = Token.TokenType.LBRACE;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RPAREN)) {
                    type = Token.TokenType.RPAREN;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LPAREN)) {
                    type = Token.TokenType.LPAREN;
                }
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(74);
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL)) {
                    type = Token.TokenType.INTEGER_LITERAL;
                }
            }
            if (ch == 95) {
                if (validTypes == null || validTypes.contains(Token.TokenType.UNDERSCORE)) {
                    type = Token.TokenType.UNDERSCORE;
                }
            } else if (ch == 26) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CTRL_Z)) {
                    type = Token.TokenType.CTRL_Z;
                }
            } else if (ch == 9) {
                nextStates.set(116);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 10) {
                nextStates.set(116);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 12) {
                nextStates.set(116);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 13) {
                nextStates.set(116);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 32) {
                nextStates.set(116);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 92) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BACKSLASH)) {
                    type = Token.TokenType.BACKSLASH;
                }
            } else if (ch == 35 && (validTypes == null || validTypes.contains(Token.TokenType.HASH))) {
                type = Token.TokenType.HASH;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(4);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(7);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(8);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(9);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 && (validTypes == null || validTypes.contains(Token.TokenType._RECOVER_TO))) {
                type = Token.TokenType._RECOVER_TO;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(10);
            } else if (ch == 92) {
                nextStates.set(11);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(Token.TokenType.STRING_LITERAL))) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(10);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(12);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(14);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(13);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(10);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(10);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(10);
            } else if (ch == 92) {
                nextStates.set(11);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(Token.TokenType.STRING_LITERAL))) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(16);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(17);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(18);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.SEALED))) {
                type = Token.TokenType.SEALED;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(21);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(22);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111 && (validTypes == null || validTypes.contains(Token.TokenType.GOTO))) {
                type = Token.TokenType.GOTO;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(24);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(Token.TokenType.VAR))) {
                type = Token.TokenType.VAR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(26);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(27);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(28);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(29);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(30);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(32);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(33);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(Token.TokenType.INSTANCEOF))) {
                type = Token.TokenType.INSTANCEOF;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(35);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(41);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(36);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(42);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(37);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(38);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(38);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(40);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(39);
                nextStates.set(38);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(38);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(40);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(39);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(41);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(42);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(36);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 60) {
                nextStates.set(44);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.LSHIFTASSIGN))) {
                type = Token.TokenType.LSHIFTASSIGN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(46);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(47);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(48);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.WHILE))) {
                type = Token.TokenType.WHILE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.REMASSIGN))) {
                type = Token.TokenType.REMASSIGN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(52);
            } else if (ch == 92) {
                nextStates.set(51);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(52);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(54);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(53);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.CHARACTER_LITERAL))) {
                type = Token.TokenType.CHARACTER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(52);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.CHARACTER_LITERAL))) {
                type = Token.TokenType.CHARACTER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(52);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(57);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(58);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(59);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(60);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(61);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(62);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.VOLATILE))) {
                type = Token.TokenType.VOLATILE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.PLUSASSIGN))) {
                type = Token.TokenType.PLUSASSIGN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 98) {
                nextStates.set(65);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(66);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(67);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(68);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(69);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(70);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.ABSTRACT))) {
                type = Token.TokenType.ABSTRACT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(72);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(73);
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL)) {
                    type = Token.TokenType.INTEGER_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(73);
            }
            if ((ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) && (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL))) {
                type = Token.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(74);
            }
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL))) {
                type = Token.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(76);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(77);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(78);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(79);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(80);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.PRIVATE))) {
                type = Token.TokenType.PRIVATE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                nextStates.set(82);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.RSIGNEDSHIFTASSIGN))) {
                type = Token.TokenType.RSIGNEDSHIFTASSIGN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 121) {
                nextStates.set(84);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(85);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(86);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(87);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(88);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(89);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(90);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(91);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 122) {
                nextStates.set(92);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(93);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.SYNCHRONIZED))) {
                type = Token.TokenType.SYNCHRONIZED;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(95);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(96);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(97);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85) {
                nextStates.set(98);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68) {
                nextStates.set(99);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(100);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(101);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71) {
                nextStates.set(102);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(103);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(104);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77) {
                nextStates.set(105);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77) {
                nextStates.set(106);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(107);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 && (validTypes == null || validTypes.contains(Token.TokenType._INCLUDE))) {
                type = Token.TokenType._INCLUDE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83) {
                nextStates.set(109);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83) {
                nextStates.set(110);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(111);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(112);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 && (validTypes == null || validTypes.contains(Token.TokenType._ENSURE))) {
                type = Token.TokenType._ENSURE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(114);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(115);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(Token.TokenType.WHEN))) {
                type = Token.TokenType.WHEN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9) {
                nextStates.set(116);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 10) {
                nextStates.set(116);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 12) {
                nextStates.set(116);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 13) {
                nextStates.set(116);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 32) {
                nextStates.set(116);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(118);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.INT))) {
                type = Token.TokenType.INT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(120);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(121);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.ELSE))) {
                type = Token.TokenType.ELSE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(123);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100) {
                nextStates.set(124);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(125);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(126);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.MODULE))) {
                type = Token.TokenType.MODULE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(128);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(129);
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.LONG_LITERAL))) {
                type = Token.TokenType.LONG_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.LONG_LITERAL))) {
                type = Token.TokenType.LONG_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(128);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(129);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(131);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(132);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(Token.TokenType.CHAR))) {
                type = Token.TokenType.CHAR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111 && (validTypes == null || validTypes.contains(Token.TokenType.TO))) {
                type = Token.TokenType.TO;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(135);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80) {
                nextStates.set(136);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(137);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(138);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83) {
                nextStates.set(139);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(140);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 && (validTypes == null || validTypes.contains(Token.TokenType._UNPARSED))) {
                type = Token.TokenType._UNPARSED;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(142);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(143);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(144);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN))) {
                type = Token.TokenType._TOKEN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(146);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(147);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(153);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(154);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(155);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(148);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(152);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(149);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(151);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(150);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(151);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(150);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(149);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(148);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(153);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(148);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(154);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(155);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 60 && (validTypes == null || validTypes.contains(Token.TokenType.LSHIFT))) {
                type = Token.TokenType.LSHIFT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 121) {
                nextStates.set(158);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(159);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.BYTE))) {
                type = Token.TokenType.BYTE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(161);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(162);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 107) {
                nextStates.set(163);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(164);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(165);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.PACKAGE))) {
                type = Token.TokenType.PACKAGE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(167);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(168);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(169);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86) {
                nextStates.set(170);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(171);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(172);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(173);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(174);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(175);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(176);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex176(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(177);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex177(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(178);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex178(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(179);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex179(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 && (validTypes == null || validTypes.contains(Token.TokenType._ACTIVATE_TOKENS))) {
                type = Token.TokenType._ACTIVATE_TOKENS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex180(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(181);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex181(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46 && (validTypes == null || validTypes.contains(Token.TokenType.VAR_ARGS))) {
                type = Token.TokenType.VAR_ARGS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex182(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(183);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex183(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(184);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex184(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(185);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex185(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(186);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex186(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.NATIVE))) {
                type = Token.TokenType.NATIVE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex187(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.XORASSIGN))) {
                type = Token.TokenType.XORASSIGN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex188(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(189);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex189(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(190);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex190(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(191);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex191(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(192);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex192(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(193);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex193(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(194);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex194(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(195);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex195(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.PROTECTED))) {
                type = Token.TokenType.PROTECTED;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex196(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(197);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex197(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(198);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex198(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(199);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex199(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(200);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex200(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100) {
                nextStates.set(201);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex201(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(202);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex202(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.PROVIDES))) {
                type = Token.TokenType.PROVIDES;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex203(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                nextStates.set(204);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex204(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                nextStates.set(205);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex205(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 12 || ch == 32) {
                nextStates.set(205);
            } else if (ch == 10) {
                nextStates.set(206);
            } else if (ch == 13) {
                nextStates.set(206);
                nextStates.set(217);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex206(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(206);
            } else if (ch == 34) {
                nextStates.set(211);
                nextStates.set(213);
                nextStates.set(212);
            } else if (ch == 92) {
                nextStates.set(207);
                nextStates.set(209);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex207(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 10) {
                nextStates.set(206);
            } else if (ch == 13) {
                nextStates.set(206);
                nextStates.set(208);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex208(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 10) {
                nextStates.set(206);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex209(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(206);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(215);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(210);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex210(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(206);
            } else if (ch == 34) {
                nextStates.set(211);
                nextStates.set(213);
                nextStates.set(212);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(206);
            } else if (ch == 92) {
                nextStates.set(207);
                nextStates.set(209);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex211(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(206);
            } else if (ch == 34) {
                nextStates.set(212);
            } else if (ch == 92) {
                nextStates.set(207);
                nextStates.set(209);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex212(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(206);
            } else if (ch == 92) {
                nextStates.set(207);
                nextStates.set(209);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex213(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                nextStates.set(214);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex214(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 && (validTypes == null || validTypes.contains(Token.TokenType.TEXT_BLOCK_LITERAL))) {
                type = Token.TokenType.TEXT_BLOCK_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex215(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(216);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex216(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(206);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex217(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 10) {
                nextStates.set(206);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex218(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(219);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex219(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(220);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex220(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103 && (validTypes == null || validTypes.contains(Token.TokenType.LONG))) {
                type = Token.TokenType.LONG;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex221(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(222);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex222(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(223);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex223(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(224);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex224(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(Token.TokenType.SUPER))) {
                type = Token.TokenType.SUPER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex225(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(226);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex226(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(227);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex227(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(228);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex228(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(229);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex229(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(230);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex230(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(231);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex231(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.CONTINUE))) {
                type = Token.TokenType.CONTINUE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex232(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(233);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex233(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(234);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex234(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(Token.TokenType.NULL))) {
                type = Token.TokenType.NULL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex235(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(236);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex236(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(237);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex237(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(238);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex238(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.CLASS))) {
                type = Token.TokenType.CLASS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex239(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(240);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex240(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(241);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex241(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(Token.TokenType.WITH))) {
                type = Token.TokenType.WITH;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex242(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(243);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex243(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(244);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex244(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(245);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex245(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(246);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex246(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(247);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex247(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(248);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex248(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(249);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex249(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(250);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex250(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.TRANSITIVE))) {
                type = Token.TokenType.TRANSITIVE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex251(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(252);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex252(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(253);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex253(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 && (validTypes == null || validTypes.contains(Token.TokenType._SKIP))) {
                type = Token.TokenType._SKIP;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex254(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(255);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex255(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(256);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex256(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.CASE))) {
                type = Token.TokenType.CASE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex257(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(258);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex258(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(259);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex259(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(260);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(128);
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.LONG_LITERAL))) {
                type = Token.TokenType.LONG_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex260(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(260);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(128);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex261(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(262);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex262(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 113) {
                nextStates.set(263);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex263(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(264);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex264(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(265);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex265(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(266);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex266(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(267);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex267(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.REQUIRES))) {
                type = Token.TokenType.REQUIRES;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex268(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111 && (validTypes == null || validTypes.contains(Token.TokenType.DO))) {
                type = Token.TokenType.DO;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex269(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.SLASHASSIGN))) {
                type = Token.TokenType.SLASHASSIGN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex270(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(271);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex271(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(272);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex272(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(273);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex273(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.FALSE))) {
                type = Token.TokenType.FALSE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex274(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(275);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex275(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 74) {
                nextStates.set(276);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex276(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(277);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex277(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(278);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex278(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 && (validTypes == null || validTypes.contains(Token.TokenType._INJECT))) {
                type = Token.TokenType._INJECT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex279(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(280);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex280(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(281);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex281(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(282);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex282(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(283);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex283(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(284);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex284(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(285);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex285(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(286);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex286(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.TRANSIENT))) {
                type = Token.TokenType.TRANSIENT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex287(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.MINUSASSIGN))) {
                type = Token.TokenType.MINUSASSIGN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex288(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(289);
            } else if (ch == 92) {
                nextStates.set(299);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex289(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(291);
            } else if (ch == 92) {
                nextStates.set(290);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex290(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(291);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(296);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(298);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex291(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(291);
            } else if (ch == 92) {
                nextStates.set(292);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_QUOTE_STRING))) {
                type = Token.TokenType.SINGLE_QUOTE_STRING;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex292(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(291);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(294);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(293);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex293(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(291);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(291);
            } else if (ch == 92) {
                nextStates.set(292);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_QUOTE_STRING))) {
                type = Token.TokenType.SINGLE_QUOTE_STRING;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex294(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(295);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex295(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(291);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex296(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(297);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex297(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(291);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex298(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(291);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(291);
            } else if (ch == 92) {
                nextStates.set(292);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_QUOTE_STRING))) {
                type = Token.TokenType.SINGLE_QUOTE_STRING;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex299(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(289);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(300);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(302);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex300(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(301);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex301(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(289);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex302(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(291);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(289);
            } else if (ch == 92) {
                nextStates.set(290);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex303(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(304);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex304(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(305);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex305(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(306);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex306(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 107 && (validTypes == null || validTypes.contains(Token.TokenType.BREAK))) {
                type = Token.TokenType.BREAK;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex307(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(308);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex308(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(309);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex309(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(310);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex310(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77) {
                nextStates.set(311);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex311(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80) {
                nextStates.set(312);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex312(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(313);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex313(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(314);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex314(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(315);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex315(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(316);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex316(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(317);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex317(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(318);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex318(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(319);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex319(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(320);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex320(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(321);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex321(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 && (validTypes == null || validTypes.contains(Token.TokenType._MORE))) {
                type = Token.TokenType._MORE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex322(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 120) {
                nextStates.set(323);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex323(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(324);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex324(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(325);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex325(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(326);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex326(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(327);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex327(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.EXPORTS))) {
                type = Token.TokenType.EXPORTS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex328(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(329);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex329(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(330);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex330(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(331);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex331(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(332);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex332(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(Token.TokenType.RETURN))) {
                type = Token.TokenType.RETURN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex333(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 120) {
                nextStates.set(334);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex334(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(335);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex335(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(336);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex336(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(337);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex337(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100) {
                nextStates.set(338);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex338(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.EXTENDS))) {
                type = Token.TokenType.EXTENDS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex339(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80) {
                nextStates.set(340);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex340(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(341);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex341(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(342);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex342(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(343);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex343(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(344);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex344(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(345);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex345(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(346);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex346(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(347);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex347(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(348);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex348(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(349);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex349(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(350);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex350(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 && (validTypes == null || validTypes.contains(Token.TokenType._UNPARSED))) {
                type = Token.TokenType._UNPARSED;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex351(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(352);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex352(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(353);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex353(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(354);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex354(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(355);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex355(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(356);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex356(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(Token.TokenType.FINALLY))) {
                type = Token.TokenType.FINALLY;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex357(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(358);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex358(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(359);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex359(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(360);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex360(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86) {
                nextStates.set(361);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex361(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(362);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex362(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(363);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex363(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(364);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex364(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(365);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex365(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(366);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex366(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(367);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex367(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(368);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex368(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 && (validTypes == null || validTypes.contains(Token.TokenType._ACTIVE_TOKENS))) {
                type = Token.TokenType._ACTIVE_TOKENS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex369(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(370);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex370(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(371);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex371(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(372);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex372(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(373);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex373(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(374);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex374(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(375);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex375(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(376);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex376(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(377);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex377(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.IMPLEMENTS))) {
                type = Token.TokenType.IMPLEMENTS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex378(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(379);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex379(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(380);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex380(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(381);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex381(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.CONST))) {
                type = Token.TokenType.CONST;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex382(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(383);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex383(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(384);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex384(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(385);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex385(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(386);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex386(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(387);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex387(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(388);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex388(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112 && (validTypes == null || validTypes.contains(Token.TokenType.STRICTFP))) {
                type = Token.TokenType.STRICTFP;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex389(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.EQ))) {
                type = Token.TokenType.EQ;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex390(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(391);
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL)) {
                    type = Token.TokenType.INTEGER_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex391(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55 || ch == 95) {
                nextStates.set(391);
            }
            if (ch >= 48 && ch <= 55 && (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL))) {
                type = Token.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex392(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(393);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex393(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(394);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex394(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.VOID))) {
                type = Token.TokenType.VOID;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex395(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(396);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex396(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(397);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex397(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 && (validTypes == null || validTypes.contains(Token.TokenType._SCAN))) {
                type = Token.TokenType._SCAN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex398(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.GE))) {
                type = Token.TokenType.GE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex399(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 66 || ch == 98) {
                nextStates.set(400);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex400(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(401);
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL)) {
                    type = Token.TokenType.INTEGER_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex401(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49 || ch == 95) {
                nextStates.set(401);
            }
            if (!(ch != 48 && ch != 49 || validTypes != null && !validTypes.contains(Token.TokenType.INTEGER_LITERAL))) {
                type = Token.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex402(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(Token.TokenType.IF))) {
                type = Token.TokenType.IF;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex403(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(404);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(405);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(406);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex404(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(404);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(405);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex405(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(406);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex406(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(410);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(407);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex407(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(407);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(408);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(409);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex408(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(408);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(409);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex409(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(407);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex410(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(407);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex411(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 124 && (validTypes == null || validTypes.contains(Token.TokenType.SC_OR))) {
                type = Token.TokenType.SC_OR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex412(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(413);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex413(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(414);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex414(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(415);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex415(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(416);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex416(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88) {
                nextStates.set(417);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex417(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(418);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex418(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85) {
                nextStates.set(419);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex419(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(420);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex420(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(421);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex421(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(422);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex422(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(423);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex423(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(424);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex424(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89) {
                nextStates.set(425);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex425(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 87) {
                nextStates.set(426);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex426(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(427);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex427(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(428);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex428(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 && (validTypes == null || validTypes.contains(Token.TokenType._CONTEXTUAL_KEYWORD))) {
                type = Token.TokenType._CONTEXTUAL_KEYWORD;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex429(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(430);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex430(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(431);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex431(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(432);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex432(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(433);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex433(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(434);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex434(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType._DEFAULT))) {
                type = Token.TokenType._DEFAULT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex435(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(436);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex436(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(437);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex437(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(438);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex438(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.OPENS))) {
                type = Token.TokenType.OPENS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex439(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(440);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex440(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(441);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex441(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 && (validTypes == null || validTypes.contains(Token.TokenType._MORE))) {
                type = Token.TokenType._MORE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex442(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(443);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex443(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(444);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex444(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(445);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex445(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(Token.TokenType.CATCH))) {
                type = Token.TokenType.CATCH;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex446(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(447);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex447(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(448);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex448(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(449);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex449(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(450);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex450(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.RECORD))) {
                type = Token.TokenType.RECORD;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex451(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(452);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex452(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88) {
                nextStates.set(453);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex453(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(454);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex454(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(455);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex455(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(456);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex456(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(457);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex457(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(458);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex458(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83) {
                nextStates.set(459);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex459(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(460);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex460(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(461);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex461(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(462);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex462(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 && (validTypes == null || validTypes.contains(Token.TokenType._LEXICAL_STATE))) {
                type = Token.TokenType._LEXICAL_STATE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex463(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(464);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex464(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(465);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex465(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(466);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex466(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(467);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex467(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(468);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex468(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(Token.TokenType.BOOLEAN))) {
                type = Token.TokenType.BOOLEAN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex469(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 38 && (validTypes == null || validTypes.contains(Token.TokenType.SC_AND))) {
                type = Token.TokenType.SC_AND;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex470(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.ANDASSIGN))) {
                type = Token.TokenType.ANDASSIGN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex471(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(Token.TokenType.RSIGNEDSHIFT))) {
                type = Token.TokenType.RSIGNEDSHIFT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex472(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 42 && (validTypes == null || validTypes.contains(Token.TokenType.MULTI_LINE_COMMENT_START))) {
                type = Token.TokenType.MULTI_LINE_COMMENT_START;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex473(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(474);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex474(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(475);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex475(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(476);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex476(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77) {
                nextStates.set(477);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex477(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80) {
                nextStates.set(478);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex478(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 && (validTypes == null || validTypes.contains(Token.TokenType._ATTEMPT))) {
                type = Token.TokenType._ATTEMPT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex479(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71) {
                nextStates.set(480);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex480(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(481);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex481(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(482);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex482(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(483);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex483(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(484);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex484(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(485);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex485(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(486);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex486(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(487);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex487(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83) {
                nextStates.set(488);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex488(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 && (validTypes == null || validTypes.contains(Token.TokenType._IGNORE_CASE))) {
                type = Token.TokenType._IGNORE_CASE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex489(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(490);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex490(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(493);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(491);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex491(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(493);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(492);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(502);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex492(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(493);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex493(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(494);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex494(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(500);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(501);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(495);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex495(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(496);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(497);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex496(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(497);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex497(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(499);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(498);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex498(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex499(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(499);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(498);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex500(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(495);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex501(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(500);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(501);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex502(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(492);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(502);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex503(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(504);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex504(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(505);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex505(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(506);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex506(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.SHORT))) {
                type = Token.TokenType.SHORT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex507(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45 && (validTypes == null || validTypes.contains(Token.TokenType.DECR))) {
                type = Token.TokenType.DECR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex508(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(509);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex509(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71) {
                nextStates.set(510);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex510(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85) {
                nextStates.set(511);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex511(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(512);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex512(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(513);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex513(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(514);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex514(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(515);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex515(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(516);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex516(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(517);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex517(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(518);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex518(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(519);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex519(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN))) {
                type = Token.TokenType._TOKEN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex520(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 && (validTypes == null || validTypes.contains(Token.TokenType.INCR))) {
                type = Token.TokenType.INCR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex521(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(522);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex522(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(523);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex523(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 && (validTypes == null || validTypes.contains(Token.TokenType._FAIL))) {
                type = Token.TokenType._FAIL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex524(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(Token.TokenType.RIGHT_ARROW))) {
                type = Token.TokenType.RIGHT_ARROW;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex525(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(526);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex526(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(527);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex527(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(528);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex528(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(529);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex529(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72) {
                nextStates.set(530);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex530(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(531);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex531(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(532);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex532(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(533);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex533(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(534);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex534(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(535);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex535(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(536);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex536(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(537);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex537(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 && (validTypes == null || validTypes.contains(Token.TokenType._UNCACHE_TOKENS))) {
                type = Token.TokenType._UNCACHE_TOKENS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex538(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(539);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex539(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(128);
            }
            if (ch >= 48 && ch <= 55 || ch == 95) {
                nextStates.set(540);
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.LONG_LITERAL))) {
                type = Token.TokenType.LONG_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex540(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(128);
            }
            if (ch >= 48 && ch <= 55 || ch == 95) {
                nextStates.set(540);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex541(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(542);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex542(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(543);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex543(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(544);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex544(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(545);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex545(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99 && (validTypes == null || validTypes.contains(Token.TokenType.STATIC))) {
                type = Token.TokenType.STATIC;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex546(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(547);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex547(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(548);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex548(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 98) {
                nextStates.set(549);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex549(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(550);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex550(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE))) {
                type = Token.TokenType.DOUBLE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex551(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(552);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex552(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(553);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex553(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(Token.TokenType.OPEN))) {
                type = Token.TokenType.OPEN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex554(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.LE))) {
                type = Token.TokenType.LE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex555(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.NE))) {
                type = Token.TokenType.NE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex556(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(557);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex557(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(558);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex558(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(559);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex559(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 119 && (validTypes == null || validTypes.contains(Token.TokenType.THROW))) {
                type = Token.TokenType.THROW;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex560(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.STARASSIGN))) {
                type = Token.TokenType.STARASSIGN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex561(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(562);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex562(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(Token.TokenType.TRY))) {
                type = Token.TokenType.TRY;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex563(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36 && (validTypes == null || validTypes.contains(Token.TokenType.START_UNPARSED))) {
                type = Token.TokenType.START_UNPARSED;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex564(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT_START))) {
                type = Token.TokenType.SINGLE_LINE_COMMENT_START;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex565(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                nextStates.set(566);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex566(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                nextStates.set(567);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex567(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.RUNSIGNEDSHIFTASSIGN))) {
                type = Token.TokenType.RUNSIGNEDSHIFTASSIGN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex568(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(569);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex569(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(570);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex570(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(571);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex571(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.YIELD))) {
                type = Token.TokenType.YIELD;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex572(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 58 && (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE_COLON))) {
                type = Token.TokenType.DOUBLE_COLON;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex573(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(574);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(580);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(575);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex574(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(575);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex575(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(576);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(577);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex576(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(577);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex577(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(579);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(578);
                nextStates.set(577);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex578(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(577);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex579(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(579);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(578);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex580(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(574);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(580);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex581(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(582);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex582(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(583);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex583(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(584);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex584(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(585);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex585(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(586);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex586(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(587);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex587(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 && (validTypes == null || validTypes.contains(Token.TokenType._ON_ERROR))) {
                type = Token.TokenType._ON_ERROR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex588(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                nextStates.set(589);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex589(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 124) {
                nextStates.set(590);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex590(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43) {
                nextStates.set(591);
            } else if (ch == 124 && (validTypes == null || validTypes.contains(Token.TokenType.UP_TO_HERE))) {
                type = Token.TokenType.UP_TO_HERE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex591(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.UP_TO_HERE))) {
                type = Token.TokenType.UP_TO_HERE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex592(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(593);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex593(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(594);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex594(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(595);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex595(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(596);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex596(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(597);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex597(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(598);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex598(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(599);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex599(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(600);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex600(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.NON_SEALED))) {
                type = Token.TokenType.NON_SEALED;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex601(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(602);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex602(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 98) {
                nextStates.set(603);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex603(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(604);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex604(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(605);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex605(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99 && (validTypes == null || validTypes.contains(Token.TokenType.PUBLIC))) {
                type = Token.TokenType.PUBLIC;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex606(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(607);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex607(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(608);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex608(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(609);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex609(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85) {
                nextStates.set(610);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex610(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68) {
                nextStates.set(611);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex611(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 && (validTypes == null || validTypes.contains(Token.TokenType._INCLUDE))) {
                type = Token.TokenType._INCLUDE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex612(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(613);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex613(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(614);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex614(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(615);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex615(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(616);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex616(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(617);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex617(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(618);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex618(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(619);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex619(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.INTERFACE))) {
                type = Token.TokenType.INTERFACE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex620(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(621);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex621(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(622);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex622(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109 && (validTypes == null || validTypes.contains(Token.TokenType.ENUM))) {
                type = Token.TokenType.ENUM;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex623(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch >= 14 && ch <= 27 || ch == 36 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 127 && ch <= 159 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_JAVA_922, ch)) {
                nextStates.set(623);
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    type = Token.TokenType.IDENTIFIER;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex624(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(625);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex625(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(626);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex626(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(627);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex627(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(Token.TokenType.FINAL))) {
                type = Token.TokenType.FINAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex628(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(629);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(630);
            } else if (ch == 46) {
                nextStates.set(631);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex629(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(629);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(630);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex630(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(631);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex631(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(632);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(637);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex632(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(636);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(633);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex633(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(634);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(633);
                nextStates.set(635);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex634(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(634);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(635);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex635(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(633);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex636(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(633);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex637(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(638);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(632);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(639);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex638(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(638);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(639);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex639(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(632);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex640(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(641);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex641(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(642);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex642(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(643);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex643(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(644);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex644(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(645);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex645(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86) {
                nextStates.set(646);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex646(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(647);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex647(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(648);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex648(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(649);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex649(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(650);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex650(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(651);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex651(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(652);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex652(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(653);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex653(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(654);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex654(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(655);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex655(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 && (validTypes == null || validTypes.contains(Token.TokenType._DEACTIVATE_TOKENS))) {
                type = Token.TokenType._DEACTIVATE_TOKENS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex656(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(657);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex657(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(658);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex658(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.USES))) {
                type = Token.TokenType.USES;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex659(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(Token.TokenType.LAMBDA))) {
                type = Token.TokenType.LAMBDA;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex660(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(661);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex661(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(662);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex662(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.THIS))) {
                type = Token.TokenType.THIS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex663(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(664);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex664(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(Token.TokenType.FOR))) {
                type = Token.TokenType.FOR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex665(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(666);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex666(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(667);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex667(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(668);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex668(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(669);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex669(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType._ASSERT))) {
                type = Token.TokenType._ASSERT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex670(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 119) {
                nextStates.set(671);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex671(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(672);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex672(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(673);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex673(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(674);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex674(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(Token.TokenType.SWITCH))) {
                type = Token.TokenType.SWITCH;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex675(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.ORASSIGN))) {
                type = Token.TokenType.ORASSIGN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex676(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 66 || ch == 98) {
                nextStates.set(677);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex677(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(678);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex678(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(128);
            }
            if (ch == 48 || ch == 49 || ch == 95) {
                nextStates.set(679);
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.LONG_LITERAL))) {
                type = Token.TokenType.LONG_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex679(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(128);
            }
            if (ch == 48 || ch == 49 || ch == 95) {
                nextStates.set(679);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex680(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(681);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex681(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(682);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex682(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(683);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex683(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 119) {
                nextStates.set(684);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex684(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.THROWS))) {
                type = Token.TokenType.THROWS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex685(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(686);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex686(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 && (validTypes == null || validTypes.contains(Token.TokenType._EOF))) {
                type = Token.TokenType._EOF;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex687(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(688);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex688(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(689);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex689(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(690);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex690(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(691);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex691(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType._IMPORT))) {
                type = Token.TokenType._IMPORT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex692(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(693);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex693(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(694);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex694(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.TRUE))) {
                type = Token.TokenType.TRUE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex695(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                nextStates.set(696);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex696(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(Token.TokenType.RUNSIGNEDSHIFT))) {
                type = Token.TokenType.RUNSIGNEDSHIFT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex697(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(698);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex698(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 119 && (validTypes == null || validTypes.contains(Token.TokenType.NEW))) {
                type = Token.TokenType.NEW;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex699(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(700);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex700(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(701);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex701(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(702);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex702(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86) {
                nextStates.set(703);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex703(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(704);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex704(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 && (validTypes == null || validTypes.contains(Token.TokenType._RECOVER))) {
                type = Token.TokenType._RECOVER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex705(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(706);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex706(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(707);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex707(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(708);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex708(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(709);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex709(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(710);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex710(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.PERMITS))) {
                type = Token.TokenType.PERMITS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex711(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(712);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex712(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(713);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex713(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(714);
            }
            return type;
        }

        private static Token.TokenType getNfaNameJAVAIndex714(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.FLOAT))) {
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static int[] NFA_MOVES_JAVA_921_init() {
            return new int[]{36, 36, 65, 90, 95, 95, 97, 122, 162, 165, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1488, 1514, 1519, 1522, 1547, 1547, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2046, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2160, 2183, 2185, 2190, 2208, 2249, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2547, 2555, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2801, 2801, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3065, 3065, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3165, 3165, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3293, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3647, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5905, 5919, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6107, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6988, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43064, 43064, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65284, 65284, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69488, 69505, 69552, 69572, 69600, 69622, 69635, 69687, 69745, 69746, 69749, 69749, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71488, 71494, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92784, 92862, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 122624, 122654, 123136, 123180, 123191, 123197, 123214, 123214, 123536, 123565, 123584, 123627, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125184, 125251, 125259, 125259, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static int[] NFA_MOVES_JAVA_922_init() {
            return new int[]{0, 8, 14, 27, 36, 36, 48, 57, 65, 90, 95, 95, 97, 122, 127, 159, 162, 165, 170, 170, 173, 173, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1536, 1541, 1547, 1547, 1552, 1562, 1564, 1564, 1568, 1641, 1646, 1747, 1749, 1757, 1759, 1768, 1770, 1788, 1791, 1791, 1807, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2093, 2112, 2139, 2144, 2154, 2160, 2183, 2185, 2190, 2192, 2193, 2200, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2547, 2555, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2801, 2801, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3065, 3065, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3132, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3165, 3165, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3293, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3647, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5909, 5919, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6107, 6109, 6112, 6121, 6155, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6862, 6912, 6988, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8203, 8207, 8234, 8238, 8255, 8256, 8276, 8276, 8288, 8292, 8294, 8303, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43047, 43052, 43052, 43064, 43064, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65279, 65279, 65284, 65284, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65529, 65531, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69488, 69509, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69749, 69759, 69818, 69821, 69821, 69826, 69826, 69837, 69837, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71488, 71494, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 78896, 78904, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92784, 92862, 92864, 92873, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 113824, 113827, 118528, 118573, 118576, 118598, 119141, 119145, 119149, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122624, 122654, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123536, 123566, 123584, 123641, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917505, 917505, 917536, 917631, 917760, 917999};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{JAVA::getNfaNameJAVAIndex0, JAVA::getNfaNameJAVAIndex1, JAVA::getNfaNameJAVAIndex2, JAVA::getNfaNameJAVAIndex3, JAVA::getNfaNameJAVAIndex4, JAVA::getNfaNameJAVAIndex5, JAVA::getNfaNameJAVAIndex6, JAVA::getNfaNameJAVAIndex7, JAVA::getNfaNameJAVAIndex8, JAVA::getNfaNameJAVAIndex9, JAVA::getNfaNameJAVAIndex10, JAVA::getNfaNameJAVAIndex11, JAVA::getNfaNameJAVAIndex12, JAVA::getNfaNameJAVAIndex13, JAVA::getNfaNameJAVAIndex14, JAVA::getNfaNameJAVAIndex15, JAVA::getNfaNameJAVAIndex16, JAVA::getNfaNameJAVAIndex17, JAVA::getNfaNameJAVAIndex18, JAVA::getNfaNameJAVAIndex19, JAVA::getNfaNameJAVAIndex20, JAVA::getNfaNameJAVAIndex21, JAVA::getNfaNameJAVAIndex22, JAVA::getNfaNameJAVAIndex23, JAVA::getNfaNameJAVAIndex24, JAVA::getNfaNameJAVAIndex25, JAVA::getNfaNameJAVAIndex26, JAVA::getNfaNameJAVAIndex27, JAVA::getNfaNameJAVAIndex28, JAVA::getNfaNameJAVAIndex29, JAVA::getNfaNameJAVAIndex30, JAVA::getNfaNameJAVAIndex31, JAVA::getNfaNameJAVAIndex32, JAVA::getNfaNameJAVAIndex33, JAVA::getNfaNameJAVAIndex34, JAVA::getNfaNameJAVAIndex35, JAVA::getNfaNameJAVAIndex36, JAVA::getNfaNameJAVAIndex37, JAVA::getNfaNameJAVAIndex38, JAVA::getNfaNameJAVAIndex39, JAVA::getNfaNameJAVAIndex40, JAVA::getNfaNameJAVAIndex41, JAVA::getNfaNameJAVAIndex42, JAVA::getNfaNameJAVAIndex43, JAVA::getNfaNameJAVAIndex44, JAVA::getNfaNameJAVAIndex45, JAVA::getNfaNameJAVAIndex46, JAVA::getNfaNameJAVAIndex47, JAVA::getNfaNameJAVAIndex48, JAVA::getNfaNameJAVAIndex49, JAVA::getNfaNameJAVAIndex50, JAVA::getNfaNameJAVAIndex51, JAVA::getNfaNameJAVAIndex52, JAVA::getNfaNameJAVAIndex53, JAVA::getNfaNameJAVAIndex54, JAVA::getNfaNameJAVAIndex55, JAVA::getNfaNameJAVAIndex56, JAVA::getNfaNameJAVAIndex57, JAVA::getNfaNameJAVAIndex58, JAVA::getNfaNameJAVAIndex59, JAVA::getNfaNameJAVAIndex60, JAVA::getNfaNameJAVAIndex61, JAVA::getNfaNameJAVAIndex62, JAVA::getNfaNameJAVAIndex63, JAVA::getNfaNameJAVAIndex64, JAVA::getNfaNameJAVAIndex65, JAVA::getNfaNameJAVAIndex66, JAVA::getNfaNameJAVAIndex67, JAVA::getNfaNameJAVAIndex68, JAVA::getNfaNameJAVAIndex69, JAVA::getNfaNameJAVAIndex70, JAVA::getNfaNameJAVAIndex71, JAVA::getNfaNameJAVAIndex72, JAVA::getNfaNameJAVAIndex73, JAVA::getNfaNameJAVAIndex74, JAVA::getNfaNameJAVAIndex75, JAVA::getNfaNameJAVAIndex76, JAVA::getNfaNameJAVAIndex77, JAVA::getNfaNameJAVAIndex78, JAVA::getNfaNameJAVAIndex79, JAVA::getNfaNameJAVAIndex80, JAVA::getNfaNameJAVAIndex81, JAVA::getNfaNameJAVAIndex82, JAVA::getNfaNameJAVAIndex83, JAVA::getNfaNameJAVAIndex84, JAVA::getNfaNameJAVAIndex85, JAVA::getNfaNameJAVAIndex86, JAVA::getNfaNameJAVAIndex87, JAVA::getNfaNameJAVAIndex88, JAVA::getNfaNameJAVAIndex89, JAVA::getNfaNameJAVAIndex90, JAVA::getNfaNameJAVAIndex91, JAVA::getNfaNameJAVAIndex92, JAVA::getNfaNameJAVAIndex93, JAVA::getNfaNameJAVAIndex94, JAVA::getNfaNameJAVAIndex95, JAVA::getNfaNameJAVAIndex96, JAVA::getNfaNameJAVAIndex97, JAVA::getNfaNameJAVAIndex98, JAVA::getNfaNameJAVAIndex99, JAVA::getNfaNameJAVAIndex100, JAVA::getNfaNameJAVAIndex101, JAVA::getNfaNameJAVAIndex102, JAVA::getNfaNameJAVAIndex103, JAVA::getNfaNameJAVAIndex104, JAVA::getNfaNameJAVAIndex105, JAVA::getNfaNameJAVAIndex106, JAVA::getNfaNameJAVAIndex107, JAVA::getNfaNameJAVAIndex108, JAVA::getNfaNameJAVAIndex109, JAVA::getNfaNameJAVAIndex110, JAVA::getNfaNameJAVAIndex111, JAVA::getNfaNameJAVAIndex112, JAVA::getNfaNameJAVAIndex113, JAVA::getNfaNameJAVAIndex114, JAVA::getNfaNameJAVAIndex115, JAVA::getNfaNameJAVAIndex116, JAVA::getNfaNameJAVAIndex117, JAVA::getNfaNameJAVAIndex118, JAVA::getNfaNameJAVAIndex119, JAVA::getNfaNameJAVAIndex120, JAVA::getNfaNameJAVAIndex121, JAVA::getNfaNameJAVAIndex122, JAVA::getNfaNameJAVAIndex123, JAVA::getNfaNameJAVAIndex124, JAVA::getNfaNameJAVAIndex125, JAVA::getNfaNameJAVAIndex126, JAVA::getNfaNameJAVAIndex127, JAVA::getNfaNameJAVAIndex128, JAVA::getNfaNameJAVAIndex129, JAVA::getNfaNameJAVAIndex130, JAVA::getNfaNameJAVAIndex131, JAVA::getNfaNameJAVAIndex132, JAVA::getNfaNameJAVAIndex133, JAVA::getNfaNameJAVAIndex134, JAVA::getNfaNameJAVAIndex135, JAVA::getNfaNameJAVAIndex136, JAVA::getNfaNameJAVAIndex137, JAVA::getNfaNameJAVAIndex138, JAVA::getNfaNameJAVAIndex139, JAVA::getNfaNameJAVAIndex140, JAVA::getNfaNameJAVAIndex141, JAVA::getNfaNameJAVAIndex142, JAVA::getNfaNameJAVAIndex143, JAVA::getNfaNameJAVAIndex144, JAVA::getNfaNameJAVAIndex145, JAVA::getNfaNameJAVAIndex146, JAVA::getNfaNameJAVAIndex147, JAVA::getNfaNameJAVAIndex148, JAVA::getNfaNameJAVAIndex149, JAVA::getNfaNameJAVAIndex150, JAVA::getNfaNameJAVAIndex151, JAVA::getNfaNameJAVAIndex152, JAVA::getNfaNameJAVAIndex153, JAVA::getNfaNameJAVAIndex154, JAVA::getNfaNameJAVAIndex155, JAVA::getNfaNameJAVAIndex156, JAVA::getNfaNameJAVAIndex157, JAVA::getNfaNameJAVAIndex158, JAVA::getNfaNameJAVAIndex159, JAVA::getNfaNameJAVAIndex160, JAVA::getNfaNameJAVAIndex161, JAVA::getNfaNameJAVAIndex162, JAVA::getNfaNameJAVAIndex163, JAVA::getNfaNameJAVAIndex164, JAVA::getNfaNameJAVAIndex165, JAVA::getNfaNameJAVAIndex166, JAVA::getNfaNameJAVAIndex167, JAVA::getNfaNameJAVAIndex168, JAVA::getNfaNameJAVAIndex169, JAVA::getNfaNameJAVAIndex170, JAVA::getNfaNameJAVAIndex171, JAVA::getNfaNameJAVAIndex172, JAVA::getNfaNameJAVAIndex173, JAVA::getNfaNameJAVAIndex174, JAVA::getNfaNameJAVAIndex175, JAVA::getNfaNameJAVAIndex176, JAVA::getNfaNameJAVAIndex177, JAVA::getNfaNameJAVAIndex178, JAVA::getNfaNameJAVAIndex179, JAVA::getNfaNameJAVAIndex180, JAVA::getNfaNameJAVAIndex181, JAVA::getNfaNameJAVAIndex182, JAVA::getNfaNameJAVAIndex183, JAVA::getNfaNameJAVAIndex184, JAVA::getNfaNameJAVAIndex185, JAVA::getNfaNameJAVAIndex186, JAVA::getNfaNameJAVAIndex187, JAVA::getNfaNameJAVAIndex188, JAVA::getNfaNameJAVAIndex189, JAVA::getNfaNameJAVAIndex190, JAVA::getNfaNameJAVAIndex191, JAVA::getNfaNameJAVAIndex192, JAVA::getNfaNameJAVAIndex193, JAVA::getNfaNameJAVAIndex194, JAVA::getNfaNameJAVAIndex195, JAVA::getNfaNameJAVAIndex196, JAVA::getNfaNameJAVAIndex197, JAVA::getNfaNameJAVAIndex198, JAVA::getNfaNameJAVAIndex199, JAVA::getNfaNameJAVAIndex200, JAVA::getNfaNameJAVAIndex201, JAVA::getNfaNameJAVAIndex202, JAVA::getNfaNameJAVAIndex203, JAVA::getNfaNameJAVAIndex204, JAVA::getNfaNameJAVAIndex205, JAVA::getNfaNameJAVAIndex206, JAVA::getNfaNameJAVAIndex207, JAVA::getNfaNameJAVAIndex208, JAVA::getNfaNameJAVAIndex209, JAVA::getNfaNameJAVAIndex210, JAVA::getNfaNameJAVAIndex211, JAVA::getNfaNameJAVAIndex212, JAVA::getNfaNameJAVAIndex213, JAVA::getNfaNameJAVAIndex214, JAVA::getNfaNameJAVAIndex215, JAVA::getNfaNameJAVAIndex216, JAVA::getNfaNameJAVAIndex217, JAVA::getNfaNameJAVAIndex218, JAVA::getNfaNameJAVAIndex219, JAVA::getNfaNameJAVAIndex220, JAVA::getNfaNameJAVAIndex221, JAVA::getNfaNameJAVAIndex222, JAVA::getNfaNameJAVAIndex223, JAVA::getNfaNameJAVAIndex224, JAVA::getNfaNameJAVAIndex225, JAVA::getNfaNameJAVAIndex226, JAVA::getNfaNameJAVAIndex227, JAVA::getNfaNameJAVAIndex228, JAVA::getNfaNameJAVAIndex229, JAVA::getNfaNameJAVAIndex230, JAVA::getNfaNameJAVAIndex231, JAVA::getNfaNameJAVAIndex232, JAVA::getNfaNameJAVAIndex233, JAVA::getNfaNameJAVAIndex234, JAVA::getNfaNameJAVAIndex235, JAVA::getNfaNameJAVAIndex236, JAVA::getNfaNameJAVAIndex237, JAVA::getNfaNameJAVAIndex238, JAVA::getNfaNameJAVAIndex239, JAVA::getNfaNameJAVAIndex240, JAVA::getNfaNameJAVAIndex241, JAVA::getNfaNameJAVAIndex242, JAVA::getNfaNameJAVAIndex243, JAVA::getNfaNameJAVAIndex244, JAVA::getNfaNameJAVAIndex245, JAVA::getNfaNameJAVAIndex246, JAVA::getNfaNameJAVAIndex247, JAVA::getNfaNameJAVAIndex248, JAVA::getNfaNameJAVAIndex249, JAVA::getNfaNameJAVAIndex250, JAVA::getNfaNameJAVAIndex251, JAVA::getNfaNameJAVAIndex252, JAVA::getNfaNameJAVAIndex253, JAVA::getNfaNameJAVAIndex254, JAVA::getNfaNameJAVAIndex255, JAVA::getNfaNameJAVAIndex256, JAVA::getNfaNameJAVAIndex257, JAVA::getNfaNameJAVAIndex258, JAVA::getNfaNameJAVAIndex259, JAVA::getNfaNameJAVAIndex260, JAVA::getNfaNameJAVAIndex261, JAVA::getNfaNameJAVAIndex262, JAVA::getNfaNameJAVAIndex263, JAVA::getNfaNameJAVAIndex264, JAVA::getNfaNameJAVAIndex265, JAVA::getNfaNameJAVAIndex266, JAVA::getNfaNameJAVAIndex267, JAVA::getNfaNameJAVAIndex268, JAVA::getNfaNameJAVAIndex269, JAVA::getNfaNameJAVAIndex270, JAVA::getNfaNameJAVAIndex271, JAVA::getNfaNameJAVAIndex272, JAVA::getNfaNameJAVAIndex273, JAVA::getNfaNameJAVAIndex274, JAVA::getNfaNameJAVAIndex275, JAVA::getNfaNameJAVAIndex276, JAVA::getNfaNameJAVAIndex277, JAVA::getNfaNameJAVAIndex278, JAVA::getNfaNameJAVAIndex279, JAVA::getNfaNameJAVAIndex280, JAVA::getNfaNameJAVAIndex281, JAVA::getNfaNameJAVAIndex282, JAVA::getNfaNameJAVAIndex283, JAVA::getNfaNameJAVAIndex284, JAVA::getNfaNameJAVAIndex285, JAVA::getNfaNameJAVAIndex286, JAVA::getNfaNameJAVAIndex287, JAVA::getNfaNameJAVAIndex288, JAVA::getNfaNameJAVAIndex289, JAVA::getNfaNameJAVAIndex290, JAVA::getNfaNameJAVAIndex291, JAVA::getNfaNameJAVAIndex292, JAVA::getNfaNameJAVAIndex293, JAVA::getNfaNameJAVAIndex294, JAVA::getNfaNameJAVAIndex295, JAVA::getNfaNameJAVAIndex296, JAVA::getNfaNameJAVAIndex297, JAVA::getNfaNameJAVAIndex298, JAVA::getNfaNameJAVAIndex299, JAVA::getNfaNameJAVAIndex300, JAVA::getNfaNameJAVAIndex301, JAVA::getNfaNameJAVAIndex302, JAVA::getNfaNameJAVAIndex303, JAVA::getNfaNameJAVAIndex304, JAVA::getNfaNameJAVAIndex305, JAVA::getNfaNameJAVAIndex306, JAVA::getNfaNameJAVAIndex307, JAVA::getNfaNameJAVAIndex308, JAVA::getNfaNameJAVAIndex309, JAVA::getNfaNameJAVAIndex310, JAVA::getNfaNameJAVAIndex311, JAVA::getNfaNameJAVAIndex312, JAVA::getNfaNameJAVAIndex313, JAVA::getNfaNameJAVAIndex314, JAVA::getNfaNameJAVAIndex315, JAVA::getNfaNameJAVAIndex316, JAVA::getNfaNameJAVAIndex317, JAVA::getNfaNameJAVAIndex318, JAVA::getNfaNameJAVAIndex319, JAVA::getNfaNameJAVAIndex320, JAVA::getNfaNameJAVAIndex321, JAVA::getNfaNameJAVAIndex322, JAVA::getNfaNameJAVAIndex323, JAVA::getNfaNameJAVAIndex324, JAVA::getNfaNameJAVAIndex325, JAVA::getNfaNameJAVAIndex326, JAVA::getNfaNameJAVAIndex327, JAVA::getNfaNameJAVAIndex328, JAVA::getNfaNameJAVAIndex329, JAVA::getNfaNameJAVAIndex330, JAVA::getNfaNameJAVAIndex331, JAVA::getNfaNameJAVAIndex332, JAVA::getNfaNameJAVAIndex333, JAVA::getNfaNameJAVAIndex334, JAVA::getNfaNameJAVAIndex335, JAVA::getNfaNameJAVAIndex336, JAVA::getNfaNameJAVAIndex337, JAVA::getNfaNameJAVAIndex338, JAVA::getNfaNameJAVAIndex339, JAVA::getNfaNameJAVAIndex340, JAVA::getNfaNameJAVAIndex341, JAVA::getNfaNameJAVAIndex342, JAVA::getNfaNameJAVAIndex343, JAVA::getNfaNameJAVAIndex344, JAVA::getNfaNameJAVAIndex345, JAVA::getNfaNameJAVAIndex346, JAVA::getNfaNameJAVAIndex347, JAVA::getNfaNameJAVAIndex348, JAVA::getNfaNameJAVAIndex349, JAVA::getNfaNameJAVAIndex350, JAVA::getNfaNameJAVAIndex351, JAVA::getNfaNameJAVAIndex352, JAVA::getNfaNameJAVAIndex353, JAVA::getNfaNameJAVAIndex354, JAVA::getNfaNameJAVAIndex355, JAVA::getNfaNameJAVAIndex356, JAVA::getNfaNameJAVAIndex357, JAVA::getNfaNameJAVAIndex358, JAVA::getNfaNameJAVAIndex359, JAVA::getNfaNameJAVAIndex360, JAVA::getNfaNameJAVAIndex361, JAVA::getNfaNameJAVAIndex362, JAVA::getNfaNameJAVAIndex363, JAVA::getNfaNameJAVAIndex364, JAVA::getNfaNameJAVAIndex365, JAVA::getNfaNameJAVAIndex366, JAVA::getNfaNameJAVAIndex367, JAVA::getNfaNameJAVAIndex368, JAVA::getNfaNameJAVAIndex369, JAVA::getNfaNameJAVAIndex370, JAVA::getNfaNameJAVAIndex371, JAVA::getNfaNameJAVAIndex372, JAVA::getNfaNameJAVAIndex373, JAVA::getNfaNameJAVAIndex374, JAVA::getNfaNameJAVAIndex375, JAVA::getNfaNameJAVAIndex376, JAVA::getNfaNameJAVAIndex377, JAVA::getNfaNameJAVAIndex378, JAVA::getNfaNameJAVAIndex379, JAVA::getNfaNameJAVAIndex380, JAVA::getNfaNameJAVAIndex381, JAVA::getNfaNameJAVAIndex382, JAVA::getNfaNameJAVAIndex383, JAVA::getNfaNameJAVAIndex384, JAVA::getNfaNameJAVAIndex385, JAVA::getNfaNameJAVAIndex386, JAVA::getNfaNameJAVAIndex387, JAVA::getNfaNameJAVAIndex388, JAVA::getNfaNameJAVAIndex389, JAVA::getNfaNameJAVAIndex390, JAVA::getNfaNameJAVAIndex391, JAVA::getNfaNameJAVAIndex392, JAVA::getNfaNameJAVAIndex393, JAVA::getNfaNameJAVAIndex394, JAVA::getNfaNameJAVAIndex395, JAVA::getNfaNameJAVAIndex396, JAVA::getNfaNameJAVAIndex397, JAVA::getNfaNameJAVAIndex398, JAVA::getNfaNameJAVAIndex399, JAVA::getNfaNameJAVAIndex400, JAVA::getNfaNameJAVAIndex401, JAVA::getNfaNameJAVAIndex402, JAVA::getNfaNameJAVAIndex403, JAVA::getNfaNameJAVAIndex404, JAVA::getNfaNameJAVAIndex405, JAVA::getNfaNameJAVAIndex406, JAVA::getNfaNameJAVAIndex407, JAVA::getNfaNameJAVAIndex408, JAVA::getNfaNameJAVAIndex409, JAVA::getNfaNameJAVAIndex410, JAVA::getNfaNameJAVAIndex411, JAVA::getNfaNameJAVAIndex412, JAVA::getNfaNameJAVAIndex413, JAVA::getNfaNameJAVAIndex414, JAVA::getNfaNameJAVAIndex415, JAVA::getNfaNameJAVAIndex416, JAVA::getNfaNameJAVAIndex417, JAVA::getNfaNameJAVAIndex418, JAVA::getNfaNameJAVAIndex419, JAVA::getNfaNameJAVAIndex420, JAVA::getNfaNameJAVAIndex421, JAVA::getNfaNameJAVAIndex422, JAVA::getNfaNameJAVAIndex423, JAVA::getNfaNameJAVAIndex424, JAVA::getNfaNameJAVAIndex425, JAVA::getNfaNameJAVAIndex426, JAVA::getNfaNameJAVAIndex427, JAVA::getNfaNameJAVAIndex428, JAVA::getNfaNameJAVAIndex429, JAVA::getNfaNameJAVAIndex430, JAVA::getNfaNameJAVAIndex431, JAVA::getNfaNameJAVAIndex432, JAVA::getNfaNameJAVAIndex433, JAVA::getNfaNameJAVAIndex434, JAVA::getNfaNameJAVAIndex435, JAVA::getNfaNameJAVAIndex436, JAVA::getNfaNameJAVAIndex437, JAVA::getNfaNameJAVAIndex438, JAVA::getNfaNameJAVAIndex439, JAVA::getNfaNameJAVAIndex440, JAVA::getNfaNameJAVAIndex441, JAVA::getNfaNameJAVAIndex442, JAVA::getNfaNameJAVAIndex443, JAVA::getNfaNameJAVAIndex444, JAVA::getNfaNameJAVAIndex445, JAVA::getNfaNameJAVAIndex446, JAVA::getNfaNameJAVAIndex447, JAVA::getNfaNameJAVAIndex448, JAVA::getNfaNameJAVAIndex449, JAVA::getNfaNameJAVAIndex450, JAVA::getNfaNameJAVAIndex451, JAVA::getNfaNameJAVAIndex452, JAVA::getNfaNameJAVAIndex453, JAVA::getNfaNameJAVAIndex454, JAVA::getNfaNameJAVAIndex455, JAVA::getNfaNameJAVAIndex456, JAVA::getNfaNameJAVAIndex457, JAVA::getNfaNameJAVAIndex458, JAVA::getNfaNameJAVAIndex459, JAVA::getNfaNameJAVAIndex460, JAVA::getNfaNameJAVAIndex461, JAVA::getNfaNameJAVAIndex462, JAVA::getNfaNameJAVAIndex463, JAVA::getNfaNameJAVAIndex464, JAVA::getNfaNameJAVAIndex465, JAVA::getNfaNameJAVAIndex466, JAVA::getNfaNameJAVAIndex467, JAVA::getNfaNameJAVAIndex468, JAVA::getNfaNameJAVAIndex469, JAVA::getNfaNameJAVAIndex470, JAVA::getNfaNameJAVAIndex471, JAVA::getNfaNameJAVAIndex472, JAVA::getNfaNameJAVAIndex473, JAVA::getNfaNameJAVAIndex474, JAVA::getNfaNameJAVAIndex475, JAVA::getNfaNameJAVAIndex476, JAVA::getNfaNameJAVAIndex477, JAVA::getNfaNameJAVAIndex478, JAVA::getNfaNameJAVAIndex479, JAVA::getNfaNameJAVAIndex480, JAVA::getNfaNameJAVAIndex481, JAVA::getNfaNameJAVAIndex482, JAVA::getNfaNameJAVAIndex483, JAVA::getNfaNameJAVAIndex484, JAVA::getNfaNameJAVAIndex485, JAVA::getNfaNameJAVAIndex486, JAVA::getNfaNameJAVAIndex487, JAVA::getNfaNameJAVAIndex488, JAVA::getNfaNameJAVAIndex489, JAVA::getNfaNameJAVAIndex490, JAVA::getNfaNameJAVAIndex491, JAVA::getNfaNameJAVAIndex492, JAVA::getNfaNameJAVAIndex493, JAVA::getNfaNameJAVAIndex494, JAVA::getNfaNameJAVAIndex495, JAVA::getNfaNameJAVAIndex496, JAVA::getNfaNameJAVAIndex497, JAVA::getNfaNameJAVAIndex498, JAVA::getNfaNameJAVAIndex499, JAVA::getNfaNameJAVAIndex500, JAVA::getNfaNameJAVAIndex501, JAVA::getNfaNameJAVAIndex502, JAVA::getNfaNameJAVAIndex503, JAVA::getNfaNameJAVAIndex504, JAVA::getNfaNameJAVAIndex505, JAVA::getNfaNameJAVAIndex506, JAVA::getNfaNameJAVAIndex507, JAVA::getNfaNameJAVAIndex508, JAVA::getNfaNameJAVAIndex509, JAVA::getNfaNameJAVAIndex510, JAVA::getNfaNameJAVAIndex511, JAVA::getNfaNameJAVAIndex512, JAVA::getNfaNameJAVAIndex513, JAVA::getNfaNameJAVAIndex514, JAVA::getNfaNameJAVAIndex515, JAVA::getNfaNameJAVAIndex516, JAVA::getNfaNameJAVAIndex517, JAVA::getNfaNameJAVAIndex518, JAVA::getNfaNameJAVAIndex519, JAVA::getNfaNameJAVAIndex520, JAVA::getNfaNameJAVAIndex521, JAVA::getNfaNameJAVAIndex522, JAVA::getNfaNameJAVAIndex523, JAVA::getNfaNameJAVAIndex524, JAVA::getNfaNameJAVAIndex525, JAVA::getNfaNameJAVAIndex526, JAVA::getNfaNameJAVAIndex527, JAVA::getNfaNameJAVAIndex528, JAVA::getNfaNameJAVAIndex529, JAVA::getNfaNameJAVAIndex530, JAVA::getNfaNameJAVAIndex531, JAVA::getNfaNameJAVAIndex532, JAVA::getNfaNameJAVAIndex533, JAVA::getNfaNameJAVAIndex534, JAVA::getNfaNameJAVAIndex535, JAVA::getNfaNameJAVAIndex536, JAVA::getNfaNameJAVAIndex537, JAVA::getNfaNameJAVAIndex538, JAVA::getNfaNameJAVAIndex539, JAVA::getNfaNameJAVAIndex540, JAVA::getNfaNameJAVAIndex541, JAVA::getNfaNameJAVAIndex542, JAVA::getNfaNameJAVAIndex543, JAVA::getNfaNameJAVAIndex544, JAVA::getNfaNameJAVAIndex545, JAVA::getNfaNameJAVAIndex546, JAVA::getNfaNameJAVAIndex547, JAVA::getNfaNameJAVAIndex548, JAVA::getNfaNameJAVAIndex549, JAVA::getNfaNameJAVAIndex550, JAVA::getNfaNameJAVAIndex551, JAVA::getNfaNameJAVAIndex552, JAVA::getNfaNameJAVAIndex553, JAVA::getNfaNameJAVAIndex554, JAVA::getNfaNameJAVAIndex555, JAVA::getNfaNameJAVAIndex556, JAVA::getNfaNameJAVAIndex557, JAVA::getNfaNameJAVAIndex558, JAVA::getNfaNameJAVAIndex559, JAVA::getNfaNameJAVAIndex560, JAVA::getNfaNameJAVAIndex561, JAVA::getNfaNameJAVAIndex562, JAVA::getNfaNameJAVAIndex563, JAVA::getNfaNameJAVAIndex564, JAVA::getNfaNameJAVAIndex565, JAVA::getNfaNameJAVAIndex566, JAVA::getNfaNameJAVAIndex567, JAVA::getNfaNameJAVAIndex568, JAVA::getNfaNameJAVAIndex569, JAVA::getNfaNameJAVAIndex570, JAVA::getNfaNameJAVAIndex571, JAVA::getNfaNameJAVAIndex572, JAVA::getNfaNameJAVAIndex573, JAVA::getNfaNameJAVAIndex574, JAVA::getNfaNameJAVAIndex575, JAVA::getNfaNameJAVAIndex576, JAVA::getNfaNameJAVAIndex577, JAVA::getNfaNameJAVAIndex578, JAVA::getNfaNameJAVAIndex579, JAVA::getNfaNameJAVAIndex580, JAVA::getNfaNameJAVAIndex581, JAVA::getNfaNameJAVAIndex582, JAVA::getNfaNameJAVAIndex583, JAVA::getNfaNameJAVAIndex584, JAVA::getNfaNameJAVAIndex585, JAVA::getNfaNameJAVAIndex586, JAVA::getNfaNameJAVAIndex587, JAVA::getNfaNameJAVAIndex588, JAVA::getNfaNameJAVAIndex589, JAVA::getNfaNameJAVAIndex590, JAVA::getNfaNameJAVAIndex591, JAVA::getNfaNameJAVAIndex592, JAVA::getNfaNameJAVAIndex593, JAVA::getNfaNameJAVAIndex594, JAVA::getNfaNameJAVAIndex595, JAVA::getNfaNameJAVAIndex596, JAVA::getNfaNameJAVAIndex597, JAVA::getNfaNameJAVAIndex598, JAVA::getNfaNameJAVAIndex599, JAVA::getNfaNameJAVAIndex600, JAVA::getNfaNameJAVAIndex601, JAVA::getNfaNameJAVAIndex602, JAVA::getNfaNameJAVAIndex603, JAVA::getNfaNameJAVAIndex604, JAVA::getNfaNameJAVAIndex605, JAVA::getNfaNameJAVAIndex606, JAVA::getNfaNameJAVAIndex607, JAVA::getNfaNameJAVAIndex608, JAVA::getNfaNameJAVAIndex609, JAVA::getNfaNameJAVAIndex610, JAVA::getNfaNameJAVAIndex611, JAVA::getNfaNameJAVAIndex612, JAVA::getNfaNameJAVAIndex613, JAVA::getNfaNameJAVAIndex614, JAVA::getNfaNameJAVAIndex615, JAVA::getNfaNameJAVAIndex616, JAVA::getNfaNameJAVAIndex617, JAVA::getNfaNameJAVAIndex618, JAVA::getNfaNameJAVAIndex619, JAVA::getNfaNameJAVAIndex620, JAVA::getNfaNameJAVAIndex621, JAVA::getNfaNameJAVAIndex622, JAVA::getNfaNameJAVAIndex623, JAVA::getNfaNameJAVAIndex624, JAVA::getNfaNameJAVAIndex625, JAVA::getNfaNameJAVAIndex626, JAVA::getNfaNameJAVAIndex627, JAVA::getNfaNameJAVAIndex628, JAVA::getNfaNameJAVAIndex629, JAVA::getNfaNameJAVAIndex630, JAVA::getNfaNameJAVAIndex631, JAVA::getNfaNameJAVAIndex632, JAVA::getNfaNameJAVAIndex633, JAVA::getNfaNameJAVAIndex634, JAVA::getNfaNameJAVAIndex635, JAVA::getNfaNameJAVAIndex636, JAVA::getNfaNameJAVAIndex637, JAVA::getNfaNameJAVAIndex638, JAVA::getNfaNameJAVAIndex639, JAVA::getNfaNameJAVAIndex640, JAVA::getNfaNameJAVAIndex641, JAVA::getNfaNameJAVAIndex642, JAVA::getNfaNameJAVAIndex643, JAVA::getNfaNameJAVAIndex644, JAVA::getNfaNameJAVAIndex645, JAVA::getNfaNameJAVAIndex646, JAVA::getNfaNameJAVAIndex647, JAVA::getNfaNameJAVAIndex648, JAVA::getNfaNameJAVAIndex649, JAVA::getNfaNameJAVAIndex650, JAVA::getNfaNameJAVAIndex651, JAVA::getNfaNameJAVAIndex652, JAVA::getNfaNameJAVAIndex653, JAVA::getNfaNameJAVAIndex654, JAVA::getNfaNameJAVAIndex655, JAVA::getNfaNameJAVAIndex656, JAVA::getNfaNameJAVAIndex657, JAVA::getNfaNameJAVAIndex658, JAVA::getNfaNameJAVAIndex659, JAVA::getNfaNameJAVAIndex660, JAVA::getNfaNameJAVAIndex661, JAVA::getNfaNameJAVAIndex662, JAVA::getNfaNameJAVAIndex663, JAVA::getNfaNameJAVAIndex664, JAVA::getNfaNameJAVAIndex665, JAVA::getNfaNameJAVAIndex666, JAVA::getNfaNameJAVAIndex667, JAVA::getNfaNameJAVAIndex668, JAVA::getNfaNameJAVAIndex669, JAVA::getNfaNameJAVAIndex670, JAVA::getNfaNameJAVAIndex671, JAVA::getNfaNameJAVAIndex672, JAVA::getNfaNameJAVAIndex673, JAVA::getNfaNameJAVAIndex674, JAVA::getNfaNameJAVAIndex675, JAVA::getNfaNameJAVAIndex676, JAVA::getNfaNameJAVAIndex677, JAVA::getNfaNameJAVAIndex678, JAVA::getNfaNameJAVAIndex679, JAVA::getNfaNameJAVAIndex680, JAVA::getNfaNameJAVAIndex681, JAVA::getNfaNameJAVAIndex682, JAVA::getNfaNameJAVAIndex683, JAVA::getNfaNameJAVAIndex684, JAVA::getNfaNameJAVAIndex685, JAVA::getNfaNameJAVAIndex686, JAVA::getNfaNameJAVAIndex687, JAVA::getNfaNameJAVAIndex688, JAVA::getNfaNameJAVAIndex689, JAVA::getNfaNameJAVAIndex690, JAVA::getNfaNameJAVAIndex691, JAVA::getNfaNameJAVAIndex692, JAVA::getNfaNameJAVAIndex693, JAVA::getNfaNameJAVAIndex694, JAVA::getNfaNameJAVAIndex695, JAVA::getNfaNameJAVAIndex696, JAVA::getNfaNameJAVAIndex697, JAVA::getNfaNameJAVAIndex698, JAVA::getNfaNameJAVAIndex699, JAVA::getNfaNameJAVAIndex700, JAVA::getNfaNameJAVAIndex701, JAVA::getNfaNameJAVAIndex702, JAVA::getNfaNameJAVAIndex703, JAVA::getNfaNameJAVAIndex704, JAVA::getNfaNameJAVAIndex705, JAVA::getNfaNameJAVAIndex706, JAVA::getNfaNameJAVAIndex707, JAVA::getNfaNameJAVAIndex708, JAVA::getNfaNameJAVAIndex709, JAVA::getNfaNameJAVAIndex710, JAVA::getNfaNameJAVAIndex711, JAVA::getNfaNameJAVAIndex712, JAVA::getNfaNameJAVAIndex713, JAVA::getNfaNameJAVAIndex714};
            functionTableMap.put(LexicalState.JAVA, functions);
        }
    }

    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3);
    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo(Token.TokenType matchedType, int matchLength) {
            this.matchedType = matchedType;
            this.matchLength = matchLength;
        }
    }

    public static enum LexicalState {
        JAVA,
        IN_UNPARSED_CODE_BLOCK,
        IN_MULTI_LINE_COMMENT,
        IN_SINGLE_LINE_COMMENT,
        JAVA_MODULE;

    }
}

