/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.core.nfa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.congocc.core.nfa.LexicalStateData;
import org.congocc.core.nfa.NfaState;

public class CompositeStateSet {
    private Set<NfaState> states;
    final LexicalStateData lexicalState;
    int index = -1;

    CompositeStateSet(Set<NfaState> states, LexicalStateData lsd) {
        this.states = new HashSet<NfaState>(states);
        this.lexicalState = lsd;
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public String getMethodName() {
        String lexicalStateName = this.lexicalState.getName();
        if (lexicalStateName.equals("DEFAULT")) {
            return "NfaIndex" + this.index;
        }
        return "NfaName" + lexicalStateName + "Index" + this.index;
    }

    public boolean equals(Object other) {
        return other instanceof CompositeStateSet && ((CompositeStateSet)other).states.equals(this.states);
    }

    public List<NfaState> getOrderedStates() {
        ArrayList<NfaState> result = new ArrayList<NfaState>(this.states);
        Collections.sort(result, CompositeStateSet::nfaComparator);
        return result;
    }

    private static int nfaComparator(NfaState state1, NfaState state2) {
        int result = CompositeStateSet.getOrdinal(state2.getNextState()) - CompositeStateSet.getOrdinal(state1.getNextState());
        if (result == 0) {
            result = state1.getMoveRanges().get(0) - state2.getMoveRanges().get(0);
        }
        if (result == 0) {
            result = state1.getMoveRanges().get(1) - state2.getMoveRanges().get(1);
        }
        if (result == 0) {
            result = state2.getMoveRanges().size() - state2.getMoveRanges().size();
        }
        return result;
    }

    private static int getOrdinal(NfaState state) {
        return state.getType() == null ? Integer.MAX_VALUE : state.getType().getOrdinal();
    }

    void findWhatIsUsed(Set<CompositeStateSet> alreadyVisited, Set<CompositeStateSet> usedStates) {
        if (alreadyVisited.contains(this)) {
            return;
        }
        alreadyVisited.add(this);
        if (this.states.isEmpty()) {
            return;
        }
        usedStates.add(this);
        for (NfaState state : this.states) {
            state.getNextState().getComposite().findWhatIsUsed(alreadyVisited, usedStates);
        }
    }
}

