/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.congocc.app.Errors;
import org.congocc.core.Grammar;
import org.congocc.core.RegexpSpec;
import org.congocc.core.RegularExpression;
import org.congocc.core.TokenSet;
import org.congocc.core.nfa.LexicalStateData;
import org.congocc.parser.Node;
import org.congocc.parser.tree.EndOfFile;
import org.congocc.parser.tree.RegexpRef;
import org.congocc.parser.tree.RegexpStringLiteral;
import org.congocc.parser.tree.TokenProduction;

public class LexerData {
    private Grammar grammar;
    private Errors errors;
    private List<LexicalStateData> lexicalStates = new ArrayList<LexicalStateData>();
    private List<RegularExpression> regularExpressions = new ArrayList<RegularExpression>();
    private Map<String, RegularExpression> namedTokensTable = new HashMap<String, RegularExpression>();
    private Set<RegularExpression> overriddenTokens = new HashSet<RegularExpression>();

    public LexerData(Grammar grammar) {
        this.grammar = grammar;
        this.errors = grammar.getErrors();
        EndOfFile reof = new EndOfFile();
        reof.setGrammar(grammar);
        reof.setLabel("EOF");
        this.regularExpressions.add(reof);
    }

    public String getTokenName(int ordinal) {
        if (ordinal < this.regularExpressions.size()) {
            return this.regularExpressions.get(ordinal).getLabel();
        }
        return this.grammar.getAppSettings().getExtraTokenNames().get(ordinal - this.regularExpressions.size());
    }

    public String getLexicalStateName(int index) {
        return this.lexicalStates.get(index).getName();
    }

    void addLexicalState(String name) {
        this.lexicalStates.add(new LexicalStateData(this.grammar, name));
    }

    public LexicalStateData getLexicalState(String name) {
        for (LexicalStateData lsd : this.lexicalStates) {
            if (!lsd.getName().equals(name)) continue;
            return lsd;
        }
        return null;
    }

    public int getMaxNfaStates() {
        return this.lexicalStates.stream().mapToInt(state -> state.getAllNfaStates().size()).max().getAsInt();
    }

    public List<RegularExpression> getRegularExpressions() {
        ArrayList<RegularExpression> result = new ArrayList<RegularExpression>(this.regularExpressions);
        result.removeIf(re -> this.isOverridden((RegularExpression)re));
        return result;
    }

    public boolean getHasLexicalStateTransitions() {
        return this.getNumLexicalStates() > 1 && this.regularExpressions.stream().anyMatch(re -> re.getNewLexicalState() != null);
    }

    public boolean getHasTokenActions() {
        return this.regularExpressions.stream().anyMatch(re -> re.getCodeSnippet() != null);
    }

    public int getNumLexicalStates() {
        return this.lexicalStates.size();
    }

    public List<LexicalStateData> getLexicalStates() {
        return this.lexicalStates;
    }

    private void addRegularExpression(RegularExpression regexp) {
        regexp.setOrdinal(this.regularExpressions.size());
        this.regularExpressions.add(regexp);
        if (regexp instanceof RegexpStringLiteral) {
            RegexpStringLiteral stringLiteral = (RegexpStringLiteral)regexp;
            for (String lexicalStateName : stringLiteral.getLexicalStateNames()) {
                LexicalStateData lsd = this.getLexicalState(lexicalStateName);
                lsd.addStringLiteral(stringLiteral);
            }
        }
    }

    private void resolveStringLiterals() {
        for (RegexpStringLiteral rsl2 : this.grammar.descendants(RegexpStringLiteral.class, rsl -> rsl.getTokenProduction() == null)) {
            String label = this.getStringLiteralLabel(rsl2.getLiteralString());
            rsl2.setLabel(label);
        }
    }

    private void ensureRegexpLabels() {
        ListIterator<RegularExpression> it = this.regularExpressions.listIterator();
        while (it.hasNext()) {
            String s;
            RegularExpression regexp = it.next();
            if (LexerData.isJavaIdentifier(regexp.getLabel())) continue;
            String label = "_TOKEN_" + it.previousIndex();
            if (regexp instanceof RegexpStringLiteral && LexerData.isJavaIdentifier(s = ((RegexpStringLiteral)regexp).getLiteralString().toUpperCase()) && !this.regexpLabelAlreadyUsed(s)) {
                label = s;
            }
            regexp.setLabel(label);
        }
    }

    static int compare(RegularExpression first, RegularExpression second) {
        if (first instanceof EndOfFile) {
            return -1;
        }
        if (second instanceof EndOfFile) {
            return 1;
        }
        if (first instanceof RegexpStringLiteral && !(second instanceof RegexpStringLiteral)) {
            return -1;
        }
        if (second instanceof RegexpStringLiteral && !(first instanceof RegexpStringLiteral)) {
            return 1;
        }
        if (first instanceof RegexpStringLiteral && second instanceof RegexpStringLiteral && first.getLiteralString().equalsIgnoreCase(second.getLiteralString())) {
            if (first.getIgnoreCase() && !second.getIgnoreCase()) {
                return 1;
            }
            if (second.getIgnoreCase() && !first.getIgnoreCase()) {
                return -1;
            }
        }
        return first.getOrdinal() - second.getOrdinal();
    }

    void reorder() {
        Collections.sort(this.regularExpressions, LexerData::compare);
        for (int i = 0; i < this.regularExpressions.size(); ++i) {
            this.regularExpressions.get(i).setOrdinal(i);
        }
    }

    public List<String> getTokenNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (RegularExpression regexp : this.regularExpressions) {
            result.add(regexp.getLabel());
        }
        return result;
    }

    public static boolean isJavaIdentifier(String s) {
        return !s.isEmpty() && Character.isJavaIdentifierStart(s.codePointAt(0)) && s.codePoints().allMatch(ch -> Character.isJavaIdentifierPart(ch));
    }

    private boolean regexpLabelAlreadyUsed(String label) {
        for (RegularExpression regexp : this.regularExpressions) {
            if (!label.contentEquals(regexp.getLabel())) continue;
            return true;
        }
        return false;
    }

    public String getStringLiteralLabel(String image) {
        for (RegularExpression regexp : this.regularExpressions) {
            if (!(regexp instanceof RegexpStringLiteral)) continue;
            if (regexp.getLiteralString().equals(image)) {
                return regexp.getLabel();
            }
            if (!regexp.getIgnoreCase() || !regexp.getLiteralString().equalsIgnoreCase(image)) continue;
            return regexp.getLabel();
        }
        return null;
    }

    public int getTokenCount() {
        return this.regularExpressions.size() + this.grammar.getAppSettings().getExtraTokenNames().size();
    }

    public TokenSet getMoreTokens() {
        return this.getTokensOfKind("MORE");
    }

    public TokenSet getSkippedTokens() {
        return this.getTokensOfKind("SKIP");
    }

    public TokenSet getUnparsedTokens() {
        return this.getTokensOfKind("UNPARSED");
    }

    public TokenSet getRegularTokens() {
        TokenSet result = this.getTokensOfKind("TOKEN");
        for (RegularExpression re : this.regularExpressions) {
            if (re.getTokenProduction() != null) continue;
            result.set(re.getOrdinal());
        }
        return result;
    }

    private TokenSet getTokensOfKind(String kind) {
        TokenSet result = new TokenSet(this.grammar);
        for (RegularExpression re : this.regularExpressions) {
            TokenProduction tp;
            if (this.isOverridden(re) || (tp = re.getTokenProduction()) == null || !tp.getKind().equals(kind)) continue;
            result.set(re.getOrdinal());
        }
        return result;
    }

    private void addNamedToken(String name, RegularExpression regexp) {
        if (this.namedTokensTable.containsKey(name)) {
            RegularExpression oldValue = this.namedTokensTable.get(name);
            this.namedTokensTable.replace(name, oldValue, regexp);
            this.overriddenTokens.add(oldValue);
        } else {
            this.namedTokensTable.put(name, regexp);
        }
    }

    public boolean isOverridden(RegularExpression regexp) {
        return this.overriddenTokens.contains(regexp);
    }

    public List<RegularExpression> getOrderedNamedTokens() {
        return new ArrayList<RegularExpression>(this.namedTokensTable.values());
    }

    void buildData() {
        for (TokenProduction tp : this.grammar.descendants(TokenProduction.class)) {
            for (RegexpSpec res : tp.getRegexpSpecs()) {
                RegularExpression re = res.getRegexp();
                if (re.hasLabel()) {
                    String label = re.getLabel();
                    RegularExpression regexp = this.namedTokensTable.get(label);
                    if (regexp != null) {
                        this.errors.addInfo(res.getRegexp(), "Token name \"" + label + " is redefined.");
                    }
                    this.addNamedToken(label, re);
                }
                if (re.isPrivate() || re.getOrdinal() != 0) continue;
                this.addRegularExpression(re);
            }
        }
        for (RegexpStringLiteral stringLiteral : this.grammar.descendants(RegexpStringLiteral.class, rsl -> rsl.getTokenProduction() == null)) {
            String kind;
            String image = stringLiteral.getLiteralString();
            String lexicalStateName = stringLiteral.getLexicalState();
            LexicalStateData lsd = this.getLexicalState(lexicalStateName);
            RegexpStringLiteral alreadyPresent = lsd.getStringLiteral(image);
            if (alreadyPresent == null) {
                if (stringLiteral.getOrdinal() != 0) continue;
                this.addRegularExpression(stringLiteral);
                continue;
            }
            String string = kind = alreadyPresent.getTokenProduction() == null ? "TOKEN" : alreadyPresent.getTokenProduction().getKind();
            if (!kind.equals("TOKEN")) {
                this.errors.addError(stringLiteral, "String token \"" + image + "\" has been defined as a \"" + kind + "\" token.");
                continue;
            }
            stringLiteral.setOrdinal(alreadyPresent.getOrdinal());
        }
        this.ensureRegexpLabels();
        this.resolveStringLiterals();
        for (RegexpRef ref : this.grammar.descendants(RegexpRef.class)) {
            String label = ref.getLabel();
            if (this.grammar.getAppSettings().getExtraTokens().containsKey(label)) continue;
            RegularExpression referenced = this.namedTokensTable.get(label);
            if (referenced == null) {
                this.errors.addError(ref, "Undefined lexical token name \"" + label + "\".");
            } else if (ref.getTokenProduction() == null) {
                if (referenced.isPrivate()) {
                    this.errors.addError(ref, "Token name \"" + label + "\" refers to a private (with a #) regular expression.");
                } else if (!referenced.getTokenProduction().getKind().equals("TOKEN")) {
                    this.errors.addError(ref, "Token name \"" + label + "\" refers to a non-token (SKIP, MORE, UNPARSED) regular expression.");
                }
            }
            if (referenced == null) continue;
            ref.setOrdinal(referenced.getOrdinal());
            ref.setRegexp(referenced);
        }
        new RegexpVisitor().visit(this.grammar);
        for (TokenProduction tokenProduction : this.grammar.descendants(TokenProduction.class)) {
            for (String lexStateName : tokenProduction.getLexicalStateNames()) {
                LexicalStateData lexState = this.getLexicalState(lexStateName);
                lexState.addTokenProduction(tokenProduction);
            }
        }
        for (LexicalStateData lexState : this.lexicalStates) {
            lexState.process();
        }
    }

    class RegexpVisitor
    extends Node.Visitor {
        private Set<RegularExpression> alreadyVisited = new HashSet<RegularExpression>();
        private Set<RegularExpression> currentlyVisiting = new HashSet<RegularExpression>();

        RegexpVisitor() {
        }

        void visit(RegexpRef ref) {
            RegularExpression referredTo = ref.getRegexp();
            if (referredTo != null && !this.alreadyVisited.contains(referredTo)) {
                if (!this.currentlyVisiting.contains(referredTo)) {
                    this.currentlyVisiting.add(referredTo);
                    this.visit(referredTo);
                    this.currentlyVisiting.remove(referredTo);
                } else {
                    this.alreadyVisited.add(referredTo);
                    LexerData.this.errors.addError(ref, "Self-referential loop detected");
                }
            }
        }
    }
}

