/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.java;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.tree.Annotation;
import org.congocc.parser.tree.CompilationUnit;
import org.congocc.parser.tree.DotName;
import org.congocc.parser.tree.FieldDeclaration;
import org.congocc.parser.tree.Identifier;
import org.congocc.parser.tree.ImportDeclaration;
import org.congocc.parser.tree.InvocationArguments;
import org.congocc.parser.tree.MethodCall;
import org.congocc.parser.tree.MethodDeclaration;
import org.congocc.parser.tree.MethodReference;
import org.congocc.parser.tree.Modifiers;
import org.congocc.parser.tree.Name;
import org.congocc.parser.tree.ObjectType;
import org.congocc.parser.tree.PackageDeclaration;
import org.congocc.parser.tree.TypeDeclaration;
import org.congocc.parser.tree.VariableDeclarator;

class Reaper
extends Node.Visitor {
    private Set<String> usedMethodNames = new HashSet<String>();
    private Set<String> usedTypeNames = new HashSet<String>();
    private Set<String> usedVarNames = new HashSet<String>();
    private Set<String> usedImportDeclarations = new HashSet<String>();
    private CompilationUnit jcu;
    private boolean onSecondPass;

    Reaper(CompilationUnit jcu) {
        this.jcu = jcu;
    }

    void stripUnused() {
        int prevNameCount;
        int nameCount;
        do {
            prevNameCount = this.usedMethodNames.size() + this.usedTypeNames.size() + this.usedVarNames.size();
            this.visit(this.jcu);
        } while ((nameCount = this.usedMethodNames.size() + this.usedTypeNames.size() + this.usedVarNames.size()) > prevNameCount);
        for (MethodDeclaration md2 : this.jcu.descendants(MethodDeclaration.class, md -> !this.usedMethodNames.contains(md.getName()))) {
            md2.getParent().removeChild(md2);
        }
        for (FieldDeclaration fd2 : this.jcu.descendants(FieldDeclaration.class, fd -> this.isPrivate((Node)fd))) {
            this.stripUnusedVars(fd2);
        }
        for (TypeDeclaration td2 : this.jcu.descendants(TypeDeclaration.class, td -> this.isPrivate((Node)td))) {
            if (this.usedTypeNames.contains(td2.getName())) continue;
            td2.getParent().removeChild(td2);
        }
        this.usedMethodNames.clear();
        this.usedTypeNames.clear();
        this.usedVarNames.clear();
        this.onSecondPass = true;
        this.visit(this.jcu);
        for (ImportDeclaration imp : this.jcu.childrenOfType(ImportDeclaration.class)) {
            if (!this.usedImportDeclarations.add(this.getKey(imp))) {
                this.jcu.removeChild(imp);
                continue;
            }
            if (imp.firstChildOfType(Token.TokenType.STAR) != null) continue;
            List<Identifier> names = imp.descendants(Identifier.class);
            String name = names.get(names.size() - 1).getImage();
            if (imp.firstChildOfType(Token.TokenType.STATIC) != null && this.usedMethodNames.contains(name) || this.usedTypeNames.contains(name)) continue;
            this.jcu.removeChild(imp);
        }
    }

    private String getKey(ImportDeclaration decl) {
        String result = "";
        for (Node node : decl.descendants(Token.class)) {
            result = result + node;
        }
        return result;
    }

    private boolean isPrivate(Node node) {
        if (this.onSecondPass) {
            return false;
        }
        if (node.firstChildOfType(Token.TokenType.PRIVATE) != null) {
            return true;
        }
        Modifiers mods = node.firstChildOfType(Modifiers.class);
        return mods == null ? false : mods.firstChildOfType(Token.TokenType.PRIVATE) != null;
    }

    void visit(MethodDeclaration md) {
        if (!this.isPrivate(md)) {
            this.usedMethodNames.add(md.getName());
        }
        if (this.usedMethodNames.contains(md.getName())) {
            this.recurse(md);
        }
    }

    void visit(ObjectType ot) {
        Identifier firstID = ot.firstChildOfType(Identifier.class);
        this.usedTypeNames.add(firstID.getImage());
        this.recurse(ot);
    }

    void visit(Annotation ann) {
        String firstID = ann.firstDescendantOfType(Identifier.class).getImage();
        this.usedTypeNames.add(firstID);
        this.recurse(ann);
    }

    void visit(MethodCall mc) {
        String lhs = mc.firstChildOfType(InvocationArguments.class).previousSibling().getImage();
        this.usedMethodNames.add(lhs.substring(lhs.lastIndexOf(46) + 1));
        this.recurse(mc);
    }

    void visit(MethodReference mr) {
        this.usedMethodNames.add(mr.firstChildOfType(Identifier.class).getImage());
        this.recurse(mr);
    }

    void visit(Name name) {
        if (name.getChildCount() > 1 || !(name.getParent() instanceof MethodCall)) {
            this.usedVarNames.add(name.getChild(0).toString());
            this.usedTypeNames.add(name.getChild(0).toString());
        }
    }

    void visit(DotName dotName) {
        this.usedVarNames.add(dotName.getLastChild().toString());
        this.recurse(dotName);
    }

    void visit(VariableDeclarator vd) {
        if (!this.isPrivate(vd.getParent()) || this.usedVarNames.contains(vd.getName())) {
            this.recurse(vd);
        }
    }

    void visit(TypeDeclaration td) {
        if (!this.isPrivate(td) || this.usedTypeNames.contains(td.getName())) {
            this.recurse(td);
        }
    }

    void visit(ImportDeclaration decl) {
    }

    void visit(PackageDeclaration decl) {
    }

    void visit(FieldDeclaration fd) {
        if (this.isUsed(fd)) {
            this.recurse(fd);
        }
    }

    private boolean isUsed(FieldDeclaration fd) {
        if (!this.isPrivate(fd)) {
            return true;
        }
        for (VariableDeclarator vd : fd.childrenOfType(VariableDeclarator.class)) {
            if (!this.usedVarNames.contains(vd.getName())) continue;
            return true;
        }
        return false;
    }

    private void stripUnusedVars(FieldDeclaration fd) {
        HashSet<Node> toBeRemoved = new HashSet<Node>();
        for (VariableDeclarator vd : fd.childrenOfType(VariableDeclarator.class)) {
            if (this.usedVarNames.contains(vd.getName())) continue;
            toBeRemoved.add(vd);
            Node prev = vd.previousSibling();
            Node next = vd.nextSibling();
            if (prev.getType() == Token.TokenType.COMMA) {
                toBeRemoved.add(prev);
                continue;
            }
            if (next.getType() != Token.TokenType.COMMA) continue;
            toBeRemoved.add(next);
        }
        for (Node n : toBeRemoved) {
            fd.removeChild(n);
        }
        if (fd.firstChildOfType(VariableDeclarator.class) == null) {
            fd.getParent().removeChild(fd);
        }
    }
}

