/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.ClassString;
import freemarker.ext.beans.OverloadedMethodUtilities;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class OverloadedMethod<T extends Member> {
    static final Object NO_SUCH_METHOD = new Object();
    static final Object AMBIGUOUS_METHOD = new Object();
    static final Object[] EMPTY_ARGS = new Object[0];
    private Class<?>[][] marshalTypes;
    private final Map<ClassString<T>, Object> selectorCache = new ConcurrentHashMap<ClassString<T>, Object>();
    private final List<T> members = new LinkedList<T>();
    private final Map<T, Class<?>[]> signatures = new HashMap<T, Class<?>[]>();

    OverloadedMethod() {
    }

    void addMember(T member) {
        this.members.add(member);
        Class<?>[] argTypes = OverloadedMethodUtilities.getParameterTypes(member);
        int l = argTypes.length;
        this.onAddSignature(member, argTypes);
        if (this.marshalTypes == null) {
            this.marshalTypes = new Class[l + 1][];
            this.marshalTypes[l] = argTypes;
            this.updateSignature(l);
        } else if (this.marshalTypes.length <= l) {
            Class[][] newMarshalTypes = new Class[l + 1][];
            System.arraycopy(this.marshalTypes, 0, newMarshalTypes, 0, this.marshalTypes.length);
            this.marshalTypes = newMarshalTypes;
            this.marshalTypes[l] = argTypes;
            this.updateSignature(l);
        } else {
            Class<?>[] oldTypes = this.marshalTypes[l];
            if (oldTypes == null) {
                this.marshalTypes[l] = argTypes;
            } else {
                for (int i = 0; i < oldTypes.length; ++i) {
                    oldTypes[i] = OverloadedMethodUtilities.getMostSpecificCommonType(oldTypes[i], argTypes[i]);
                }
            }
            this.updateSignature(l);
        }
        this.afterSignatureAdded(l);
    }

    Class<?>[] getSignature(T member) {
        Class<?>[] signature = this.signatures.get(member);
        if (signature == null) {
            signature = OverloadedMethodUtilities.getParameterTypes(member);
            this.signatures.put(member, signature);
        }
        return signature;
    }

    Class<?>[][] getMarshalTypes() {
        return this.marshalTypes;
    }

    Object getMemberForArgs(Object[] args, boolean varArg) {
        ClassString<T> argTypes = new ClassString<T>(args);
        Object objMember = this.selectorCache.get(argTypes);
        if (objMember == null) {
            objMember = argTypes.getMostSpecific(this.members, varArg);
            this.selectorCache.put(argTypes, objMember);
        }
        return objMember;
    }

    abstract void onAddSignature(T var1, Class<?>[] var2);

    abstract void updateSignature(int var1);

    abstract void afterSignatureAdded(int var1);

    abstract Object getMemberAndArguments(List<TemplateModel> var1, BeansWrapper var2) throws TemplateModelException;
}

