/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MemberAndArguments;
import freemarker.ext.beans.OverloadedFixArgMethod;
import freemarker.ext.beans.OverloadedMethod;
import freemarker.ext.beans.OverloadedVarArgMethod;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;

class MethodMap<T extends Member> {
    private final String name;
    private final BeansWrapper wrapper;
    private final OverloadedMethod<T> fixArgMethod = new OverloadedFixArgMethod();
    private OverloadedMethod<T> varArgMethod;

    MethodMap(String name, BeansWrapper wrapper) {
        this.name = name;
        this.wrapper = wrapper;
    }

    BeansWrapper getWrapper() {
        return this.wrapper;
    }

    void addMember(T member) {
        this.fixArgMethod.addMember(member);
        if (MethodMap.isVarArgs(member)) {
            if (this.varArgMethod == null) {
                this.varArgMethod = new OverloadedVarArgMethod();
            }
            this.varArgMethod.addMember(member);
        }
    }

    MemberAndArguments<T> getMemberAndArguments(List<TemplateModel> arguments) {
        Object memberAndArguments = this.fixArgMethod.getMemberAndArguments(arguments, this.wrapper);
        if (memberAndArguments == OverloadedMethod.NO_SUCH_METHOD) {
            if (this.varArgMethod != null) {
                memberAndArguments = this.varArgMethod.getMemberAndArguments(arguments, this.wrapper);
            }
            if (memberAndArguments == OverloadedMethod.NO_SUCH_METHOD) {
                throw new TemplateModelException("No signature of method " + this.name + " matches the arguments");
            }
        }
        if (memberAndArguments == OverloadedMethod.AMBIGUOUS_METHOD) {
            throw new TemplateModelException("Multiple signatures of method " + this.name + " match the arguments");
        }
        return (MemberAndArguments)memberAndArguments;
    }

    private static boolean isVarArgs(Member member) {
        if (member instanceof Method) {
            return ((Method)member).isVarArgs();
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).isVarArgs();
        }
        throw new AssertionError();
    }
}

