/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.helpers;

import freemarker.core.AbstractScope;
import freemarker.core.Scope;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NamedParameterListScope
extends AbstractScope {
    private final List<String> paramNames;
    private final List<TemplateModel> paramValues;
    private final boolean readOnly;

    public NamedParameterListScope(Scope enclosingScope, List<String> paramNames, List<TemplateModel> paramValues, boolean readOnly) {
        super(enclosingScope);
        this.paramNames = paramNames;
        this.paramValues = paramValues;
        this.readOnly = readOnly;
    }

    @Override
    public boolean definesVariable(String name) {
        return this.paramNames.contains(name);
    }

    @Override
    public Collection<String> getDirectVariableNames() {
        return this.paramNames;
    }

    @Override
    public void put(String key, TemplateModel value) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        int i = this.paramNames.indexOf(key);
        if (i == -1) {
            throw new IllegalArgumentException("key " + key + " not found");
        }
        while (i >= this.paramValues.size()) {
            this.paramValues.add(null);
        }
        this.paramValues.set(i, value);
    }

    @Override
    public TemplateModel remove(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TemplateCollectionModel keys() {
        int size = Math.min(this.paramNames.size(), this.paramValues.size());
        ArrayList<SimpleScalar> nonNullValueKeys = new ArrayList<SimpleScalar>(size);
        for (int i = 0; i < size; ++i) {
            if (this.paramValues.get(i) == null) continue;
            nonNullValueKeys.add(new SimpleScalar(this.paramNames.get(i)));
        }
        return new SimpleCollection(nonNullValueKeys);
    }

    @Override
    public int size() {
        int nonNullCount = 0;
        int size = Math.min(this.paramNames.size(), this.paramValues.size());
        for (int i = 0; i < size; ++i) {
            if (this.paramValues.get(i) == null) continue;
            ++nonNullCount;
        }
        return nonNullCount;
    }

    @Override
    public TemplateCollectionModel values() {
        int size = Math.min(this.paramNames.size(), this.paramValues.size());
        ArrayList<TemplateModel> nonNullValues = new ArrayList<TemplateModel>(size);
        for (int i = 0; i < size; ++i) {
            TemplateModel value = this.paramValues.get(i);
            if (value == null) continue;
            nonNullValues.add(value);
        }
        return new SimpleCollection(nonNullValues);
    }

    @Override
    public TemplateModel get(String key) {
        int i = this.paramNames.indexOf(key);
        return i != -1 && i < this.paramValues.size() ? this.paramValues.get(i) : null;
    }
}

