/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.Expression;
import freemarker.core.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.StringUtil;

public abstract class StringTransformations
extends ExpressionEvaluatingBuiltIn {
    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller, TemplateModel model) {
        String string = null;
        string = model instanceof TemplateScalarModel ? ((TemplateScalarModel)model).getAsString() : Expression.getStringValue(model, caller.getTarget(), env);
        if (string == null) {
            throw new InvalidReferenceException("String is undefined", env);
        }
        return new SimpleScalar(this.apply(string));
    }

    public abstract String apply(String var1);

    public static class Chomp
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.chomp(string);
        }
    }

    public static class Capitalize
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.capitalize(string);
        }
    }

    public static class JavaScript
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.javaScriptStringEnc(string);
        }
    }

    public static class Java
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.javaStringEnc(string);
        }
    }

    public static class Trim
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return string.trim();
        }
    }

    public static class CapFirst
    extends StringTransformations {
        private final boolean cap;

        public CapFirst(boolean cap) {
            this.cap = cap;
        }

        @Override
        public String apply(String string) {
            for (int i = 0; i < string.length(); ++i) {
                char ch = string.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                if (this.cap && Character.isUpperCase(ch) || !this.cap && Character.isLowerCase(ch)) {
                    return string;
                }
                char[] chars = string.toCharArray();
                chars[i] = this.cap ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
                return new String(chars);
            }
            return string;
        }
    }

    public static class Rtf
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.RTFEnc(string);
        }
    }

    public static class Xml
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.XMLEnc(string);
        }
    }

    public static class Xhtml
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.XHTMLEnc(string);
        }
    }

    public static class Html
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.HTMLEnc(string);
        }
    }

    public static class LowerCase
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return string.toLowerCase();
        }
    }

    public static class UpperCase
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return string.toUpperCase();
        }
    }
}

