/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.MacroContext;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.Macro;
import freemarker.core.ast.TemplateNode;
import freemarker.core.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

public abstract class MacroBuiltins
extends ExpressionEvaluatingBuiltIn {
    @Override
    public boolean isSideEffectFree() {
        return false;
    }

    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller, TemplateModel model) {
        if (!(model instanceof Macro)) {
            throw TemplateNode.invalidTypeException(model, caller.getTarget(), env, "macro");
        }
        return this.apply(env, (Macro)model);
    }

    public abstract TemplateModel apply(Environment var1, Macro var2) throws TemplateModelException;

    public static class Scope
    extends MacroBuiltins {
        @Override
        public TemplateModel apply(Environment env, Macro macro) throws TemplateModelException {
            MacroContext result = env.getMacroContext(macro);
            return result == null ? TemplateModel.JAVA_NULL : result;
        }
    }

    public static class Namespace
    extends MacroBuiltins {
        @Override
        public TemplateModel apply(Environment env, Macro macro) throws TemplateModelException {
            return env.getMacroNamespace(macro);
        }
    }
}

