/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.Scope;
import freemarker.core.ast.Expression;
import freemarker.core.ast.StringLiteral;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateModel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class VarDirective
extends TemplateElement {
    private Map<String, Expression> vars = new LinkedHashMap<String, Expression>();

    @Override
    public void execute(Environment env) {
        for (Map.Entry<String, Expression> entry : this.vars.entrySet()) {
            String varname = entry.getKey();
            Expression exp = entry.getValue();
            Scope scope = env.getCurrentScope();
            if (exp == null) {
                if (scope.get(varname) != null) continue;
                scope.put(varname, TemplateModel.JAVA_NULL);
                continue;
            }
            TemplateModel tm = exp.getAsTemplateModel(env);
            VarDirective.assertIsDefined(tm, exp, env);
            scope.put(varname, tm);
        }
    }

    public Map<String, Expression> getVariables() {
        return Collections.unmodifiableMap(this.vars);
    }

    public void addVar(Expression name, Expression value) {
        String varname = name.toString();
        if (name instanceof StringLiteral) {
            varname = ((StringLiteral)name).getAsString();
        }
        this.vars.put(varname, value);
    }

    public void addVar(String name) {
        this.vars.put(name, null);
    }

    @Override
    public String getDescription() {
        return "variable declaration";
    }
}

