/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.TemplateElement;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class TextBlock
extends TemplateElement {
    public static final TextBlock EMPTY_BLOCK = new TextBlock("");
    private char[] text;
    private int type;
    private boolean ignore;
    public static final int PRINTABLE_TEXT = 0;
    public static final int WHITE_SPACE = 1;
    public static final int OPENING_WS = 2;
    public static final int TRAILING_WS = 3;

    private static String rightTrim(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (TextBlock.isWhitespace(c)) continue;
            return s.substring(0, i + 1);
        }
        return "";
    }

    public TextBlock(String text) {
        this.text = text.toCharArray();
    }

    @Override
    public void setLocation(Template template, int beginColumn, int beginLine, int endColumn, int endLine) {
        super.setLocation(template, beginColumn, beginLine, endColumn, endLine);
        boolean printable = false;
        for (char c : this.text) {
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            printable = true;
        }
        if (printable) {
            this.type = 0;
        } else {
            boolean containsStart;
            char lastChar = this.text[this.text.length - 1];
            boolean containsEOL = lastChar == '\n' || lastChar == '\r';
            boolean bl = containsStart = beginColumn == 1;
            this.type = containsEOL && containsStart ? 1 : (!containsEOL && !containsStart ? 1 : (containsEOL ? 3 : 2));
        }
        this.text = null;
    }

    public String getText() {
        return this.text != null ? new String(this.text) : this.getSource();
    }

    public void setText(String text) {
        this.text = text.toCharArray();
    }

    public int getType() {
        return this.type;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    @Override
    public void execute(Environment env) throws IOException {
        if (this.ignore) {
            return;
        }
        Writer out = env.getOut();
        if (this.text != null) {
            out.write(this.text);
        } else {
            this.template.writeTextAt(out, this.beginColumn, this.beginLine, this.endColumn, this.endLine);
        }
    }

    @Override
    public String getDescription() {
        String s = new String(this.getText()).trim();
        if (s.length() == 0) {
            return "whitespace";
        }
        if (s.length() > 20) {
            s = s.substring(0, 20) + "...";
            s = s.replace('\n', ' ');
            s = s.replace('\r', ' ');
        }
        return "text block (" + s + ")";
    }

    @Override
    public boolean isIgnorable() {
        return this.ignore;
    }

    public boolean isWhitespace() {
        if (this.text == null) {
            return this.type != 0;
        }
        for (char c : this.text) {
            if (TextBlock.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private static List<TextBlock> breakSingleLineIntoBlocks(String input, Template template, int column, int line) {
        TextBlock tb;
        boolean boundedBothSides;
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        char lastChar = input.charAt(input.length() - 1);
        boolean spansRight = lastChar == '\r' || lastChar == '\n';
        boolean spansLeft = column == 1;
        boolean spansEntireLine = spansRight && spansLeft;
        boolean bl = boundedBothSides = !spansRight && !spansLeft;
        if (spansEntireLine || boundedBothSides || spansLeft && !TextBlock.isWhitespace(input.charAt(0))) {
            TextBlock tb2 = new TextBlock(input);
            tb2.setLocation(template, column, line, column + input.length() - 1, line);
            result.add(tb2);
            return result;
        }
        if (spansLeft) {
            TextBlock tb3;
            String printablePart = TextBlock.leftTrim(input);
            String openingWS = input.substring(0, input.length() - printablePart.length());
            if (openingWS.length() > 0) {
                tb3 = new TextBlock(openingWS);
                tb3.setLocation(template, column, line, openingWS.length(), line);
                result.add(tb3);
            }
            if (printablePart.length() > 0) {
                tb3 = new TextBlock(printablePart);
                tb3.setLocation(template, column + openingWS.length(), line, column + input.length() - 1, line);
                result.add(tb3);
            }
            return result;
        }
        String startingPart = TextBlock.rightTrim(input);
        String trailingWS = input.substring(startingPart.length());
        if (startingPart.length() > 0) {
            tb = new TextBlock(startingPart);
            tb.setLocation(template, column, line, column + startingPart.length() - 1, line);
            result.add(tb);
        }
        if (trailingWS.length() > 0) {
            tb = new TextBlock(trailingWS);
            tb.setLocation(template, column + startingPart.length(), line, column + input.length() - 1, line);
            result.add(tb);
        }
        return result;
    }

    public static List<TextBlock> breakIntoBlocksLineByLine(String input, Template template, int beginColumn, int beginLine) {
        List<String> lines = TextBlock.lines(input);
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        for (String line : lines) {
            String ltrim = TextBlock.leftTrim(line);
            int initWSLength = line.length() - ltrim.length();
            if (initWSLength > 0) {
                TextBlock tb = new TextBlock(line.substring(0, initWSLength));
                tb.setLocation(template, beginColumn, beginLine, beginColumn + initWSLength - 1, beginLine);
                beginColumn += initWSLength;
                tb.type = 2;
                result.add(tb);
            }
            if (ltrim.length() > 0) {
                String trimmed = TextBlock.rightTrim(ltrim);
                int trailingWSLength = ltrim.length() - trimmed.length();
                if (trimmed.length() > 0) {
                    TextBlock tb = new TextBlock(trimmed);
                    tb.setLocation(template, beginColumn, beginLine, beginColumn + trimmed.length() - 1, beginLine);
                    tb.type = 0;
                    result.add(tb);
                    beginColumn += trimmed.length();
                }
                if (trailingWSLength > 0) {
                    String trailingWS = ltrim.substring(trimmed.length());
                    TextBlock tb = new TextBlock(trailingWS);
                    tb.setLocation(template, beginColumn, beginLine, beginColumn + trailingWSLength - 1, beginLine);
                    tb.type = 3;
                    result.add(tb);
                }
            }
            beginColumn = 1;
            ++beginLine;
        }
        return result;
    }

    public static List<TextBlock> breakIntoBlocks(String input, Template template, int beginColumn, int beginLine) {
        boolean mergeLastLine;
        int numLines = TextBlock.countLines(input);
        if (numLines == 1) {
            return TextBlock.breakSingleLineIntoBlocks(input, template, beginColumn, beginLine);
        }
        String firstLine = TextBlock.firstLine(input);
        String lastLine = TextBlock.lastLine(input);
        String middleLines = input.substring(firstLine.length(), input.length() - lastLine.length());
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        if (beginColumn == 1) {
            middleLines = input.substring(0, firstLine.length() + middleLines.length());
        } else {
            TextBlock tb;
            String firstPart = TextBlock.rightTrim(firstLine);
            String trailingWS = firstLine.substring(firstPart.length());
            if (firstPart.length() > 0) {
                tb = new TextBlock(firstPart);
                tb.setLocation(template, beginColumn, beginLine, beginColumn + firstPart.length() - 1, beginLine);
                result.add(tb);
            }
            if (trailingWS.length() > 0) {
                tb = new TextBlock(trailingWS);
                tb.setLocation(template, beginColumn + firstPart.length(), beginLine, beginColumn + firstLine.length() - 1, beginLine);
                result.add(tb);
            }
        }
        boolean bl = mergeLastLine = lastLine.endsWith("\n") || lastLine.endsWith("\r") || !TextBlock.isWhitespace(lastLine.charAt(0));
        if (mergeLastLine) {
            middleLines = beginColumn == 1 ? input : input.substring(firstLine.length());
        }
        if (middleLines.length() > 0) {
            TextBlock tb = new TextBlock(middleLines);
            int startingLine = beginLine;
            if (beginColumn != 1) {
                ++startingLine;
            }
            int endColumn = mergeLastLine ? lastLine.length() : TextBlock.lastLine(middleLines).length();
            int endingLine = beginLine + numLines - 1;
            if (!mergeLastLine) {
                --endingLine;
            }
            tb.setLocation(template, 1, startingLine, endColumn, endingLine);
            result.add(tb);
        }
        if (!mergeLastLine) {
            String printablePart = TextBlock.leftTrim(lastLine);
            String openingWS = lastLine.substring(0, lastLine.length() - printablePart.length());
            if (openingWS.length() > 0) {
                TextBlock tb = new TextBlock(openingWS);
                tb.setLocation(template, 1, beginLine + numLines - 1, openingWS.length(), beginLine + numLines - 1);
                result.add(tb);
            }
            if (printablePart.length() > 0) {
                TextBlock tb = new TextBlock(printablePart);
                tb.setLocation(template, 1 + openingWS.length(), beginLine + numLines - 1, lastLine.length(), beginLine + numLines - 1);
                result.add(tb);
            }
        }
        return result;
    }

    private static boolean isWhitespace(char c) {
        return c == '\n' || c == '\r' || c == '\t' || c == ' ';
    }

    private static int countLines(String input) {
        int result = 0;
        int lastChar = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\r') {
                ++result;
            } else if (c == '\n' && lastChar != 13) {
                ++result;
            }
            lastChar = c;
        }
        if (lastChar != 10 && lastChar != 13) {
            ++result;
        }
        return result;
    }

    private static String firstLine(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\n') {
                return input.substring(0, i + 1);
            }
            if (c != '\r') continue;
            if (input.length() == i + 1) {
                return input;
            }
            int endLine = input.charAt(i + 1) == '\n' ? i + 1 : i;
            return input.substring(0, endLine + 1);
        }
        return input;
    }

    private static String lastLine(String input) {
        int lineLength = input.length();
        if (lineLength < 2) {
            return input;
        }
        int startBackTrack = lineLength - 1;
        char lastChar = input.charAt(startBackTrack);
        if (lastChar == '\r' || lastChar == '\n') {
            --startBackTrack;
        }
        if (lastChar == '\n' && input.charAt(startBackTrack) == '\r') {
            --startBackTrack;
        }
        for (int i = startBackTrack; i >= 0; --i) {
            char c = input.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return input.substring(i + 1);
        }
        return input;
    }

    private static List<String> lines(String input) {
        ArrayList<String> result = new ArrayList<String>();
        while (input.length() > 0) {
            String line = TextBlock.firstLine(input);
            result.add(line);
            input = input.substring(line.length());
        }
        return result;
    }

    private static String leftTrim(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (TextBlock.isWhitespace(c)) continue;
            return s.substring(i);
        }
        return "";
    }

    static {
        TextBlock.EMPTY_BLOCK.ignore = true;
    }
}

