/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ast.Expression;
import freemarker.core.helpers.DefaultReferenceChecker;
import freemarker.core.helpers.DefaultTreeDumper;
import freemarker.core.parser.TemplateLocation;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

public abstract class TemplateNode
extends TemplateLocation {
    private static DefaultReferenceChecker referenceChecker = DefaultReferenceChecker.instance;
    private static DefaultTreeDumper canonicalTreeRenderer = new DefaultTreeDumper(false);
    TemplateNode parent;

    @Override
    public String getSource() {
        if (this.template != null) {
            return this.template.getSource(this.getBeginColumn(), this.getBeginLine(), this.getEndColumn(), this.getEndLine());
        }
        return this.getCanonicalForm();
    }

    @Override
    public String toString() {
        try {
            return this.getSource();
        }
        catch (Exception e) {
            return this.getCanonicalForm();
        }
    }

    public static TemplateException invalidTypeException(TemplateModel model, Expression exp, Environment env, String expected) throws TemplateException {
        TemplateNode.assertNonNull(model, exp, env);
        return new TemplateException("Expected " + expected + ". " + exp + " evaluated instead to " + model.getClass().getName() + " " + exp.getStartLocation() + ".", env);
    }

    public static void assertNonNull(TemplateModel model, Expression exp, Environment env) throws InvalidReferenceException {
        referenceChecker.assertNonNull(model, exp, env);
    }

    public static void assertIsDefined(TemplateModel model, Expression exp, Environment env) throws InvalidReferenceException {
        referenceChecker.assertIsDefined(model, exp, env);
    }

    public final String getCanonicalForm() {
        return canonicalTreeRenderer.render(this);
    }

    public TemplateNode getParentNode() {
        return this.parent;
    }
}

