/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.ParameterList;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ooparam.OOParamModel;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OOParamElement
extends TemplateElement {
    private String name;
    private ParameterList params;
    private List<OOParamElement> subParams;
    private Expression exp;

    public OOParamElement(String name, ParameterList params, TemplateElement block) {
        this.name = name;
        this.params = params;
        this.nestedBlock = block;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        env.unqualifiedSet(this.name, new OOParamModel(this));
    }

    public Expression asExp() {
        if (this.exp == null) {
            this.exp = new Expr();
        }
        return this.exp;
    }

    static class MultiParam
    extends Expression {
        List<OOParamElement> params = new ArrayList<OOParamElement>();

        MultiParam() {
        }

        @Override
        public Expression _deepClone(String s, Expression e) {
            return this;
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public TemplateModel _getAsTemplateModel(Environment env) {
            SimpleSequence result = new SimpleSequence();
            for (OOParamElement param : this.params) {
                result.add(new OOParamModel(param));
            }
            return result;
        }
    }

    class Expr
    extends Expression {
        public Expr() {
            this.copyLocationFrom(OOParamElement.this);
        }

        @Override
        public Expression _deepClone(String s, Expression e) {
            return this;
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public TemplateModel _getAsTemplateModel(Environment env) {
            return new OOParamModel(OOParamElement.this);
        }
    }
}

