/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.ArgsList;
import freemarker.core.ast.Expression;
import freemarker.core.ast.OOParamElement;
import freemarker.core.ast.ParameterList;
import freemarker.core.ast.TemplateNode;
import freemarker.core.parser.ParseException;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NamedArgsList
extends ArgsList {
    private LinkedHashMap<String, Expression> namedArgs = new LinkedHashMap();

    public void addNamedArg(String name, Expression exp) throws ParseException {
        if (this.namedArgs.containsKey(name)) {
            throw new ParseException("Error at: " + exp.getStartLocation() + "\nArgument " + name + " was already specified.");
        }
        this.namedArgs.put(name, exp);
        exp.parent = this;
    }

    public Map<String, Expression> getArgs() {
        return this.namedArgs;
    }

    @Override
    public int size() {
        return this.namedArgs.size();
    }

    Map<String, Expression> getCopyOfMap() {
        return (Map)this.namedArgs.clone();
    }

    @Override
    Map<String, TemplateModel> getParameterMap(TemplateModel tm, Environment env) {
        HashMap<String, TemplateModel> result = null;
        ParameterList annotatedParameterList = ArgsList.getParameterList(tm);
        if (annotatedParameterList == null) {
            result = new HashMap();
            for (String paramName : this.namedArgs.keySet()) {
                Expression exp = this.namedArgs.get(paramName);
                TemplateModel value = exp.getAsTemplateModel(env);
                TemplateNode.assertIsDefined(value, exp, env);
                result.put(paramName, value);
            }
        } else {
            result = annotatedParameterList.getParameterMap(this, env);
        }
        return result;
    }

    @Override
    List getParameterSequence(TemplateModel target, Environment env) {
        ParameterList annotatedParameterList = NamedArgsList.getParameterList(target);
        if (annotatedParameterList == null) {
            String msg = "Error at: " + this.getStartLocation() + "\nCannot invoke method " + target + " with a key=value parameter list because it is not annotated.";
            throw new TemplateException(msg, env);
        }
        List<TemplateModel> result = annotatedParameterList.getParameterSequence(this, env);
        if (target instanceof TemplateMethodModel && !(target instanceof TemplateMethodModelEx)) {
            ArrayList<String> strings = new ArrayList<String>();
            List<String> paramNames = annotatedParameterList.getParamNames();
            for (int i = 0; i < result.size(); ++i) {
                TemplateModel value = result.get(i);
                String paramName = paramNames.get(i);
                Expression exp = this.namedArgs.get(paramName);
                if (exp == null) {
                    exp = annotatedParameterList.getDefaultExpression(paramName);
                }
                strings.add(Expression.getStringValue(value, exp, env));
            }
            return strings;
        }
        return result;
    }

    @Override
    public String getStartLocation() {
        Iterator<Expression> iterator = this.namedArgs.values().iterator();
        if (iterator.hasNext()) {
            Expression exp = iterator.next();
            return exp.getStartLocation();
        }
        return "";
    }

    @Override
    ArgsList deepClone(String name, Expression subst) {
        NamedArgsList result = new NamedArgsList();
        for (Map.Entry<String, Expression> entry : this.namedArgs.entrySet()) {
            try {
                result.addNamedArg(entry.getKey(), entry.getValue());
            }
            catch (ParseException parseException) {}
        }
        return result;
    }

    @Override
    void addOOParamArg(OOParamElement param) {
        Expression exp = this.namedArgs.get(param.getName());
        if (exp != null) {
            // empty if block
        }
        this.addNamedArg(param.getName(), param.asExp());
    }
}

