/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.ConditionalBlock;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TemplateNode;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IfBlock
extends TemplateElement {
    public IfBlock(ConditionalBlock block) {
        this.nestedElements = new ArrayList();
        this.addBlock(block);
    }

    public void addBlock(ConditionalBlock block) {
        this.nestedElements.add(block);
    }

    public List<TemplateElement> getSubBlocks() {
        return Collections.unmodifiableList(this.nestedElements);
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        for (TemplateNode te : this.nestedElements) {
            ConditionalBlock cblock = (ConditionalBlock)te;
            Expression condition = cblock.getCondition();
            if (condition != null && !condition.isTrue(env)) continue;
            if (cblock.getNestedBlock() != null) {
                env.render(cblock);
            }
            return;
        }
    }

    @Override
    public String getDescription() {
        return "if-else ";
    }
}

