/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.CollectionAndSequence;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateNode;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class HashLiteral
extends Expression {
    private final ArrayList<Expression> keys;
    private final ArrayList<Expression> values;
    private final int size;

    public HashLiteral(ArrayList<Expression> keys, ArrayList<Expression> values) {
        this.keys = keys;
        this.values = values;
        this.size = keys.size();
        keys.trimToSize();
        values.trimToSize();
        for (Expression exp : keys) {
            exp.parent = this;
        }
        for (Expression exp : values) {
            exp.parent = this;
        }
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) {
        return new SequenceHash(env);
    }

    public List<Expression> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public List<Expression> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        for (int i = 0; i < this.size; ++i) {
            Expression key = this.keys.get(i);
            Expression value = this.values.get(i);
            if (key.isLiteral() && value.isLiteral()) continue;
            return false;
        }
        return true;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        ArrayList<Expression> clonedKeys = new ArrayList<Expression>(this.keys.size());
        for (Expression exp : this.keys) {
            clonedKeys.add(exp.deepClone(name, subst));
        }
        ArrayList<Expression> clonedValues = new ArrayList<Expression>(this.values.size());
        for (Expression exp : this.values) {
            clonedValues.add(exp.deepClone(name, subst));
        }
        return new HashLiteral(clonedKeys, clonedValues);
    }

    private class SequenceHash
    implements TemplateHashModelEx {
        private HashMap<String, TemplateModel> keyMap = new HashMap();
        private TemplateCollectionModel keyCollection;
        private TemplateCollectionModel valueCollection;

        SequenceHash(Environment env) {
            ArrayList<String> keyList = new ArrayList<String>(HashLiteral.this.size);
            ArrayList<TemplateModel> valueList = new ArrayList<TemplateModel>(HashLiteral.this.size);
            for (int i = 0; i < HashLiteral.this.size; ++i) {
                Expression keyExp = (Expression)HashLiteral.this.keys.get(i);
                Expression valExp = (Expression)HashLiteral.this.values.get(i);
                String key = keyExp.getStringValue(env);
                TemplateModel value = valExp.getAsTemplateModel(env);
                TemplateNode.assertIsDefined(value, valExp, env);
                this.keyMap.put(key, value);
                keyList.add(key);
                valueList.add(value);
            }
            this.keyCollection = new CollectionAndSequence(new SimpleSequence(keyList));
            this.valueCollection = new CollectionAndSequence(new SimpleSequence(valueList));
        }

        @Override
        public int size() {
            return HashLiteral.this.size;
        }

        @Override
        public TemplateCollectionModel keys() {
            return this.keyCollection;
        }

        @Override
        public TemplateCollectionModel values() {
            return this.valueCollection;
        }

        @Override
        public TemplateModel get(String key) {
            return this.keyMap.get(key);
        }

        @Override
        public boolean isEmpty() {
            return HashLiteral.this.size == 0;
        }
    }
}

