/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;

public class BooleanLiteral
extends Expression {
    private boolean value;

    public BooleanLiteral(boolean value) {
        this.value = value;
    }

    public boolean getValue() {
        return this.value;
    }

    static TemplateBooleanModel getTemplateModel(boolean b) {
        return b ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
    }

    @Override
    boolean isTrue(Environment env) {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value ? "true" : "false";
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) {
        return this.value ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
    }

    @Override
    boolean isLiteral() {
        return true;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new BooleanLiteral(this.value);
    }
}

