/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.commonvox.hbase_column_manager.HBaseSchemaArchive;

class XmlSchemaGenerator {
    static final String DEFAULT_OUTPUT_FILE_NAME = "HBaseSchemaArchive.xsd.xml";
    static final String DEFAULT_JAVADOCS_OUTPUT_PATH = "src/main/java/org/commonvox/hbase_column_manager/doc-files/";
    static final String DEFAULT_TEST_RESOURCE_OUTPUT_PATH = "src/test/resources";
    static File outputDirectory;
    final String outputFile;

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            XmlSchemaGenerator.outputToFile(DEFAULT_JAVADOCS_OUTPUT_PATH);
            XmlSchemaGenerator.outputToFile(DEFAULT_TEST_RESOURCE_OUTPUT_PATH);
        } else {
            XmlSchemaGenerator.outputToFile(args[0]);
        }
    }

    static void outputToFile(String outputPath) throws IOException, JAXBException {
        outputDirectory = new File(outputPath);
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        new XmlSchemaGenerator(outputPath + DEFAULT_OUTPUT_FILE_NAME).outputSchema();
        System.out.println("XML Schema file <HBaseSchemaArchive.xsd.xml> has been generated and outputted to the following directory: " + outputDirectory.getCanonicalPath());
    }

    private XmlSchemaGenerator(String outputFile) throws IOException, JAXBException {
        this.outputFile = outputFile;
    }

    private void outputSchema() throws IOException, JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{HBaseSchemaArchive.class});
        SchemaOutputResolverClass sor = new SchemaOutputResolverClass();
        jaxbContext.generateSchema((SchemaOutputResolver)sor);
    }

    private class SchemaOutputResolverClass
    extends SchemaOutputResolver {
        private SchemaOutputResolverClass() {
        }

        public Result createOutput(String namespaceURI, String suggestedFileName) throws IOException {
            File file = new File(XmlSchemaGenerator.this.outputFile);
            StreamResult result = new StreamResult(file);
            result.setSystemId(file.toURI().toURL().toString());
            return result;
        }
    }
}

