/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.log4j.Logger;
import org.commonvox.hbase_column_manager.ChangeEventMonitor;
import org.commonvox.hbase_column_manager.MConfiguration;
import org.commonvox.hbase_column_manager.MConnectionFactory;
import org.commonvox.hbase_column_manager.Repository;
import org.commonvox.hbase_column_manager.RepositoryAdmin;

class UtilityRunner {
    private static final Logger LOG = Logger.getLogger((String)UtilityRunner.class.getName());
    private static final Option UTILITY_OPTION;
    private static final Option TABLE_OPTION;
    private static final Option TABLE_OPTION_NOT_REQUIRED;
    private static final Option FILE_OPTION;
    private static final Option FILE_OPTION_NOT_REQUIRED;
    private static final Option HELP_OPTION;
    private static final Options OPTIONS_SET_2;
    private static final Options OPTIONS_SET_1;
    private static final HelpFormatter HELP_FORMATTER;
    private static final String BAR = "====================";
    public static final String EXPORT_SCHEMA_UTILITY = "exportSchema";
    public static final String IMPORT_SCHEMA_UTILITY = "importSchema";
    public static final String GET_COLUMN_QUALIFIERS_UTILITY_DIRECT_SCAN = "getColumnQualifiers";
    public static final String GET_COLUMN_QUALIFIERS_UTILITY_MAP_REDUCE = "getColumnQualifiersViaMapReduce";
    public static final String GET_CHANGE_EVENTS_UTILITY = "getChangeEventsForTable";
    public static final String UNINSTALL_REPOSITORY = "uninstallRepository";
    private static final Set<String> UTILITY_LIST;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    UtilityRunner(String[] args) throws Exception, ParseException, IOException, JAXBException {
        String selectedUtility;
        CommandLine commandLine;
        if (args != null && args.length == 1 && (args[0].equals("-" + HELP_OPTION.getOpt()) || args[0].equals("--" + HELP_OPTION.getLongOpt()))) {
            this.printHelp();
            return;
        }
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(OPTIONS_SET_1, args);
        }
        catch (ParseException pe) {
            LOG.error((Object)(pe.getClass().getSimpleName() + " encountered: " + pe.getMessage()));
            this.printHelp();
            throw pe;
        }
        if (commandLine.hasOption(HELP_OPTION.getLongOpt())) {
            this.printHelp();
        }
        if (!UTILITY_LIST.contains(selectedUtility = commandLine.getOptionValue(UTILITY_OPTION.getOpt()))) {
            throw new ParseException("Invalid utility argument submitted: <" + selectedUtility + ">");
        }
        if (selectedUtility.equals(UNINSTALL_REPOSITORY)) {
            this.logParmInfo(commandLine);
            LOG.info((Object)(this.getClass().getSimpleName() + " is invoking the following utility: <" + selectedUtility + ">"));
            try (Admin standardAdmin = ConnectionFactory.createConnection().getAdmin();){
                RepositoryAdmin.uninstallRepositoryStructures(standardAdmin);
                return;
            }
        }
        try {
            parser = new DefaultParser();
            commandLine = parser.parse(OPTIONS_SET_2, args);
        }
        catch (ParseException pe) {
            LOG.error((Object)(pe.getClass().getSimpleName() + " encountered: " + pe.getMessage()));
            this.printHelp();
            throw pe;
        }
        this.logParmInfo(commandLine);
        String selectedTableString = commandLine.getOptionValue(TABLE_OPTION.getOpt());
        String selectedNamespaceString = "";
        if (selectedTableString.endsWith(":*") && (selectedNamespaceString = selectedTableString.substring(0, selectedTableString.length() - 2)).isEmpty()) {
            selectedNamespaceString = Bytes.toString((byte[])Repository.HBASE_DEFAULT_NAMESPACE);
        }
        String selectedFileString = commandLine.getOptionValue(FILE_OPTION.getOpt());
        Configuration mConf = MConfiguration.create();
        mConf.setBoolean("column_manager.activated", true);
        try (Connection mConnection = MConnectionFactory.createConnection(mConf);){
            RepositoryAdmin repositoryAdmin = new RepositoryAdmin(mConnection);
            File selectedFile = new File(selectedFileString);
            LOG.info((Object)(this.getClass().getSimpleName() + " is invoking the following utility: <" + selectedUtility + (selectedNamespaceString.isEmpty() ? "> on the following table: <" + selectedTableString : "> on the following namespace: <" + selectedNamespaceString) + "> using the following source/target file <" + selectedFileString + ">"));
            switch (selectedUtility) {
                case "exportSchema": {
                    if (selectedNamespaceString.isEmpty()) {
                        repositoryAdmin.exportSchema(selectedFile, TableName.valueOf((String)selectedTableString));
                        return;
                    }
                    repositoryAdmin.exportSchema(selectedFile, selectedNamespaceString);
                    return;
                }
                case "importSchema": {
                    if (selectedNamespaceString.isEmpty()) {
                        repositoryAdmin.importSchema(selectedFile, TableName.valueOf((String)selectedTableString), false);
                        return;
                    }
                    repositoryAdmin.importSchema(selectedFile, selectedNamespaceString, false);
                    return;
                }
                case "getChangeEventsForTable": {
                    StringBuilder headerDetail = new StringBuilder("-- file generated for ").append(selectedNamespaceString.isEmpty() && selectedTableString.isEmpty() ? "full ColumnManagerAPI Repository, " : "").append(selectedNamespaceString.isEmpty() ? "" : "Namespace:[" + selectedNamespaceString + "], ").append(selectedTableString.isEmpty() ? "" : "Table:[" + selectedTableString + "], ");
                    if (selectedNamespaceString.isEmpty()) {
                        ChangeEventMonitor.exportChangeEventListToCsvFile(repositoryAdmin.getChangeEventMonitor().getChangeEventsForTable(TableName.valueOf((String)selectedTableString), true), selectedFile, headerDetail.toString());
                        return;
                    }
                    ChangeEventMonitor.exportChangeEventListToCsvFile(repositoryAdmin.getChangeEventMonitor().getChangeEventsForNamespace(Bytes.toBytes((String)selectedNamespaceString), true), selectedFile, headerDetail.toString());
                    return;
                }
                case "getColumnQualifiers": {
                    if (selectedNamespaceString.isEmpty()) {
                        repositoryAdmin.discoverColumnMetadata(TableName.valueOf((String)selectedTableString), true, false);
                        repositoryAdmin.outputReportOnColumnQualifiers(selectedFile, TableName.valueOf((String)selectedTableString));
                        return;
                    }
                    repositoryAdmin.discoverColumnMetadata(selectedNamespaceString, true, false);
                    repositoryAdmin.outputReportOnColumnQualifiers(selectedFile, selectedNamespaceString);
                    return;
                }
                case "getColumnQualifiersViaMapReduce": {
                    if (selectedNamespaceString.isEmpty()) {
                        repositoryAdmin.discoverColumnMetadata(TableName.valueOf((String)selectedTableString), true, true);
                        repositoryAdmin.outputReportOnColumnQualifiers(selectedFile, TableName.valueOf((String)selectedTableString));
                        return;
                    }
                    repositoryAdmin.discoverColumnMetadata(selectedNamespaceString, true, true);
                    repositoryAdmin.outputReportOnColumnQualifiers(selectedFile, selectedNamespaceString);
                    return;
                }
            }
            return;
        }
    }

    private void logParmInfo(CommandLine commandLine) {
        StringBuilder parmInfo = new StringBuilder(this.getClass().getSimpleName() + " has been invoked with the following <option=argument> combinations:");
        for (Option option : commandLine.getOptions()) {
            parmInfo.append(" <").append(option.getLongOpt()).append(option.getValue() == null ? "" : "=" + option.getValue()).append(">");
        }
        LOG.info((Object)parmInfo);
    }

    private void printHelp() {
        System.out.println(BAR);
        String commandLineSyntax = "java [-options] -cp <hbase-classpath-entries> " + this.getClass().getName();
        String header = "\n    *** Note that <hbase-classpath-entries> must include\n    ***   $HBASE_HOME/lib/*:$HBASE_HOME/conf, where $HBASE_HOME\n    ***   is the path to the local HBase installation.\n\nArguments for ColumnManagerAPI " + this.getClass().getSimpleName() + ":\n" + BAR;
        String footer = "====================\n\nFOR EXAMPLE, the exportSchema function might be invoked as follows from within the directory containing the ColumnManager JAR file:\n\n    java -cp *:$HBASE_HOME/lib/*:$HBASE_HOME/conf\n        org.commonvox.hbase_column_manager.UtilityRunner\n        -u exportSchema -t myNamespace:myTable -f myOutputFile.xml";
        HELP_FORMATTER.printHelp(commandLineSyntax, header, OPTIONS_SET_2, footer, true);
    }

    public static void main(String[] args) throws Exception, ParseException, IOException, JAXBException {
        new UtilityRunner(args);
    }

    static {
        HELP_FORMATTER = new HelpFormatter();
        HELP_FORMATTER.setOptionComparator(null);
        UTILITY_LIST = new TreeSet<String>();
        UTILITY_LIST.add(EXPORT_SCHEMA_UTILITY);
        UTILITY_LIST.add(IMPORT_SCHEMA_UTILITY);
        UTILITY_LIST.add(GET_CHANGE_EVENTS_UTILITY);
        UTILITY_LIST.add(GET_COLUMN_QUALIFIERS_UTILITY_DIRECT_SCAN);
        UTILITY_LIST.add(GET_COLUMN_QUALIFIERS_UTILITY_MAP_REDUCE);
        UTILITY_LIST.add(UNINSTALL_REPOSITORY);
        StringBuilder validUtilities = new StringBuilder();
        for (String utility : UTILITY_LIST) {
            if (validUtilities.length() > 0) {
                validUtilities.append(",");
            }
            validUtilities.append(" ").append(utility);
        }
        UTILITY_OPTION = Option.builder("u").longOpt("utility").hasArg().required(true).desc("Utility to run. Valid <arg> values are as follows:" + validUtilities).optionalArg(false).build();
        TABLE_OPTION = Option.builder("t").longOpt("table").hasArg().required(true).desc("Fully-qualified table name; or submit '*' in place of table qualifier (e.g., 'myNamespace:*') to process all tables in a given namespace.").optionalArg(false).build();
        TABLE_OPTION_NOT_REQUIRED = (Option)TABLE_OPTION.clone();
        TABLE_OPTION_NOT_REQUIRED.setRequired(false);
        FILE_OPTION = Option.builder("f").longOpt("file").hasArg().required(true).desc("Source/target file.").optionalArg(false).build();
        FILE_OPTION_NOT_REQUIRED = (Option)FILE_OPTION.clone();
        FILE_OPTION_NOT_REQUIRED.setRequired(false);
        HELP_OPTION = Option.builder("h").longOpt("help").hasArg(false).required(false).desc("Display this help message.").build();
        OPTIONS_SET_1 = new Options();
        OPTIONS_SET_1.addOption(UTILITY_OPTION);
        OPTIONS_SET_1.addOption(TABLE_OPTION_NOT_REQUIRED);
        OPTIONS_SET_1.addOption(FILE_OPTION_NOT_REQUIRED);
        OPTIONS_SET_1.addOption(HELP_OPTION);
        OPTIONS_SET_2 = new Options();
        OPTIONS_SET_2.addOption(UTILITY_OPTION);
        OPTIONS_SET_2.addOption(TABLE_OPTION);
        OPTIONS_SET_2.addOption(FILE_OPTION);
        OPTIONS_SET_2.addOption(HELP_OPTION);
    }
}

