/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlType;

@XmlType
enum SchemaEntityType {
    NAMESPACE(78, "Namespace"),
    TABLE(84, "Table"),
    COLUMN_FAMILY(70, "ColumnFamily"),
    COLUMN_AUDITOR(67, "ColumnAuditor"),
    COLUMN_DEFINITION(68, "ColumnDefinition");

    static final Map<Byte, SchemaEntityType> ENTITY_TYPE_BYTE_TO_ENUM_MAP;
    static final Map<String, Byte> ENTITY_TYPE_LABEL_TO_BYTE_MAP;
    private final byte recordType;
    private final String entityTypeLabel;

    private SchemaEntityType(byte recordType, String entityTypeLabel) {
        this.recordType = recordType;
        this.entityTypeLabel = entityTypeLabel;
    }

    byte getRecordType() {
        return this.recordType;
    }

    public String toString() {
        return this.entityTypeLabel;
    }

    static {
        ENTITY_TYPE_BYTE_TO_ENUM_MAP = new TreeMap<Byte, SchemaEntityType>();
        ENTITY_TYPE_LABEL_TO_BYTE_MAP = new TreeMap<String, Byte>();
        ENTITY_TYPE_BYTE_TO_ENUM_MAP.put(NAMESPACE.getRecordType(), NAMESPACE);
        ENTITY_TYPE_BYTE_TO_ENUM_MAP.put(TABLE.getRecordType(), TABLE);
        ENTITY_TYPE_BYTE_TO_ENUM_MAP.put(COLUMN_FAMILY.getRecordType(), COLUMN_FAMILY);
        ENTITY_TYPE_BYTE_TO_ENUM_MAP.put(COLUMN_AUDITOR.getRecordType(), COLUMN_AUDITOR);
        ENTITY_TYPE_BYTE_TO_ENUM_MAP.put(COLUMN_DEFINITION.getRecordType(), COLUMN_DEFINITION);
        for (Map.Entry<Byte, SchemaEntityType> entry : ENTITY_TYPE_BYTE_TO_ENUM_MAP.entrySet()) {
            ENTITY_TYPE_LABEL_TO_BYTE_MAP.put(entry.getValue().toString(), entry.getKey());
        }
    }
}

