/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTableMultiplexer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.log4j.Logger;
import org.commonvox.hbase_column_manager.ChangeEventMonitor;
import org.commonvox.hbase_column_manager.ColumnAuditor;
import org.commonvox.hbase_column_manager.ColumnDefinition;
import org.commonvox.hbase_column_manager.ColumnInvalidityReport;
import org.commonvox.hbase_column_manager.HBaseSchemaArchive;
import org.commonvox.hbase_column_manager.MColumnDescriptor;
import org.commonvox.hbase_column_manager.MConnection;
import org.commonvox.hbase_column_manager.MConnectionFactory;
import org.commonvox.hbase_column_manager.MNamespaceDescriptor;
import org.commonvox.hbase_column_manager.MTableDescriptor;
import org.commonvox.hbase_column_manager.Repository;
import org.commonvox.hbase_column_manager.TableNotIncludedForProcessingException;

public class RepositoryAdmin {
    private final Logger logger = Logger.getLogger((String)this.getClass().getName());
    private final Connection hbaseConnection;
    private final Repository repository;

    public RepositoryAdmin(Connection connection) throws IOException {
        MConnection mConnection = MConnection.class.isAssignableFrom(connection.getClass()) ? (MConnection)connection : MConnectionFactory.getMConnection(connection);
        this.hbaseConnection = mConnection.getStandardConnection();
        this.repository = mConnection.getRepository();
    }

    public static void installRepositoryStructures(Admin hbaseAdmin) throws IOException {
        Repository.initializeRepositoryNamespace(hbaseAdmin);
        Repository.initializeRepositoryTable(hbaseAdmin);
        Repository.initializeAliasTable(hbaseAdmin);
        new RepositoryAdmin((Connection)hbaseAdmin.getConnection()).repository.discoverSchema(false, false, false);
    }

    public static void setRepositoryMaxVersions(Admin hbaseAdmin, int maxVersions) throws IOException {
        Repository.setRepositoryMaxVersions(hbaseAdmin, maxVersions);
    }

    public static int getRepositoryMaxVersions(Admin hbaseAdmin) throws IOException {
        return Repository.getRepositoryMaxVersions(hbaseAdmin);
    }

    public static void uninstallRepositoryStructures(Admin hbaseAdmin) throws IOException {
        Repository.dropRepository(hbaseAdmin, Logger.getLogger((String)RepositoryAdmin.class.getName()));
        ColumnInvalidityReport.dropTempReportNamespace(hbaseAdmin);
    }

    public static void deleteTempReportTables(Admin hbaseAdmin) throws IOException {
        ColumnInvalidityReport.dropTempReportTables(hbaseAdmin);
    }

    public void dumpRepositoryTable() throws IOException {
        if (this.repository.isActivated()) {
            this.repository.dumpRepositoryTable();
        }
    }

    Repository getRepository() {
        return this.repository;
    }

    public void addColumnAuditor(TableName tableName, byte[] colFamily, final ColumnAuditor colAuditor) throws IOException, TableNotIncludedForProcessingException {
        ArrayList<ColumnAuditor> colAuditors = new ArrayList<ColumnAuditor>(){
            {
                this.add(colAuditor);
            }
        };
        this.repository.putColumnAuditorSchemaEntities(tableName, colFamily, (List<ColumnAuditor>)colAuditors);
    }

    public void addColumnAuditor(HTableDescriptor htd, HColumnDescriptor hcd, ColumnAuditor colAuditor) throws IOException, TableNotIncludedForProcessingException {
        this.addColumnAuditor(htd.getTableName(), hcd.getName(), colAuditor);
    }

    public void addColumnAuditors(TableName tableName, byte[] colFamily, List<ColumnAuditor> colAuditors) throws IOException, TableNotIncludedForProcessingException {
        this.repository.putColumnAuditorSchemaEntities(tableName, colFamily, colAuditors);
    }

    public void addColumnAuditors(HTableDescriptor htd, HColumnDescriptor hcd, List<ColumnAuditor> colAuditors) throws IOException, TableNotIncludedForProcessingException {
        this.repository.putColumnAuditorSchemaEntities(htd.getTableName(), hcd.getName(), colAuditors);
    }

    public Set<ColumnAuditor> getColumnAuditors(HTableDescriptor htd, HColumnDescriptor hcd) throws IOException, TableNotIncludedForProcessingException {
        if (!this.repository.isIncludedTable(htd.getTableName())) {
            throw new TableNotIncludedForProcessingException(htd.getTableName().getName(), null);
        }
        if (MColumnDescriptor.class.isAssignableFrom(hcd.getClass())) {
            return ((MColumnDescriptor)hcd).getColumnAuditors();
        }
        return this.repository.getColumnAuditors(htd, hcd);
    }

    public Set<ColumnAuditor> getColumnAuditors(TableName tableName, byte[] colFamily) throws IOException, TableNotIncludedForProcessingException {
        if (!this.repository.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
        MTableDescriptor mtd = this.getRepository().getMTableDescriptor(tableName);
        if (mtd == null) {
            return null;
        }
        MColumnDescriptor mcd = mtd.getMColumnDescriptor(colFamily);
        if (mcd == null) {
            return null;
        }
        return this.getColumnAuditors(mtd, mcd);
    }

    public Set<byte[]> getColumnQualifiers(HTableDescriptor htd, HColumnDescriptor hcd) throws IOException, TableNotIncludedForProcessingException {
        if (!this.repository.isIncludedTable(htd.getTableName())) {
            throw new TableNotIncludedForProcessingException(htd.getTableName().getName(), null);
        }
        TreeSet<byte[]> columnQualifiers = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        if (MColumnDescriptor.class.isAssignableFrom(hcd.getClass())) {
            return ((MColumnDescriptor)hcd).getColumnQualifiers();
        }
        Set<ColumnAuditor> columnAuditors = this.repository.getColumnAuditors(htd, hcd);
        if (columnAuditors == null) {
            return null;
        }
        for (ColumnAuditor columnAuditor : columnAuditors) {
            columnQualifiers.add(columnAuditor.getName());
        }
        return columnQualifiers;
    }

    public Set<byte[]> getColumnQualifiers(TableName tableName, byte[] colFamily) throws IOException, TableNotIncludedForProcessingException {
        if (!this.repository.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
        MTableDescriptor mtd = this.repository.getMTableDescriptor(tableName);
        if (mtd == null) {
            return null;
        }
        MColumnDescriptor mcd = mtd.getMColumnDescriptor(colFamily);
        if (mcd == null) {
            return null;
        }
        return mcd.getColumnQualifiers();
    }

    public void addColumnDefinition(TableName tableName, byte[] colFamily, final ColumnDefinition colDefinition) throws IOException, TableNotIncludedForProcessingException {
        ArrayList<ColumnDefinition> colDefinitions = new ArrayList<ColumnDefinition>(){
            {
                this.add(colDefinition);
            }
        };
        this.repository.putColumnDefinitionSchemaEntities(tableName, colFamily, (List<ColumnDefinition>)colDefinitions);
    }

    public void addColumnDefinition(HTableDescriptor htd, HColumnDescriptor hcd, ColumnDefinition colDefinition) throws IOException, TableNotIncludedForProcessingException {
        this.addColumnDefinition(htd.getTableName(), hcd.getName(), colDefinition);
    }

    public void addColumnDefinitions(TableName tableName, byte[] colFamily, List<ColumnDefinition> colDefinitions) throws IOException, TableNotIncludedForProcessingException {
        this.repository.putColumnDefinitionSchemaEntities(tableName, colFamily, colDefinitions);
    }

    public void addColumnDefinitions(HTableDescriptor htd, HColumnDescriptor hcd, List<ColumnDefinition> colDefinitions) throws IOException, TableNotIncludedForProcessingException {
        this.repository.putColumnDefinitionSchemaEntities(htd.getTableName(), hcd.getName(), colDefinitions);
    }

    public Collection<ColumnDefinition> getColumnDefinitions(HTableDescriptor htd, HColumnDescriptor hcd) throws IOException, TableNotIncludedForProcessingException {
        if (MColumnDescriptor.class.isAssignableFrom(hcd.getClass())) {
            return ((MColumnDescriptor)hcd).getColumnDefinitions();
        }
        return this.repository.getColumnDefinitions(htd, hcd);
    }

    public Collection<ColumnDefinition> getColumnDefinitions(TableName tableName, byte[] colFamily) throws IOException, TableNotIncludedForProcessingException {
        MTableDescriptor mtd = this.getRepository().getMTableDescriptor(tableName);
        MColumnDescriptor mcd = mtd.getMColumnDescriptor(colFamily);
        return this.getColumnDefinitions(mtd, mcd);
    }

    public void deleteColumnDefinition(TableName tableName, byte[] colFamily, byte[] colQualifier) throws IOException, TableNotIncludedForProcessingException {
        this.repository.deleteColumnDefinition(tableName, colFamily, colQualifier);
    }

    public void deleteColumnDefinition(HTableDescriptor htd, HColumnDescriptor hcd, byte[] colQualifier) throws IOException, TableNotIncludedForProcessingException {
        this.repository.deleteColumnDefinition(htd.getTableName(), hcd.getName(), colQualifier);
    }

    public boolean columnDefinitionsEnforced(TableName tableName, byte[] colFamily) throws IOException, TableNotIncludedForProcessingException {
        return this.repository.columnDefinitionsEnforced(tableName, colFamily);
    }

    public void enableColumnDefinitionEnforcement(boolean enabled, TableName tableName, byte[] colFamily) throws IOException, TableNotIncludedForProcessingException {
        this.repository.enableColumnDefinitionEnforcement(enabled, tableName, colFamily);
    }

    public void enableColumnAliases(boolean enabled, TableName tableName, byte[] colFamily) throws IOException, TableNotIncludedForProcessingException {
        this.repository.enableColumnAliases(enabled, tableName, colFamily);
    }

    public ChangeEventMonitor getChangeEventMonitor() throws IOException {
        return new ChangeEventMonitor(this.repository.getRepositoryTable());
    }

    MTableDescriptor getMTableDescriptor(TableName tn) throws IOException {
        if (!this.repository.isActivated()) {
            return null;
        }
        return new MTableDescriptor(this.repository.getAdmin().getTableDescriptor(tn), this.repository);
    }

    MTableDescriptor getMTableDescriptorFromRepository(TableName tn) throws IOException {
        if (!this.repository.isActivated()) {
            return null;
        }
        return this.repository.getMTableDescriptor(tn);
    }

    MNamespaceDescriptor getMNamespaceDescriptorFromRepository(String namespaceName) throws IOException {
        if (!this.repository.isActivated()) {
            return null;
        }
        return this.repository.getMNamespaceDescriptor(namespaceName);
    }

    public HTableMultiplexer createHTableMultiplexer(int perRegionServerBufferQueueSize) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void discoverColumnMetadata(boolean includeAllCells, boolean useMapreduce) throws Exception {
        this.repository.discoverSchema(true, includeAllCells, useMapreduce);
    }

    public void discoverColumnMetadata(String namespace, boolean includeAllCells, boolean useMapreduce) throws Exception, TableNotIncludedForProcessingException {
        this.repository.discoverSchema(namespace, true, includeAllCells, useMapreduce);
    }

    public void discoverColumnMetadata(TableName tableName, boolean includeAllCells, boolean useMapreduce) throws Exception, TableNotIncludedForProcessingException {
        this.repository.discoverSchema(tableName, true, includeAllCells, useMapreduce);
    }

    void purgeTableSchemaEntity(TableName tn) throws IOException {
        this.repository.purgeTableSchemaEntity(tn);
    }

    public void exportSchema(File targetFile) throws IOException, JAXBException, XMLStreamException {
        this.repository.exportSchema(null, null, targetFile);
    }

    public void exportSchema(File targetFile, String sourceNamespaceName) throws IOException, JAXBException, XMLStreamException, TableNotIncludedForProcessingException {
        this.repository.exportSchema(sourceNamespaceName, null, targetFile);
    }

    public void exportSchema(File targetFile, TableName sourceTableName) throws IOException, JAXBException, XMLStreamException, TableNotIncludedForProcessingException {
        this.repository.exportSchema(sourceTableName.getNamespaceAsString(), sourceTableName, targetFile);
    }

    public void importSchema(File sourceHsaFile, boolean includeColumnAuditors) throws IOException, JAXBException {
        this.repository.importSchema(sourceHsaFile, null, null, null, includeColumnAuditors, false);
    }

    public void importSchema(File sourceHsaFile, String namespaceName, boolean includeColumnAuditors) throws IOException, JAXBException, TableNotIncludedForProcessingException {
        this.repository.importSchema(sourceHsaFile, namespaceName, null, null, includeColumnAuditors, false);
    }

    public void importSchema(File sourceHsaFile, TableName tableName, boolean includeColumnAuditors) throws IOException, JAXBException, TableNotIncludedForProcessingException {
        this.repository.importSchema(sourceHsaFile, tableName.getNamespaceAsString(), tableName, null, includeColumnAuditors, false);
    }

    public void importColumnDefinitions(File sourceHsaFile) throws IOException, JAXBException {
        this.repository.importSchema(sourceHsaFile, null, null, null, false, true);
    }

    public void importColumnDefinitions(File sourceHsaFile, String namespace) throws IOException, JAXBException, TableNotIncludedForProcessingException {
        this.repository.importSchema(sourceHsaFile, namespace, null, null, false, true);
    }

    public void importColumnDefinitions(File sourceHsaFile, TableName tableName) throws IOException, JAXBException, TableNotIncludedForProcessingException {
        this.repository.importSchema(sourceHsaFile, tableName.getNamespaceAsString(), tableName, null, false, true);
    }

    public void importColumnDefinitions(File sourceHsaFile, TableName tableName, byte[] colFamily) throws IOException, JAXBException, TableNotIncludedForProcessingException {
        this.repository.importSchema(sourceHsaFile, tableName.getNamespaceAsString(), tableName, colFamily, false, true);
    }

    public static String generateHsaFileSummary(File sourceHsaFile) throws JAXBException {
        return HBaseSchemaArchive.getSummaryReport(sourceHsaFile);
    }

    public boolean outputReportOnColumnQualifiers(File targetFile, String namespace) throws IOException, TableNotIncludedForProcessingException {
        return this.repository.outputReportOnColumnQualifiers(namespace, null, null, targetFile);
    }

    public boolean outputReportOnColumnQualifiers(File targetFile, TableName tableName) throws IOException, TableNotIncludedForProcessingException {
        return this.repository.outputReportOnColumnQualifiers(tableName.getNamespaceAsString(), tableName, null, targetFile);
    }

    public boolean outputReportOnColumnQualifiers(File targetFile, TableName tableName, byte[] colFamily) throws IOException, TableNotIncludedForProcessingException {
        return this.repository.outputReportOnColumnQualifiers(tableName.getNamespaceAsString(), tableName, colFamily, targetFile);
    }

    public boolean outputReportOnInvalidColumnQualifiers(File targetFile, TableName tableName, boolean verbose, boolean useMapreduce) throws Exception, TableNotIncludedForProcessingException {
        return this.outputReportOnInvalidColumnQualifiers(targetFile, tableName, null, verbose, useMapreduce);
    }

    public boolean outputReportOnInvalidColumnQualifiers(File targetFile, TableName tableName, byte[] colFamily, boolean verbose, boolean useMapreduce) throws Exception, TableNotIncludedForProcessingException {
        return this.repository.outputReportOnInvalidColumns(ColumnInvalidityReport.ReportType.QUALIFIER, tableName, colFamily, targetFile, verbose, false, useMapreduce);
    }

    public boolean outputReportOnInvalidColumnLengths(File targetFile, TableName tableName, boolean verbose, boolean includeAllCells, boolean useMapreduce) throws Exception, TableNotIncludedForProcessingException {
        return this.outputReportOnInvalidColumnLengths(targetFile, tableName, null, verbose, includeAllCells, useMapreduce);
    }

    public boolean outputReportOnInvalidColumnLengths(File targetFile, TableName tableName, byte[] colFamily, boolean verbose, boolean includeAllCells, boolean useMapreduce) throws Exception, TableNotIncludedForProcessingException {
        return this.repository.outputReportOnInvalidColumns(ColumnInvalidityReport.ReportType.LENGTH, tableName, colFamily, targetFile, verbose, includeAllCells, useMapreduce);
    }

    public boolean outputReportOnInvalidColumnValues(File targetFile, TableName tableName, boolean verbose, boolean includeAllCells, boolean useMapreduce) throws Exception, TableNotIncludedForProcessingException {
        return this.outputReportOnInvalidColumnValues(targetFile, tableName, null, verbose, includeAllCells, useMapreduce);
    }

    public boolean outputReportOnInvalidColumnValues(File targetFile, TableName tableName, byte[] colFamily, boolean verbose, boolean includeAllCells, boolean useMapreduce) throws Exception, TableNotIncludedForProcessingException {
        return this.repository.outputReportOnInvalidColumns(ColumnInvalidityReport.ReportType.VALUE, tableName, colFamily, targetFile, verbose, includeAllCells, useMapreduce);
    }

    public boolean namespaceExists(NamespaceDescriptor nd) throws IOException {
        return this.repository.namespaceExists(nd.getName());
    }

    public boolean namespaceExists(String namespaceName) throws IOException {
        return this.repository.namespaceExists(namespaceName);
    }
}

