/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import org.commonvox.hbase_column_manager.ColumnAuditor;
import org.commonvox.hbase_column_manager.ColumnDefinition;
import org.commonvox.hbase_column_manager.ColumnDefinitionNotFoundException;
import org.commonvox.hbase_column_manager.ColumnDiscoveryTool;
import org.commonvox.hbase_column_manager.ColumnInvalidityReport;
import org.commonvox.hbase_column_manager.ColumnManagerIOException;
import org.commonvox.hbase_column_manager.ColumnQualifierReport;
import org.commonvox.hbase_column_manager.ColumnValueInvalidException;
import org.commonvox.hbase_column_manager.HBaseSchemaArchive;
import org.commonvox.hbase_column_manager.MAdmin;
import org.commonvox.hbase_column_manager.MColumnDescriptor;
import org.commonvox.hbase_column_manager.MConfiguration;
import org.commonvox.hbase_column_manager.MConnection;
import org.commonvox.hbase_column_manager.MNamespaceDescriptor;
import org.commonvox.hbase_column_manager.MTableDescriptor;
import org.commonvox.hbase_column_manager.SchemaEntity;
import org.commonvox.hbase_column_manager.SchemaEntityType;
import org.commonvox.hbase_column_manager.TableNotIncludedForProcessingException;

class Repository {
    private final Logger logger = Logger.getLogger((String)this.getClass().getName());
    private static final Logger staticLogger = Logger.getLogger((String)Repository.class.getName());
    private final byte[] javaUsername = Bytes.toBytes((String)System.getProperty(Bytes.toString((byte[])JAVA_USERNAME_PROPERTY_KEY)));
    private final boolean columnManagerIsActivated;
    private Set<String> includedNamespaces;
    private Set<String> includedEntireNamespaces;
    private Set<TableName> includedTables;
    private Set<String> excludedNamespaces;
    private Set<String> excludedEntireNamespaces;
    private Set<TableName> excludedTables;
    private final Connection hbaseConnection;
    private final Admin standardAdmin;
    private final Table repositoryTable;
    private final Table aliasTable;
    private static final byte[] ALIAS_INCREMENTOR_COLUMN = Bytes.toBytes((String)"#$$#_aliasIncrementor");
    private static final int INVALID_ALIAS_INT = -1;
    private static final byte[] INVALID_ALIAS = Bytes.toBytes((int)-1);
    private static final NavigableSet<byte[]> NULL_NAVIGABLE_SET = null;
    static final String PRODUCT_NAME = "ColumnManagerAPI";
    static final byte[] JAVA_USERNAME_PROPERTY_KEY = Bytes.toBytes((String)"user.name");
    private static final String REPOSITORY_NOT_ACTIVATED_MSG = "ColumnManagerAPI Repository is NOT ACTIVATED.";
    static final String HBASE_CONFIG_PARM_KEY_PREFIX = "column_manager.";
    static final String HBASE_CONFIG_PARM_KEY_COLMANAGER_ACTIVATED = "column_manager.activated";
    private static final String HBASE_CONFIG_PARM_VALUE_COLMANAGER_DEACTIVATED = "false";
    private static final String HBASE_CONFIG_PARM_VALUE_COLMANAGER_ACTIVATED = "true";
    static final String HBASE_CONFIG_PARM_KEY_COLMANAGER_INCLUDED_TABLES = "column_manager.includedTables";
    static final String HBASE_CONFIG_PARM_KEY_COLMANAGER_EXCLUDED_TABLES = "column_manager.excludedTables";
    static final String ALL_TABLES_WILDCARD_INDICATOR = ":*";
    private static final int UNIQUE_FOREIGN_KEY_LENGTH = 16;
    private static final NamespaceDescriptor HBASE_SYSTEM_NAMESPACE_DESCRIPTOR = NamespaceDescriptor.create((String)"hbase").build();
    static final NamespaceDescriptor REPOSITORY_NAMESPACE_DESCRIPTOR = NamespaceDescriptor.create((String)"__column_manager_repository_namespace").build();
    static final TableName REPOSITORY_TABLENAME = TableName.valueOf((String)REPOSITORY_NAMESPACE_DESCRIPTOR.getName(), (String)"column_manager_repository_table");
    static final byte[] REPOSITORY_CF = Bytes.toBytes((String)"se");
    static final int DEFAULT_REPOSITORY_MAX_VERSIONS = 50;
    static final TableName ALIAS_DIRECTORY_TABLENAME = TableName.valueOf((String)REPOSITORY_NAMESPACE_DESCRIPTOR.getName(), (String)"column_manager_alias_directory_table");
    static final byte[] ALIAS_CF = Bytes.toBytes((String)"ca");
    static final byte[] NAMESPACE_PARENT_FOREIGN_KEY = new byte[]{45};
    static final byte[] HBASE_DEFAULT_NAMESPACE = Bytes.toBytes((String)"default");
    private static final Map<ImmutableBytesWritable, ImmutableBytesWritable> EMPTY_VALUES = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
    private static final String CONFIG_COLUMN_PREFIX = "Configuration__";
    private static final byte[] CONFIG_COLUMN_PREFIX_BYTES = Bytes.toBytes((String)"Configuration__");
    private static final String VALUE_COLUMN_PREFIX = "Value__";
    private static final byte[] VALUE_COLUMN_PREFIX_BYTES = Bytes.toBytes((String)"Value__");
    static final String COUNTER_COLUMN_PREFIX = "Counter__";
    static final byte[] COUNTER_COLUMN_PREFIX_BYTES = Bytes.toBytes((String)"Counter__");
    static final byte[] COL_COUNTER_QUALIFIER = Bytes.toBytes((String)"Counter__column");
    static final byte[] CELL_COUNTER_QUALIFIER = Bytes.toBytes((String)"Counter__cell");
    static final String TIMESTAMP_KEY_PREFIX = "Timestamp__";
    static final byte[] TIMESTAMP_KEY_PREFIX_BYTES = Bytes.toBytes((String)"Timestamp__");
    static final byte[] COL_COUNTER_TIMESTAMP_KEY = Bytes.toBytes((String)"Timestamp__column_counter");
    static final byte[] CELL_COUNTER_TIMESTAMP_KEY = Bytes.toBytes((String)"Timestamp__cell_counter");
    static final byte[] MAX_VALUE_QUALIFIER = ByteBuffer.allocate("Value__".length() + "MAX_VALUE_LENGTH_FOUND".length()).put(VALUE_COLUMN_PREFIX_BYTES).put(Bytes.toBytes((String)"MAX_VALUE_LENGTH_FOUND")).array();
    static final String JOB_NAME_CONF_KEY = "mapreduce.job.name";
    static final String MAP_SPECULATIVE_CONF_KEY = "mapreduce.map.speculative";
    static final String COLMANAGER_MAP_CONF_KEY_PREFIX = "colmanager.map.";
    static final String TABLE_NAME_CONF_KEY = "colmanager.map.source.table";
    static final String COLFAMILY_CONF_KEY = "colmanager.map.source.colfamily";
    static final String ARG_KEY_PREFIX = "--";
    static final String ARG_DELIMITER = "=";
    static final String TABLE_NAME_ARG_KEY = "--colmanager.map.source.table=";
    static final String COLFAMILY_ARG_KEY = "--colmanager.map.source.colfamily=";
    static final String INCLUDE_ALL_CELLS_CONF_KEY = "include_all_cells";
    static final String INCLUDE_ALL_CELLS_ARG_KEY = "--include_all_cells=";
    private static final String SYNC_ERROR_MSG = "SYNCHRONIZATION ERROR FOUND IN ColumnManagerAPI REPOSITORY. ";
    private static final String SCHEMA_ENTITY_NOT_FOUND_SYNC_ERROR_MSG = "SYNCHRONIZATION ERROR FOUND IN ColumnManagerAPI REPOSITORY. %s in Repository NOT FOUND in HBase: ";
    static final String NAMESPACE_NOT_FOUND_SYNC_ERROR_MSG = String.format("SYNCHRONIZATION ERROR FOUND IN ColumnManagerAPI REPOSITORY. %s in Repository NOT FOUND in HBase: ", NamespaceDescriptor.class.getSimpleName());
    static final String TABLE_NOT_FOUND_SYNC_ERROR_MSG = String.format("SYNCHRONIZATION ERROR FOUND IN ColumnManagerAPI REPOSITORY. %s in Repository NOT FOUND in HBase: ", HTableDescriptor.class.getSimpleName());
    static final String COLDESCRIPTOR_NOT_FOUND_SYNC_ERROR_MSG = String.format("SYNCHRONIZATION ERROR FOUND IN ColumnManagerAPI REPOSITORY. %s in Repository NOT FOUND in HBase: ", HColumnDescriptor.class.getSimpleName());
    private static final String SCHEMA_ENTITY_ATTRIBUTE_SYNC_ERROR_MSG = "SYNCHRONIZATION ERROR FOUND IN ColumnManagerAPI REPOSITORY. %s in Repository has attribute-value(s) differing from that in HBase: ";
    static final String NAMESPACE_ATTRIBUTE_SYNC_ERROR_MSG = String.format("SYNCHRONIZATION ERROR FOUND IN ColumnManagerAPI REPOSITORY. %s in Repository has attribute-value(s) differing from that in HBase: ", NamespaceDescriptor.class.getSimpleName());
    static final String TABLE_ATTRIBUTE_SYNC_ERROR_MSG = String.format("SYNCHRONIZATION ERROR FOUND IN ColumnManagerAPI REPOSITORY. %s in Repository has attribute-value(s) differing from that in HBase: ", HTableDescriptor.class.getSimpleName());
    static final String COLDESCRIPTOR_ATTRIBUTE_SYNC_ERROR_MSG = String.format("SYNCHRONIZATION ERROR FOUND IN ColumnManagerAPI REPOSITORY. %s in Repository has attribute-value(s) differing from that in HBase: ", HColumnDescriptor.class.getSimpleName());
    private static final byte[] ENTITY_STATUS_COLUMN = Bytes.toBytes((String)"_Status");
    private static final byte[] ACTIVE_STATUS = Bytes.toBytes((String)"A");
    private static final byte[] DELETED_STATUS = Bytes.toBytes((String)"D");
    static final byte[] FOREIGN_KEY_COLUMN = Bytes.toBytes((String)"_ForeignKey");
    private static final byte[] HEX_00_ARRAY = new byte[16];
    private static final byte[] HEX_FF_ARRAY = new byte[16];

    Repository(Connection hBaseConnection, Object originatingObject) throws IOException {
        this.hbaseConnection = hBaseConnection;
        this.standardAdmin = Repository.getNewAdmin(this.hbaseConnection);
        Configuration conf = this.hbaseConnection.getConfiguration();
        String columnManagerActivatedStatus = conf.get(HBASE_CONFIG_PARM_KEY_COLMANAGER_ACTIVATED, HBASE_CONFIG_PARM_VALUE_COLMANAGER_DEACTIVATED);
        this.logger.info((Object)("ColumnManagerAPI Repository instance being instantiated by object of " + originatingObject.getClass().getSimpleName() + " class."));
        this.logger.info((Object)("ColumnManagerAPI config parameter: column_manager.activated = " + columnManagerActivatedStatus));
        if (columnManagerActivatedStatus.equalsIgnoreCase(HBASE_CONFIG_PARM_VALUE_COLMANAGER_ACTIVATED)) {
            this.columnManagerIsActivated = true;
            this.logger.info((Object)"ColumnManagerAPI Repository is ACTIVATED.");
            this.buildIncludedAndExcludedTablesSets(conf);
            boolean newInstallation = !this.standardAdmin.tableExists(REPOSITORY_TABLENAME);
            Repository.initializeRepositoryNamespace(this.standardAdmin);
            this.repositoryTable = Repository.initializeRepositoryTable(this.standardAdmin);
            this.aliasTable = Repository.initializeAliasTable(this.standardAdmin);
            this.doSyncCheck();
            if (newInstallation) {
                this.discoverSchema(false, false, false);
            }
        } else {
            this.columnManagerIsActivated = false;
            this.repositoryTable = null;
            this.aliasTable = null;
            this.logger.info((Object)REPOSITORY_NOT_ACTIVATED_MSG);
        }
    }

    private void buildIncludedAndExcludedTablesSets(Configuration conf) {
        String[] includedTablesArray = conf.getStrings(HBASE_CONFIG_PARM_KEY_COLMANAGER_INCLUDED_TABLES);
        String[] excludedTablesArray = conf.getStrings(HBASE_CONFIG_PARM_KEY_COLMANAGER_EXCLUDED_TABLES);
        if (includedTablesArray != null && excludedTablesArray != null) {
            this.logger.warn((Object)"ColumnManagerAPI column_manager.excludedTables parameter will be ignored; overridden by column_manager.includedTables parameter.");
        }
        if (includedTablesArray == null) {
            this.includedTables = null;
            this.includedNamespaces = null;
            this.includedEntireNamespaces = null;
            if (excludedTablesArray == null) {
                this.excludedTables = null;
                this.excludedNamespaces = null;
                this.excludedEntireNamespaces = null;
                this.logger.info((Object)"ColumnManagerAPI Repository activated for ALL user tables.");
            } else {
                this.excludedTables = new TreeSet<TableName>();
                this.excludedNamespaces = new TreeSet<String>();
                this.excludedEntireNamespaces = new TreeSet<String>();
                for (String excludedTableString : new TreeSet<String>(Arrays.asList(excludedTablesArray))) {
                    try {
                        TableName excludedTableName = TableName.valueOf((String)excludedTableString);
                        this.excludedTables.add(excludedTableName);
                    }
                    catch (IllegalArgumentException e) {
                        if (excludedTableString.endsWith(ALL_TABLES_WILDCARD_INDICATOR)) {
                            String excludedNamespaceString = excludedTableString.substring(0, excludedTableString.length() - 2);
                            TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)excludedNamespaceString));
                            this.excludedNamespaces.add(excludedNamespaceString);
                            this.excludedEntireNamespaces.add(excludedNamespaceString);
                            continue;
                        }
                        throw e;
                    }
                }
                this.logger.info((Object)("ColumnManagerAPI Repository activated for all EXCEPT the following user tables: " + conf.get(HBASE_CONFIG_PARM_KEY_COLMANAGER_EXCLUDED_TABLES)));
            }
        } else {
            this.excludedTables = null;
            this.excludedNamespaces = null;
            this.excludedEntireNamespaces = null;
            this.includedTables = new TreeSet<TableName>();
            this.includedNamespaces = new TreeSet<String>();
            this.includedEntireNamespaces = new TreeSet<String>();
            for (String includedTableString : new TreeSet<String>(Arrays.asList(includedTablesArray))) {
                try {
                    TableName includedTableName = TableName.valueOf((String)includedTableString);
                    this.includedTables.add(includedTableName);
                    this.includedNamespaces.add(includedTableName.getNamespaceAsString());
                }
                catch (IllegalArgumentException e) {
                    if (includedTableString.endsWith(ALL_TABLES_WILDCARD_INDICATOR)) {
                        String includedNamespaceString = includedTableString.substring(0, includedTableString.length() - 2);
                        TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)includedNamespaceString));
                        this.includedNamespaces.add(includedNamespaceString);
                        this.includedEntireNamespaces.add(includedNamespaceString);
                        continue;
                    }
                    throw e;
                }
            }
            this.logger.info((Object)("ColumnManagerAPI Repository activated for ONLY the following user tables: " + conf.get(HBASE_CONFIG_PARM_KEY_COLMANAGER_INCLUDED_TABLES)));
        }
    }

    Table getRepositoryTable() {
        return this.repositoryTable;
    }

    static boolean repositoryTableExists(Admin standardAdmin) throws IOException {
        return standardAdmin.tableExists(REPOSITORY_TABLENAME);
    }

    static void initializeRepositoryNamespace(Admin hbaseAdmin) throws IOException {
        Admin standardAdmin = Repository.getStandardAdmin(hbaseAdmin);
        if (Repository.namespaceExists(standardAdmin, REPOSITORY_NAMESPACE_DESCRIPTOR)) {
            staticLogger.info((Object)("ColumnManager Repository Namespace found: " + REPOSITORY_NAMESPACE_DESCRIPTOR.getName()));
        } else {
            standardAdmin.createNamespace(REPOSITORY_NAMESPACE_DESCRIPTOR);
            staticLogger.info((Object)("ColumnManager Repository Namespace has been created (did not already exist): " + REPOSITORY_NAMESPACE_DESCRIPTOR.getName()));
        }
    }

    static Table initializeRepositoryTable(Admin hbaseAdmin) throws IOException {
        Connection standardConnection = Repository.getStandardConnection(hbaseAdmin.getConnection());
        Admin standardAdmin = Repository.getStandardAdmin(hbaseAdmin);
        try (Table existingRepositoryTable = standardConnection.getTable(REPOSITORY_TABLENAME);){
            if (standardAdmin.tableExists(existingRepositoryTable.getName())) {
                staticLogger.info((Object)("ColumnManager Repository Table found: " + REPOSITORY_TABLENAME.getNameAsString()));
                Table table = existingRepositoryTable;
                return table;
            }
        }
        standardAdmin.createTable(new HTableDescriptor(REPOSITORY_TABLENAME).addFamily(new HColumnDescriptor(REPOSITORY_CF).setMaxVersions(50).setInMemory(true)));
        var4_4 = null;
        try (Table newRepositoryTable = standardConnection.getTable(REPOSITORY_TABLENAME);){
            staticLogger.info((Object)("ColumnManager Repository Table has been created (did not already exist): " + REPOSITORY_TABLENAME.getNameAsString()));
            Table table = newRepositoryTable;
            return table;
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    static Table initializeAliasTable(Admin hbaseAdmin) throws IOException {
        Connection standardConnection = Repository.getStandardConnection(hbaseAdmin.getConnection());
        Admin standardAdmin = Repository.getStandardAdmin(hbaseAdmin);
        try (Table existingAliasDirectoryTable = standardConnection.getTable(ALIAS_DIRECTORY_TABLENAME);){
            if (standardAdmin.tableExists(existingAliasDirectoryTable.getName())) {
                staticLogger.info((Object)("ColumnManager AliasDirectory Table found: " + ALIAS_DIRECTORY_TABLENAME.getNameAsString()));
                Table table = existingAliasDirectoryTable;
                return table;
            }
        }
        standardAdmin.createTable(new HTableDescriptor(ALIAS_DIRECTORY_TABLENAME).addFamily(new HColumnDescriptor(ALIAS_CF).setInMemory(true)));
        var4_4 = null;
        try (Table newAliasDirectoryTable = standardConnection.getTable(ALIAS_DIRECTORY_TABLENAME);){
            staticLogger.info((Object)("ColumnManager AliasDirectory Table has been created (did not already exist): " + ALIAS_DIRECTORY_TABLENAME.getNameAsString()));
            Table table = newAliasDirectoryTable;
            return table;
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    static void setRepositoryMaxVersions(Admin hbaseAdmin, int maxVersions) throws IOException {
        HColumnDescriptor repositoryHcd = Repository.getStandardAdmin(hbaseAdmin).getTableDescriptor(REPOSITORY_TABLENAME).getFamily(REPOSITORY_CF);
        int oldMaxVersions = repositoryHcd.getMaxVersions();
        if (oldMaxVersions != maxVersions) {
            repositoryHcd.setMaxVersions(maxVersions);
            hbaseAdmin.modifyColumn(REPOSITORY_TABLENAME, repositoryHcd);
            staticLogger.info((Object)("ColumnManager Repository Table column-family's <maxVersions> setting has been changed from <" + oldMaxVersions + "> to <" + maxVersions + ">."));
        }
    }

    static int getRepositoryMaxVersions(Admin hbaseAdmin) throws IOException {
        HColumnDescriptor repositoryHcd = Repository.getStandardAdmin(hbaseAdmin).getTableDescriptor(REPOSITORY_TABLENAME).getFamily(REPOSITORY_CF);
        return repositoryHcd.getMaxVersions();
    }

    private static Connection getStandardConnection(Connection connection) {
        if (MConnection.class.isAssignableFrom(connection.getClass())) {
            return ((MConnection)connection).getStandardConnection();
        }
        return connection;
    }

    private static Admin getStandardAdmin(Admin admin) {
        if (MAdmin.class.isAssignableFrom(admin.getClass())) {
            return ((MAdmin)admin).getWrappedAdmin();
        }
        return admin;
    }

    private static Admin getNewAdmin(Connection hbaseConnection) throws IOException {
        try (Admin admin = Repository.getStandardConnection(hbaseConnection).getAdmin();){
            Admin admin2 = admin;
            return admin2;
        }
    }

    Admin getAdmin() {
        return this.standardAdmin;
    }

    boolean isActivated() {
        return this.columnManagerIsActivated;
    }

    private boolean doSyncCheck() throws IOException {
        boolean syncErrorFound = false;
        for (MNamespaceDescriptor mnd : this.getMNamespaceDescriptors()) {
            block10: {
                try {
                    NamespaceDescriptor nd = this.standardAdmin.getNamespaceDescriptor(mnd.getNameAsString());
                    if (this.schemaEntityAttributesInSync(nd.getName(), NAMESPACE_ATTRIBUTE_SYNC_ERROR_MSG, mnd.getConfiguration(), nd.getConfiguration(), null, null)) break block10;
                    syncErrorFound = true;
                }
                catch (NamespaceNotFoundException e) {
                    this.logger.warn((Object)(NAMESPACE_NOT_FOUND_SYNC_ERROR_MSG + mnd.getNameAsString()));
                    syncErrorFound = true;
                    continue;
                }
            }
            for (MTableDescriptor mtd : this.getMTableDescriptors(mnd.getForeignKey())) {
                if (!this.standardAdmin.tableExists(mtd.getTableName())) {
                    this.logger.warn((Object)(TABLE_NOT_FOUND_SYNC_ERROR_MSG + mtd.getNameAsString()));
                    syncErrorFound = true;
                    continue;
                }
                HTableDescriptor htd = this.standardAdmin.getTableDescriptor(mtd.getTableName());
                if (!this.schemaEntityAttributesInSync(mtd.getTableName().getNameAsString(), TABLE_ATTRIBUTE_SYNC_ERROR_MSG, mtd.getConfiguration(), htd.getConfiguration(), mtd.getValues(), htd.getValues())) {
                    syncErrorFound = true;
                }
                Collection hcdCollection = htd.getFamilies();
                TreeSet<String> hcdNames = new TreeSet<String>();
                for (HColumnDescriptor hcd : hcdCollection) {
                    hcdNames.add(hcd.getNameAsString());
                }
                for (MColumnDescriptor mcd : mtd.getMColumnDescriptors()) {
                    if (!hcdNames.contains(mcd.getNameAsString())) {
                        this.logger.warn((Object)(COLDESCRIPTOR_NOT_FOUND_SYNC_ERROR_MSG + mcd.getNameAsString()));
                        syncErrorFound = true;
                        continue;
                    }
                    HColumnDescriptor hcd = htd.getFamily(mcd.getName());
                    if (this.schemaEntityAttributesInSync(mtd.getNameAsString() + ":" + mcd.getNameAsString(), COLDESCRIPTOR_ATTRIBUTE_SYNC_ERROR_MSG, mcd.getConfiguration(), hcd.getConfiguration(), mcd.getValues(), hcd.getValues())) continue;
                    syncErrorFound = true;
                }
            }
        }
        if (syncErrorFound) {
            this.logger.warn((Object)"DISCREPANCIES found between ColumnManagerAPI repository and schema structures in HBase; invocation of RepositoryAdmin#discoverSchema method may be required for resynchronization.");
        }
        return syncErrorFound;
    }

    private boolean schemaEntityAttributesInSync(String entityName, String errorMsg, Map<String, String> repositoryConfigurationMap, Map<String, String> hbaseConfigurationMap, Map<ImmutableBytesWritable, ImmutableBytesWritable> repositoryValuesMap, Map<ImmutableBytesWritable, ImmutableBytesWritable> hbaseValuesMap) {
        ImmutableBytesWritable valueEntryValue;
        String configValue;
        for (Map.Entry<String, String> entry : repositoryConfigurationMap.entrySet()) {
            if (entry.getKey().equals("_ColDefinitionsEnforced") || entry.getKey().equals("_ColAliasesEnabled") || (configValue = hbaseConfigurationMap.get(entry.getKey())) != null && configValue.equals(entry.getValue())) continue;
            this.logger.warn((Object)(errorMsg + entityName));
            return false;
        }
        for (Map.Entry<String, String> entry : hbaseConfigurationMap.entrySet()) {
            configValue = repositoryConfigurationMap.get(entry.getKey());
            if (configValue != null && configValue.equals(entry.getValue())) continue;
            this.logger.warn((Object)(errorMsg + entityName));
            return false;
        }
        if (repositoryValuesMap == null || hbaseValuesMap == null) {
            return true;
        }
        for (Map.Entry<String, String> entry : repositoryValuesMap.entrySet()) {
            valueEntryValue = hbaseValuesMap.get(entry.getKey());
            if (valueEntryValue != null && valueEntryValue.equals((Object)entry.getValue())) continue;
            this.logger.warn((Object)(errorMsg + entityName));
            return false;
        }
        for (Map.Entry<String, String> entry : hbaseValuesMap.entrySet()) {
            valueEntryValue = repositoryValuesMap.get(entry.getKey());
            if (valueEntryValue != null && valueEntryValue.equals((Object)entry.getValue())) continue;
            this.logger.warn((Object)(errorMsg + entityName));
            return false;
        }
        return true;
    }

    static boolean namespaceExists(Admin hbaseAdmin, NamespaceDescriptor nd) throws IOException {
        try {
            hbaseAdmin.getNamespaceDescriptor(nd.getName());
        }
        catch (NamespaceNotFoundException e) {
            return false;
        }
        return true;
    }

    static boolean namespaceExists(Admin hbaseAdmin, byte[] namespace) throws IOException {
        return Repository.namespaceExists(hbaseAdmin, NamespaceDescriptor.create((String)Bytes.toString((byte[])namespace)).build());
    }

    private boolean isIncludedNamespace(String namespaceName) {
        if (namespaceName.equals(HBASE_SYSTEM_NAMESPACE_DESCRIPTOR.getName()) || namespaceName.equals(REPOSITORY_NAMESPACE_DESCRIPTOR.getName()) || namespaceName.equals("__column_manager_temp_reports")) {
            return false;
        }
        if (this.includedNamespaces == null) {
            if (this.excludedNamespaces == null) {
                return true;
            }
            return !this.excludedNamespaces.contains(namespaceName);
        }
        return this.includedNamespaces.contains(namespaceName);
    }

    boolean isIncludedTable(TableName tableName) {
        if (!this.isIncludedNamespace(tableName.getNamespaceAsString())) {
            return false;
        }
        if (this.includedTables == null && this.includedEntireNamespaces == null) {
            if (this.excludedTables == null && this.excludedEntireNamespaces == null) {
                return true;
            }
            return this.excludedTables.contains(tableName) ? false : !this.excludedEntireNamespaces.contains(tableName.getNamespaceAsString());
        }
        return this.includedTables.contains(tableName) ? true : this.includedEntireNamespaces.contains(tableName.getNamespaceAsString());
    }

    private static byte[] generateUniqueForeignKey() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer uniqueID = ByteBuffer.wrap(new byte[16]);
        uniqueID.putLong(uuid.getMostSignificantBits());
        uniqueID.putLong(uuid.getLeastSignificantBits());
        return uniqueID.array();
    }

    byte[] putNamespaceSchemaEntity(NamespaceDescriptor nd) throws IOException {
        if (!this.isIncludedNamespace(nd.getName())) {
            return null;
        }
        RowId namespaceRowId = new RowId(SchemaEntityType.NAMESPACE.getRecordType(), NAMESPACE_PARENT_FOREIGN_KEY, Bytes.toBytes((String)nd.getName()));
        Map<byte[], byte[]> entityAttributeMap = this.buildEntityAttributeMap(EMPTY_VALUES, nd.getConfiguration());
        return this.putSchemaEntity(namespaceRowId, entityAttributeMap, false);
    }

    byte[] putTableSchemaEntity(HTableDescriptor htd) throws IOException {
        if (!this.isIncludedTable(htd.getTableName())) {
            return null;
        }
        byte[] namespaceForeignKey = this.getNamespaceForeignKey(htd.getTableName().getNamespace());
        RowId tableRowId = new RowId(SchemaEntityType.TABLE.getRecordType(), namespaceForeignKey, htd.getTableName().getName());
        Map<byte[], byte[]> entityAttributeMap = this.buildEntityAttributeMap(htd.getValues(), htd.getConfiguration());
        byte[] tableForeignKey = this.putSchemaEntity(tableRowId, entityAttributeMap, false);
        TreeSet<byte[]> oldMcdNames = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        for (MColumnDescriptor oldMcd : this.getMColumnDescriptors(tableForeignKey)) {
            oldMcdNames.add(oldMcd.getName());
        }
        for (HColumnDescriptor newHcd : htd.getColumnFamilies()) {
            oldMcdNames.remove(newHcd.getName());
        }
        for (byte[] deletedMcdName : oldMcdNames) {
            this.deleteColumnFamily(htd.getTableName(), deletedMcdName);
        }
        for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
            this.putColumnFamilySchemaEntity(tableForeignKey, hcd, htd.getTableName());
        }
        return tableForeignKey;
    }

    byte[] putColumnFamilySchemaEntity(TableName tn, HColumnDescriptor hcd) throws IOException {
        if (!this.isIncludedTable(tn)) {
            return null;
        }
        byte[] tableForeignKey = this.getTableForeignKey(tn);
        if (tableForeignKey == null) {
            tableForeignKey = this.putTableSchemaEntity(this.standardAdmin.getTableDescriptor(tn));
        }
        return this.putColumnFamilySchemaEntity(tableForeignKey, hcd, tn);
    }

    private byte[] putColumnFamilySchemaEntity(byte[] tableForeignKey, HColumnDescriptor hcd, TableName tableName) throws IOException {
        Map<byte[], byte[]> entityAttributeMap = this.buildEntityAttributeMap(hcd.getValues(), hcd.getConfiguration());
        return this.putSchemaEntity(new RowId(SchemaEntityType.COLUMN_FAMILY.getRecordType(), tableForeignKey, hcd.getName()), entityAttributeMap, false);
    }

    boolean putColumnAuditorSchemaEntities(MTableDescriptor mtd) throws IOException {
        if (!this.isIncludedTable(mtd.getTableName())) {
            return false;
        }
        byte[] tableForeignKey = this.getTableForeignKey(mtd);
        boolean serializationCompleted = true;
        for (MColumnDescriptor mcd : mtd.getMColumnDescriptorArray()) {
            byte[] colDescForeignKey = this.getForeignKey(SchemaEntityType.COLUMN_FAMILY.getRecordType(), tableForeignKey, mcd.getName());
            if (colDescForeignKey == null) {
                serializationCompleted = false;
                continue;
            }
            for (ColumnAuditor columnAuditor : mcd.getColumnAuditors()) {
                byte[] colForeignKey = this.putColumnAuditorSchemaEntity(colDescForeignKey, columnAuditor);
                if (colForeignKey != null) continue;
                serializationCompleted = false;
            }
        }
        return serializationCompleted;
    }

    private byte[] putColumnAuditorSchemaEntity(byte[] colFamilyForeignKey, ColumnAuditor columnAuditor) throws IOException {
        Map<byte[], byte[]> entityAttributeMap = this.buildEntityAttributeMap(columnAuditor.getValues(), columnAuditor.getConfiguration());
        return this.putSchemaEntity(new RowId(SchemaEntityType.COLUMN_AUDITOR.getRecordType(), colFamilyForeignKey, columnAuditor.getName()), entityAttributeMap, false);
    }

    void putColumnAuditorSchemaEntities(TableName tableName, List<? extends Mutation> mutations) throws IOException {
        if (!this.isIncludedTable(tableName)) {
            return;
        }
        MTableDescriptor mtd = this.getMTableDescriptor(tableName);
        for (Mutation mutation : mutations) {
            this.putColumnAuditorSchemaEntities(mtd, mutation);
        }
    }

    void putColumnAuditorSchemaEntities(TableName tableName, Mutation mutation) throws IOException {
        if (!this.isIncludedTable(tableName)) {
            return;
        }
        this.putColumnAuditorSchemaEntities(this.getMTableDescriptor(tableName), mutation);
    }

    void putColumnAuditorSchemaEntities(MTableDescriptor mtd, RowMutations mutations) throws IOException {
        if (!this.isIncludedTable(mtd.getTableName())) {
            return;
        }
        for (Mutation mutation : mutations.getMutations()) {
            this.putColumnAuditorSchemaEntities(mtd, mutation);
        }
    }

    void putColumnAuditorSchemaEntities(MTableDescriptor mtd, List<? extends Mutation> mutations) throws IOException {
        if (!this.isIncludedTable(mtd.getTableName())) {
            return;
        }
        for (Mutation mutation : mutations) {
            this.putColumnAuditorSchemaEntities(mtd, mutation);
        }
    }

    void putColumnAuditorSchemaEntities(MTableDescriptor mtd, Mutation mutation) throws IOException {
        if (!this.isIncludedTable(mtd.getTableName()) || Delete.class.isAssignableFrom(mutation.getClass())) {
            return;
        }
        for (Map.Entry colFamilyCellList : mutation.getFamilyCellMap().entrySet()) {
            MColumnDescriptor mcd = mtd.getMColumnDescriptor((byte[])colFamilyCellList.getKey());
            for (Cell cell : (List)colFamilyCellList.getValue()) {
                byte[] colQualifier = Bytes.copy((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                ColumnAuditor oldColAuditor = this.getColumnAuditor(mcd.getForeignKey(), colQualifier);
                if (oldColAuditor != null && (long)cell.getValueLength() <= oldColAuditor.getMaxValueLengthFound()) continue;
                ColumnAuditor newColAuditor = new ColumnAuditor(colQualifier);
                if (oldColAuditor == null || (long)cell.getValueLength() > oldColAuditor.getMaxValueLengthFound()) {
                    newColAuditor.setMaxValueLengthFound(cell.getValueLength());
                } else {
                    newColAuditor.setMaxValueLengthFound(oldColAuditor.getMaxValueLengthFound());
                }
                boolean suppressUserName = oldColAuditor != null;
                Map<byte[], byte[]> entityAttributeMap = this.buildEntityAttributeMap(newColAuditor.getValues(), newColAuditor.getConfiguration());
                this.putSchemaEntity(new RowId(SchemaEntityType.COLUMN_AUDITOR.getRecordType(), mcd.getForeignKey(), newColAuditor.getName()), entityAttributeMap, suppressUserName);
            }
        }
    }

    void putDiscoveredColumnAuditors(MTableDescriptor mtd, Result row, boolean keyOnlyFilterUsed) throws IOException {
        if (!this.isIncludedTable(mtd.getTableName())) {
            return;
        }
        for (Map.Entry familyToColumnsMapEntry : row.getMap().entrySet()) {
            MColumnDescriptor mcd = mtd.getMColumnDescriptor((byte[])familyToColumnsMapEntry.getKey());
            for (Map.Entry colEntry : ((NavigableMap)familyToColumnsMapEntry.getValue()).entrySet()) {
                byte[] colQualifier = (byte[])colEntry.getKey();
                RowId rowId = new RowId(SchemaEntityType.COLUMN_AUDITOR.getRecordType(), mcd.getForeignKey(), colQualifier);
                Set cellEntries = ((NavigableMap)colEntry.getValue()).entrySet();
                for (Map.Entry cellEntry : cellEntries) {
                    int colValueLength = keyOnlyFilterUsed ? Bytes.toInt((byte[])((byte[])cellEntry.getValue())) : ((byte[])cellEntry.getValue()).length;
                    ColumnAuditor oldColAuditor = this.getColumnAuditor(mcd.getForeignKey(), colQualifier);
                    if (oldColAuditor != null && (long)colValueLength <= oldColAuditor.getMaxValueLengthFound()) continue;
                    ColumnAuditor newColAuditor = new ColumnAuditor(colQualifier);
                    if (oldColAuditor == null || (long)colValueLength > oldColAuditor.getMaxValueLengthFound()) {
                        newColAuditor.setMaxValueLengthFound(colValueLength);
                    } else {
                        newColAuditor.setMaxValueLengthFound(oldColAuditor.getMaxValueLengthFound());
                    }
                    boolean suppressUserName = false;
                    if (oldColAuditor != null) {
                        suppressUserName = true;
                    }
                    Map<byte[], byte[]> entityAttributeMap = this.buildEntityAttributeMap(newColAuditor.getValues(), newColAuditor.getConfiguration());
                    this.putSchemaEntity(rowId, entityAttributeMap, suppressUserName);
                }
                this.repositoryTable.incrementColumnValue(rowId.getByteArray(), REPOSITORY_CF, COL_COUNTER_QUALIFIER, 1L);
                this.repositoryTable.incrementColumnValue(rowId.getByteArray(), REPOSITORY_CF, CELL_COUNTER_QUALIFIER, (long)cellEntries.size());
            }
        }
    }

    boolean putColumnAuditorSchemaEntities(TableName tableName, byte[] colFamily, List<ColumnAuditor> colAuditors) throws IOException {
        if (!this.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
        boolean allPutsCompleted = false;
        byte[] colFamilyForeignKey = this.getForeignKey(SchemaEntityType.COLUMN_FAMILY.getRecordType(), this.getTableForeignKey(tableName), colFamily);
        if (colFamilyForeignKey != null) {
            allPutsCompleted = true;
            for (ColumnAuditor colDefinition : colAuditors) {
                byte[] columnForeignKey = this.putColumnAuditorSchemaEntity(colFamilyForeignKey, colDefinition);
                if (columnForeignKey != null) continue;
                allPutsCompleted = false;
            }
        }
        return allPutsCompleted;
    }

    void validateColumns(MTableDescriptor mtd, Mutation mutation) throws IOException {
        if (!this.isIncludedTable(mtd.getTableName()) || !mtd.hasColDescriptorWithColDefinitionsEnforced() || Delete.class.isAssignableFrom(mutation.getClass())) {
            return;
        }
        for (Map.Entry colFamilyCellList : mutation.getFamilyCellMap().entrySet()) {
            MColumnDescriptor mcd = mtd.getMColumnDescriptor((byte[])colFamilyCellList.getKey());
            if (!mcd.columnDefinitionsEnforced()) continue;
            for (Cell cell : (List)colFamilyCellList.getValue()) {
                byte[] colValue;
                byte[] colQualifier = Bytes.copy((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                ColumnDefinition colDefinition = mcd.getColumnDefinition(colQualifier);
                if (colDefinition == null) {
                    throw new ColumnDefinitionNotFoundException(mtd.getTableName().getName(), mcd.getName(), colQualifier, null);
                }
                if (colDefinition.getColumnLength() > 0L && (long)cell.getValueLength() > colDefinition.getColumnLength()) {
                    throw new ColumnValueInvalidException(mtd.getTableName().getName(), mcd.getName(), colQualifier, null, "Value length of <" + cell.getValueLength() + "> is longer than maximum length of <" + colDefinition.getColumnLength() + "> defined for the column in its corresponding ColumnDefinition.");
                }
                String colValidationRegex = colDefinition.getColumnValidationRegex();
                if (colValidationRegex == null || colValidationRegex.length() <= 0 || Bytes.toString((byte[])(colValue = Bytes.getBytes((ByteBuffer)CellUtil.getValueBufferShallowCopy((Cell)cell)))).matches(colValidationRegex)) continue;
                throw new ColumnValueInvalidException(mtd.getTableName().getName(), mcd.getName(), colQualifier, colValue, "Value does not match the regular expression defined for the column in its corresponding ColumnDefinition: <" + colValidationRegex + ">");
            }
        }
    }

    void validateColumns(MTableDescriptor mtd, RowMutations mutations) throws IOException {
        if (this.isIncludedTable(mtd.getTableName()) && mtd.hasColDescriptorWithColDefinitionsEnforced()) {
            for (Mutation mutation : mutations.getMutations()) {
                this.validateColumns(mtd, mutation);
            }
        }
    }

    void validateColumns(MTableDescriptor mtd, List<? extends Mutation> mutations) throws IOException {
        if (this.isIncludedTable(mtd.getTableName()) && mtd.hasColDescriptorWithColDefinitionsEnforced()) {
            for (Mutation mutation : mutations) {
                this.validateColumns(mtd, mutation);
            }
        }
    }

    void validateColumns(TableName tableName, Mutation mutation) throws IOException {
        if (!this.isIncludedTable(tableName)) {
            return;
        }
        MTableDescriptor mtd = this.getMTableDescriptor(tableName);
        if (mtd != null && mtd.hasColDescriptorWithColDefinitionsEnforced()) {
            this.validateColumns(mtd, mutation);
        }
    }

    void validateColumns(TableName tableName, List<? extends Mutation> mutations) throws IOException {
        if (!this.isIncludedTable(tableName)) {
            return;
        }
        MTableDescriptor mtd = this.getMTableDescriptor(tableName);
        if (mtd != null && mtd.hasColDescriptorWithColDefinitionsEnforced()) {
            for (Mutation mutation : mutations) {
                this.validateColumns(mtd, mutation);
            }
        }
    }

    private boolean putColumnDefinitionSchemaEntities(MTableDescriptor mtd) throws IOException {
        if (!this.isIncludedTable(mtd.getTableName())) {
            throw new TableNotIncludedForProcessingException(mtd.getTableName().getName(), null);
        }
        byte[] tableForeignKey = this.getTableForeignKey(mtd);
        boolean serializationCompleted = true;
        for (MColumnDescriptor mcd : mtd.getMColumnDescriptorArray()) {
            byte[] colDescForeignKey = this.getForeignKey(SchemaEntityType.COLUMN_FAMILY.getRecordType(), tableForeignKey, mcd.getName());
            if (colDescForeignKey == null) {
                serializationCompleted = false;
                continue;
            }
            for (ColumnDefinition colDef : mcd.getColumnDefinitions()) {
                byte[] colDefinitionForeignKey = this.putColumnDefinitionSchemaEntity(colDescForeignKey, colDef);
                if (colDefinitionForeignKey != null) continue;
                serializationCompleted = false;
            }
        }
        return serializationCompleted;
    }

    boolean putColumnDefinitionSchemaEntities(TableName tableName, byte[] colFamily, List<ColumnDefinition> colDefinitions) throws IOException {
        if (!this.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
        boolean allPutsCompleted = false;
        byte[] colFamilyForeignKey = this.getForeignKey(SchemaEntityType.COLUMN_FAMILY.getRecordType(), this.getTableForeignKey(tableName), colFamily);
        if (colFamilyForeignKey != null) {
            allPutsCompleted = true;
            for (ColumnDefinition colDefinition : colDefinitions) {
                byte[] columnForeignKey = this.putColumnDefinitionSchemaEntity(colFamilyForeignKey, colDefinition);
                if (columnForeignKey != null) continue;
                allPutsCompleted = false;
            }
        }
        return allPutsCompleted;
    }

    private byte[] putColumnDefinitionSchemaEntity(byte[] colFamilyForeignKey, ColumnDefinition colDef) throws IOException {
        Map<byte[], byte[]> entityAttributeMap = this.buildEntityAttributeMap(colDef.getValues(), colDef.getConfiguration());
        return this.putSchemaEntity(new RowId(SchemaEntityType.COLUMN_DEFINITION.getRecordType(), colFamilyForeignKey, colDef.getName()), entityAttributeMap, false);
    }

    private Map<byte[], byte[]> buildEntityAttributeMap(Map<ImmutableBytesWritable, ImmutableBytesWritable> values, Map<String, String> configuration) {
        TreeMap<byte[], byte[]> entityAttributeMap = new TreeMap<byte[], byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : values.entrySet()) {
            byte[] attributeKeySuffix = entry.getKey().get();
            byte[] attributeValue = entry.getValue().get();
            if (attributeKeySuffix.length > COUNTER_COLUMN_PREFIX_BYTES.length && Bytes.startsWith((byte[])attributeKeySuffix, (byte[])COUNTER_COLUMN_PREFIX_BYTES) || attributeKeySuffix.length > TIMESTAMP_KEY_PREFIX_BYTES.length && Bytes.startsWith((byte[])attributeKeySuffix, (byte[])TIMESTAMP_KEY_PREFIX_BYTES)) continue;
            ByteBuffer attributeKey = ByteBuffer.allocate(VALUE_COLUMN_PREFIX_BYTES.length + attributeKeySuffix.length);
            attributeKey.put(VALUE_COLUMN_PREFIX_BYTES).put(attributeKeySuffix);
            entityAttributeMap.put(Bytes.toBytes((ByteBuffer)attributeKey), attributeValue);
        }
        for (Map.Entry<Object, Object> entry : configuration.entrySet()) {
            entityAttributeMap.put(Bytes.toBytes((String)(CONFIG_COLUMN_PREFIX + (String)entry.getKey())), Bytes.toBytes((String)((String)entry.getValue())));
        }
        return entityAttributeMap;
    }

    private byte[] putSchemaEntity(RowId rowId, Map<byte[], byte[]> entityAttributeMap, boolean suppressUserName) throws IOException {
        byte[] foreignKey;
        Map<byte[], byte[]> oldEntityAttributeMap;
        Result oldRow = this.repositoryTable.get(new Get(rowId.getByteArray()));
        Put newRow = new Put(rowId.getByteArray());
        if (oldRow.isEmpty()) {
            oldEntityAttributeMap = null;
            foreignKey = Repository.generateUniqueForeignKey();
            newRow.addColumn(REPOSITORY_CF, FOREIGN_KEY_COLUMN, foreignKey);
            newRow.addColumn(REPOSITORY_CF, ENTITY_STATUS_COLUMN, ACTIVE_STATUS);
        } else {
            Iterator<byte[]> entity = this.deserializeSchemaEntity(oldRow);
            oldEntityAttributeMap = this.buildEntityAttributeMap(((SchemaEntity)((Object)entity)).getValues(), ((SchemaEntity)((Object)entity)).getConfiguration());
            foreignKey = oldRow.getValue(REPOSITORY_CF, FOREIGN_KEY_COLUMN);
            if (!Bytes.equals((byte[])oldRow.getValue(REPOSITORY_CF, ENTITY_STATUS_COLUMN), (byte[])ACTIVE_STATUS)) {
                newRow.addColumn(REPOSITORY_CF, ENTITY_STATUS_COLUMN, ACTIVE_STATUS);
            }
        }
        for (Map.Entry entry : entityAttributeMap.entrySet()) {
            byte[] newAttributeKey = (byte[])entry.getKey();
            byte[] newAttributeValue = (byte[])entry.getValue();
            byte[] oldAttributeValue = oldEntityAttributeMap == null ? null : oldEntityAttributeMap.get(newAttributeKey);
            boolean attributeValueChanged = false;
            if (oldAttributeValue == null) {
                if (newAttributeValue != null) {
                    attributeValueChanged = true;
                }
            } else if (!Bytes.equals((byte[])oldAttributeValue, (byte[])newAttributeValue)) {
                attributeValueChanged = true;
            }
            if (!attributeValueChanged) continue;
            if (newAttributeValue == null) {
                newRow.addColumn(REPOSITORY_CF, newAttributeKey, null);
                continue;
            }
            newRow.addColumn(REPOSITORY_CF, newAttributeKey, newAttributeValue);
        }
        if (oldEntityAttributeMap != null) {
            for (byte[] byArray : oldEntityAttributeMap.keySet()) {
                if (entityAttributeMap.containsKey(byArray)) continue;
                newRow.addColumn(REPOSITORY_CF, byArray, null);
            }
        }
        if (!newRow.isEmpty()) {
            if (!suppressUserName) {
                newRow.addColumn(REPOSITORY_CF, JAVA_USERNAME_PROPERTY_KEY, this.javaUsername);
            }
            if (rowId.entityType == SchemaEntityType.COLUMN_AUDITOR.getRecordType()) {
                List maxValueLengthCells = newRow.get(REPOSITORY_CF, ColumnAuditor.MAX_VALUE_LENGTH_KEY_BYTES);
                if (maxValueLengthCells == null || maxValueLengthCells.size() == 0) {
                    this.repositoryTable.put(newRow);
                } else {
                    this.repositoryTable.checkAndPut(rowId.getByteArray(), REPOSITORY_CF, ColumnAuditor.MAX_VALUE_LENGTH_KEY_BYTES, CompareFilter.CompareOp.LESS, ((Cell)maxValueLengthCells.get(0)).getValueArray(), newRow);
                }
            } else {
                this.repositoryTable.put(newRow);
            }
        }
        return foreignKey;
    }

    MNamespaceDescriptor getMNamespaceDescriptor(String namespaceName) throws IOException {
        Result row = this.getActiveRow(SchemaEntityType.NAMESPACE.getRecordType(), NAMESPACE_PARENT_FOREIGN_KEY, Bytes.toBytes((String)namespaceName), null);
        if (row == null || row.isEmpty()) {
            if (this.isIncludedNamespace(namespaceName)) {
                this.putNamespaceSchemaEntity(this.standardAdmin.getNamespaceDescriptor(namespaceName));
                row = this.getActiveRow(SchemaEntityType.NAMESPACE.getRecordType(), NAMESPACE_PARENT_FOREIGN_KEY, Bytes.toBytes((String)namespaceName), null);
            } else {
                return null;
            }
        }
        MNamespaceDescriptor nd = new MNamespaceDescriptor(this.deserializeSchemaEntity(row));
        return nd;
    }

    Set<MNamespaceDescriptor> getMNamespaceDescriptors() throws IOException {
        TreeSet<MNamespaceDescriptor> mNamespaceDescriptors = new TreeSet<MNamespaceDescriptor>();
        for (Result row : this.getActiveRows(SchemaEntityType.NAMESPACE.getRecordType(), NAMESPACE_PARENT_FOREIGN_KEY)) {
            mNamespaceDescriptors.add(new MNamespaceDescriptor(this.deserializeSchemaEntity(row)));
        }
        return mNamespaceDescriptors;
    }

    MTableDescriptor getMTableDescriptor(TableName tn) throws IOException {
        byte[] namespaceForeignKey = this.getNamespaceForeignKey(tn.getNamespace());
        Result row = this.getActiveRow(SchemaEntityType.TABLE.getRecordType(), namespaceForeignKey, tn.getName(), null);
        if (row == null || row.isEmpty()) {
            if (this.isIncludedTable(tn)) {
                this.putTableSchemaEntity(this.standardAdmin.getTableDescriptor(tn));
                row = this.getActiveRow(SchemaEntityType.TABLE.getRecordType(), namespaceForeignKey, tn.getName(), null);
            } else {
                return null;
            }
        }
        MTableDescriptor mtd = new MTableDescriptor(this.deserializeSchemaEntity(row));
        for (MColumnDescriptor mcd : this.getMColumnDescriptors(mtd.getForeignKey())) {
            mtd.addFamily(mcd);
        }
        return mtd;
    }

    Set<MTableDescriptor> getMTableDescriptors(byte[] namespaceForeignKey) throws IOException {
        TreeSet<MTableDescriptor> mTableDescriptors = new TreeSet<MTableDescriptor>();
        for (Result row : this.getActiveRows(SchemaEntityType.TABLE.getRecordType(), namespaceForeignKey)) {
            MTableDescriptor mtd = new MTableDescriptor(this.deserializeSchemaEntity(row));
            for (MColumnDescriptor mcd : this.getMColumnDescriptors(mtd.getForeignKey())) {
                mtd.addFamily(mcd);
            }
            mTableDescriptors.add(mtd);
        }
        return mTableDescriptors;
    }

    private Set<MColumnDescriptor> getMColumnDescriptors(byte[] tableForeignKey) throws IOException {
        TreeSet<MColumnDescriptor> mColumnDescriptors = new TreeSet<MColumnDescriptor>();
        for (Result row : this.getActiveRows(SchemaEntityType.COLUMN_FAMILY.getRecordType(), tableForeignKey)) {
            MColumnDescriptor mcd = new MColumnDescriptor(this.deserializeSchemaEntity(row));
            mColumnDescriptors.add(mcd.addColumnAuditors(this.getColumnAuditors(mcd.getForeignKey())).addColumnDefinitions(this.getColumnDefinitions(mcd.getForeignKey())));
        }
        return mColumnDescriptors;
    }

    private MColumnDescriptor getMColumnDescriptor(byte[] tableForeignKey, byte[] colFamily) throws IOException {
        Result row = this.getActiveRow(SchemaEntityType.COLUMN_FAMILY.getRecordType(), tableForeignKey, colFamily, null);
        return row == null ? null : new MColumnDescriptor(this.deserializeSchemaEntity(row));
    }

    Set<ColumnAuditor> getColumnAuditors(HTableDescriptor htd, HColumnDescriptor hcd) throws IOException {
        if (!this.isIncludedTable(htd.getTableName())) {
            throw new TableNotIncludedForProcessingException(htd.getTableName().getName(), null);
        }
        byte[] colFamilyForeignKey = this.getForeignKey(SchemaEntityType.COLUMN_FAMILY.getRecordType(), this.getTableForeignKey(htd), hcd.getName());
        return colFamilyForeignKey == null ? null : this.getColumnAuditors(colFamilyForeignKey);
    }

    private Set<ColumnAuditor> getColumnAuditors(byte[] colFamilyForeignKey) throws IOException {
        TreeSet<ColumnAuditor> columnAuditors = new TreeSet<ColumnAuditor>();
        Result[] colAuditorRows = this.getActiveRows(SchemaEntityType.COLUMN_AUDITOR.getRecordType(), colFamilyForeignKey);
        if (colAuditorRows != null) {
            for (Result row : colAuditorRows) {
                columnAuditors.add(new ColumnAuditor(this.deserializeSchemaEntity(row)));
            }
        }
        return columnAuditors;
    }

    private ColumnAuditor getColumnAuditor(byte[] colFamilyForeignKey, byte[] colQualifier) throws IOException {
        Result row = this.getActiveRow(SchemaEntityType.COLUMN_AUDITOR.getRecordType(), colFamilyForeignKey, colQualifier, null);
        return row == null ? null : new ColumnAuditor(this.deserializeSchemaEntity(row));
    }

    Set<ColumnDefinition> getColumnDefinitions(HTableDescriptor htd, HColumnDescriptor hcd) throws IOException {
        if (!this.isIncludedTable(htd.getTableName())) {
            throw new TableNotIncludedForProcessingException(htd.getTableName().getName(), null);
        }
        byte[] colFamilyForeignKey = this.getForeignKey(SchemaEntityType.COLUMN_FAMILY.getRecordType(), this.getTableForeignKey(htd), hcd.getName());
        return this.getColumnDefinitions(colFamilyForeignKey);
    }

    private Set<ColumnDefinition> getColumnDefinitions(byte[] colFamilyForeignKey) throws IOException {
        TreeSet<ColumnDefinition> columnDefinitions = new TreeSet<ColumnDefinition>();
        for (Result row : this.getActiveRows(SchemaEntityType.COLUMN_DEFINITION.getRecordType(), colFamilyForeignKey)) {
            columnDefinitions.add(new ColumnDefinition(this.deserializeSchemaEntity(row)));
        }
        return columnDefinitions;
    }

    private ColumnDefinition getColumnDefinition(byte[] colFamilyForeignKey, byte[] colQualifier) throws IOException {
        Result row = this.getActiveRow(SchemaEntityType.COLUMN_DEFINITION.getRecordType(), colFamilyForeignKey, colQualifier, null);
        return row == null ? null : new ColumnDefinition(this.deserializeSchemaEntity(row));
    }

    private SchemaEntity deserializeSchemaEntity(Result row) {
        if (row == null || row.isEmpty()) {
            return null;
        }
        RowId rowId = new RowId(row.getRow());
        SchemaEntity entity = new SchemaEntity(rowId.getEntityType(), rowId.getEntityName());
        for (Map.Entry familyToCellsMapEntry : row.getMap().entrySet()) {
            for (Map.Entry colEntry : ((NavigableMap)familyToCellsMapEntry.getValue()).entrySet()) {
                byte[] key = (byte[])colEntry.getKey();
                Iterator iterator = ((NavigableMap)colEntry.getValue()).entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry cellEntry = iterator.next();
                byte[] value = (byte[])cellEntry.getValue();
                if (Bytes.equals((byte[])key, (byte[])FOREIGN_KEY_COLUMN)) {
                    entity.setForeignKey((byte[])cellEntry.getValue());
                    continue;
                }
                if (key.length > VALUE_COLUMN_PREFIX_BYTES.length && Bytes.startsWith((byte[])key, (byte[])VALUE_COLUMN_PREFIX_BYTES)) {
                    entity.setValue(Bytes.tail((byte[])key, (int)(key.length - VALUE_COLUMN_PREFIX_BYTES.length)), value);
                    continue;
                }
                if (key.length > COUNTER_COLUMN_PREFIX_BYTES.length && Bytes.startsWith((byte[])key, (byte[])COUNTER_COLUMN_PREFIX_BYTES)) {
                    entity.setValue(key, value);
                    if (Bytes.equals((byte[])key, (byte[])COL_COUNTER_QUALIFIER)) {
                        entity.setValue(COL_COUNTER_TIMESTAMP_KEY, Bytes.toBytes((long)((Long)cellEntry.getKey())));
                        continue;
                    }
                    if (!Bytes.equals((byte[])key, (byte[])CELL_COUNTER_QUALIFIER)) continue;
                    entity.setValue(CELL_COUNTER_TIMESTAMP_KEY, Bytes.toBytes((long)((Long)cellEntry.getKey())));
                    continue;
                }
                if (key.length <= CONFIG_COLUMN_PREFIX_BYTES.length || !Bytes.startsWith((byte[])key, (byte[])CONFIG_COLUMN_PREFIX_BYTES)) continue;
                entity.setConfiguration(Bytes.toString((byte[])Bytes.tail((byte[])key, (int)(key.length - CONFIG_COLUMN_PREFIX_BYTES.length))), Bytes.toString((byte[])((byte[])cellEntry.getValue())));
            }
        }
        return entity;
    }

    private Result getActiveRow(byte recordType, byte[] parentForeignKey, byte[] entityName, byte[] columnToGet) throws IOException {
        Result[] rows = this.getActiveRows(false, recordType, parentForeignKey, entityName, columnToGet);
        return rows == null || rows.length == 0 ? null : rows[0];
    }

    private Result[] getActiveRows(byte recordType, byte[] parentForeignKey) throws IOException {
        return this.getActiveRows(false, recordType, parentForeignKey, null, null);
    }

    private Result[] getActiveRows(boolean getRowIdAndStatusOnly, byte recordType, byte[] parentForeignKey, byte[] entityName, byte[] columnToGet) throws IOException {
        SingleColumnValueFilter activeRowsOnlyFilter = new SingleColumnValueFilter(REPOSITORY_CF, ENTITY_STATUS_COLUMN, CompareFilter.CompareOp.EQUAL, ACTIVE_STATUS);
        activeRowsOnlyFilter.setFilterIfMissing(true);
        return this.getRepositoryRows(getRowIdAndStatusOnly, recordType, parentForeignKey, entityName, columnToGet, (Filter)activeRowsOnlyFilter);
    }

    private Result[] getRepositoryRows(byte recordType, byte[] parentForeignKey, byte[] columnToGet) throws IOException {
        return this.getRepositoryRows(false, recordType, parentForeignKey, null, columnToGet, null);
    }

    private Result[] getRepositoryRows(boolean getRowIdAndStatusOnly, byte recordType, byte[] parentForeignKey, byte[] entityName, byte[] columnToGet, Filter filter) throws IOException {
        if (parentForeignKey == null) {
            return null;
        }
        RowId startRowId = new RowId(recordType, parentForeignKey, entityName);
        byte[] stopRowId = startRowId.getStopRowIdByteArray();
        Scan scanParms = new Scan(startRowId.getByteArray(), stopRowId);
        if (getRowIdAndStatusOnly || columnToGet != null) {
            scanParms.addColumn(REPOSITORY_CF, FOREIGN_KEY_COLUMN);
            scanParms.addColumn(REPOSITORY_CF, ENTITY_STATUS_COLUMN);
            if (columnToGet != null) {
                scanParms.addColumn(REPOSITORY_CF, columnToGet);
            }
        }
        if (filter != null) {
            scanParms.setFilter(filter);
        }
        ArrayList<Result> rows = new ArrayList<Result>();
        try (ResultScanner results = this.repositoryTable.getScanner(scanParms);){
            for (Result row : results) {
                rows.add(row);
            }
        }
        return rows.toArray(new Result[rows.size()]);
    }

    private byte[] getForeignKey(byte recordType, byte[] parentForeignKey, byte[] entityName) throws IOException {
        if (parentForeignKey == null || entityName == null) {
            return null;
        }
        Result row = this.repositoryTable.get(new Get(new RowId(recordType, parentForeignKey, entityName).getByteArray()));
        return row.isEmpty() ? null : row.getValue(REPOSITORY_CF, FOREIGN_KEY_COLUMN);
    }

    private byte[] getNamespaceForeignKey(byte[] namespace) throws IOException {
        byte[] namespaceForeignKey = this.getForeignKey(SchemaEntityType.NAMESPACE.getRecordType(), NAMESPACE_PARENT_FOREIGN_KEY, namespace);
        if (namespaceForeignKey == null && Repository.namespaceExists(this.standardAdmin, namespace)) {
            namespaceForeignKey = this.putNamespaceSchemaEntity(this.standardAdmin.getNamespaceDescriptor(Bytes.toString((byte[])namespace)));
        }
        return namespaceForeignKey;
    }

    private byte[] getTableForeignKey(TableName tableName) throws IOException {
        byte[] namespaceForeignKey = this.getNamespaceForeignKey(tableName.getNamespace());
        byte[] tableForeignKey = this.getForeignKey(SchemaEntityType.TABLE.getRecordType(), namespaceForeignKey, tableName.getName());
        if (tableForeignKey == null && this.standardAdmin.tableExists(tableName)) {
            tableForeignKey = this.putTableSchemaEntity(this.standardAdmin.getTableDescriptor(tableName));
        }
        return tableForeignKey;
    }

    private byte[] getTableForeignKey(Table table) throws IOException {
        return this.getTableForeignKey(table.getName());
    }

    private byte[] getTableForeignKey(HTableDescriptor htd) throws IOException {
        return this.getTableForeignKey(htd.getTableName());
    }

    boolean columnDefinitionsEnforced(TableName tableName, byte[] colFamily) throws IOException {
        if (!this.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
        MColumnDescriptor mcd = this.getMColumnDescriptor(this.getTableForeignKey(tableName), colFamily);
        return mcd == null ? false : mcd.columnDefinitionsEnforced();
    }

    void enableColumnDefinitionEnforcement(boolean enabled, TableName tableName, byte[] colFamily) throws IOException {
        if (!this.isActivated()) {
            throw new ColumnManagerIOException(REPOSITORY_NOT_ACTIVATED_MSG){};
        }
        if (!this.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
        byte[] tableForeignKey = this.getTableForeignKey(tableName);
        MColumnDescriptor mcd = this.getMColumnDescriptor(tableForeignKey, colFamily);
        if (mcd == null) {
            return;
        }
        if (mcd.columnDefinitionsEnforced() != enabled) {
            mcd.enableColumnDefinitionEnforcement(enabled);
            this.putColumnFamilySchemaEntity(tableForeignKey, mcd, tableName);
        }
    }

    void enableColumnAliases(boolean enabled, TableName tableName, byte[] colFamily) throws IOException {
        if (!this.isActivated()) {
            throw new ColumnManagerIOException(REPOSITORY_NOT_ACTIVATED_MSG){};
        }
        if (!this.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
        byte[] tableForeignKey = this.getTableForeignKey(tableName);
        MColumnDescriptor mcd = this.getMColumnDescriptor(tableForeignKey, colFamily);
        if (mcd == null) {
            return;
        }
        if (mcd.columnAliasesEnabled() != enabled) {
            mcd.enableColumnAliases(enabled);
            this.putColumnFamilySchemaEntity(tableForeignKey, mcd, tableName);
        }
    }

    private String buildOrderedCommaDelimitedString(List<String> list) {
        TreeSet<String> set = new TreeSet<String>(list);
        StringBuilder stringBuilder = new StringBuilder();
        int itemCount = 0;
        for (String item : set) {
            stringBuilder.append(item);
            if (++itemCount >= set.size()) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    void purgeNamespaceShemaEntity(String name) throws IOException {
        this.deleteNamespaceSchemaEntity(true, name);
    }

    void deleteNamespaceSchemaEntity(String name) throws IOException {
        this.deleteNamespaceSchemaEntity(false, name);
    }

    private void deleteNamespaceSchemaEntity(boolean purge, String name) throws IOException {
        this.deleteSchemaEntity(purge, false, SchemaEntityType.NAMESPACE.getRecordType(), NAMESPACE_PARENT_FOREIGN_KEY, Bytes.toBytes((String)name));
    }

    void purgeTableSchemaEntity(TableName tableName) throws IOException {
        this.deleteTableSchemaEntity(true, false, tableName);
    }

    void truncateTableColumns(TableName tableName) throws IOException {
        this.deleteTableSchemaEntity(false, true, tableName);
    }

    void deleteTableSchemaEntity(TableName tableName) throws IOException {
        this.deleteTableSchemaEntity(false, false, tableName);
    }

    private void deleteTableSchemaEntity(boolean purge, boolean truncateColumns, TableName tableName) throws IOException {
        byte[] namespaceForeignKey = this.getNamespaceForeignKey(tableName.getNamespace());
        this.deleteSchemaEntity(purge, truncateColumns, SchemaEntityType.TABLE.getRecordType(), namespaceForeignKey, tableName.getName());
    }

    void deleteColumnFamily(TableName tableName, byte[] name) throws IOException {
        this.deleteSchemaEntity(false, false, SchemaEntityType.COLUMN_FAMILY.getRecordType(), this.getTableForeignKey(tableName), name);
    }

    void deleteColumnDefinition(TableName tableName, byte[] colFamily, byte[] colQualifier) throws IOException {
        if (!this.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
        byte[] colFamilyForeignKey = this.getForeignKey(SchemaEntityType.COLUMN_FAMILY.getRecordType(), this.getTableForeignKey(tableName), colFamily);
        if (colFamilyForeignKey == null) {
            return;
        }
        this.deleteSchemaEntity(false, false, SchemaEntityType.COLUMN_DEFINITION.getRecordType(), colFamilyForeignKey, colQualifier);
    }

    private void deleteSchemaEntity(boolean purge, boolean truncateColumns, byte recordType, byte[] parentForeignKey, byte[] entityName) throws IOException {
        if (parentForeignKey == null) {
            return;
        }
        block5: for (Result row : this.getRepositoryRows(true, recordType, parentForeignKey, entityName, null, null)) {
            byte childRecordType;
            if (!truncateColumns || truncateColumns && recordType == SchemaEntityType.COLUMN_AUDITOR.getRecordType()) {
                if (purge) {
                    this.repositoryTable.delete(new Delete(row.getRow()));
                } else if (!Bytes.equals((byte[])row.getValue(REPOSITORY_CF, ENTITY_STATUS_COLUMN), (byte[])DELETED_STATUS)) {
                    this.repositoryTable.put(new Put(row.getRow()).addColumn(REPOSITORY_CF, ENTITY_STATUS_COLUMN, DELETED_STATUS).addColumn(REPOSITORY_CF, JAVA_USERNAME_PROPERTY_KEY, this.javaUsername));
                }
            }
            switch (SchemaEntityType.ENTITY_TYPE_BYTE_TO_ENUM_MAP.get(recordType)) {
                case NAMESPACE: {
                    childRecordType = SchemaEntityType.TABLE.getRecordType();
                    break;
                }
                case TABLE: {
                    childRecordType = SchemaEntityType.COLUMN_FAMILY.getRecordType();
                    break;
                }
                case COLUMN_FAMILY: {
                    childRecordType = SchemaEntityType.COLUMN_AUDITOR.getRecordType();
                    break;
                }
                default: {
                    continue block5;
                }
            }
            this.deleteSchemaEntity(purge, truncateColumns, childRecordType, row.getValue(REPOSITORY_CF, FOREIGN_KEY_COLUMN), null);
            if (childRecordType != SchemaEntityType.COLUMN_AUDITOR.getRecordType()) continue;
            this.deleteSchemaEntity(purge, truncateColumns, SchemaEntityType.COLUMN_DEFINITION.getRecordType(), row.getValue(REPOSITORY_CF, FOREIGN_KEY_COLUMN), null);
        }
    }

    final void discoverSchema(boolean includeColumnQualifiers, boolean includeAllCells, boolean useMapReduce) throws IOException {
        if (!this.isActivated()) {
            throw new ColumnManagerIOException(REPOSITORY_NOT_ACTIVATED_MSG){};
        }
        for (NamespaceDescriptor nd : this.standardAdmin.listNamespaceDescriptors()) {
            if (!this.isIncludedNamespace(nd.getName())) continue;
            this.putNamespaceSchemaEntity(nd);
            for (HTableDescriptor htd : this.standardAdmin.listTableDescriptorsByNamespace(nd.getName())) {
                if (!this.isIncludedTable(htd.getTableName()) || this.standardAdmin.isTableDisabled(htd.getTableName())) continue;
                this.discoverSchema(htd.getTableName(), includeColumnQualifiers, includeAllCells, useMapReduce);
            }
        }
    }

    final void discoverSchema(String namespace, boolean includeColumnQualifiers, boolean includeAllCells, boolean useMapReduce) throws IOException {
        if (!this.isActivated()) {
            throw new ColumnManagerIOException(REPOSITORY_NOT_ACTIVATED_MSG){};
        }
        NamespaceDescriptor nd = this.getAdmin().getNamespaceDescriptor(namespace);
        if (!this.isIncludedNamespace(namespace)) {
            throw new TableNotIncludedForProcessingException(Bytes.toBytes((String)(namespace + ALL_TABLES_WILDCARD_INDICATOR)), "NO table from namespace <" + namespace + "> is included for " + PRODUCT_NAME + " processing.");
        }
        this.putNamespaceSchemaEntity(nd);
        for (HTableDescriptor htd : this.standardAdmin.listTableDescriptorsByNamespace(nd.getName())) {
            if (!this.isIncludedTable(htd.getTableName()) || this.standardAdmin.isTableDisabled(htd.getTableName())) continue;
            this.discoverSchema(htd.getTableName(), includeColumnQualifiers, includeAllCells, useMapReduce);
        }
    }

    final void discoverSchema(TableName tableName, boolean includeColumnQualifiers, boolean includeAllCells, boolean useMapReduce) throws IOException {
        if (!this.isActivated()) {
            throw new ColumnManagerIOException(REPOSITORY_NOT_ACTIVATED_MSG){};
        }
        if (!this.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
        this.putTableSchemaEntity(this.standardAdmin.getTableDescriptor(tableName));
        if (includeColumnQualifiers) {
            this.discoverColumnMetadata(tableName, includeAllCells, useMapReduce);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void discoverColumnMetadata(TableName tableName, boolean includeAllCells, boolean useMapReduce) throws IOException {
        MTableDescriptor mtd = this.getMTableDescriptor(tableName);
        if (mtd == null) {
            return;
        }
        for (MColumnDescriptor mcd : mtd.getMColumnDescriptors()) {
            for (ColumnAuditor colAuditor : mcd.getColumnAuditors()) {
                byte[] rowId = new RowId(SchemaEntityType.COLUMN_AUDITOR.getRecordType(), mcd.getForeignKey(), colAuditor.getColumnQualifier()).getByteArray();
                long resetValue = this.repositoryTable.incrementColumnValue(rowId, REPOSITORY_CF, COL_COUNTER_QUALIFIER, 0L) * -1L;
                this.repositoryTable.incrementColumnValue(rowId, REPOSITORY_CF, COL_COUNTER_QUALIFIER, resetValue);
                resetValue = this.repositoryTable.incrementColumnValue(rowId, REPOSITORY_CF, CELL_COUNTER_QUALIFIER, 0L) * -1L;
                this.repositoryTable.incrementColumnValue(rowId, REPOSITORY_CF, CELL_COUNTER_QUALIFIER, resetValue);
            }
        }
        if (useMapReduce) {
            try {
                int jobCompletionCode = ToolRunner.run((Configuration)MConfiguration.create(), (Tool)new ColumnDiscoveryTool(), (String[])new String[]{TABLE_NAME_ARG_KEY + tableName.getNameAsString(), INCLUDE_ALL_CELLS_ARG_KEY + includeAllCells});
                if (jobCompletionCode == 0) return;
                this.logger.warn((Object)("Mapreduce process failure in " + ColumnDiscoveryTool.class.getSimpleName()));
                return;
            }
            catch (Exception e) {
                if (!IOException.class.isAssignableFrom(e.getClass())) throw new IOException("Mapreduce process failure", e);
                throw (IOException)e;
            }
        }
        Table table = this.hbaseConnection.getTable(tableName);
        Scan colScan = new Scan().setFilter((Filter)new KeyOnlyFilter(true));
        if (includeAllCells) {
            colScan.setMaxVersions();
        }
        try (ResultScanner rows = table.getScanner(colScan);){
            for (Result row : rows) {
                this.putDiscoveredColumnAuditors(mtd, row, true);
            }
            return;
        }
    }

    byte[] getAlias(MTableDescriptor mtd, byte[] colFamily, byte[] colQualifier) throws IOException {
        if (mtd.getMColumnDescriptor(colFamily).columnAliasesEnabled()) {
            TreeSet<byte[]> colQualifierSet = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
            colQualifierSet.add(colQualifier);
            return (byte[])this.getQualifierToAliasMap(mtd.getTableName(), colFamily, colQualifierSet, false).get(colQualifier);
        }
        return colQualifier;
    }

    NavigableMap<byte[], byte[]> getQualifierToAliasMap(TableName tableName, byte[] colFamily, List<Cell> cellList, boolean addAliasIfNotFound) throws IOException {
        TreeSet<byte[]> colQualifierSet = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        for (Cell cell : cellList) {
            colQualifierSet.add(Bytes.copy((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
        }
        return this.getQualifierToAliasMap(tableName, colFamily, colQualifierSet, addAliasIfNotFound);
    }

    NavigableMap<byte[], byte[]> getQualifierToAliasMap(TableName tableName, byte[] colFamily, NavigableSet<byte[]> colQualifierSet, boolean addAliasIfNotFound) throws IOException {
        TreeMap<byte[], byte[]> aliasMap = new TreeMap<byte[], byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        aliasMap.put(HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
        RowId rowId = new RowId(SchemaEntityType.COLUMN_FAMILY.getRecordType(), this.getTableForeignKey(tableName), colFamily);
        Get getAliasRow = new Get(rowId.getByteArray());
        if (colQualifierSet == null) {
            getAliasRow.addFamily(ALIAS_CF);
        } else {
            for (byte[] colQualifier : colQualifierSet) {
                getAliasRow.addColumn(ALIAS_CF, colQualifier);
            }
        }
        Result aliasRow = this.aliasTable.get(getAliasRow);
        if (!aliasRow.isEmpty()) {
            aliasMap.putAll(aliasRow.getFamilyMap(ALIAS_CF));
        }
        if (colQualifierSet != null) {
            for (byte[] colQualifier : colQualifierSet) {
                if (aliasMap.get(colQualifier) != null) continue;
                if (addAliasIfNotFound) {
                    aliasMap.put(colQualifier, this.getNewAlias(rowId.getByteArray(), colQualifier));
                    continue;
                }
                aliasMap.put(colQualifier, INVALID_ALIAS);
            }
        }
        aliasMap.remove(ALIAS_INCREMENTOR_COLUMN);
        return aliasMap;
    }

    private byte[] getNewAlias(byte[] aliasTableRowId, byte[] colQualifier) throws IOException {
        byte[] newAlias = Bytes.toBytes((int)new Long(this.aliasTable.incrementColumnValue(aliasTableRowId, ALIAS_CF, ALIAS_INCREMENTOR_COLUMN, 1L)).intValue());
        Put putNewAlias = new Put(aliasTableRowId).addColumn(ALIAS_CF, colQualifier, newAlias);
        boolean putSucceeded = this.aliasTable.checkAndPut(aliasTableRowId, ALIAS_CF, colQualifier, null, putNewAlias);
        if (!putSucceeded) {
            Get getAlias = new Get(aliasTableRowId).addColumn(ALIAS_CF, colQualifier);
            newAlias = this.aliasTable.get(getAlias).getValue(ALIAS_CF, colQualifier);
        }
        return newAlias;
    }

    private void validateNamespaceTableNameIncludedForProcessing(String namespace, TableName tableName) throws TableNotIncludedForProcessingException {
        if (tableName == null || tableName.getNameAsString().isEmpty()) {
            if (namespace != null && !namespace.isEmpty() && !this.isIncludedNamespace(namespace)) {
                throw new TableNotIncludedForProcessingException(Bytes.toBytes((String)(namespace + ALL_TABLES_WILDCARD_INDICATOR)), "NO table from namespace <" + namespace + "> is included for " + PRODUCT_NAME + " processing.");
            }
        } else if (!this.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
    }

    void exportSchema(String sourceNamespace, TableName sourceTableName, File targetFile) throws IOException, JAXBException, XMLStreamException {
        if (!this.isActivated()) {
            throw new ColumnManagerIOException(REPOSITORY_NOT_ACTIVATED_MSG){};
        }
        this.validateNamespaceTableNameIncludedForProcessing(sourceNamespace, sourceTableName);
        String allLiteral = "";
        if ((sourceNamespace == null || sourceNamespace.isEmpty()) && (sourceTableName == null || sourceTableName.getNameAsString().isEmpty())) {
            allLiteral = "ALL ";
        }
        this.logger.info((Object)("EXPORT of " + allLiteral + "ColumnManager repository schema to external XML file has been invoked."));
        if (sourceNamespace != null && !sourceNamespace.isEmpty()) {
            this.logger.info((Object)("EXPORT source NAMESPACE: " + sourceNamespace));
        }
        if (sourceTableName != null && !sourceTableName.getNameAsString().isEmpty()) {
            this.logger.info((Object)("EXPORT source TABLE: " + sourceTableName.getNameAsString()));
        }
        this.logger.info((Object)("EXPORT target FILE NAME: " + targetFile.getAbsolutePath()));
        HBaseSchemaArchive.exportToXmlFile(new HBaseSchemaArchive(sourceNamespace, sourceTableName, this), targetFile);
        this.logger.info((Object)"EXPORT of ColumnManager repository schema has been completed.");
    }

    void importSchema(File sourceHsaFile, String namespaceFilter, TableName tableNameFilter, byte[] colFamilyFilter, boolean includeColumnAuditors, boolean bypassNamespacesTablesAndCFs) throws IOException, JAXBException {
        if (!this.isActivated()) {
            throw new ColumnManagerIOException(REPOSITORY_NOT_ACTIVATED_MSG){};
        }
        this.validateNamespaceTableNameIncludedForProcessing(namespaceFilter, tableNameFilter);
        this.submitImportMessagesToLogger(sourceHsaFile, namespaceFilter, tableNameFilter, colFamilyFilter, includeColumnAuditors, bypassNamespacesTablesAndCFs);
        LinkedHashSet<Object> importedDescriptors = new LinkedHashSet<Object>();
        for (SchemaEntity entity : HBaseSchemaArchive.deserializeXmlFile(sourceHsaFile).getSchemaEntities()) {
            importedDescriptors.addAll(SchemaEntity.convertToNamespaceAndTableDescriptorSet(entity, namespaceFilter, tableNameFilter, colFamilyFilter));
        }
        this.createImportedStructures(importedDescriptors, includeColumnAuditors, bypassNamespacesTablesAndCFs);
    }

    private void submitImportMessagesToLogger(File sourceHsaFile, String namespaceFilter, TableName tableNameFilter, byte[] colFamilyFilter, boolean includeColumnAuditors, boolean bypassNamespacesTablesAndCFs) {
        this.logger.info((Object)("IMPORT of " + (bypassNamespacesTablesAndCFs ? "<COLUMN DEFINITION> " : "") + "schema " + (includeColumnAuditors ? "<INCLUDING COLUMN AUDITOR METADATA> " : "") + "from external HBaseSchemaArchive (XML) file has been requested."));
        if (namespaceFilter != null && !namespaceFilter.isEmpty() && (tableNameFilter == null || tableNameFilter.getNameAsString().isEmpty())) {
            this.logger.info((Object)("IMPORT NAMESPACE: " + namespaceFilter));
        }
        if (tableNameFilter != null && !tableNameFilter.getNameAsString().isEmpty()) {
            this.logger.info((Object)("IMPORT TABLE: " + tableNameFilter.getNameAsString()));
        }
        if (colFamilyFilter != null && colFamilyFilter.length > 0) {
            this.logger.info((Object)("IMPORT COLUMN FAMILY: " + Bytes.toString((byte[])colFamilyFilter)));
        }
        this.logger.info((Object)("IMPORT source PATH/FILE-NAME: " + sourceHsaFile.getAbsolutePath()));
    }

    private void createImportedStructures(Set<Object> importedDescriptors, boolean includeColumnAuditors, boolean bypassNamespacesTablesAndCFs) throws IOException {
        for (Object descriptor : importedDescriptors) {
            MTableDescriptor mtd;
            if (MNamespaceDescriptor.class.isAssignableFrom(descriptor.getClass())) {
                NamespaceDescriptor nd = ((MNamespaceDescriptor)descriptor).getNamespaceDescriptor();
                if (!this.isIncludedNamespace(nd.getName()) || this.namespaceExists(nd.getName())) continue;
                this.getAdmin().createNamespace(nd);
                this.putNamespaceSchemaEntity(nd);
                this.logger.info((Object)("IMPORT COMPLETED FOR NAMESPACE: " + nd.getName()));
                continue;
            }
            if (!MTableDescriptor.class.isAssignableFrom(descriptor.getClass()) || !this.isIncludedTable((mtd = (MTableDescriptor)((Object)descriptor)).getTableName())) continue;
            if (this.getAdmin().tableExists(mtd.getTableName())) {
                if (!bypassNamespacesTablesAndCFs) continue;
                this.putColumnDefinitionSchemaEntities(mtd);
                continue;
            }
            this.getAdmin().createTable((HTableDescriptor)mtd);
            this.putTableSchemaEntity(mtd);
            this.putColumnDefinitionSchemaEntities(mtd);
            if (includeColumnAuditors) {
                this.putColumnAuditorSchemaEntities(mtd);
            }
            this.logger.info((Object)("IMPORT COMPLETED FOR TABLE: " + mtd.getNameAsString() + (includeColumnAuditors ? " <INCLUDING COLUMN AUDITOR METADATA>" : "")));
        }
    }

    void dumpRepositoryTable() throws IOException {
        this.logger.info((Object)"DUMP of ColumnManager repository table has been requested.");
        try (ResultScanner results = this.repositoryTable.getScanner(new Scan().setMaxVersions());){
            this.logger.info((Object)"** START OF COMPLETE SCAN OF ColumnManagerAPI REPOSITORY TABLE **");
            for (Result result : results) {
                byte[] rowId = result.getRow();
                this.logger.info((Object)("Row type: " + Bytes.toString((byte[])rowId).substring(0, 1)));
                this.logger.info((Object)("  Row ID: " + Repository.getPrintableString(rowId)));
                this.logger.info((Object)("  Element name: " + Bytes.toString((byte[])new RowId(rowId).getEntityName())));
                for (Map.Entry cfEntry : result.getMap().entrySet()) {
                    this.logger.info((Object)("  Column Family: " + Bytes.toString((byte[])((byte[])cfEntry.getKey()))));
                    for (Map.Entry colEntry : ((NavigableMap)cfEntry.getValue()).entrySet()) {
                        this.logger.info((Object)("    Column: " + Repository.getPrintableString((byte[])colEntry.getKey())));
                        for (Map.Entry cellEntry : ((NavigableMap)colEntry.getValue()).entrySet()) {
                            this.logger.info((Object)("      Cell timestamp: " + cellEntry.getKey()));
                            this.logger.info((Object)("      Cell value: " + Repository.getPrintableString((byte[])cellEntry.getValue())));
                        }
                    }
                }
            }
            this.logger.info((Object)"** END OF COMPLETE SCAN OF ColumnManagerAPI REPOSITORY TABLE **");
        }
        this.logger.info((Object)"DUMP of ColumnManager repository table is complete.");
    }

    boolean outputReportOnColumnQualifiers(String namespace, TableName tableName, byte[] colFamily, File targetFile) throws IOException {
        if (!this.isActivated()) {
            throw new ColumnManagerIOException(REPOSITORY_NOT_ACTIVATED_MSG){};
        }
        if (tableName == null && !this.isIncludedNamespace(namespace)) {
            throw new TableNotIncludedForProcessingException(Bytes.toBytes((String)(namespace + ALL_TABLES_WILDCARD_INDICATOR)), "NO table from namespace <" + namespace + "> is included for " + PRODUCT_NAME + " processing.");
        }
        if (tableName != null && !this.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
        ColumnQualifierReport columnQualifierReport = new ColumnQualifierReport(namespace, tableName, colFamily, this, targetFile);
        return columnQualifierReport.isEmpty();
    }

    boolean outputReportOnInvalidColumns(ColumnInvalidityReport.ReportType reportType, TableName tableName, byte[] colFamily, File targetFile, boolean verbose, boolean includeAllCells, boolean useMapreduce) throws Exception {
        if (!this.isActivated()) {
            throw new ColumnManagerIOException(REPOSITORY_NOT_ACTIVATED_MSG){};
        }
        if (!this.isIncludedTable(tableName)) {
            throw new TableNotIncludedForProcessingException(tableName.getName(), null);
        }
        MTableDescriptor mtd = this.getMTableDescriptor(tableName);
        if (mtd == null || !mtd.hasColumnDefinitions()) {
            throw new ColumnDefinitionNotFoundException(tableName.getName(), colFamily, null, "No ColumnDefinitions found for table/columnFamily");
        }
        if (colFamily != null && (mtd.getMColumnDescriptor(colFamily) == null || mtd.getMColumnDescriptor(colFamily).getColumnDefinitions().isEmpty())) {
            throw new ColumnDefinitionNotFoundException(tableName.getName(), colFamily, null, "No ColumnDefinitions found for columnFamily");
        }
        try (ColumnInvalidityReport columnInvalidityReport = new ColumnInvalidityReport(reportType, this.hbaseConnection, mtd, colFamily, targetFile, verbose, includeAllCells, useMapreduce);){
            boolean bl = !columnInvalidityReport.isEmpty();
            return bl;
        }
    }

    static void dropRepository(Admin hbaseAdmin, Logger logger) throws IOException {
        Admin standardAdmin = Repository.getStandardAdmin(hbaseAdmin);
        if (!standardAdmin.tableExists(REPOSITORY_TABLENAME)) {
            return;
        }
        logger.warn((Object)"DROP (disable/delete) of ColumnManagerAPI Repository tables and namespace has been requested.");
        if (standardAdmin.isTableEnabled(REPOSITORY_TABLENAME)) {
            standardAdmin.disableTable(REPOSITORY_TABLENAME);
        }
        standardAdmin.deleteTable(REPOSITORY_TABLENAME);
        logger.warn((Object)("DROP (disable/delete) of ColumnManagerAPI Repository table has been completed: " + REPOSITORY_TABLENAME.getNameAsString()));
        if (standardAdmin.isTableEnabled(ALIAS_DIRECTORY_TABLENAME)) {
            standardAdmin.disableTable(ALIAS_DIRECTORY_TABLENAME);
        }
        standardAdmin.deleteTable(ALIAS_DIRECTORY_TABLENAME);
        logger.warn((Object)("DROP (disable/delete) of ColumnManagerAPI AliasDirectory table has been completed: " + REPOSITORY_TABLENAME.getNameAsString()));
        standardAdmin.deleteNamespace(REPOSITORY_NAMESPACE_DESCRIPTOR.getName());
        logger.warn((Object)("DROP (delete) of ColumnManagerAPI Repository namespace has been completed: " + REPOSITORY_NAMESPACE_DESCRIPTOR.getName()));
    }

    boolean namespaceExists(String namespaceName) throws IOException {
        try {
            this.getAdmin().getNamespaceDescriptor(namespaceName);
        }
        catch (NamespaceNotFoundException e) {
            return false;
        }
        return true;
    }

    void logIOExceptionAsError(IOException e, String originatingClassName) {
        this.logger.error((Object)(PRODUCT_NAME + " " + e.getClass().getSimpleName() + " encountered in multithreaded " + originatingClassName + " processing."), (Throwable)e);
    }

    static String getPrintableString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        if (Repository.isPrintable(bytes)) {
            return Bytes.toString((byte[])bytes);
        }
        StringBuilder sb = new StringBuilder("H'");
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        sb.append("'");
        return sb.toString();
    }

    static boolean isPrintable(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        for (byte nextByte : bytes) {
            if (Character.isDefined(nextByte) && nextByte > 31) continue;
            return false;
        }
        return true;
    }

    private static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    NavigableMap<byte[], NavigableMap<byte[], byte[]>> getFamilyQualifierToAliasMap(MTableDescriptor mTableDescriptor, Mutation mutation) throws IOException {
        NavigableMap<Object, Object> familyQualifierToAliasMap = new TreeMap(Bytes.BYTES_COMPARATOR);
        Class<?> mutationClass = mutation.getClass();
        if (Append.class.isAssignableFrom(mutationClass)) {
            familyQualifierToAliasMap = this.getFamilyQualifierToAliasMap(mTableDescriptor, (Append)mutation);
        } else if (Increment.class.isAssignableFrom(mutationClass)) {
            familyQualifierToAliasMap = this.getFamilyQualifierToAliasMap(mTableDescriptor, (Increment)mutation);
        } else if (Delete.class.isAssignableFrom(mutationClass) || Put.class.isAssignableFrom(mutationClass) || RowMutations.class.isAssignableFrom(mutationClass)) {
            // empty if block
        }
        return familyQualifierToAliasMap;
    }

    NavigableMap<byte[], NavigableMap<byte[], byte[]>> getFamilyQualifierToAliasMap(MTableDescriptor mTableDescriptor, Get get) throws IOException {
        TreeMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap;
        block8: {
            familyQualifierToAliasMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
            TreeSet<byte[]> aliasEnabledFamiliesInScan = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            if (get.hasFamilies()) {
                for (byte[] byArray : get.familySet()) {
                    if (!mTableDescriptor.getMColumnDescriptor(byArray).columnAliasesEnabled()) continue;
                    aliasEnabledFamiliesInScan.add(byArray);
                }
            } else {
                for (MColumnDescriptor mColumnDescriptor : mTableDescriptor.getMColumnDescriptors()) {
                    if (!mColumnDescriptor.columnAliasesEnabled()) continue;
                    aliasEnabledFamiliesInScan.add(mColumnDescriptor.getName());
                }
            }
            if (aliasEnabledFamiliesInScan.isEmpty()) break block8;
            if (get.hasFamilies()) {
                for (Map.Entry entry : get.getFamilyMap().entrySet()) {
                    byte[] colFamily = (byte[])entry.getKey();
                    NavigableSet colQualifiers = (NavigableSet)entry.getValue();
                    if (!aliasEnabledFamiliesInScan.contains(colFamily)) continue;
                    familyQualifierToAliasMap.put(colFamily, this.getQualifierToAliasMap(mTableDescriptor.getTableName(), colFamily, colQualifiers, false));
                }
            } else {
                for (byte[] byArray : aliasEnabledFamiliesInScan) {
                    familyQualifierToAliasMap.put(byArray, this.getQualifierToAliasMap(mTableDescriptor.getTableName(), byArray, NULL_NAVIGABLE_SET, false));
                }
            }
        }
        return familyQualifierToAliasMap;
    }

    NavigableMap<byte[], NavigableMap<byte[], byte[]>> getFamilyQualifierToAliasMap(MTableDescriptor mTableDescriptor, List<? extends Row> rowList, int intForUniqueSignature) throws IOException {
        TreeMap<byte[], NavigableMap<byte[], byte[]>> masterFamilyQualifierToAliasMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
        for (Row row : rowList) {
            Class<?> rowClass = row.getClass();
            NavigableMap<Object, Object> partialFamilyQualifierToAliasMap = new TreeMap(Bytes.BYTES_COMPARATOR);
            if (Append.class.isAssignableFrom(rowClass)) {
                partialFamilyQualifierToAliasMap = this.getFamilyQualifierToAliasMap(mTableDescriptor, (Append)row);
            } else if (Get.class.isAssignableFrom(rowClass)) {
                partialFamilyQualifierToAliasMap = this.getFamilyQualifierToAliasMap(mTableDescriptor, (Get)row);
            } else if (Increment.class.isAssignableFrom(rowClass)) {
                partialFamilyQualifierToAliasMap = this.getFamilyQualifierToAliasMap(mTableDescriptor, (Increment)row);
            } else if (Delete.class.isAssignableFrom(rowClass) || Put.class.isAssignableFrom(rowClass) || RowMutations.class.isAssignableFrom(rowClass)) continue;
            for (Map.Entry partialFamilyEntry : partialFamilyQualifierToAliasMap.entrySet()) {
                byte[] colFamily = (byte[])partialFamilyEntry.getKey();
                NavigableMap masterQualifierToAliasMap = (NavigableMap)masterFamilyQualifierToAliasMap.get(colFamily);
                if (masterQualifierToAliasMap == null) {
                    masterFamilyQualifierToAliasMap.put(colFamily, (NavigableMap<byte[], byte[]>)partialFamilyEntry.getValue());
                    continue;
                }
                masterQualifierToAliasMap.putAll((Map)partialFamilyEntry.getValue());
            }
        }
        return masterFamilyQualifierToAliasMap;
    }

    NavigableMap<byte[], NavigableMap<byte[], byte[]>> getFamilyQualifierToAliasMap(MTableDescriptor mTableDescriptor, List<Get> gets) throws IOException {
        TreeMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
        TreeSet<byte[]> aliasEnabledFamiliesInScan = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (Get get : gets) {
            if (get.hasFamilies()) {
                for (byte[] byArray : get.familySet()) {
                    if (!mTableDescriptor.getMColumnDescriptor(byArray).columnAliasesEnabled()) continue;
                    aliasEnabledFamiliesInScan.add(byArray);
                }
                continue;
            }
            for (MColumnDescriptor mColumnDescriptor : mTableDescriptor.getMColumnDescriptors()) {
                if (!mColumnDescriptor.columnAliasesEnabled()) continue;
                aliasEnabledFamiliesInScan.add(mColumnDescriptor.getName());
            }
        }
        if (!aliasEnabledFamiliesInScan.isEmpty()) {
            for (Get get : gets) {
                if (get.hasFamilies()) {
                    for (Map.Entry entry : get.getFamilyMap().entrySet()) {
                        byte[] colFamily = (byte[])entry.getKey();
                        NavigableSet colQualifiers = (NavigableSet)entry.getValue();
                        if (!aliasEnabledFamiliesInScan.contains(colFamily)) continue;
                        NavigableMap qualifierToAliasMap = (NavigableMap)familyQualifierToAliasMap.get(colFamily);
                        if (qualifierToAliasMap == null) {
                            familyQualifierToAliasMap.put(colFamily, this.getQualifierToAliasMap(mTableDescriptor.getTableName(), colFamily, colQualifiers, false));
                            continue;
                        }
                        qualifierToAliasMap.putAll(this.getQualifierToAliasMap(mTableDescriptor.getTableName(), colFamily, colQualifiers, false));
                    }
                    continue;
                }
                for (byte[] byArray : aliasEnabledFamiliesInScan) {
                    familyQualifierToAliasMap.put(byArray, this.getQualifierToAliasMap(mTableDescriptor.getTableName(), byArray, NULL_NAVIGABLE_SET, false));
                }
            }
        }
        return familyQualifierToAliasMap;
    }

    NavigableMap<byte[], NavigableMap<byte[], byte[]>> getFamilyQualifierToAliasMap(MTableDescriptor mTableDescriptor, Scan scan) throws IOException {
        TreeMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap;
        block8: {
            familyQualifierToAliasMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
            TreeSet<Object> aliasEnabledFamiliesInScan = new TreeSet<Object>(Bytes.BYTES_COMPARATOR);
            if (scan.hasFamilies()) {
                for (byte[] colFamily : scan.getFamilies()) {
                    if (!mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) continue;
                    aliasEnabledFamiliesInScan.add(colFamily);
                }
            } else {
                Object object = mTableDescriptor.getMColumnDescriptors().iterator();
                while (object.hasNext()) {
                    MColumnDescriptor mColumnDescriptor = (MColumnDescriptor)((Object)object.next());
                    if (!mColumnDescriptor.columnAliasesEnabled()) continue;
                    aliasEnabledFamiliesInScan.add(mColumnDescriptor.getName());
                }
            }
            if (aliasEnabledFamiliesInScan.isEmpty()) break block8;
            if (scan.hasFamilies()) {
                for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
                    byte[] colFamily = (byte[])entry.getKey();
                    NavigableSet colQualifiers = (NavigableSet)entry.getValue();
                    if (!aliasEnabledFamiliesInScan.contains(colFamily)) continue;
                    familyQualifierToAliasMap.put(colFamily, this.getQualifierToAliasMap(mTableDescriptor.getTableName(), colFamily, colQualifiers, false));
                }
            } else {
                for (byte[] byArray : aliasEnabledFamiliesInScan) {
                    familyQualifierToAliasMap.put(byArray, this.getQualifierToAliasMap(mTableDescriptor.getTableName(), byArray, NULL_NAVIGABLE_SET, false));
                }
            }
        }
        return familyQualifierToAliasMap;
    }

    NavigableMap<byte[], NavigableMap<byte[], byte[]>> getFamilyQualifierToAliasMap(MTableDescriptor mTableDescriptor, Append append) throws IOException {
        TreeMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry familyToCellsMap : append.getFamilyCellMap().entrySet()) {
            byte[] colFamily = (byte[])familyToCellsMap.getKey();
            List cellList = (List)familyToCellsMap.getValue();
            if (!mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) continue;
            familyQualifierToAliasMap.put(colFamily, this.getQualifierToAliasMap(mTableDescriptor.getTableName(), colFamily, cellList, true));
        }
        return familyQualifierToAliasMap;
    }

    NavigableMap<byte[], NavigableMap<byte[], byte[]>> getFamilyQualifierToAliasMap(MTableDescriptor mTableDescriptor, Increment increment) throws IOException {
        TreeMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry familyToCellsMap : increment.getFamilyCellMap().entrySet()) {
            byte[] colFamily = (byte[])familyToCellsMap.getKey();
            List cellList = (List)familyToCellsMap.getValue();
            if (!mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) continue;
            familyQualifierToAliasMap.put(colFamily, this.getQualifierToAliasMap(mTableDescriptor.getTableName(), colFamily, cellList, true));
        }
        return familyQualifierToAliasMap;
    }

    NavigableMap<byte[], NavigableMap<byte[], byte[]>> getFamilyAliasToQualifierMap(NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap) {
        TreeMap<byte[], NavigableMap<byte[], byte[]>> familyAliasToQualifierMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry familyQualifierToAliasEntry : familyQualifierToAliasMap.entrySet()) {
            TreeMap aliasToQualifierMap = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (Map.Entry qualifierToAliasMap : ((NavigableMap)familyQualifierToAliasEntry.getValue()).entrySet()) {
                aliasToQualifierMap.put(qualifierToAliasMap.getValue(), qualifierToAliasMap.getKey());
            }
            familyAliasToQualifierMap.put((byte[])familyQualifierToAliasEntry.getKey(), aliasToQualifierMap);
        }
        return familyAliasToQualifierMap;
    }

    NavigableMap<byte[], NavigableMap<byte[], byte[]>> getFamilyAliasToQualifierMap(MTableDescriptor mTableDescriptor, byte[] colFamily) throws IOException {
        return this.getFamilyAliasToQualifierMap(mTableDescriptor, colFamily, NULL_NAVIGABLE_SET);
    }

    NavigableMap<byte[], NavigableMap<byte[], byte[]>> getFamilyAliasToQualifierMap(MTableDescriptor mTableDescriptor, byte[] colFamily, byte[] colQualifier) throws IOException {
        TreeSet<byte[]> colQualifierSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        colQualifierSet.add(colQualifier);
        return this.getFamilyAliasToQualifierMap(mTableDescriptor, colFamily, colQualifierSet);
    }

    NavigableMap<byte[], NavigableMap<byte[], byte[]>> getFamilyAliasToQualifierMap(MTableDescriptor mTableDescriptor, byte[] colFamily, NavigableSet<byte[]> colQualifierSet) throws IOException {
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyAliasToQualifierMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
        if (mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) {
            TreeMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
            familyQualifierToAliasMap.put(colFamily, this.getQualifierToAliasMap(mTableDescriptor.getTableName(), colFamily, colQualifierSet, false));
            familyAliasToQualifierMap = this.getFamilyAliasToQualifierMap(familyQualifierToAliasMap);
        }
        return familyAliasToQualifierMap;
    }

    Row convertQualifiersToAliases(MTableDescriptor mTableDescriptor, Row originalRow, NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap, int intForUniqueSignature) throws IOException {
        Class<?> originalRowClass = originalRow.getClass();
        if (Append.class.isAssignableFrom(originalRowClass)) {
            return this.convertQualifiersToAliases(mTableDescriptor, (Append)originalRow, familyQualifierToAliasMap);
        }
        if (Delete.class.isAssignableFrom(originalRowClass)) {
            return this.convertQualifiersToAliases(mTableDescriptor, (Delete)originalRow);
        }
        if (Get.class.isAssignableFrom(originalRowClass)) {
            return this.convertQualifiersToAliases(mTableDescriptor, (Get)originalRow, familyQualifierToAliasMap);
        }
        if (Increment.class.isAssignableFrom(originalRowClass)) {
            return this.convertQualifiersToAliases(mTableDescriptor, (Increment)originalRow, familyQualifierToAliasMap);
        }
        if (Put.class.isAssignableFrom(originalRowClass)) {
            return this.convertQualifiersToAliases(mTableDescriptor, (Put)originalRow);
        }
        if (RowMutations.class.isAssignableFrom(originalRowClass)) {
            return this.convertQualifiersToAliases(mTableDescriptor, (RowMutations)originalRow);
        }
        return null;
    }

    Get convertQualifiersToAliases(MTableDescriptor mTableDescriptor, Get originalGet, NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap) throws IOException {
        if (!originalGet.hasFamilies()) {
            return originalGet;
        }
        TreeMap<byte[], NavigableSet> modifiedFamilyMap = new TreeMap<byte[], NavigableSet>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry familyToQualifiersMap : originalGet.getFamilyMap().entrySet()) {
            byte[] colFamily = (byte[])familyToQualifiersMap.getKey();
            NavigableSet colQualifierSet = (NavigableSet)familyToQualifiersMap.getValue();
            if (colQualifierSet == null || !mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) {
                modifiedFamilyMap.put(colFamily, colQualifierSet);
                continue;
            }
            NavigableMap qualifierToAliasMap = (NavigableMap)familyQualifierToAliasMap.get(colFamily);
            TreeSet<byte[]> aliasSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (byte[] qualifier : colQualifierSet) {
                byte[] alias = (byte[])qualifierToAliasMap.get(qualifier);
                aliasSet.add(alias);
            }
            modifiedFamilyMap.put(colFamily, aliasSet);
        }
        Get convertedGet = this.cloneGetWithoutFamilyMap(originalGet);
        for (Map.Entry modifiedFamilyToQualifiersMap : modifiedFamilyMap.entrySet()) {
            byte[] colFamily = (byte[])modifiedFamilyToQualifiersMap.getKey();
            NavigableSet colQualifierSet = (NavigableSet)modifiedFamilyToQualifiersMap.getValue();
            if (colQualifierSet == null) {
                convertedGet.addFamily(colFamily);
                continue;
            }
            for (byte[] colQualifier : colQualifierSet) {
                convertedGet.addColumn(colFamily, colQualifier);
            }
        }
        return convertedGet;
    }

    Get cloneGetWithoutFamilyMap(Get originalGet) throws IOException {
        Get convertedGet = new Get(originalGet.getRow());
        convertedGet.setFilter(originalGet.getFilter());
        convertedGet.setReplicaId(originalGet.getReplicaId());
        convertedGet.setConsistency(originalGet.getConsistency());
        convertedGet.setCacheBlocks(originalGet.getCacheBlocks());
        convertedGet.setMaxVersions(originalGet.getMaxVersions());
        convertedGet.setMaxResultsPerColumnFamily(originalGet.getMaxResultsPerColumnFamily());
        convertedGet.setRowOffsetPerColumnFamily(originalGet.getRowOffsetPerColumnFamily());
        convertedGet.setCheckExistenceOnly(originalGet.isCheckExistenceOnly());
        convertedGet.setClosestRowBefore(originalGet.isClosestRowBefore());
        for (Map.Entry attr : originalGet.getAttributesMap().entrySet()) {
            convertedGet.setAttribute((String)attr.getKey(), (byte[])attr.getValue());
        }
        return convertedGet;
    }

    Scan convertQualifiersToAliases(MTableDescriptor mTableDescriptor, Scan originalScan, NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap) throws IOException {
        if (!originalScan.hasFamilies()) {
            return originalScan;
        }
        TreeMap<byte[], NavigableSet> modifiedFamilyMap = new TreeMap<byte[], NavigableSet>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry familyToQualifiersMap : originalScan.getFamilyMap().entrySet()) {
            byte[] colFamily = (byte[])familyToQualifiersMap.getKey();
            NavigableSet colQualifierSet = (NavigableSet)familyToQualifiersMap.getValue();
            if (colQualifierSet == null || !mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) {
                modifiedFamilyMap.put(colFamily, colQualifierSet);
                continue;
            }
            NavigableMap qualifierToAliasMap = (NavigableMap)familyQualifierToAliasMap.get(colFamily);
            TreeSet<byte[]> aliasSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (byte[] qualifier : colQualifierSet) {
                byte[] alias = (byte[])qualifierToAliasMap.get(qualifier);
                aliasSet.add(alias);
            }
            modifiedFamilyMap.put(colFamily, aliasSet);
        }
        return new Scan(originalScan).setFamilyMap(modifiedFamilyMap);
    }

    RowMutations convertQualifiersToAliases(MTableDescriptor mTableDescriptor, RowMutations originalRowMutations) throws IOException {
        RowMutations modifiedRowMutations = new RowMutations(originalRowMutations.getRow());
        for (Mutation originalMutation : originalRowMutations.getMutations()) {
            Class<?> mutationClass = originalMutation.getClass();
            if (Put.class.isAssignableFrom(mutationClass)) {
                modifiedRowMutations.add(this.convertQualifiersToAliases(mTableDescriptor, (Put)originalMutation));
                continue;
            }
            if (!Delete.class.isAssignableFrom(mutationClass)) continue;
            modifiedRowMutations.add(this.convertQualifiersToAliases(mTableDescriptor, (Delete)originalMutation));
        }
        return modifiedRowMutations;
    }

    Put convertQualifiersToAliases(MTableDescriptor mTableDescriptor, Put originalPut) throws IOException {
        Put modifiedPut = new Put(originalPut).setFamilyCellMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        for (Map.Entry familyToCellsMap : originalPut.getFamilyCellMap().entrySet()) {
            byte[] colFamily = (byte[])familyToCellsMap.getKey();
            List cellList = (List)familyToCellsMap.getValue();
            if (mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) {
                NavigableMap<byte[], byte[]> qualifierToAliasMap = this.getQualifierToAliasMap(mTableDescriptor.getTableName(), colFamily, cellList, true);
                for (Cell originalCell : cellList) {
                    modifiedPut.addColumn(colFamily, (byte[])qualifierToAliasMap.get(Bytes.copy((byte[])originalCell.getQualifierArray(), (int)originalCell.getQualifierOffset(), (int)originalCell.getQualifierLength())), originalCell.getTimestamp(), Bytes.copy((byte[])originalCell.getValueArray(), (int)originalCell.getValueOffset(), (int)originalCell.getValueLength()));
                }
                continue;
            }
            for (Cell originalCell : cellList) {
                modifiedPut.add(originalCell);
            }
        }
        return modifiedPut;
    }

    Append convertQualifiersToAliases(MTableDescriptor mTableDescriptor, Append originalAppend, NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap) throws IOException {
        Append modifiedAppend = new Append(originalAppend).setFamilyCellMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        for (Map.Entry familyToCellsMap : originalAppend.getFamilyCellMap().entrySet()) {
            byte[] colFamily = (byte[])familyToCellsMap.getKey();
            List cellList = (List)familyToCellsMap.getValue();
            if (mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) {
                for (Cell originalCell : cellList) {
                    modifiedAppend.add(colFamily, (byte[])((NavigableMap)familyQualifierToAliasMap.get(colFamily)).get(Bytes.copy((byte[])originalCell.getQualifierArray(), (int)originalCell.getQualifierOffset(), (int)originalCell.getQualifierLength())), Bytes.copy((byte[])originalCell.getValueArray(), (int)originalCell.getValueOffset(), (int)originalCell.getValueLength()));
                }
                continue;
            }
            for (Cell originalCell : cellList) {
                modifiedAppend.add(originalCell);
            }
        }
        return modifiedAppend;
    }

    Increment convertQualifiersToAliases(MTableDescriptor mTableDescriptor, Increment originalIncrement, NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap) throws IOException {
        Increment modifiedIncrement = new Increment(originalIncrement).setFamilyCellMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        for (Map.Entry familyToCellsMap : originalIncrement.getFamilyCellMap().entrySet()) {
            byte[] colFamily = (byte[])familyToCellsMap.getKey();
            List cellList = (List)familyToCellsMap.getValue();
            if (mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) {
                NavigableMap qualifierToAliasMap = (NavigableMap)familyQualifierToAliasMap.get(colFamily);
                for (Cell originalCell : cellList) {
                    modifiedIncrement.addColumn(colFamily, (byte[])((NavigableMap)familyQualifierToAliasMap.get(colFamily)).get(Bytes.copy((byte[])originalCell.getQualifierArray(), (int)originalCell.getQualifierOffset(), (int)originalCell.getQualifierLength())), Bytes.toLong((byte[])Bytes.copy((byte[])originalCell.getValueArray(), (int)originalCell.getValueOffset(), (int)originalCell.getValueLength())));
                }
                continue;
            }
            for (Cell originalCell : cellList) {
                modifiedIncrement.add(originalCell);
            }
        }
        return modifiedIncrement;
    }

    Delete convertQualifiersToAliases(MTableDescriptor mTableDescriptor, Delete originalDelete) throws IOException {
        Delete modifiedDelete = new Delete(originalDelete).setFamilyCellMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        for (Map.Entry familyToCellsMap : originalDelete.getFamilyCellMap().entrySet()) {
            byte[] colFamily = (byte[])familyToCellsMap.getKey();
            List cellList = (List)familyToCellsMap.getValue();
            if (mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) {
                NavigableMap<byte[], byte[]> qualifierToAliasMap = this.getQualifierToAliasMap(mTableDescriptor.getTableName(), colFamily, cellList, false);
                for (Cell originalCell : cellList) {
                    byte[] colQualifier = Bytes.copy((byte[])originalCell.getQualifierArray(), (int)originalCell.getQualifierOffset(), (int)originalCell.getQualifierLength());
                    byte[] colAlias = (byte[])qualifierToAliasMap.get(colQualifier);
                    if (originalCell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode()) {
                        modifiedDelete.addFamilyVersion(colFamily, originalCell.getTimestamp());
                        continue;
                    }
                    if (originalCell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode()) {
                        modifiedDelete.addFamily(colFamily);
                        continue;
                    }
                    if (originalCell.getTypeByte() == KeyValue.Type.DeleteColumn.getCode()) {
                        modifiedDelete.addColumns(colFamily, colAlias, originalCell.getTimestamp());
                        continue;
                    }
                    if (originalCell.getTypeByte() != KeyValue.Type.Delete.getCode()) continue;
                    modifiedDelete.addColumn(colFamily, colAlias, originalCell.getTimestamp());
                }
                continue;
            }
            for (Cell originalCell : cellList) {
                byte[] colQualifier = Bytes.copy((byte[])originalCell.getQualifierArray(), (int)originalCell.getQualifierOffset(), (int)originalCell.getQualifierLength());
                if (originalCell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode()) {
                    modifiedDelete.addFamilyVersion(colFamily, originalCell.getTimestamp());
                    continue;
                }
                if (originalCell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode()) {
                    modifiedDelete.addFamily(colFamily);
                    continue;
                }
                if (originalCell.getTypeByte() == KeyValue.Type.DeleteColumn.getCode()) {
                    modifiedDelete.addColumns(colFamily, colQualifier, originalCell.getTimestamp());
                    continue;
                }
                if (originalCell.getTypeByte() != KeyValue.Type.Delete.getCode()) continue;
                modifiedDelete.addColumn(colFamily, colQualifier, originalCell.getTimestamp());
            }
        }
        return modifiedDelete;
    }

    Result convertAliasesToQualifiers(Result result, NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyAliasToQualifierMap) {
        TreeSet<Cell> convertedCellSet = new TreeSet<Cell>((Comparator<Cell>)KeyValue.COMPARATOR);
        for (Cell originalCell : result.rawCells()) {
            byte[] cellFamily = Bytes.copy((byte[])originalCell.getFamilyArray(), (int)originalCell.getFamilyOffset(), (int)originalCell.getFamilyLength());
            NavigableMap aliasToQualifierMap = (NavigableMap)familyAliasToQualifierMap.get(cellFamily);
            if (aliasToQualifierMap == null) {
                convertedCellSet.add(originalCell);
                continue;
            }
            convertedCellSet.add(CellUtil.createCell((byte[])Bytes.copy((byte[])originalCell.getRowArray(), (int)originalCell.getRowOffset(), (int)originalCell.getRowLength()), (byte[])cellFamily, (byte[])((byte[])aliasToQualifierMap.get(Bytes.copy((byte[])originalCell.getQualifierArray(), (int)originalCell.getQualifierOffset(), (int)originalCell.getQualifierLength()))), (long)originalCell.getTimestamp(), (KeyValue.Type)KeyValue.Type.codeToType((byte)originalCell.getTypeByte()), (byte[])Bytes.copy((byte[])originalCell.getValueArray(), (int)originalCell.getValueOffset(), (int)originalCell.getValueLength()), (byte[])Bytes.copy((byte[])originalCell.getTagsArray(), (int)originalCell.getTagsOffset(), (int)originalCell.getTagsLength())));
        }
        return Result.create((Cell[])convertedCellSet.toArray(new Cell[convertedCellSet.size()]));
    }

    static {
        Arrays.fill(HEX_FF_ARRAY, (byte)-1);
    }

    static class RowId {
        private final ByteBuffer rowIdByteBuffer;
        private final byte entityType;
        private final byte[] parentForeignKey;
        private final byte[] entityName;

        RowId(byte recordType, byte[] parentForeignKey, byte[] entityName) {
            this.entityType = recordType;
            this.parentForeignKey = parentForeignKey;
            this.entityName = entityName;
            if (this.entityName == null) {
                this.rowIdByteBuffer = ByteBuffer.allocate(1 + this.parentForeignKey.length);
                this.rowIdByteBuffer.put(recordType).put(this.parentForeignKey);
            } else {
                this.rowIdByteBuffer = ByteBuffer.allocate(1 + this.parentForeignKey.length + this.entityName.length);
                this.rowIdByteBuffer.put(this.entityType).put(this.parentForeignKey).put(this.entityName);
            }
        }

        RowId(byte[] rowIdByteArray) {
            int entityNamePosition;
            if (rowIdByteArray.length < 2) {
                throw new RuntimeException("Invalid RowId length (less than 2) encountered in ColumnManagerAPI Repository Table processing.");
            }
            this.entityType = rowIdByteArray[0];
            switch (SchemaEntityType.ENTITY_TYPE_BYTE_TO_ENUM_MAP.get(this.entityType)) {
                case NAMESPACE: {
                    entityNamePosition = 2;
                    this.parentForeignKey = NAMESPACE_PARENT_FOREIGN_KEY;
                    break;
                }
                case TABLE: 
                case COLUMN_FAMILY: 
                case COLUMN_AUDITOR: 
                case COLUMN_DEFINITION: {
                    entityNamePosition = 17;
                    this.parentForeignKey = Bytes.copy((byte[])rowIdByteArray, (int)1, (int)16);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid record type encountered in ColumnManagerAPI Repository Table processing: <" + String.valueOf(this.entityType) + ">");
                }
            }
            this.entityName = new byte[rowIdByteArray.length - entityNamePosition];
            this.rowIdByteBuffer = ByteBuffer.wrap(rowIdByteArray);
            this.rowIdByteBuffer.position(entityNamePosition);
            this.rowIdByteBuffer.get(this.entityName, 0, this.entityName.length);
        }

        byte[] getByteArray() {
            return this.rowIdByteBuffer.array();
        }

        byte getEntityType() {
            return this.entityType;
        }

        byte[] getParentForeignKey() {
            return this.parentForeignKey;
        }

        byte[] getEntityName() {
            return this.entityName;
        }

        byte[] getStopRowIdByteArray() {
            byte[] fillerArray = this.entityName == null ? HEX_FF_ARRAY : HEX_00_ARRAY;
            return ByteBuffer.allocate(this.rowIdByteBuffer.array().length + fillerArray.length).put(this.rowIdByteBuffer.array()).put(fillerArray).array();
        }
    }
}

