/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTableMultiplexer;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.commonvox.hbase_column_manager.MTableDescriptor;
import org.commonvox.hbase_column_manager.Repository;

class MTableMultiplexer
extends HTableMultiplexer {
    private final Repository repository;

    MTableMultiplexer(Repository repository, Configuration conf, int perRegionServerBufferQueueSize) throws IOException {
        super(conf, perRegionServerBufferQueueSize);
        this.repository = repository;
    }

    @Deprecated
    public List<Put> put(byte[] tableName, List<Put> puts) {
        return this.put(TableName.valueOf((byte[])tableName), puts);
    }

    @Deprecated
    public boolean put(byte[] tableName, Put put) {
        return this.put(TableName.valueOf((byte[])tableName), put);
    }

    @Deprecated
    public boolean put(byte[] tableName, Put put, int retry) {
        return this.put(TableName.valueOf((byte[])tableName), put, retry);
    }

    public List<Put> put(TableName tableName, List<Put> puts) {
        return super.put(tableName, puts);
    }

    public boolean put(TableName tableName, Put put) {
        return this.put(tableName, put, 0, false);
    }

    public boolean put(TableName tableName, Put put, int retry) {
        return this.put(tableName, put, retry, true);
    }

    private boolean put(TableName tableName, Put put, int retry, boolean includeRetry) {
        boolean includedInRepositoryProcessing = false;
        MTableDescriptor mtd = null;
        if (this.repository.isActivated() && this.repository.isIncludedTable(tableName)) {
            includedInRepositoryProcessing = true;
            try {
                mtd = this.repository.getMTableDescriptor(tableName);
            }
            catch (IOException e) {
                this.repository.logIOExceptionAsError(e, ((Object)((Object)this)).getClass().getSimpleName());
                return false;
            }
        }
        if (includedInRepositoryProcessing && mtd.hasColDescriptorWithColDefinitionsEnforced()) {
            try {
                this.repository.validateColumns(tableName, (Mutation)put);
            }
            catch (IOException e) {
                this.repository.logIOExceptionAsError(e, ((Object)((Object)this)).getClass().getSimpleName());
                return false;
            }
        }
        boolean putRequestQueued = false;
        if (includedInRepositoryProcessing && mtd.hasColDescriptorWithColAliasesEnabled()) {
            try {
                if (includeRetry) {
                    putRequestQueued = super.put(tableName, this.repository.convertQualifiersToAliases(mtd, put), retry);
                }
                putRequestQueued = super.put(tableName, this.repository.convertQualifiersToAliases(mtd, put));
            }
            catch (IOException e) {
                this.repository.logIOExceptionAsError(e, ((Object)((Object)this)).getClass().getSimpleName());
                return false;
            }
        } else {
            putRequestQueued = includeRetry ? super.put(tableName, put, retry) : super.put(tableName, put);
        }
        if (includedInRepositoryProcessing && putRequestQueued) {
            try {
                this.repository.putColumnAuditorSchemaEntities(tableName, (Mutation)put);
            }
            catch (IOException e) {
                this.repository.logIOExceptionAsError(e, ((Object)((Object)this)).getClass().getSimpleName());
                return false;
            }
        }
        return putRequestQueued;
    }
}

