/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.security.User;
import org.commonvox.hbase_column_manager.MConnection;

public class MConnectionFactory {
    static final String COLUMN_MANAGER_CONFIG_FILE = "hbase-column-manager.xml";

    MConnectionFactory() {
    }

    public static Connection createConnection() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.addResource(COLUMN_MANAGER_CONFIG_FILE);
        return new MConnection(ConnectionFactory.createConnection((Configuration)conf));
    }

    static MConnection getMConnection(Connection standardConnection) throws IOException {
        standardConnection.getConfiguration().addResource(COLUMN_MANAGER_CONFIG_FILE);
        return new MConnection(standardConnection);
    }

    public static Connection createConnection(Configuration conf) throws IOException {
        return new MConnection(ConnectionFactory.createConnection((Configuration)conf));
    }

    public static Connection createConnection(Configuration conf, ExecutorService pool) throws IOException {
        return new MConnection(ConnectionFactory.createConnection((Configuration)conf, (ExecutorService)pool));
    }

    public static Connection createConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        return new MConnection(ConnectionFactory.createConnection((Configuration)conf, (ExecutorService)pool, (User)user));
    }

    public static Connection createConnection(Configuration conf, User user) throws IOException {
        return new MConnection(ConnectionFactory.createConnection((Configuration)conf, (User)user));
    }
}

