/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.commonvox.hbase_column_manager.MAdmin;
import org.commonvox.hbase_column_manager.MBufferedMutator;
import org.commonvox.hbase_column_manager.MTable;
import org.commonvox.hbase_column_manager.Repository;

class MConnection
implements Connection,
Closeable,
AutoCloseable {
    private final Connection STANDARD_HBASE_CONNECTION;
    private final Repository REPOSITORY;

    MConnection(Connection hBaseClientConnection) throws IOException {
        this.STANDARD_HBASE_CONNECTION = hBaseClientConnection;
        this.REPOSITORY = new Repository(this.STANDARD_HBASE_CONNECTION, this);
    }

    Repository getRepository() {
        return this.REPOSITORY;
    }

    Connection getStandardConnection() {
        return this.STANDARD_HBASE_CONNECTION;
    }

    public Admin getAdmin() throws IOException {
        return new MAdmin(this.STANDARD_HBASE_CONNECTION.getAdmin(), this.REPOSITORY);
    }

    public Table getTable(TableName tn) throws IOException {
        return new MTable(this.STANDARD_HBASE_CONNECTION.getTable(tn), this.REPOSITORY);
    }

    public Table getTable(TableName tn, ExecutorService es) throws IOException {
        return new MTable(this.STANDARD_HBASE_CONNECTION.getTable(tn, es), this.REPOSITORY);
    }

    public BufferedMutator getBufferedMutator(TableName tn) throws IOException {
        return new MBufferedMutator(this.STANDARD_HBASE_CONNECTION.getBufferedMutator(tn), this.REPOSITORY);
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams bmp) throws IOException {
        return new MBufferedMutator(this.STANDARD_HBASE_CONNECTION.getBufferedMutator(bmp), this.REPOSITORY);
    }

    public Configuration getConfiguration() {
        return this.STANDARD_HBASE_CONNECTION.getConfiguration();
    }

    public RegionLocator getRegionLocator(TableName tn) throws IOException {
        return this.STANDARD_HBASE_CONNECTION.getRegionLocator(tn);
    }

    @Override
    public void close() throws IOException {
        this.STANDARD_HBASE_CONNECTION.close();
    }

    public boolean isClosed() {
        return this.STANDARD_HBASE_CONNECTION.isClosed();
    }

    public void abort(String string, Throwable thrwbl) {
        this.STANDARD_HBASE_CONNECTION.abort(string, thrwbl);
    }

    public boolean isAborted() {
        return this.STANDARD_HBASE_CONNECTION.isAborted();
    }

    public boolean equals(Object otherObject) {
        return this.STANDARD_HBASE_CONNECTION.equals(otherObject);
    }

    public int hashCode() {
        return this.STANDARD_HBASE_CONNECTION.hashCode();
    }
}

