/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.commonvox.hbase_column_manager.ColumnAuditor;
import org.commonvox.hbase_column_manager.ColumnDefinition;
import org.commonvox.hbase_column_manager.Repository;
import org.commonvox.hbase_column_manager.SchemaEntity;

class MColumnDescriptor
extends HColumnDescriptor {
    private final Map<byte[], ColumnAuditor> columnAuditors = new TreeMap<byte[], ColumnAuditor>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    private final Map<byte[], ColumnDefinition> columnDefinitions = new TreeMap<byte[], ColumnDefinition>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    private byte[] foreignKeyValue;
    static final String COL_DEFINITIONS_ENFORCED_KEY = "_ColDefinitionsEnforced";
    static final String COL_ALIASES_ENABLED_KEY = "_ColAliasesEnabled";

    public MColumnDescriptor(byte[] colFamily) {
        super(colFamily);
    }

    public MColumnDescriptor(HColumnDescriptor desc) {
        super(desc);
        if (MColumnDescriptor.class.isAssignableFrom(desc.getClass())) {
            MColumnDescriptor mcd = (MColumnDescriptor)desc;
            for (ColumnAuditor columnAuditor : mcd.columnAuditors.values()) {
                this.columnAuditors.put(columnAuditor.getName(), new ColumnAuditor(columnAuditor));
            }
            for (ColumnDefinition colDefinition : mcd.columnDefinitions.values()) {
                this.columnDefinitions.put(colDefinition.getName(), new ColumnDefinition(colDefinition));
            }
        }
    }

    MColumnDescriptor(HTableDescriptor htd, HColumnDescriptor hcd, Repository repository) throws IOException {
        super(hcd);
        for (ColumnAuditor columnAuditor : repository.getColumnAuditors(htd, hcd)) {
            this.columnAuditors.put(columnAuditor.getName(), columnAuditor);
        }
        for (ColumnDefinition colDefinition : repository.getColumnDefinitions(htd, hcd)) {
            this.columnDefinitions.put(colDefinition.getName(), colDefinition);
        }
    }

    MColumnDescriptor(SchemaEntity entity) {
        super(entity.getName());
        this.setForeignKey(entity.getForeignKey());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : entity.getValues().entrySet()) {
            this.setValue(entry.getKey().get(), entry.getValue().get());
        }
        for (Map.Entry<Object, Object> entry : entity.getConfiguration().entrySet()) {
            this.setConfiguration((String)entry.getKey(), (String)entry.getValue());
        }
    }

    MColumnDescriptor addColumnAuditor(ColumnAuditor columnAuditor) {
        this.columnAuditors.put(columnAuditor.getName(), columnAuditor);
        return this;
    }

    MColumnDescriptor addColumnAuditors(ColumnAuditor[] columnAuditors) {
        for (ColumnAuditor columnAuditor : columnAuditors) {
            this.columnAuditors.put(columnAuditor.getName(), columnAuditor);
        }
        return this;
    }

    MColumnDescriptor addColumnAuditors(Collection<ColumnAuditor> columnAuditors) {
        this.addColumnAuditors(columnAuditors.toArray(new ColumnAuditor[columnAuditors.size()]));
        return this;
    }

    Set<byte[]> getColumnQualifiers() {
        return this.columnAuditors.keySet();
    }

    Set<ColumnAuditor> getColumnAuditors() {
        return new TreeSet<ColumnAuditor>(this.columnAuditors.values());
    }

    MColumnDescriptor addColumnDefinition(ColumnDefinition columnDefinition) {
        this.columnDefinitions.put(columnDefinition.getName(), columnDefinition);
        return this;
    }

    MColumnDescriptor addColumnDefinitions(ColumnDefinition[] columnDefinitionArray) {
        for (ColumnDefinition columnDefinition : columnDefinitionArray) {
            this.columnDefinitions.put(columnDefinition.getName(), columnDefinition);
        }
        return this;
    }

    MColumnDescriptor addColumnDefinitions(Collection<ColumnDefinition> columnDefinitions) {
        this.addColumnDefinitions(columnDefinitions.toArray(new ColumnDefinition[columnDefinitions.size()]));
        return this;
    }

    Collection<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions.values();
    }

    ColumnDefinition getColumnDefinition(byte[] colQualifier) {
        return this.columnDefinitions.get(colQualifier);
    }

    byte[] getForeignKey() {
        return this.foreignKeyValue;
    }

    final void setForeignKey(byte[] foreignKeyValue) {
        this.foreignKeyValue = foreignKeyValue;
    }

    void enableColumnDefinitionEnforcement(boolean enabled) {
        this.setConfiguration(COL_DEFINITIONS_ENFORCED_KEY, String.valueOf(enabled));
    }

    boolean columnDefinitionsEnforced() {
        String enabledString = this.getConfigurationValue(COL_DEFINITIONS_ENFORCED_KEY);
        return enabledString == null ? false : Boolean.valueOf(enabledString);
    }

    void enableColumnAliases(boolean enabled) {
        this.setConfiguration(COL_ALIASES_ENABLED_KEY, String.valueOf(enabled));
    }

    boolean columnAliasesEnabled() {
        String enabledString = this.getConfigurationValue(COL_ALIASES_ENABLED_KEY);
        return enabledString == null ? false : Boolean.valueOf(enabledString);
    }

    public int compareTo(HColumnDescriptor other) {
        if (MColumnDescriptor.class.isAssignableFrom(other.getClass())) {
            MColumnDescriptor mcdOther = (MColumnDescriptor)other;
            int result = Bytes.compareTo((byte[])this.getName(), (byte[])mcdOther.getName());
            if (result == 0 && this.columnAuditors.size() != mcdOther.columnAuditors.size()) {
                result = Integer.valueOf(this.columnAuditors.size()).compareTo(mcdOther.columnAuditors.size());
            }
            if (result == 0) {
                Iterator<ColumnAuditor> it = this.columnAuditors.values().iterator();
                Iterator<ColumnAuditor> it2 = mcdOther.columnAuditors.values().iterator();
                while (it.hasNext() && (result = it.next().compareTo(it2.next())) == 0) {
                }
            }
            if (result != 0) {
                return result;
            }
        }
        return super.compareTo(other);
    }
}

