/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Row;
import org.commonvox.hbase_column_manager.MTableDescriptor;
import org.commonvox.hbase_column_manager.Repository;

class MBufferedMutator
implements BufferedMutator {
    private final BufferedMutator wrappedBufferedMutator;
    private final Repository repository;
    private final MTableDescriptor mTableDescriptor;
    private final boolean includedInRepositoryProcessing;

    MBufferedMutator(BufferedMutator userBufferedMutator, Repository repository) throws IOException {
        this.wrappedBufferedMutator = userBufferedMutator;
        this.repository = repository;
        if (this.repository.isActivated()) {
            this.mTableDescriptor = this.repository.getMTableDescriptor(this.wrappedBufferedMutator.getName());
            this.includedInRepositoryProcessing = repository.isIncludedTable(this.wrappedBufferedMutator.getName());
        } else {
            this.mTableDescriptor = null;
            this.includedInRepositoryProcessing = false;
        }
    }

    public TableName getName() {
        return this.wrappedBufferedMutator.getName();
    }

    public Configuration getConfiguration() {
        return this.wrappedBufferedMutator.getConfiguration();
    }

    public void mutate(Mutation mutation) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
            this.repository.validateColumns(this.mTableDescriptor, mutation);
        }
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap = this.repository.getFamilyQualifierToAliasMap(this.mTableDescriptor, mutation);
            Mutation convertedMutation = (Mutation)this.repository.convertQualifiersToAliases(this.mTableDescriptor, (Row)mutation, familyQualifierToAliasMap, 0);
            this.wrappedBufferedMutator.mutate(convertedMutation);
        } else {
            this.wrappedBufferedMutator.mutate(mutation);
        }
        if (this.includedInRepositoryProcessing) {
            this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, mutation);
        }
    }

    public void mutate(List<? extends Mutation> mutationList) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
            this.repository.validateColumns(this.mTableDescriptor, mutationList);
        }
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap = this.repository.getFamilyQualifierToAliasMap(this.mTableDescriptor, mutationList, 0);
            LinkedList<Mutation> convertedMutations = new LinkedList<Mutation>();
            for (Mutation mutation : mutationList) {
                if (!Mutation.class.isAssignableFrom(mutation.getClass())) continue;
                convertedMutations.add((Mutation)this.repository.convertQualifiersToAliases(this.mTableDescriptor, (Row)mutation, familyQualifierToAliasMap, 0));
            }
            this.wrappedBufferedMutator.mutate(convertedMutations);
        } else {
            this.wrappedBufferedMutator.mutate(mutationList);
        }
        if (this.includedInRepositoryProcessing) {
            this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, mutationList);
        }
    }

    public void close() throws IOException {
        this.wrappedBufferedMutator.close();
    }

    public void flush() throws IOException {
        this.wrappedBufferedMutator.flush();
    }

    public long getWriteBufferSize() {
        return this.wrappedBufferedMutator.getWriteBufferSize();
    }

    public boolean equals(Object otherObject) {
        return this.wrappedBufferedMutator.equals(otherObject);
    }

    public int hashCode() {
        return this.wrappedBufferedMutator.hashCode();
    }
}

