/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.commonvox.hbase_column_manager.MConfiguration;
import org.commonvox.hbase_column_manager.MConnection;
import org.commonvox.hbase_column_manager.MConnectionFactory;
import org.commonvox.hbase_column_manager.MTableDescriptor;
import org.commonvox.hbase_column_manager.Repository;

class ColumnDiscoveryTool
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ColumnDiscoveryTool.class);
    String sourceTableNameString = null;
    boolean includeAllCells = false;

    ColumnDiscoveryTool() {
    }

    Job createSubmittableJob(String[] args) throws IOException {
        if (!this.parseArguments(args)) {
            return null;
        }
        this.getConf().setBoolean("mapreduce.map.speculative", true);
        this.getConf().set("colmanager.map.source.table", this.sourceTableNameString);
        Job job = Job.getInstance((Configuration)this.getConf(), (String)this.getConf().get("mapreduce.job.name", this.sourceTableNameString));
        TableMapReduceUtil.addDependencyJars((Job)job);
        Scan scan = new Scan();
        scan.setCaching(this.getConf().getInt("hbase.mapreduce.scan.cachedrows", 500));
        scan.setCacheBlocks(false);
        scan.setFilter((Filter)new KeyOnlyFilter(true));
        if (this.includeAllCells) {
            scan.setMaxVersions();
        }
        TableMapReduceUtil.initTableMapperJob((String)this.sourceTableNameString, (Scan)scan, ColumnDiscoveryMapper.class, null, null, (Job)job);
        job.setOutputFormatClass(NullOutputFormat.class);
        return job;
    }

    private boolean parseArguments(String[] args) {
        if (args.length < 1) {
            return false;
        }
        block8: for (String arg : args) {
            String[] keyValuePair = arg.substring("--".length()).split("=");
            if (keyValuePair == null || keyValuePair.length != 2) {
                LOG.warn((Object)("ERROR in MapReduce " + ((Object)((Object)this)).getClass().getSimpleName() + " submission: Invalid argument '" + arg + "'"));
                return false;
            }
            switch (keyValuePair[0]) {
                case "colmanager.map.source.table": {
                    this.sourceTableNameString = keyValuePair[1];
                    continue block8;
                }
                case "include_all_cells": {
                    this.includeAllCells = keyValuePair[1].equalsIgnoreCase(Boolean.TRUE.toString());
                }
            }
        }
        if (this.sourceTableNameString == null) {
            System.err.println("ERROR: Required TABLE argument is missing.");
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Configuration)MConfiguration.create(), (Tool)new ColumnDiscoveryTool(), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        Job job = this.createSubmittableJob(args);
        if (job == null) {
            return 1;
        }
        if (!job.waitForCompletion(true)) {
            LOG.info((Object)(((Object)((Object)this)).getClass().getSimpleName() + " mapreduce job failed!"));
            return 1;
        }
        return 0;
    }

    static class ColumnDiscoveryMapper
    extends TableMapper<Text, Text> {
        private static final Log LOG = LogFactory.getLog(ColumnDiscoveryMapper.class);
        private Repository repository = null;
        private MTableDescriptor mtd;
        private MConnection columnManagerConnection = null;

        ColumnDiscoveryMapper() {
        }

        protected void setup(Mapper.Context context) {
            try {
                this.columnManagerConnection = (MConnection)MConnectionFactory.createConnection();
                this.repository = this.columnManagerConnection.getRepository();
                this.mtd = this.repository.getMTableDescriptor(TableName.valueOf((String)context.getConfiguration().get("colmanager.map.source.table")));
            }
            catch (IOException e) {
                this.columnManagerConnection = null;
                this.repository = null;
                LOG.warn((Object)(((Object)((Object)this)).getClass().getSimpleName() + "mapper failed to get connection!"));
            }
        }

        protected void cleanup(Mapper.Context context) {
            if (this.columnManagerConnection != null) {
                try {
                    this.columnManagerConnection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws InterruptedException, IOException {
            if (this.columnManagerConnection == null || this.columnManagerConnection.isClosed() || this.columnManagerConnection.isAborted() || this.repository == null || this.mtd == null) {
                return;
            }
            this.repository.putDiscoveredColumnAuditors(this.mtd, value, true);
        }
    }
}

