/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import org.apache.hadoop.hbase.util.Bytes;
import org.commonvox.hbase_column_manager.Repository;
import org.commonvox.hbase_column_manager.SchemaEntityType;

public class ChangeEvent
implements Comparable<ChangeEvent> {
    private Entity entity;
    private AttributeName attributeName;
    private Timestamp timestamp;
    private AttributeValue attributeValue;
    private UserName userName;

    ChangeEvent(byte entityType, byte[] parentForeignKey, byte[] entityName, byte[] entityForeignKey, byte[] attributeName, long timestamp, byte[] attributeValue, byte[] userName) {
        this.setEntity(entityType, parentForeignKey, entityName, entityForeignKey);
        this.setAttributeName(attributeName);
        this.setTimestamp(timestamp);
        this.setAttributeValue(attributeValue);
        this.setUserName(userName);
    }

    private ChangeEvent() {
    }

    Entity getEntity() {
        return this.entity;
    }

    private void setEntity(byte entityType, byte[] parentForeignKey, byte[] entityName, byte[] entityForeignKey) {
        this.entity = new Entity(entityType, parentForeignKey, entityName);
        this.entity.setEntityForeignKey(entityForeignKey);
    }

    void setEntity(Entity entity) {
        this.entity = entity;
    }

    SchemaEntityType getEntityType() {
        return SchemaEntityType.ENTITY_TYPE_BYTE_TO_ENUM_MAP.get(this.entity.getEntityRecordType().getBytes()[0]);
    }

    public String getEntityTypeAsString() {
        return SchemaEntityType.ENTITY_TYPE_BYTE_TO_ENUM_MAP.get(this.entity.getEntityRecordType().getBytes()[0]).toString();
    }

    byte[] getParentForeignKey() {
        return this.entity.getParentForeignKey().getBytes();
    }

    ParentForeignKey getParentForeignKeyObject() {
        return this.entity.getParentForeignKey();
    }

    public byte[] getEntityName() {
        return this.entity.getEntityName().getBytes();
    }

    public String getEntityNameAsString() {
        return Repository.getPrintableString(this.entity.getEntityName().getBytes());
    }

    EntityName getEntityNameObject() {
        return this.entity.getEntityName();
    }

    public String getNamespaceAsString() {
        return this.entity.getNamespaceAsString();
    }

    public String getTableNameAsString() {
        return this.entity.getTableNameAsString();
    }

    public String getColumnFamilyAsString() {
        return this.entity.getColumnFamilyAsString();
    }

    public String getColumnQualifierAsString() {
        return this.entity.getColumnQualifierAsString();
    }

    byte[] getEntityForeignKey() {
        return this.entity.getEntityForeignKey().getBytes();
    }

    EntityForeignKey getEntityForeignKeyObject() {
        return this.entity.getEntityForeignKey();
    }

    public long getTimestamp() {
        return this.timestamp.getLong();
    }

    public String getTimestampAsString() {
        return String.valueOf(this.timestamp.getLong());
    }

    Timestamp getTimestampObject() {
        return this.timestamp;
    }

    private void setTimestamp(long timestamp) {
        this.timestamp = new Timestamp(timestamp);
    }

    public byte[] getUserName() {
        return this.userName.getBytes();
    }

    public String getUserNameAsString() {
        return Repository.getPrintableString(this.userName.getBytes());
    }

    UserName getUserNameObject() {
        return this.userName;
    }

    private void setUserName(byte[] userName) {
        this.userName = new UserName(userName);
    }

    public byte[] getAttributeName() {
        return this.attributeName.getBytes();
    }

    public String getAttributeNameAsString() {
        return Repository.getPrintableString(this.attributeName.getBytes());
    }

    AttributeName getAttributeNameObject() {
        return this.attributeName;
    }

    private void setAttributeName(byte[] attributeName) {
        this.attributeName = new AttributeName(attributeName);
    }

    public byte[] getAttributeValue() {
        return this.attributeValue.getBytes();
    }

    public String getAttributeValueAsString() {
        return Repository.getPrintableString(this.attributeValue.getBytes());
    }

    AttributeValue getAttributeValueObject() {
        return this.attributeValue;
    }

    private void setAttributeValue(byte[] attributeValue) {
        this.attributeValue = new AttributeValue(attributeValue);
    }

    public String toString() {
        return "EntityType:<" + this.getEntityTypeAsString() + "> EntityName:<" + this.getEntityNameAsString() + "> Timestamp:<" + this.getTimestamp() + "> AttributeName:<" + this.getAttributeNameAsString() + "> AttributeValue:<" + this.getAttributeValueAsString() + ">";
    }

    @Override
    public int compareTo(ChangeEvent other) {
        int result = this.timestamp.compareTo(other.timestamp);
        if (result == 0) {
            result = this.userName.compareTo(other.userName);
        }
        if (result == 0) {
            result = this.entity.compareTo(other.entity);
        }
        if (result == 0) {
            result = this.attributeName.compareTo(other.attributeName);
        }
        if (result == 0) {
            result = this.attributeValue.compareTo(other.attributeValue);
        }
        return result;
    }

    static class UserName
    extends BytesContainer {
        UserName(byte[] bytes) {
            super(bytes);
        }

        UserName(String userName) {
            super(Bytes.toBytes((String)userName));
        }
    }

    static class AttributeValue
    extends BytesContainer {
        AttributeValue(byte[] bytes) {
            super(bytes);
        }
    }

    static class Timestamp
    extends BytesContainer {
        Timestamp(long timestamp) {
            super(Bytes.toBytes((long)timestamp));
        }

        long getLong() {
            return Bytes.toLong((byte[])this.getBytes());
        }
    }

    static class AttributeName
    extends BytesContainer {
        AttributeName(byte[] bytes) {
            super(bytes);
        }
    }

    static class EntityForeignKey
    extends BytesContainer {
        EntityForeignKey(byte[] bytes) {
            super(bytes);
        }
    }

    static class EntityName
    extends BytesContainer {
        EntityName(byte[] bytes) {
            super(bytes);
        }

        public String toString() {
            return Bytes.toString((byte[])this.getBytes());
        }
    }

    static class ParentForeignKey
    extends BytesContainer {
        ParentForeignKey(byte[] bytes) {
            super(bytes);
        }
    }

    static class EntityType
    extends BytesContainer {
        EntityType(byte entityRecordType) {
            super(new byte[]{entityRecordType});
        }

        public byte getByte() {
            return this.getBytes()[0];
        }

        public String toString() {
            return "EntityType:<" + Bytes.toString((byte[])this.getBytes()) + ">";
        }
    }

    private static class BytesContainer
    implements Comparable<BytesContainer> {
        private final byte[] bytes;

        BytesContainer(byte[] bytes) {
            this.bytes = bytes == null ? new byte[0] : bytes;
        }

        byte[] getBytes() {
            return this.bytes;
        }

        @Override
        public int compareTo(BytesContainer other) {
            return Bytes.compareTo((byte[])this.bytes, (byte[])other.bytes);
        }

        public boolean equals(Object other) {
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            return this.compareTo((BytesContainer)other) == 0;
        }
    }

    static class Entity
    implements Comparable<Entity> {
        private final EntityType entityType;
        private final ParentForeignKey parentForeignKey;
        private final EntityName entityName;
        private EntityForeignKey entityForeignKey;
        private Entity namespace = null;
        private Entity table = null;
        private Entity colFamily = null;
        private Entity column = null;

        Entity(byte entityType, byte[] parentForeignKey, byte[] entityName) {
            this.entityType = new EntityType(entityType);
            this.parentForeignKey = new ParentForeignKey(parentForeignKey);
            this.entityName = new EntityName(entityName);
        }

        EntityType getEntityRecordType() {
            return this.entityType;
        }

        ParentForeignKey getParentForeignKey() {
            return this.parentForeignKey;
        }

        EntityName getEntityName() {
            return this.entityName;
        }

        void setEntityForeignKey(byte[] entityForeignKey) {
            this.entityForeignKey = new EntityForeignKey(entityForeignKey);
        }

        EntityForeignKey getEntityForeignKey() {
            return this.entityForeignKey;
        }

        void setNamespaceEntity(Entity namespaceEntity) {
            this.namespace = namespaceEntity;
        }

        byte[] getNamespace() {
            return this.namespace.getEntityName().getBytes();
        }

        String getNamespaceAsString() {
            return this.extractEntityNameAsString(this.namespace);
        }

        void setTableEntity(Entity tableEntity) {
            this.table = tableEntity;
        }

        byte[] getTableName() {
            return this.table.getEntityName().getBytes();
        }

        String getTableNameAsString() {
            return this.extractEntityNameAsString(this.table);
        }

        void setColumnFamilyEntity(Entity colFamilyEntity) {
            this.colFamily = colFamilyEntity;
        }

        byte[] getColumnFamily() {
            return this.colFamily.getEntityName().getBytes();
        }

        String getColumnFamilyAsString() {
            return this.extractEntityNameAsString(this.colFamily);
        }

        void setColumnQualifierEntity(Entity columnEntity) {
            this.column = columnEntity;
        }

        byte[] getColumnQualifier() {
            return this.column.getEntityName().getBytes();
        }

        String getColumnQualifierAsString() {
            return this.extractEntityNameAsString(this.column);
        }

        private byte[] extractEntityNameAsBytes(Entity entity) {
            return entity.getEntityName().getBytes();
        }

        private String extractEntityNameAsString(Entity entity) {
            return entity == null ? "" : entity.getEntityName().toString();
        }

        @Override
        public int compareTo(Entity other) {
            int comparison = this.entityType.compareTo(other.entityType);
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.entityName.compareTo(other.entityName);
            if (comparison != 0) {
                return comparison;
            }
            return this.parentForeignKey.compareTo(other.parentForeignKey);
        }

        public boolean equals(Object other) {
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            return this.compareTo((Entity)other) == 0;
        }

        public String toString() {
            return this.entityType + " EntityName:<" + this.entityName + ">";
        }
    }
}

