/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.commonvox.hbase_column_manager.MColumnDescriptor;
import org.commonvox.hbase_column_manager.Repository;
import org.commonvox.hbase_column_manager.SchemaEntity;

class MTableDescriptor
extends HTableDescriptor {
    private byte[] foreignKeyValue;

    MTableDescriptor() {
    }

    MTableDescriptor(byte[] name) {
        super(name);
    }

    MTableDescriptor(String name) {
        super(name);
    }

    public MTableDescriptor(HTableDescriptor desc) {
        super(desc);
    }

    MTableDescriptor(TableName name) {
        super(name);
    }

    MTableDescriptor(HTableDescriptor htd, Repository repository) throws IOException {
        super(htd);
        for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
            this.removeFamily(hcd.getName());
            this.addFamily(new MColumnDescriptor(htd, hcd, repository));
        }
    }

    MTableDescriptor(SchemaEntity entity) {
        super(entity.getName());
        this.setForeignKey(entity.getForeignKey());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : entity.getValues().entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : entity.getConfiguration().entrySet()) {
            this.setConfiguration((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public MColumnDescriptor[] getMColumnDescriptorArray() {
        Collection<MColumnDescriptor> mColumnDescriptors = this.getMColumnDescriptors();
        return mColumnDescriptors.toArray(new MColumnDescriptor[mColumnDescriptors.size()]);
    }

    public Collection<MColumnDescriptor> getMColumnDescriptors() {
        ArrayList<MColumnDescriptor> mColumnDescriptors = new ArrayList<MColumnDescriptor>();
        for (HColumnDescriptor hcd : this.getColumnFamilies()) {
            if (!MColumnDescriptor.class.isAssignableFrom(hcd.getClass())) continue;
            mColumnDescriptors.add((MColumnDescriptor)hcd);
        }
        return mColumnDescriptors;
    }

    public MColumnDescriptor getMColumnDescriptor(byte[] colFamily) {
        HColumnDescriptor hcd = this.getFamily(colFamily);
        if (MColumnDescriptor.class.isAssignableFrom(hcd.getClass())) {
            return (MColumnDescriptor)hcd;
        }
        return null;
    }

    final void setForeignKey(byte[] foreignKeyValue) {
        this.foreignKeyValue = foreignKeyValue;
    }

    byte[] getForeignKey() {
        return this.foreignKeyValue;
    }

    boolean hasColumnDefinitions() {
        for (MColumnDescriptor mcd : this.getMColumnDescriptors()) {
            if (mcd.getColumnDefinitions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    boolean hasColDescriptorWithColDefinitionsEnforced() {
        for (MColumnDescriptor mcd : this.getMColumnDescriptors()) {
            if (!mcd.columnDefinitionsEnforced()) continue;
            return true;
        }
        return false;
    }

    boolean hasColDescriptorWithColAliasesEnabled() {
        for (MColumnDescriptor mcd : this.getMColumnDescriptors()) {
            if (!mcd.columnAliasesEnabled()) continue;
            return true;
        }
        return false;
    }
}

