/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.util.Map;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.commonvox.hbase_column_manager.SchemaEntity;
import org.commonvox.hbase_column_manager.SchemaEntityType;

class MNamespaceDescriptor
extends SchemaEntity {
    public MNamespaceDescriptor(byte[] namespaceName) {
        super(SchemaEntityType.NAMESPACE.getRecordType(), namespaceName);
    }

    public MNamespaceDescriptor(String namespaceName) {
        super(SchemaEntityType.NAMESPACE.getRecordType(), namespaceName);
    }

    public MNamespaceDescriptor(NamespaceDescriptor nd) {
        super(SchemaEntityType.NAMESPACE.getRecordType(), nd.getName());
        for (Map.Entry configEntry : nd.getConfiguration().entrySet()) {
            this.setConfiguration((String)configEntry.getKey(), (String)configEntry.getValue());
        }
    }

    MNamespaceDescriptor(SchemaEntity entity) {
        super(SchemaEntityType.NAMESPACE.getRecordType(), entity.getName());
        this.setForeignKey(entity.getForeignKey());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : entity.getValues().entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : entity.getConfiguration().entrySet()) {
            this.setConfiguration((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public NamespaceDescriptor getNamespaceDescriptor() {
        NamespaceDescriptor nd = NamespaceDescriptor.create((String)Bytes.toString((byte[])this.getName())).build();
        for (Map.Entry<String, String> configEntry : this.getConfiguration().entrySet()) {
            nd.setConfiguration(configEntry.getKey(), configEntry.getValue());
        }
        return nd;
    }

    @Override
    public MNamespaceDescriptor setValue(String key, String value) {
        super.setValue(key, value);
        return this;
    }

    @Override
    public MNamespaceDescriptor setValue(byte[] key, byte[] value) {
        super.setValue(key, value);
        return this;
    }

    @Override
    public MNamespaceDescriptor setValue(ImmutableBytesWritable key, ImmutableBytesWritable value) {
        super.setValue(key, value);
        return this;
    }

    @Override
    public MNamespaceDescriptor setConfiguration(String key, String value) {
        super.setConfiguration(key, value);
        return this;
    }
}

