/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.commonvox.hbase_column_manager.HBaseSchemaArchive;
import org.commonvox.hbase_column_manager.Repository;
import org.commonvox.hbase_column_manager.SchemaEntity;

class ColumnQualifierReport {
    static final CSVFormat CSV_FORMAT = CSVFormat.DEFAULT.withRecordSeparator("\n").withCommentMarker('#').withHeader(ReportHeader.class);
    private final Repository repository;
    private final String sourceNamespace;
    private final TableName sourceTableName;
    private final byte[] sourceColFamily;
    private final File targetFile;
    private boolean recordsWrittenToReport = false;
    private String namespaceReportString;
    private String tableReportString;
    private String colFamilyReportString;
    private String colQualifierReportString;
    private String colMaxLengthReportString;

    ColumnQualifierReport(String namespace, TableName tableName, byte[] colFamily, Repository repository, File targetFile) throws IOException {
        this.sourceNamespace = namespace;
        this.sourceTableName = tableName;
        this.sourceColFamily = colFamily;
        this.repository = repository;
        this.targetFile = targetFile;
        this.outputReport();
    }

    private void outputReport() throws IOException {
        HBaseSchemaArchive hsa = new HBaseSchemaArchive(this.sourceNamespace, this.sourceTableName, this.repository);
        StringBuilder headerCommentsBuilder = new StringBuilder("Report on ColumnAuditors");
        if (this.sourceNamespace == null && this.sourceTableName == null) {
            headerCommentsBuilder.append(" in ALL ColumnManager-included Tables in ALL Namespaces");
        } else {
            if (this.sourceNamespace != null) {
                headerCommentsBuilder.append(" in Namespace <").append(this.sourceNamespace).append(">");
            }
            if (this.sourceTableName != null) {
                headerCommentsBuilder.append(" in Table <").append(this.sourceTableName.getNameAsString()).append(">");
            }
            if (this.sourceColFamily != null) {
                headerCommentsBuilder.append(" in Column Family <").append(Bytes.toString((byte[])this.sourceColFamily)).append(">");
            }
            headerCommentsBuilder.append(" -- Generated by ").append("ColumnManagerAPI").append(":").append(this.getClass().getSimpleName());
        }
        try (CSVPrinter csvPrinter = CSV_FORMAT.withHeaderComments(headerCommentsBuilder, new Date()).print(new FileWriter(this.targetFile));){
            this.namespaceReportString = "";
            this.tableReportString = "";
            this.colFamilyReportString = "";
            this.colQualifierReportString = "";
            this.colMaxLengthReportString = "";
            this.printReport(csvPrinter, hsa.getSchemaEntities());
        }
    }

    void printReport(CSVPrinter csvPrinter, Set<SchemaEntity> schemaEntities) throws IOException {
        for (SchemaEntity entity : schemaEntities) {
            switch (entity.getSchemaEntityType()) {
                case NAMESPACE: {
                    this.namespaceReportString = entity.getNameAsString();
                    this.tableReportString = "";
                    this.colFamilyReportString = "";
                    this.colQualifierReportString = "";
                    this.colMaxLengthReportString = "";
                    this.printReport(csvPrinter, entity.getChildren());
                    break;
                }
                case TABLE: {
                    this.tableReportString = entity.getNameAsString();
                    this.printReport(csvPrinter, entity.getChildren());
                    break;
                }
                case COLUMN_FAMILY: {
                    this.colFamilyReportString = entity.getNameAsString();
                    if (this.sourceColFamily != null && !this.colFamilyReportString.equals(Bytes.toString((byte[])this.sourceColFamily))) break;
                    this.printReport(csvPrinter, entity.getChildren());
                    break;
                }
                case COLUMN_AUDITOR: {
                    this.colQualifierReportString = entity.getNameAsString();
                    this.colMaxLengthReportString = entity.getValue("MAX_VALUE_LENGTH_FOUND");
                    csvPrinter.print(this.namespaceReportString);
                    csvPrinter.print(this.tableReportString);
                    csvPrinter.print(this.colFamilyReportString);
                    csvPrinter.print(this.colQualifierReportString);
                    csvPrinter.print(this.colMaxLengthReportString);
                    csvPrinter.println();
                    this.recordsWrittenToReport = true;
                }
            }
        }
    }

    boolean isEmpty() {
        return !this.recordsWrittenToReport;
    }

    static enum ReportHeader {
        NAMESPACE,
        TABLE,
        COLUMN_FAMILY,
        COLUMN_QUALIFIER,
        COLUMN_MAX_LENGTH;

    }

    static enum ReportType {
        QUALIFIER,
        LENGTH,
        VALUE;

    }
}

