/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.commonvox.hbase_column_manager.Column;
import org.commonvox.hbase_column_manager.SchemaEntity;
import org.commonvox.hbase_column_manager.SchemaEntityType;

public class ColumnDefinition
extends Column {
    static final String COLUMN_LENGTH_KEY = "COLUMN_LENGTH";
    static final Long COLUMN_LENGTH_DEFAULT_VALUE = 0L;
    static final String COLUMN_VALIDATION_REGEX_KEY = "COLUMN_VALIDATION_REGEX";

    public ColumnDefinition(byte[] columnQualifier) {
        super(SchemaEntityType.COLUMN_DEFINITION.getRecordType(), columnQualifier);
    }

    public ColumnDefinition(String columnQualifier) {
        super(SchemaEntityType.COLUMN_DEFINITION.getRecordType(), columnQualifier);
    }

    ColumnDefinition(SchemaEntity entity) {
        super(SchemaEntityType.COLUMN_DEFINITION.getRecordType(), entity.getName());
        this.setForeignKey(entity.getForeignKey());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : entity.getValues().entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : entity.getConfiguration().entrySet()) {
            this.setConfiguration((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    final ColumnDefinition setValue(String key, String value) {
        super.setValue(key, value);
        return this;
    }

    @Override
    final ColumnDefinition setValue(byte[] key, byte[] value) {
        super.setValue(key, value);
        return this;
    }

    @Override
    final ColumnDefinition setValue(ImmutableBytesWritable key, ImmutableBytesWritable value) {
        super.setValue(key, value);
        return this;
    }

    @Override
    final ColumnDefinition setConfiguration(String key, String value) {
        super.setConfiguration(key, value);
        return this;
    }

    public ColumnDefinition setColumnLength(long columnLength) {
        return this.setValue(COLUMN_LENGTH_KEY, Long.toString(columnLength));
    }

    public long getColumnLength() {
        String value = this.getValue(COLUMN_LENGTH_KEY);
        return value == null ? COLUMN_LENGTH_DEFAULT_VALUE : Long.valueOf(value);
    }

    public ColumnDefinition setColumnValidationRegex(String regexString) {
        return this.setValue(COLUMN_VALIDATION_REGEX_KEY, regexString);
    }

    public String getColumnValidationRegex() {
        String value = this.getValue(COLUMN_VALIDATION_REGEX_KEY);
        return value == null ? "" : value;
    }
}

