/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.commonvox.hbase_column_manager.ChangeEvent;
import org.commonvox.hbase_column_manager.Repository;
import org.commonvox.hbase_column_manager.SchemaEntityType;

public class ChangeEventMonitor {
    private static final char COMMA = ',';
    private Set<ChangeEvent.Entity> entitySet = new TreeSet<ChangeEvent.Entity>();
    private final Set<ChangeEvent> changeEventsByTimestamp = new TreeSet<ChangeEvent>();
    private final Set<ChangeEvent> changeEventsByUser = new TreeSet<ChangeEvent>(new Comparator<ChangeEvent>(){

        @Override
        public int compare(ChangeEvent ce1, ChangeEvent ce2) {
            int result = ce1.getUserNameObject().compareTo(ce2.getUserNameObject());
            if (result == 0) {
                result = ce1.getTimestampObject().compareTo(ce2.getTimestampObject());
            }
            if (result == 0) {
                result = ce1.getEntity().compareTo(ce2.getEntity());
            }
            if (result == 0) {
                result = ce1.getAttributeNameObject().compareTo(ce2.getAttributeNameObject());
            }
            if (result == 0) {
                result = ce1.getAttributeValueObject().compareTo(ce2.getAttributeValueObject());
            }
            return result;
        }
    });
    private Set<ChangeEvent> changeEventsByEntity = new TreeSet<ChangeEvent>(new Comparator<ChangeEvent>(){

        @Override
        public int compare(ChangeEvent ce1, ChangeEvent ce2) {
            int result = ce1.getEntity().compareTo(ce2.getEntity());
            if (result == 0) {
                result = ce1.getTimestampObject().compareTo(ce2.getTimestampObject());
            }
            if (result == 0) {
                result = ce1.getAttributeNameObject().compareTo(ce2.getAttributeNameObject());
            }
            if (result == 0) {
                result = ce1.getAttributeValueObject().compareTo(ce2.getAttributeValueObject());
            }
            return result;
        }
    });
    private static final Charset ENCODING = StandardCharsets.UTF_8;

    ChangeEventMonitor(Table repositoryTable) throws IOException {
        try (ResultScanner rows = repositoryTable.getScanner(new Scan().setMaxVersions());){
            for (Result row : rows) {
                Repository.RowId rowId = new Repository.RowId(row.getRow());
                byte entityType = rowId.getEntityType();
                byte[] entityName = rowId.getEntityName();
                byte[] parentForeignKey = rowId.getParentForeignKey();
                byte[] entityForeignKey = row.getValue(Repository.REPOSITORY_CF, Repository.FOREIGN_KEY_COLUMN);
                HashMap<Long, byte[]> userNameKeyedByTimestampMap = new HashMap<Long, byte[]>();
                for (Cell cell : row.getColumnCells(Repository.REPOSITORY_CF, Repository.JAVA_USERNAME_PROPERTY_KEY)) {
                    userNameKeyedByTimestampMap.put(cell.getTimestamp(), Bytes.getBytes((ByteBuffer)CellUtil.getValueBufferShallowCopy((Cell)cell)));
                }
                for (Map.Entry entry : row.getMap().entrySet()) {
                    for (Map.Entry colEntry : ((NavigableMap)entry.getValue()).entrySet()) {
                        byte[] attributeName = (byte[])colEntry.getKey();
                        if (Bytes.equals((byte[])attributeName, (byte[])Repository.FOREIGN_KEY_COLUMN) || Bytes.equals((byte[])attributeName, (byte[])Repository.JAVA_USERNAME_PROPERTY_KEY) || Bytes.equals((byte[])attributeName, (byte[])Repository.MAX_VALUE_QUALIFIER) || Bytes.equals((byte[])attributeName, (byte[])Repository.COL_COUNTER_QUALIFIER) || Bytes.equals((byte[])attributeName, (byte[])Repository.CELL_COUNTER_QUALIFIER)) continue;
                        for (Map.Entry cellEntry : ((NavigableMap)colEntry.getValue()).entrySet()) {
                            long timestamp = (Long)cellEntry.getKey();
                            byte[] attributeValue = (byte[])cellEntry.getValue();
                            byte[] userName = (byte[])userNameKeyedByTimestampMap.get(timestamp);
                            ChangeEvent changeEvent = new ChangeEvent(entityType, parentForeignKey, entityName, entityForeignKey, attributeName, timestamp, attributeValue, userName);
                            this.changeEventsByEntity.add(changeEvent);
                            this.entitySet.add(changeEvent.getEntity());
                        }
                    }
                }
            }
        }
        this.denormalize();
    }

    private void denormalize() {
        TreeMap<byte[], ChangeEvent.Entity> entityForeignKeyMap = new TreeMap<byte[], ChangeEvent.Entity>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        for (ChangeEvent.Entity entity : this.entitySet) {
            entityForeignKeyMap.put(entity.getEntityForeignKey().getBytes(), entity);
        }
        TreeSet<ChangeEvent> denormalizedChangeEventsByEntity = new TreeSet<ChangeEvent>(((TreeSet)this.changeEventsByEntity).comparator());
        TreeSet<ChangeEvent.Entity> denormalizedEntitySet = new TreeSet<ChangeEvent.Entity>();
        ChangeEvent.Entity denormalizedEntity = null;
        for (ChangeEvent event : this.changeEventsByEntity) {
            ChangeEvent.Entity entity = event.getEntity();
            if (denormalizedEntity == null || entity.compareTo(denormalizedEntity) != 0) {
                byte[] namespaceForeignKey = new byte[]{32};
                byte[] tableForeignKey = new byte[]{32};
                byte[] colFamilyForeignKey = new byte[]{32};
                byte[] colQualifierForeignKey = new byte[]{32};
                switch (event.getEntityType()) {
                    case NAMESPACE: {
                        namespaceForeignKey = entity.getEntityForeignKey().getBytes();
                        break;
                    }
                    case TABLE: {
                        tableForeignKey = entity.getEntityForeignKey().getBytes();
                        namespaceForeignKey = entity.getParentForeignKey().getBytes();
                        break;
                    }
                    case COLUMN_FAMILY: {
                        colFamilyForeignKey = entity.getEntityForeignKey().getBytes();
                        tableForeignKey = entity.getParentForeignKey().getBytes();
                        namespaceForeignKey = ((ChangeEvent.Entity)entityForeignKeyMap.get(tableForeignKey)).getParentForeignKey().getBytes();
                        break;
                    }
                    case COLUMN_AUDITOR: 
                    case COLUMN_DEFINITION: {
                        colQualifierForeignKey = entity.getEntityForeignKey().getBytes();
                        colFamilyForeignKey = entity.getParentForeignKey().getBytes();
                        tableForeignKey = ((ChangeEvent.Entity)entityForeignKeyMap.get(colFamilyForeignKey)).getParentForeignKey().getBytes();
                        namespaceForeignKey = ((ChangeEvent.Entity)entityForeignKeyMap.get(tableForeignKey)).getParentForeignKey().getBytes();
                    }
                }
                entity.setNamespaceEntity((ChangeEvent.Entity)entityForeignKeyMap.get(namespaceForeignKey));
                entity.setTableEntity((ChangeEvent.Entity)entityForeignKeyMap.get(tableForeignKey));
                entity.setColumnFamilyEntity((ChangeEvent.Entity)entityForeignKeyMap.get(colFamilyForeignKey));
                entity.setColumnQualifierEntity((ChangeEvent.Entity)entityForeignKeyMap.get(colQualifierForeignKey));
                denormalizedEntity = entity;
                denormalizedEntitySet.add(denormalizedEntity);
            }
            event.setEntity(denormalizedEntity);
            this.changeEventsByTimestamp.add(event);
            this.changeEventsByUser.add(event);
            denormalizedChangeEventsByEntity.add(event);
        }
        this.changeEventsByEntity = denormalizedChangeEventsByEntity;
        this.entitySet = denormalizedEntitySet;
    }

    public Set<ChangeEvent> getAllChangeEvents() {
        return this.changeEventsByTimestamp;
    }

    public Set<ChangeEvent> getAllChangeEventsByUserName() {
        return this.changeEventsByUser;
    }

    public Set<ChangeEvent> getChangeEventsForUserName(String userName) {
        LinkedHashSet<ChangeEvent> changeEventsForUser = new LinkedHashSet<ChangeEvent>();
        boolean userFound = false;
        ChangeEvent.UserName userNameObject = new ChangeEvent.UserName(userName);
        for (ChangeEvent ce : this.changeEventsByUser) {
            if (ce.getUserNameObject().equals(userNameObject)) {
                userFound = true;
                changeEventsForUser.add(ce);
                continue;
            }
            if (!userFound) continue;
            break;
        }
        return changeEventsForUser;
    }

    public Set<ChangeEvent> getChangeEventsForNamespace(byte[] namespaceName, boolean includeChildEntities) {
        return this.getChangeEventsForEntity(SchemaEntityType.NAMESPACE, namespaceName, null, null, null, includeChildEntities);
    }

    public Set<ChangeEvent> getChangeEventsForTable(TableName tableName, boolean includeChildEntities) {
        return this.getChangeEventsForEntity(SchemaEntityType.TABLE, tableName.getNamespace(), tableName.getName(), null, null, includeChildEntities);
    }

    public Set<ChangeEvent> getChangeEventsForTableAttribute(TableName tableName, String attributeName) {
        Set<ChangeEvent> tableEvents = this.getChangeEventsForTable(tableName, false);
        LinkedHashSet<ChangeEvent> attributeEvents = new LinkedHashSet<ChangeEvent>();
        for (ChangeEvent changeEvent : tableEvents) {
            if (!attributeName.equals(changeEvent.getAttributeNameAsString())) continue;
            attributeEvents.add(changeEvent);
        }
        return attributeEvents;
    }

    public Set<ChangeEvent> getChangeEventsForColumnFamily(TableName tableName, byte[] columnFamily, boolean includeChildEntities) {
        return this.getChangeEventsForEntity(SchemaEntityType.COLUMN_FAMILY, tableName.getNamespace(), tableName.getName(), columnFamily, null, includeChildEntities);
    }

    public Set<ChangeEvent> getChangeEventsForColumnFamilyAttribute(TableName tableName, byte[] columnFamily, String attributeName) {
        Set<ChangeEvent> cfEvents = this.getChangeEventsForColumnFamily(tableName, columnFamily, false);
        LinkedHashSet<ChangeEvent> attributeEvents = new LinkedHashSet<ChangeEvent>();
        for (ChangeEvent changeEvent : cfEvents) {
            if (!attributeName.equals(changeEvent.getAttributeNameAsString())) continue;
            attributeEvents.add(changeEvent);
        }
        return attributeEvents;
    }

    public Set<ChangeEvent> getChangeEventsForColumnDefinition(TableName tableName, byte[] columnFamily, byte[] columnQualifier) {
        return this.getChangeEventsForEntity(SchemaEntityType.COLUMN_DEFINITION, tableName.getNamespace(), tableName.getName(), columnFamily, columnQualifier, false);
    }

    public Set<ChangeEvent> getChangeEventsForColumnAuditor(TableName tableName, byte[] columnFamily, byte[] columnQualifier) {
        return this.getChangeEventsForEntity(SchemaEntityType.COLUMN_AUDITOR, tableName.getNamespace(), tableName.getName(), columnFamily, columnQualifier, false);
    }

    private Set<ChangeEvent> getChangeEventsForEntity(SchemaEntityType entityType, byte[] namespaceName, byte[] tableName, byte[] columnFamily, byte[] columnQualifier, boolean includeChildEntities) {
        ChangeEvent.Entity namespaceEntity;
        Object[] entityArray = this.entitySet.toArray(new ChangeEvent.Entity[this.entitySet.size()]);
        int namespaceIndex = Arrays.binarySearch(entityArray, namespaceEntity = new ChangeEvent.Entity(SchemaEntityType.NAMESPACE.getRecordType(), Repository.NAMESPACE_PARENT_FOREIGN_KEY, namespaceName));
        if (namespaceIndex < 0) {
            return null;
        }
        if (entityType.equals((Object)SchemaEntityType.NAMESPACE)) {
            Set<ChangeEvent> returnedChangeEvents = this.getChangeEventsForEntity(namespaceEntity);
            if (includeChildEntities) {
                for (Object entity : entityArray) {
                    if (((ChangeEvent.Entity)entity).getEntityRecordType().getByte() != SchemaEntityType.TABLE.getRecordType() || !Bytes.equals((byte[])((ChangeEvent.Entity)entity).getNamespace(), (byte[])namespaceName)) continue;
                    returnedChangeEvents.addAll(this.getChangeEventsForEntity(SchemaEntityType.TABLE, namespaceName, ((ChangeEvent.Entity)entity).getEntityName().getBytes(), null, null, includeChildEntities));
                }
            }
            return returnedChangeEvents;
        }
        byte[] namespaceForeignKey = ((ChangeEvent.Entity)entityArray[namespaceIndex]).getEntityForeignKey().getBytes();
        ChangeEvent.Entity tableEntity = new ChangeEvent.Entity(SchemaEntityType.TABLE.getRecordType(), namespaceForeignKey, tableName);
        int tableIndex = Arrays.binarySearch(entityArray, tableEntity);
        if (tableIndex < 0) {
            return null;
        }
        if (entityType.equals((Object)SchemaEntityType.TABLE)) {
            Set<ChangeEvent> returnedChangeEvents = this.getChangeEventsForEntity(tableEntity);
            if (includeChildEntities) {
                for (Object entity : entityArray) {
                    if (((ChangeEvent.Entity)entity).getEntityRecordType().getByte() != SchemaEntityType.COLUMN_FAMILY.getRecordType() || !Bytes.equals((byte[])((ChangeEvent.Entity)entity).getNamespace(), (byte[])namespaceName) || !Bytes.equals((byte[])((ChangeEvent.Entity)entity).getTableName(), (byte[])tableName)) continue;
                    returnedChangeEvents.addAll(this.getChangeEventsForEntity(SchemaEntityType.COLUMN_FAMILY, namespaceName, tableName, ((ChangeEvent.Entity)entity).getEntityName().getBytes(), null, includeChildEntities));
                }
            }
            return returnedChangeEvents;
        }
        byte[] tableForeignKey = ((ChangeEvent.Entity)entityArray[tableIndex]).getEntityForeignKey().getBytes();
        ChangeEvent.Entity colFamilyEntity = new ChangeEvent.Entity(SchemaEntityType.COLUMN_FAMILY.getRecordType(), tableForeignKey, columnFamily);
        int colFamilyIndex = Arrays.binarySearch(entityArray, colFamilyEntity);
        if (colFamilyIndex < 0) {
            return null;
        }
        if (entityType.equals((Object)SchemaEntityType.COLUMN_FAMILY)) {
            Set<ChangeEvent> returnedChangeEvents = this.getChangeEventsForEntity(colFamilyEntity);
            if (includeChildEntities) {
                for (Object entity : entityArray) {
                    if (((ChangeEvent.Entity)entity).getEntityRecordType().getByte() == SchemaEntityType.COLUMN_AUDITOR.getRecordType() && Bytes.equals((byte[])((ChangeEvent.Entity)entity).getNamespace(), (byte[])namespaceName) && Bytes.equals((byte[])((ChangeEvent.Entity)entity).getTableName(), (byte[])tableName) && Bytes.equals((byte[])((ChangeEvent.Entity)entity).getColumnFamily(), (byte[])columnFamily)) {
                        returnedChangeEvents.addAll(this.getChangeEventsForEntity(SchemaEntityType.COLUMN_AUDITOR, namespaceName, tableName, ((ChangeEvent.Entity)entity).getEntityName().getBytes(), null, includeChildEntities));
                    }
                    if (((ChangeEvent.Entity)entity).getEntityRecordType().getByte() != SchemaEntityType.COLUMN_DEFINITION.getRecordType() || !Bytes.equals((byte[])((ChangeEvent.Entity)entity).getNamespace(), (byte[])namespaceName) || !Bytes.equals((byte[])((ChangeEvent.Entity)entity).getTableName(), (byte[])tableName) || !Bytes.equals((byte[])((ChangeEvent.Entity)entity).getColumnFamily(), (byte[])columnFamily)) continue;
                    returnedChangeEvents.addAll(this.getChangeEventsForEntity(SchemaEntityType.COLUMN_DEFINITION, namespaceName, tableName, ((ChangeEvent.Entity)entity).getEntityName().getBytes(), null, includeChildEntities));
                }
            }
            return returnedChangeEvents;
        }
        byte[] colFamilyForeignKey = ((ChangeEvent.Entity)entityArray[colFamilyIndex]).getEntityForeignKey().getBytes();
        ChangeEvent.Entity colQualifierEntity = new ChangeEvent.Entity(entityType.getRecordType(), colFamilyForeignKey, columnQualifier);
        int colQualifierIndex = Arrays.binarySearch(entityArray, colQualifierEntity);
        if (colQualifierIndex < 0) {
            return null;
        }
        if (entityType.equals((Object)SchemaEntityType.COLUMN_AUDITOR) || entityType.equals((Object)SchemaEntityType.COLUMN_DEFINITION)) {
            return this.getChangeEventsForEntity(colQualifierEntity);
        }
        return null;
    }

    private Set<ChangeEvent> getChangeEventsForEntity(ChangeEvent.Entity entity) {
        LinkedHashSet<ChangeEvent> changeEventsForEntity = new LinkedHashSet<ChangeEvent>();
        boolean entityFound = false;
        for (ChangeEvent ce : this.changeEventsByEntity) {
            if (ce.getEntity().equals(entity)) {
                entityFound = true;
                changeEventsForEntity.add(ce);
                continue;
            }
            if (!entityFound) continue;
            break;
        }
        return changeEventsForEntity;
    }

    public static void exportChangeEventListToCsvFile(Collection<ChangeEvent> changeEvents, File targetFile) throws IOException {
        ChangeEventMonitor.exportChangeEventListToCsvFile(changeEvents, targetFile, "");
    }

    static void exportChangeEventListToCsvFile(Collection<ChangeEvent> changeEvents, File targetFile, String headerDetail) throws IOException {
        CSVFormat csvFormat = CSVFormat.DEFAULT.withRecordSeparator("\n").withCommentMarker('#').withHeader(ReportHeader.class);
        try (CSVPrinter csvPrinter = csvFormat.withHeaderComments("List of ChangeEvents in ColumnManagerAPI repository " + headerDetail + "-- Exported to CSV by " + "ColumnManagerAPI" + ":" + ChangeEventMonitor.class.getSimpleName(), new Date()).print(new FileWriter(targetFile));){
            if (changeEvents == null) {
                return;
            }
            for (ChangeEvent ce : changeEvents) {
                csvPrinter.print(ce.getTimestampAsString());
                csvPrinter.print(ce.getUserNameAsString());
                csvPrinter.print(ce.getEntityType().toString());
                csvPrinter.print(ce.getNamespaceAsString());
                csvPrinter.print(ce.getTableNameAsString());
                csvPrinter.print(ce.getColumnFamilyAsString());
                csvPrinter.print(ce.getColumnQualifierAsString());
                csvPrinter.print(ce.getAttributeNameAsString());
                csvPrinter.print(ce.getAttributeValueAsString());
                csvPrinter.println();
            }
        }
    }

    private static String buildCommaDelimitedString(String ... strings) {
        StringBuilder stringBuilder = new StringBuilder();
        int stringCount = 0;
        for (String string : strings) {
            stringBuilder.append(string);
            if (++stringCount >= strings.length) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    private static enum ReportHeader {
        TIMESTAMP,
        JAVA_USERNAME,
        ENTITY_TYPE,
        NAMESPACE,
        TABLE,
        COLUMN_FAMILY,
        COLUMN_QUALIFIER,
        ATTRIBUTE_NAME,
        ATTRIBUTE_VALUE;

    }
}

