/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.commonvox.hbase_column_manager.ColumnAuditor;
import org.commonvox.hbase_column_manager.ColumnDefinition;
import org.commonvox.hbase_column_manager.MColumnDescriptor;
import org.commonvox.hbase_column_manager.MNamespaceDescriptor;
import org.commonvox.hbase_column_manager.MTableDescriptor;
import org.commonvox.hbase_column_manager.Repository;
import org.commonvox.hbase_column_manager.SchemaEntityType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="hBaseSchemaEntity")
class SchemaEntity
implements Comparable<SchemaEntity> {
    @XmlAttribute
    private SchemaEntityType schemaEntityType;
    @XmlAttribute
    private String name;
    private final Map<String, String> values = new HashMap<String, String>();
    private final Map<String, String> configurations = new HashMap<String, String>();
    @XmlElementWrapper(name="childEntities")
    @XmlElement(name="hBaseSchemaEntity")
    private TreeSet<SchemaEntity> children = null;
    @XmlTransient
    private byte[] foreignKeyValue;
    @XmlTransient
    private SchemaEntityType type;

    public SchemaEntity() {
    }

    SchemaEntity(byte entityType, byte[] name) {
        this.type = SchemaEntityType.ENTITY_TYPE_BYTE_TO_ENUM_MAP.get(entityType);
        this.schemaEntityType = SchemaEntityType.ENTITY_TYPE_BYTE_TO_ENUM_MAP.get(entityType);
        this.name = Bytes.toString((byte[])name);
    }

    SchemaEntity(byte entityType, String name) {
        this(entityType, Bytes.toBytes((String)name));
    }

    SchemaEntity(MNamespaceDescriptor namespaceDescriptor) {
        this(namespaceDescriptor.getEntityRecordType(), namespaceDescriptor.getName());
        this.shallowClone(namespaceDescriptor);
    }

    SchemaEntity(SchemaEntity schemaEntity) {
        this(schemaEntity.getEntityRecordType(), schemaEntity.getName());
        this.shallowClone(schemaEntity);
    }

    private void shallowClone(SchemaEntity entity) {
        for (Map.Entry<String, String> valueEntry : entity.values.entrySet()) {
            this.values.put(valueEntry.getKey(), valueEntry.getValue());
        }
        for (Map.Entry<String, String> configEntry : entity.configurations.entrySet()) {
            this.configurations.put(configEntry.getKey(), configEntry.getValue());
        }
    }

    SchemaEntity(MTableDescriptor mtd) {
        this(SchemaEntityType.TABLE.getRecordType(), mtd.getNameAsString());
        for (Map.Entry valueEntry : mtd.getValues().entrySet()) {
            this.values.put(Bytes.toString((byte[])((ImmutableBytesWritable)valueEntry.getKey()).get()), Bytes.toString((byte[])((ImmutableBytesWritable)valueEntry.getValue()).get()));
        }
        for (Map.Entry configEntry : mtd.getConfiguration().entrySet()) {
            this.configurations.put((String)configEntry.getKey(), (String)configEntry.getValue());
        }
    }

    SchemaEntity(MColumnDescriptor mcd) {
        this(SchemaEntityType.COLUMN_FAMILY.getRecordType(), mcd.getNameAsString());
        for (Map.Entry valueEntry : mcd.getValues().entrySet()) {
            this.values.put(Bytes.toString((byte[])((ImmutableBytesWritable)valueEntry.getKey()).get()), Bytes.toString((byte[])((ImmutableBytesWritable)valueEntry.getValue()).get()));
        }
        for (Map.Entry configEntry : mcd.getConfiguration().entrySet()) {
            this.configurations.put((String)configEntry.getKey(), (String)configEntry.getValue());
        }
    }

    byte getEntityRecordType() {
        return this.schemaEntityType.getRecordType();
    }

    SchemaEntityType getSchemaEntityType() {
        if (this.type == null) {
            this.type = SchemaEntityType.ENTITY_TYPE_BYTE_TO_ENUM_MAP.get(this.getEntityRecordType());
        }
        return this.type;
    }

    byte[] getName() {
        return this.name.getBytes();
    }

    String getNameAsString() {
        return this.name;
    }

    Map<ImmutableBytesWritable, ImmutableBytesWritable> getValues() {
        HashMap<ImmutableBytesWritable, ImmutableBytesWritable> valuesImmutable = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            valuesImmutable.put(new ImmutableBytesWritable(entry.getKey().getBytes()), new ImmutableBytesWritable(entry.getValue().getBytes()));
        }
        return valuesImmutable;
    }

    Map<String, String> getValuesStringMap() {
        return this.values;
    }

    byte[] getValue(byte[] key) {
        String valueAsString = this.values.get(Bytes.toString((byte[])key));
        if (valueAsString == null) {
            return null;
        }
        if (key.length > Repository.COUNTER_COLUMN_PREFIX_BYTES.length && Bytes.startsWith((byte[])key, (byte[])Repository.COUNTER_COLUMN_PREFIX_BYTES) || key.length > Repository.TIMESTAMP_KEY_PREFIX_BYTES.length && Bytes.startsWith((byte[])key, (byte[])Repository.TIMESTAMP_KEY_PREFIX_BYTES)) {
            return Bytes.toBytes((long)Long.valueOf(valueAsString));
        }
        return valueAsString.getBytes();
    }

    String getValue(String key) {
        return this.values.get(key);
    }

    void remove(byte[] key) {
        this.values.remove(Bytes.toString((byte[])key));
    }

    SchemaEntity setValue(String key, String value) {
        if (value == null) {
            this.remove(Bytes.toBytes((String)key));
        } else {
            this.values.put(key, value);
        }
        return this;
    }

    SchemaEntity setValue(byte[] key, byte[] value) {
        String keyString = Bytes.toString((byte[])key);
        if (key.length > Repository.COUNTER_COLUMN_PREFIX_BYTES.length && Bytes.startsWith((byte[])key, (byte[])Repository.COUNTER_COLUMN_PREFIX_BYTES) || key.length > Repository.TIMESTAMP_KEY_PREFIX_BYTES.length && Bytes.startsWith((byte[])key, (byte[])Repository.TIMESTAMP_KEY_PREFIX_BYTES)) {
            this.values.put(keyString, String.valueOf(Bytes.toLong((byte[])value)));
        } else {
            this.values.put(keyString, Bytes.toString((byte[])value));
        }
        return this;
    }

    SchemaEntity setValue(ImmutableBytesWritable key, ImmutableBytesWritable value) {
        String keyString = Bytes.toString((byte[])key.get());
        if (key.getLength() > Repository.COUNTER_COLUMN_PREFIX_BYTES.length && Bytes.startsWith((byte[])key.get(), (byte[])Repository.COUNTER_COLUMN_PREFIX_BYTES) || key.getLength() > Repository.TIMESTAMP_KEY_PREFIX_BYTES.length && Bytes.startsWith((byte[])key.get(), (byte[])Repository.TIMESTAMP_KEY_PREFIX_BYTES)) {
            this.values.put(keyString, String.valueOf(Bytes.toLong((byte[])value.get())));
        } else {
            this.values.put(keyString, Bytes.toString((byte[])value.get()));
        }
        return this;
    }

    Map<String, String> getConfiguration() {
        return this.configurations;
    }

    String getConfigurationValue(String key) {
        return this.configurations.get(key);
    }

    SchemaEntity setConfiguration(String key, String value) {
        if (value == null) {
            this.removeConfiguration(key);
        } else {
            this.configurations.put(key, value);
        }
        return this;
    }

    void removeConfiguration(String key) {
        this.configurations.remove(key);
    }

    byte[] getForeignKey() {
        return this.foreignKeyValue;
    }

    void setForeignKey(byte[] foreignKeyValue) {
        this.foreignKeyValue = foreignKeyValue;
    }

    void addChild(SchemaEntity child) {
        if (this.children == null) {
            this.children = new TreeSet();
        }
        this.children.add(child);
    }

    Set<SchemaEntity> getChildren() {
        if (this.children == null) {
            return new TreeSet<SchemaEntity>();
        }
        return this.children;
    }

    static Set<Object> convertToNamespaceAndTableDescriptorSet(SchemaEntity entity, String namespaceFilter, TableName tableNameFilter, byte[] colFamilyFilter) {
        LinkedHashSet<Object> convertedObjects = new LinkedHashSet<Object>();
        if (entity.getEntityRecordType() == SchemaEntityType.NAMESPACE.getRecordType()) {
            if (namespaceFilter != null && !namespaceFilter.equals(entity.getNameAsString())) {
                return convertedObjects;
            }
            convertedObjects.add(new MNamespaceDescriptor(entity));
            for (SchemaEntity childEntity : entity.getChildren()) {
                convertedObjects.addAll(SchemaEntity.convertToNamespaceAndTableDescriptorSet(childEntity, namespaceFilter, tableNameFilter, colFamilyFilter));
            }
        } else if (entity.getEntityRecordType() == SchemaEntityType.TABLE.getRecordType()) {
            if (tableNameFilter != null && !tableNameFilter.getNameAsString().equals(entity.getNameAsString())) {
                return convertedObjects;
            }
            MTableDescriptor mtd = new MTableDescriptor(entity);
            if (entity.getChildren() != null) {
                for (SchemaEntity childEntity : entity.getChildren()) {
                    if (childEntity.getEntityRecordType() != SchemaEntityType.COLUMN_FAMILY.getRecordType()) continue;
                    Set<Object> returnedMcdSet = SchemaEntity.convertToNamespaceAndTableDescriptorSet(childEntity, namespaceFilter, tableNameFilter, colFamilyFilter);
                    for (Object returnedMcd : returnedMcdSet) {
                        mtd.addFamily((MColumnDescriptor)((Object)returnedMcd));
                    }
                }
            }
            convertedObjects.add((Object)mtd);
        } else if (entity.getEntityRecordType() == SchemaEntityType.COLUMN_FAMILY.getRecordType()) {
            if (colFamilyFilter != null && !Bytes.toString((byte[])colFamilyFilter).equals(entity.getNameAsString())) {
                return convertedObjects;
            }
            MColumnDescriptor mcd = new MColumnDescriptor(entity);
            if (entity.getChildren() != null) {
                for (SchemaEntity childEntity : entity.getChildren()) {
                    if (childEntity.getEntityRecordType() == SchemaEntityType.COLUMN_AUDITOR.getRecordType()) {
                        mcd.addColumnAuditor(new ColumnAuditor(childEntity));
                        continue;
                    }
                    if (childEntity.getEntityRecordType() != SchemaEntityType.COLUMN_DEFINITION.getRecordType()) continue;
                    mcd.addColumnDefinition(new ColumnDefinition(childEntity));
                }
            }
            convertedObjects.add((Object)mcd);
        }
        return convertedObjects;
    }

    @Override
    public int compareTo(SchemaEntity other) {
        int result = this.schemaEntityType.compareTo(other.schemaEntityType);
        if (result == 0) {
            result = this.name.compareTo(other.name);
        }
        if (result == 0) {
            int childrenSize = this.children == null ? 0 : this.children.size();
            int otherChildrenSize = other.children == null ? 0 : other.children.size();
            result = childrenSize - otherChildrenSize;
        }
        if (result == 0 && this.children != null && other.children != null) {
            Iterator<SchemaEntity> it = this.children.iterator();
            Iterator<SchemaEntity> it2 = other.children.iterator();
            while (it.hasNext() && (result = it.next().compareTo(it2.next())) == 0) {
            }
        }
        if (result == 0) {
            result = this.values.hashCode() - other.values.hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        if (result == 0) {
            result = this.configurations.hashCode() - other.configurations.hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaEntity)) {
            return false;
        }
        return this.compareTo((SchemaEntity)obj) == 0;
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + Objects.hashCode((Object)this.schemaEntityType);
        hash = 41 * hash + Objects.hashCode(this.name);
        hash = 41 * hash + Objects.hashCode(this.values);
        hash = 41 * hash + Objects.hashCode(this.configurations);
        hash = 41 * hash + Objects.hashCode(this.children);
        return hash;
    }

    public String toString() {
        return (Object)((Object)this.schemaEntityType) + ": " + this.name;
    }
}

