/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.commonvox.hbase_column_manager.MTableDescriptor;
import org.commonvox.hbase_column_manager.Repository;

class MTable
implements Table {
    private final Table wrappedTable;
    private final Repository repository;
    private final MTableDescriptor mTableDescriptor;
    private final boolean includedInRepositoryProcessing;

    MTable(Table userTable, Repository repository) throws IOException {
        this.wrappedTable = userTable;
        this.repository = repository;
        if (repository.isActivated()) {
            this.mTableDescriptor = repository.getMTableDescriptor(this.wrappedTable.getName());
            this.includedInRepositoryProcessing = repository.isIncludedTable(this.wrappedTable.getName());
        } else {
            this.mTableDescriptor = null;
            this.includedInRepositoryProcessing = false;
        }
    }

    public TableName getName() {
        return this.wrappedTable.getName();
    }

    public Configuration getConfiguration() {
        return this.wrappedTable.getConfiguration();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.wrappedTable.getTableDescriptor();
    }

    public boolean exists(Get get) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            return this.wrappedTable.exists(this.repository.convertQualifiersToAliases(this.mTableDescriptor, get, this.repository.getFamilyQualifierToAliasMap(this.mTableDescriptor, get)));
        }
        return this.wrappedTable.exists(get);
    }

    public boolean[] existsAll(List<Get> listOfGets) throws IOException {
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap;
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled() && !(familyQualifierToAliasMap = this.repository.getFamilyQualifierToAliasMap(this.mTableDescriptor, listOfGets)).isEmpty()) {
            LinkedList<Get> convertedGets = new LinkedList<Get>();
            for (Get originalGet : listOfGets) {
                convertedGets.add(this.repository.convertQualifiersToAliases(this.mTableDescriptor, originalGet, familyQualifierToAliasMap));
            }
            return this.wrappedTable.existsAll(convertedGets);
        }
        return this.wrappedTable.existsAll(listOfGets);
    }

    public void batch(List<? extends Row> rowList, Object[] os) throws IOException, InterruptedException {
        this.batchProcessing(rowList, os, null, false);
    }

    @Deprecated
    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        Object[] results = new Object[actions.size()];
        this.batch(actions, results);
        return results;
    }

    public <R> void batchCallback(List<? extends Row> list, Object[] os, Batch.Callback<R> clbck) throws IOException, InterruptedException {
        this.batchProcessing(list, os, clbck, true);
    }

    @Deprecated
    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        Object[] results = new Object[actions.size()];
        this.batchCallback(actions, results, callback);
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private <R> void batchProcessing(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback, boolean includeCallback) throws IOException, InterruptedException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
            for (Row row : actions) {
                if (!Mutation.class.isAssignableFrom(row.getClass())) continue;
                this.repository.validateColumns(this.mTableDescriptor, (Mutation)row);
            }
        }
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap = this.repository.getFamilyQualifierToAliasMap(this.mTableDescriptor, actions, 0);
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (Row row : actions) {
                if (!Mutation.class.isAssignableFrom(row.getClass())) continue;
                linkedList.add(this.repository.convertQualifiersToAliases(this.mTableDescriptor, row, familyQualifierToAliasMap, 0));
            }
            int listIndex = 0;
            for (Row row : actions) {
                if (Get.class.isAssignableFrom(row.getClass())) {
                    linkedList.add(listIndex, this.repository.convertQualifiersToAliases(this.mTableDescriptor, (Get)row, familyQualifierToAliasMap));
                }
                ++listIndex;
            }
            if (includeCallback) {
                this.wrappedTable.batchCallback(linkedList, results, callback);
            } else {
                this.wrappedTable.batch(linkedList, results);
            }
            NavigableMap<byte[], NavigableMap<byte[], byte[]>> navigableMap = this.repository.getFamilyAliasToQualifierMap(familyQualifierToAliasMap);
            Object[] objectArray = new Object[results.length];
            int objectIndex = 0;
            for (Object returnedObject : results) {
                objectArray[objectIndex] = Result.class.isAssignableFrom(returnedObject.getClass()) ? this.repository.convertAliasesToQualifiers((Result)returnedObject, navigableMap) : results[objectIndex];
                ++objectIndex;
            }
            objectIndex = 0;
            for (Object convertedResult : objectArray) {
                results[objectIndex++] = convertedResult;
            }
        } else if (includeCallback) {
            this.wrappedTable.batchCallback(actions, results, callback);
        } else {
            this.wrappedTable.batch(actions, results);
        }
        if (this.includedInRepositoryProcessing) {
            void var8_17;
            int rowCount = 0;
            Object[] objectArray = results;
            int n = objectArray.length;
            boolean bl = false;
            while (var8_17 < n) {
                Row action;
                Object object = objectArray[var8_17];
                if (object != null && Mutation.class.isAssignableFrom((action = actions.get(rowCount)).getClass())) {
                    this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, (Mutation)action);
                }
                ++rowCount;
                ++var8_17;
            }
        }
    }

    public Result get(Get get) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap = this.repository.getFamilyQualifierToAliasMap(this.mTableDescriptor, get);
            Result result = this.wrappedTable.get(this.repository.convertQualifiersToAliases(this.mTableDescriptor, get, familyQualifierToAliasMap));
            return this.repository.convertAliasesToQualifiers(result, this.repository.getFamilyAliasToQualifierMap(familyQualifierToAliasMap));
        }
        return this.wrappedTable.get(get);
    }

    public Result[] get(List<Get> listOfGets) throws IOException {
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap;
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled() && !(familyQualifierToAliasMap = this.repository.getFamilyQualifierToAliasMap(this.mTableDescriptor, listOfGets)).isEmpty()) {
            LinkedList<Get> convertedGets = new LinkedList<Get>();
            for (Get originalGet : listOfGets) {
                convertedGets.add(this.repository.convertQualifiersToAliases(this.mTableDescriptor, originalGet, familyQualifierToAliasMap));
            }
            Result[] originalResults = this.wrappedTable.get(convertedGets);
            NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyAliasToQualifierMap = this.repository.getFamilyAliasToQualifierMap(familyQualifierToAliasMap);
            LinkedList<Result> convertedResults = new LinkedList<Result>();
            for (Result originalResult : originalResults) {
                convertedResults.add(this.repository.convertAliasesToQualifiers(originalResult, familyAliasToQualifierMap));
            }
            return convertedResults.toArray(new Result[convertedResults.size()]);
        }
        return this.wrappedTable.get(listOfGets);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap;
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled() && !(familyQualifierToAliasMap = this.repository.getFamilyQualifierToAliasMap(this.mTableDescriptor, scan)).isEmpty()) {
            return new ResultScannerForAliasedFamilies(this.wrappedTable.getScanner(this.repository.convertQualifiersToAliases(this.mTableDescriptor, scan, familyQualifierToAliasMap)), this.repository.getFamilyAliasToQualifierMap(familyQualifierToAliasMap));
        }
        return this.wrappedTable.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] colFamily) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) {
            return new ResultScannerForAliasedFamilies(this.wrappedTable.getScanner(colFamily), this.repository.getFamilyAliasToQualifierMap(this.mTableDescriptor, colFamily));
        }
        return this.wrappedTable.getScanner(colFamily);
    }

    public ResultScanner getScanner(byte[] colFamily, byte[] colQualifier) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.getMColumnDescriptor(colFamily).columnAliasesEnabled()) {
            return new ResultScannerForAliasedFamilies(this.wrappedTable.getScanner(colFamily, this.repository.getAlias(this.mTableDescriptor, colFamily, colQualifier)), this.repository.getFamilyAliasToQualifierMap(this.mTableDescriptor, colFamily, colQualifier));
        }
        return this.wrappedTable.getScanner(colFamily, colQualifier);
    }

    public void put(Put put) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
            this.repository.validateColumns(this.mTableDescriptor, (Mutation)put);
        }
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            this.wrappedTable.put(this.repository.convertQualifiersToAliases(this.mTableDescriptor, put));
        } else {
            this.wrappedTable.put(put);
        }
        if (this.includedInRepositoryProcessing) {
            this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, (Mutation)put);
        }
    }

    public void put(List<Put> list) throws IOException {
        for (Put put : list) {
            this.put(put);
        }
    }

    public boolean checkAndPut(byte[] rowId, byte[] colFamily, byte[] colQualifier, byte[] colValue, Put put) throws IOException {
        boolean putPerformed;
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
            this.repository.validateColumns(this.mTableDescriptor, (Mutation)put);
        }
        if ((putPerformed = this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled() ? this.wrappedTable.checkAndPut(rowId, colFamily, this.repository.getAlias(this.mTableDescriptor, colFamily, colQualifier), colValue, this.repository.convertQualifiersToAliases(this.mTableDescriptor, put)) : this.wrappedTable.checkAndPut(rowId, colFamily, colQualifier, colValue, put)) && this.includedInRepositoryProcessing) {
            this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, (Mutation)put);
        }
        return putPerformed;
    }

    public boolean checkAndPut(byte[] rowId, byte[] colFamily, byte[] colQualifier, CompareFilter.CompareOp co, byte[] colValue, Put put) throws IOException {
        boolean putPerformed;
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
            this.repository.validateColumns(this.mTableDescriptor, (Mutation)put);
        }
        if ((putPerformed = this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled() ? this.wrappedTable.checkAndPut(rowId, colFamily, this.repository.getAlias(this.mTableDescriptor, colFamily, colQualifier), co, colValue, this.repository.convertQualifiersToAliases(this.mTableDescriptor, put)) : this.wrappedTable.checkAndPut(rowId, colFamily, colQualifier, co, colValue, put)) && this.includedInRepositoryProcessing) {
            this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, (Mutation)put);
        }
        return putPerformed;
    }

    public void delete(Delete delete) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            this.wrappedTable.delete(this.repository.convertQualifiersToAliases(this.mTableDescriptor, delete));
        } else {
            this.wrappedTable.delete(delete);
        }
    }

    public void delete(List<Delete> deleteList) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            LinkedList<Delete> convertedDeleteList = new LinkedList<Delete>();
            for (Delete delete : deleteList) {
                convertedDeleteList.add(this.repository.convertQualifiersToAliases(this.mTableDescriptor, delete));
            }
            this.wrappedTable.delete(convertedDeleteList);
        } else {
            this.wrappedTable.delete(deleteList);
        }
    }

    public boolean checkAndDelete(byte[] rowId, byte[] colFamily, byte[] colQualifier, byte[] colValue, Delete delete) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            return this.wrappedTable.checkAndDelete(rowId, colFamily, this.repository.getAlias(this.mTableDescriptor, colFamily, colQualifier), colValue, this.repository.convertQualifiersToAliases(this.mTableDescriptor, delete));
        }
        return this.wrappedTable.checkAndDelete(rowId, colFamily, colQualifier, colValue, delete);
    }

    public boolean checkAndDelete(byte[] rowId, byte[] colFamily, byte[] colQualifier, CompareFilter.CompareOp co, byte[] colValue, Delete delete) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            return this.wrappedTable.checkAndDelete(rowId, colFamily, this.repository.getAlias(this.mTableDescriptor, colFamily, colQualifier), co, colValue, this.repository.convertQualifiersToAliases(this.mTableDescriptor, delete));
        }
        return this.wrappedTable.checkAndDelete(rowId, colFamily, colQualifier, co, colValue, delete);
    }

    public void mutateRow(RowMutations rm) throws IOException {
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
            this.repository.validateColumns(this.mTableDescriptor, rm);
        }
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            this.wrappedTable.mutateRow(this.repository.convertQualifiersToAliases(this.mTableDescriptor, rm));
        } else {
            this.wrappedTable.mutateRow(rm);
        }
        if (this.includedInRepositoryProcessing) {
            this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, rm);
        }
    }

    public Result append(Append append) throws IOException {
        Result result;
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
            this.repository.validateColumns(this.mTableDescriptor, (Mutation)append);
        }
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap = null;
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            familyQualifierToAliasMap = this.repository.getFamilyQualifierToAliasMap(this.mTableDescriptor, append);
            result = this.wrappedTable.append(this.repository.convertQualifiersToAliases(this.mTableDescriptor, append, familyQualifierToAliasMap));
        } else {
            result = this.wrappedTable.append(append);
        }
        if (this.includedInRepositoryProcessing) {
            this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, (Mutation)append);
        }
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            return this.repository.convertAliasesToQualifiers(result, this.repository.getFamilyAliasToQualifierMap(familyQualifierToAliasMap));
        }
        return result;
    }

    public Result increment(Increment increment) throws IOException {
        Result result;
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
            this.repository.validateColumns(this.mTableDescriptor, (Mutation)increment);
        }
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyQualifierToAliasMap = null;
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            familyQualifierToAliasMap = this.repository.getFamilyQualifierToAliasMap(this.mTableDescriptor, increment);
            result = this.wrappedTable.increment(this.repository.convertQualifiersToAliases(this.mTableDescriptor, increment, familyQualifierToAliasMap));
        } else {
            result = this.wrappedTable.increment(increment);
        }
        if (this.includedInRepositoryProcessing) {
            this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, (Mutation)increment);
        }
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled()) {
            return this.repository.convertAliasesToQualifiers(result, this.repository.getFamilyAliasToQualifierMap(familyQualifierToAliasMap));
        }
        return result;
    }

    public long incrementColumnValue(byte[] rowId, byte[] colFamily, byte[] colQualifier, long l) throws IOException {
        Increment increment = null;
        if (this.includedInRepositoryProcessing) {
            increment = new Increment(rowId).addColumn(colFamily, colQualifier, l);
            if (this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
                this.repository.validateColumns(this.mTableDescriptor, (Mutation)increment);
            }
        }
        long returnedLong = this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled() ? this.wrappedTable.incrementColumnValue(rowId, colFamily, this.repository.getAlias(this.mTableDescriptor, colFamily, colQualifier), l) : this.wrappedTable.incrementColumnValue(rowId, colFamily, colQualifier, l);
        if (this.includedInRepositoryProcessing) {
            this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, (Mutation)increment);
        }
        return returnedLong;
    }

    public long incrementColumnValue(byte[] rowId, byte[] colFamily, byte[] colQualifier, long l, Durability drblt) throws IOException {
        Increment increment = null;
        if (this.includedInRepositoryProcessing) {
            increment = new Increment(rowId).addColumn(colFamily, colQualifier, l);
            if (this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
                this.repository.validateColumns(this.mTableDescriptor, (Mutation)increment);
            }
        }
        long returnedLong = this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled() ? this.wrappedTable.incrementColumnValue(rowId, colFamily, this.repository.getAlias(this.mTableDescriptor, colFamily, colQualifier), l, drblt) : this.wrappedTable.incrementColumnValue(rowId, colFamily, colQualifier, l, drblt);
        if (this.includedInRepositoryProcessing) {
            this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, (Mutation)increment);
        }
        return returnedLong;
    }

    public void close() throws IOException {
        this.wrappedTable.close();
    }

    public CoprocessorRpcChannel coprocessorService(byte[] bytes) {
        return this.wrappedTable.coprocessorService(bytes);
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> type, byte[] bytes, byte[] bytes1, Batch.Call<T, R> call) throws ServiceException, Throwable {
        return this.wrappedTable.coprocessorService(type, bytes, bytes1, call);
    }

    public <T extends Service, R> void coprocessorService(Class<T> type, byte[] bytes, byte[] bytes1, Batch.Call<T, R> call, Batch.Callback<R> clbck) throws ServiceException, Throwable {
        this.wrappedTable.coprocessorService(type, bytes, bytes1, call, clbck);
    }

    @Deprecated
    public long getWriteBufferSize() {
        return this.wrappedTable.getWriteBufferSize();
    }

    @Deprecated
    public void setWriteBufferSize(long l) throws IOException {
        this.wrappedTable.setWriteBufferSize(l);
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor md, Message msg, byte[] bytes, byte[] bytes1, R r) throws ServiceException, Throwable {
        return this.wrappedTable.batchCoprocessorService(md, msg, bytes, bytes1, r);
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor md, Message msg, byte[] bytes, byte[] bytes1, R r, Batch.Callback<R> clbck) throws ServiceException, Throwable {
        this.wrappedTable.batchCoprocessorService(md, msg, bytes, bytes1, r, clbck);
    }

    public boolean checkAndMutate(byte[] rowId, byte[] colFamily, byte[] colQualifier, CompareFilter.CompareOp co, byte[] colValue, RowMutations rm) throws IOException {
        boolean mutationsPerformed;
        if (this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColDefinitionsEnforced()) {
            this.repository.validateColumns(this.mTableDescriptor, rm);
        }
        if ((mutationsPerformed = this.includedInRepositoryProcessing && this.mTableDescriptor.hasColDescriptorWithColAliasesEnabled() ? this.wrappedTable.checkAndMutate(rowId, colFamily, this.repository.getAlias(this.mTableDescriptor, colFamily, colQualifier), co, colValue, this.repository.convertQualifiersToAliases(this.mTableDescriptor, rm)) : this.wrappedTable.checkAndMutate(rowId, colFamily, colQualifier, co, colValue, rm)) && this.includedInRepositoryProcessing) {
            this.repository.putColumnAuditorSchemaEntities(this.mTableDescriptor, rm);
        }
        return mutationsPerformed;
    }

    public boolean equals(Object otherObject) {
        return this.wrappedTable.equals(otherObject);
    }

    public int hashCode() {
        return this.wrappedTable.hashCode();
    }

    class ResultScannerForAliasedFamilies
    implements ResultScanner {
        private final ResultScanner wrappedResultScanner;
        private final NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyAliasToQualifierMap;

        ResultScannerForAliasedFamilies(ResultScanner resultScanner, NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyAliasToQualifierMap) {
            this.wrappedResultScanner = resultScanner;
            this.familyAliasToQualifierMap = familyAliasToQualifierMap;
        }

        public Result next() throws IOException {
            return MTable.this.repository.convertAliasesToQualifiers(this.wrappedResultScanner.next(), this.familyAliasToQualifierMap);
        }

        public Result[] next(int i) throws IOException {
            LinkedList<Result> convertedResultList = new LinkedList<Result>();
            for (Result originalResult : this.wrappedResultScanner.next(i)) {
                convertedResultList.add(MTable.this.repository.convertAliasesToQualifiers(originalResult, this.familyAliasToQualifierMap));
            }
            return convertedResultList.toArray(new Result[convertedResultList.size()]);
        }

        public void close() {
            this.wrappedResultScanner.close();
        }

        public Iterator<Result> iterator() {
            return new MResultIterator(this.wrappedResultScanner.iterator());
        }

        class MResultIterator
        implements Iterator<Result> {
            private final Iterator<Result> wrappedIterator;

            MResultIterator(Iterator<Result> wrappedIterator) {
                this.wrappedIterator = wrappedIterator;
            }

            @Override
            public boolean hasNext() {
                return this.wrappedIterator.hasNext();
            }

            @Override
            public Result next() {
                return MTable.this.repository.convertAliasesToQualifiers(this.wrappedIterator.next(), ResultScannerForAliasedFamilies.this.familyAliasToQualifierMap);
            }
        }
    }
}

