/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.commonvox.hbase_column_manager.MConnectionFactory;

public class MHBaseTestingUtility
extends HBaseTestingUtility {
    private volatile Connection connection = null;
    private Admin admin = null;

    public MHBaseTestingUtility() {
        this(HBaseConfiguration.create());
    }

    public MHBaseTestingUtility(Configuration conf) {
        super(conf);
        if (conf != null) {
            conf.addResource("hbase-column-manager.xml");
            if (conf.getInt("hbase.master.info.port", 16010) == 16010) {
                conf.setInt("hbase.master.info.port", -1);
                LOG.debug((Object)"Config property hbase.master.info.port changed to -1");
            }
            if (conf.getInt("hbase.regionserver.port", 16020) == 16020) {
                conf.setInt("hbase.regionserver.port", -1);
                LOG.debug((Object)"Config property hbase.regionserver.port changed to -1");
            }
        }
    }

    public Connection getConnection() throws IOException {
        if (this.connection == null) {
            this.connection = MConnectionFactory.createConnection(this.conf);
        }
        return this.connection;
    }

    public synchronized HBaseAdmin getHBaseAdmin() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ColumnManagerAPI does not support this method, deprecated as of HBase 2.0.");
    }

    public synchronized Admin getAdmin() throws IOException {
        if (this.admin == null) {
            this.admin = this.getConnection().getAdmin();
        }
        return this.admin;
    }
}

