/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Pair;
import org.commonvox.hbase_column_manager.Repository;

class MAdmin
implements Admin {
    private final Admin wrappedHbaseAdmin;
    private final Repository repository;
    private static final String UNSUPPORTED_WHEN_COLMANAGER_ACTIVATED_MSG = "Method not supported when ColumnManager repository is ACTIVATED.";
    private static final String UNSUPPORTED_MASS_DISABLE_DELETE_METHOD = " This method's signature does not properly and explicitly support namespaces, and its use could accidently disable or delete ColumnManager table(s).";

    MAdmin(Admin hBaseAdmin, Repository repository) {
        this.wrappedHbaseAdmin = hBaseAdmin;
        this.repository = repository;
    }

    Admin getWrappedAdmin() {
        return this.wrappedHbaseAdmin;
    }

    public void createTable(HTableDescriptor htd) throws IOException {
        this.wrappedHbaseAdmin.createTable(htd);
        if (this.repository.isActivated()) {
            this.repository.putTableSchemaEntity(htd);
        }
    }

    public void createTable(HTableDescriptor htd, byte[] bytes, byte[] bytes1, int i) throws IOException {
        this.wrappedHbaseAdmin.createTable(htd, bytes, bytes1, i);
        if (this.repository.isActivated()) {
            this.repository.putTableSchemaEntity(htd);
        }
    }

    public void createTable(HTableDescriptor htd, byte[][] bytes) throws IOException {
        this.wrappedHbaseAdmin.createTable(htd, bytes);
        if (this.repository.isActivated()) {
            this.repository.putTableSchemaEntity(htd);
        }
    }

    public void createTableAsync(HTableDescriptor htd, byte[][] bytes) throws IOException {
        if (this.repository.isActivated()) {
            throw new UnsupportedOperationException(UNSUPPORTED_WHEN_COLMANAGER_ACTIVATED_MSG);
        }
        this.wrappedHbaseAdmin.createTableAsync(htd, bytes);
    }

    public void deleteTable(TableName tn) throws IOException {
        this.wrappedHbaseAdmin.deleteTable(tn);
        if (this.repository.isActivated()) {
            this.repository.deleteTableSchemaEntity(tn);
        }
    }

    public HTableDescriptor[] deleteTables(String tableNameRegex) throws IOException {
        if (this.repository.isActivated()) {
            throw new UnsupportedOperationException("Method not supported when ColumnManager repository is ACTIVATED. This method's signature does not properly and explicitly support namespaces, and its use could accidently disable or delete ColumnManager table(s).");
        }
        return this.wrappedHbaseAdmin.deleteTables(tableNameRegex);
    }

    public HTableDescriptor[] deleteTables(Pattern ptrn) throws IOException {
        if (this.repository.isActivated()) {
            throw new UnsupportedOperationException("Method not supported when ColumnManager repository is ACTIVATED. This method's signature does not properly and explicitly support namespaces, and its use could accidently disable or delete ColumnManager table(s).");
        }
        return this.wrappedHbaseAdmin.deleteTables(ptrn);
    }

    public HTableDescriptor[] disableTables(String string) throws IOException {
        if (this.repository.isActivated()) {
            throw new UnsupportedOperationException("Method not supported when ColumnManager repository is ACTIVATED. This method's signature does not properly and explicitly support namespaces, and its use could accidently disable or delete ColumnManager table(s).");
        }
        return this.wrappedHbaseAdmin.disableTables(string);
    }

    public HTableDescriptor[] disableTables(Pattern ptrn) throws IOException {
        if (this.repository.isActivated()) {
            throw new UnsupportedOperationException("Method not supported when ColumnManager repository is ACTIVATED. This method's signature does not properly and explicitly support namespaces, and its use could accidently disable or delete ColumnManager table(s).");
        }
        return this.wrappedHbaseAdmin.disableTables(ptrn);
    }

    public void truncateTable(TableName tn, boolean bln) throws IOException {
        this.wrappedHbaseAdmin.truncateTable(tn, bln);
        if (this.repository.isActivated()) {
            this.repository.truncateTableColumns(tn);
        }
    }

    public void addColumn(TableName tn, HColumnDescriptor hcd) throws IOException {
        this.wrappedHbaseAdmin.addColumn(tn, hcd);
        if (this.repository.isActivated()) {
            this.repository.putColumnFamilySchemaEntity(tn, hcd);
        }
    }

    public void addColumnFamily(TableName tn, HColumnDescriptor hcd) throws IOException {
        this.wrappedHbaseAdmin.addColumn(tn, hcd);
        if (this.repository.isActivated()) {
            this.repository.putColumnFamilySchemaEntity(tn, hcd);
        }
    }

    public void modifyColumn(TableName tn, HColumnDescriptor hcd) throws IOException {
        this.wrappedHbaseAdmin.modifyColumn(tn, hcd);
        if (this.repository.isActivated()) {
            this.repository.putColumnFamilySchemaEntity(tn, hcd);
        }
    }

    public void modifyColumnFamily(TableName tn, HColumnDescriptor hcd) throws IOException {
        this.wrappedHbaseAdmin.modifyColumn(tn, hcd);
        if (this.repository.isActivated()) {
            this.repository.putColumnFamilySchemaEntity(tn, hcd);
        }
    }

    public void deleteColumn(TableName tn, byte[] name) throws IOException {
        this.wrappedHbaseAdmin.deleteColumn(tn, name);
        if (this.repository.isActivated()) {
            this.repository.deleteColumnFamily(tn, name);
        }
    }

    public void deleteColumnFamily(TableName tn, byte[] name) throws IOException {
        this.wrappedHbaseAdmin.deleteColumn(tn, name);
        if (this.repository.isActivated()) {
            this.repository.deleteColumnFamily(tn, name);
        }
    }

    public void modifyTable(TableName tn, HTableDescriptor htd) throws IOException {
        this.wrappedHbaseAdmin.modifyTable(tn, htd);
        if (this.repository.isActivated()) {
            this.repository.putTableSchemaEntity(htd);
        }
    }

    public void createNamespace(NamespaceDescriptor nd) throws IOException {
        this.wrappedHbaseAdmin.createNamespace(nd);
        if (this.repository.isActivated()) {
            this.repository.putNamespaceSchemaEntity(nd);
        }
    }

    public void modifyNamespace(NamespaceDescriptor nd) throws IOException {
        this.wrappedHbaseAdmin.modifyNamespace(nd);
        if (this.repository.isActivated()) {
            this.repository.putNamespaceSchemaEntity(nd);
        }
    }

    public void deleteNamespace(String string) throws IOException {
        this.wrappedHbaseAdmin.deleteNamespace(string);
        if (this.repository.isActivated()) {
            this.repository.deleteNamespaceSchemaEntity(string);
        }
    }

    public int getOperationTimeout() {
        return this.wrappedHbaseAdmin.getOperationTimeout();
    }

    public void abort(String string, Throwable thrwbl) {
        this.wrappedHbaseAdmin.abort(string, thrwbl);
    }

    public boolean isAborted() {
        return this.wrappedHbaseAdmin.isAborted();
    }

    public Connection getConnection() {
        return this.wrappedHbaseAdmin.getConnection();
    }

    public boolean tableExists(TableName tn) throws IOException {
        return this.wrappedHbaseAdmin.tableExists(tn);
    }

    public HTableDescriptor getTableDescriptor(TableName tn) throws TableNotFoundException, IOException {
        return this.wrappedHbaseAdmin.getTableDescriptor(tn);
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.wrappedHbaseAdmin.listTables();
    }

    public HTableDescriptor[] listTables(Pattern ptrn) throws IOException {
        return this.wrappedHbaseAdmin.listTables(ptrn);
    }

    public HTableDescriptor[] listTables(String string) throws IOException {
        return this.wrappedHbaseAdmin.listTables(string);
    }

    public HTableDescriptor[] listTables(Pattern ptrn, boolean bln) throws IOException {
        return this.wrappedHbaseAdmin.listTables(ptrn, bln);
    }

    public HTableDescriptor[] listTables(String string, boolean bln) throws IOException {
        return this.wrappedHbaseAdmin.listTables(string, bln);
    }

    public TableName[] listTableNames() throws IOException {
        return this.wrappedHbaseAdmin.listTableNames();
    }

    public TableName[] listTableNames(Pattern ptrn) throws IOException {
        return this.wrappedHbaseAdmin.listTableNames(ptrn);
    }

    public TableName[] listTableNames(String string) throws IOException {
        return this.wrappedHbaseAdmin.listTableNames(string);
    }

    public TableName[] listTableNames(Pattern ptrn, boolean bln) throws IOException {
        return this.wrappedHbaseAdmin.listTableNames(ptrn, bln);
    }

    public TableName[] listTableNames(String string, boolean bln) throws IOException {
        return this.wrappedHbaseAdmin.listTableNames(string, bln);
    }

    public void enableTable(TableName tn) throws IOException {
        this.wrappedHbaseAdmin.enableTable(tn);
    }

    public void enableTableAsync(TableName tn) throws IOException {
        this.wrappedHbaseAdmin.enableTableAsync(tn);
    }

    public HTableDescriptor[] enableTables(String string) throws IOException {
        return this.wrappedHbaseAdmin.enableTables(string);
    }

    public HTableDescriptor[] enableTables(Pattern ptrn) throws IOException {
        return this.wrappedHbaseAdmin.enableTables(ptrn);
    }

    public void disableTableAsync(TableName tn) throws IOException {
        this.wrappedHbaseAdmin.disableTableAsync(tn);
    }

    public void disableTable(TableName tn) throws IOException {
        this.wrappedHbaseAdmin.disableTable(tn);
    }

    public boolean isTableEnabled(TableName tn) throws IOException {
        return this.wrappedHbaseAdmin.isTableEnabled(tn);
    }

    public boolean isTableDisabled(TableName tn) throws IOException {
        return this.wrappedHbaseAdmin.isTableDisabled(tn);
    }

    public boolean isTableAvailable(TableName tn) throws IOException {
        return this.wrappedHbaseAdmin.isTableAvailable(tn);
    }

    public boolean isTableAvailable(TableName tn, byte[][] bytes) throws IOException {
        return this.wrappedHbaseAdmin.isTableAvailable(tn, bytes);
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tn) throws IOException {
        return this.wrappedHbaseAdmin.getAlterStatus(tn);
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] bytes) throws IOException {
        return this.wrappedHbaseAdmin.getAlterStatus(bytes);
    }

    public void closeRegion(String string, String string1) throws IOException {
        this.wrappedHbaseAdmin.closeRegion(string, string1);
    }

    public void closeRegion(byte[] bytes, String string) throws IOException {
        this.wrappedHbaseAdmin.closeRegion(bytes, string);
    }

    public boolean closeRegionWithEncodedRegionName(String string, String string1) throws IOException {
        return this.wrappedHbaseAdmin.closeRegionWithEncodedRegionName(string, string1);
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        this.wrappedHbaseAdmin.closeRegion(sn, hri);
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        return this.wrappedHbaseAdmin.getOnlineRegions(sn);
    }

    public void flush(TableName tn) throws IOException {
        this.wrappedHbaseAdmin.flush(tn);
    }

    public void flushRegion(byte[] bytes) throws IOException {
        this.wrappedHbaseAdmin.flushRegion(bytes);
    }

    public void compact(TableName tn) throws IOException {
        this.wrappedHbaseAdmin.compact(tn);
    }

    public void compactRegion(byte[] bytes) throws IOException {
        this.wrappedHbaseAdmin.compactRegion(bytes);
    }

    public void compact(TableName tn, byte[] bytes) throws IOException {
        this.wrappedHbaseAdmin.compact(tn, bytes);
    }

    public void compactRegion(byte[] bytes, byte[] bytes1) throws IOException {
        this.wrappedHbaseAdmin.compactRegion(bytes, bytes1);
    }

    public void majorCompact(TableName tn) throws IOException {
        this.wrappedHbaseAdmin.majorCompact(tn);
    }

    public void majorCompactRegion(byte[] bytes) throws IOException {
        this.wrappedHbaseAdmin.majorCompactRegion(bytes);
    }

    public void majorCompact(TableName tn, byte[] bytes) throws IOException {
        this.wrappedHbaseAdmin.majorCompact(tn, bytes);
    }

    public void majorCompactRegion(byte[] bytes, byte[] bytes1) throws IOException {
        this.wrappedHbaseAdmin.majorCompactRegion(bytes, bytes1);
    }

    public void compactRegionServer(ServerName sn, boolean bln) throws IOException, InterruptedException {
        this.wrappedHbaseAdmin.compactRegionServer(sn, bln);
    }

    public void move(byte[] bytes, byte[] bytes1) throws IOException {
        this.wrappedHbaseAdmin.move(bytes, bytes1);
    }

    public void assign(byte[] bytes) throws IOException {
        this.wrappedHbaseAdmin.assign(bytes);
    }

    public void unassign(byte[] bytes, boolean bln) throws IOException {
        this.wrappedHbaseAdmin.unassign(bytes, bln);
    }

    public void offline(byte[] bytes) throws IOException {
        this.wrappedHbaseAdmin.offline(bytes);
    }

    public boolean setBalancerRunning(boolean bln, boolean bln1) throws IOException {
        return this.wrappedHbaseAdmin.setBalancerRunning(bln, bln1);
    }

    public boolean balancer() throws IOException {
        return this.wrappedHbaseAdmin.balancer();
    }

    public boolean enableCatalogJanitor(boolean bln) throws IOException {
        return this.wrappedHbaseAdmin.enableCatalogJanitor(bln);
    }

    public int runCatalogScan() throws IOException {
        return this.wrappedHbaseAdmin.runCatalogScan();
    }

    public boolean isCatalogJanitorEnabled() throws IOException {
        return this.wrappedHbaseAdmin.isCatalogJanitorEnabled();
    }

    public void mergeRegions(byte[] bytes, byte[] bytes1, boolean bln) throws IOException {
        this.wrappedHbaseAdmin.mergeRegions(bytes, bytes1, bln);
    }

    public void split(TableName tn) throws IOException {
        this.wrappedHbaseAdmin.split(tn);
    }

    public void splitRegion(byte[] bytes) throws IOException {
        this.wrappedHbaseAdmin.splitRegion(bytes);
    }

    public void split(TableName tn, byte[] bytes) throws IOException {
        this.wrappedHbaseAdmin.split(tn, bytes);
    }

    public void splitRegion(byte[] bytes, byte[] bytes1) throws IOException {
        this.wrappedHbaseAdmin.splitRegion(bytes, bytes1);
    }

    public void shutdown() throws IOException {
        this.wrappedHbaseAdmin.shutdown();
    }

    public void stopMaster() throws IOException {
        this.wrappedHbaseAdmin.stopMaster();
    }

    public void stopRegionServer(String string) throws IOException {
        this.wrappedHbaseAdmin.stopRegionServer(string);
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return this.wrappedHbaseAdmin.getClusterStatus();
    }

    public Configuration getConfiguration() {
        return this.wrappedHbaseAdmin.getConfiguration();
    }

    public NamespaceDescriptor getNamespaceDescriptor(String string) throws IOException {
        return this.wrappedHbaseAdmin.getNamespaceDescriptor(string);
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        return this.wrappedHbaseAdmin.listNamespaceDescriptors();
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String string) throws IOException {
        return this.wrappedHbaseAdmin.listTableDescriptorsByNamespace(string);
    }

    public TableName[] listTableNamesByNamespace(String string) throws IOException {
        return this.wrappedHbaseAdmin.listTableNamesByNamespace(string);
    }

    public List<HRegionInfo> getTableRegions(TableName tn) throws IOException {
        return this.wrappedHbaseAdmin.getTableRegions(tn);
    }

    public void close() throws IOException {
        this.wrappedHbaseAdmin.close();
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> list) throws IOException {
        return this.wrappedHbaseAdmin.getTableDescriptorsByTableName(list);
    }

    public HTableDescriptor[] getTableDescriptors(List<String> list) throws IOException {
        return this.wrappedHbaseAdmin.getTableDescriptors(list);
    }

    public void rollWALWriter(ServerName sn) throws IOException, FailedLogCloseException {
        this.wrappedHbaseAdmin.rollWALWriter(sn);
    }

    public String[] getMasterCoprocessors() throws IOException {
        return this.wrappedHbaseAdmin.getMasterCoprocessors();
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tn) throws IOException {
        return this.wrappedHbaseAdmin.getCompactionState(tn);
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] bytes) throws IOException {
        return this.wrappedHbaseAdmin.getCompactionStateForRegion(bytes);
    }

    public void snapshot(String string, TableName tn) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.wrappedHbaseAdmin.snapshot(string, tn);
    }

    public void snapshot(byte[] name, TableName tn) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.wrappedHbaseAdmin.snapshot(name, tn);
    }

    public void snapshot(String string, TableName tn, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.wrappedHbaseAdmin.snapshot(string, tn, type);
    }

    public void snapshot(HBaseProtos.SnapshotDescription sd) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.wrappedHbaseAdmin.snapshot(sd);
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription sd) throws IOException, SnapshotCreationException {
        return this.wrappedHbaseAdmin.takeSnapshotAsync(sd);
    }

    public boolean isSnapshotFinished(HBaseProtos.SnapshotDescription sd) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        return this.wrappedHbaseAdmin.isSnapshotFinished(sd);
    }

    public void restoreSnapshot(byte[] name) throws IOException, RestoreSnapshotException, UnsupportedOperationException {
        if (this.repository.isActivated()) {
            throw new UnsupportedOperationException(UNSUPPORTED_WHEN_COLMANAGER_ACTIVATED_MSG);
        }
        this.wrappedHbaseAdmin.restoreSnapshot(name);
    }

    public void restoreSnapshot(String string) throws IOException, RestoreSnapshotException, UnsupportedOperationException {
        if (this.repository.isActivated()) {
            throw new UnsupportedOperationException(UNSUPPORTED_WHEN_COLMANAGER_ACTIVATED_MSG);
        }
        this.wrappedHbaseAdmin.restoreSnapshot(string);
    }

    public void restoreSnapshot(byte[] name, boolean bln) throws IOException, RestoreSnapshotException, UnsupportedOperationException {
        if (this.repository.isActivated()) {
            throw new UnsupportedOperationException(UNSUPPORTED_WHEN_COLMANAGER_ACTIVATED_MSG);
        }
        this.wrappedHbaseAdmin.restoreSnapshot(name, bln);
    }

    public void restoreSnapshot(String string, boolean bln) throws IOException, RestoreSnapshotException, UnsupportedOperationException {
        if (this.repository.isActivated()) {
            throw new UnsupportedOperationException(UNSUPPORTED_WHEN_COLMANAGER_ACTIVATED_MSG);
        }
        this.wrappedHbaseAdmin.restoreSnapshot(string, bln);
    }

    public void cloneSnapshot(byte[] name, TableName tn) throws IOException, TableExistsException, RestoreSnapshotException, UnsupportedOperationException {
        if (this.repository.isActivated()) {
            throw new UnsupportedOperationException(UNSUPPORTED_WHEN_COLMANAGER_ACTIVATED_MSG);
        }
        this.wrappedHbaseAdmin.cloneSnapshot(name, tn);
    }

    public void cloneSnapshot(String string, TableName tn) throws IOException, TableExistsException, RestoreSnapshotException, UnsupportedOperationException {
        if (this.repository.isActivated()) {
            throw new UnsupportedOperationException(UNSUPPORTED_WHEN_COLMANAGER_ACTIVATED_MSG);
        }
        this.wrappedHbaseAdmin.cloneSnapshot(string, tn);
    }

    public void execProcedure(String string, String string1, Map<String, String> map) throws IOException {
        this.wrappedHbaseAdmin.execProcedure(string, string1, map);
    }

    public byte[] execProcedureWithRet(String string, String string1, Map<String, String> map) throws IOException {
        return this.wrappedHbaseAdmin.execProcedureWithRet(string, string1, map);
    }

    public boolean isProcedureFinished(String string, String string1, Map<String, String> map) throws IOException {
        return this.wrappedHbaseAdmin.isProcedureFinished(string, string1, map);
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        return this.wrappedHbaseAdmin.listSnapshots();
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String string) throws IOException {
        return this.wrappedHbaseAdmin.listSnapshots(string);
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern ptrn) throws IOException {
        return this.wrappedHbaseAdmin.listSnapshots(ptrn);
    }

    public void deleteSnapshot(byte[] name) throws IOException {
        this.wrappedHbaseAdmin.deleteSnapshot(name);
    }

    public void deleteSnapshot(String string) throws IOException {
        this.wrappedHbaseAdmin.deleteSnapshot(string);
    }

    public void deleteSnapshots(String string) throws IOException {
        this.wrappedHbaseAdmin.deleteSnapshots(string);
    }

    public void deleteSnapshots(Pattern ptrn) throws IOException {
        this.wrappedHbaseAdmin.deleteSnapshots(ptrn);
    }

    public CoprocessorRpcChannel coprocessorService() {
        return this.wrappedHbaseAdmin.coprocessorService();
    }

    public CoprocessorRpcChannel coprocessorService(ServerName sn) {
        return this.wrappedHbaseAdmin.coprocessorService(sn);
    }

    public void updateConfiguration(ServerName sn) throws IOException {
        this.wrappedHbaseAdmin.updateConfiguration(sn);
    }

    public void updateConfiguration() throws IOException {
        this.wrappedHbaseAdmin.updateConfiguration();
    }

    public int getMasterInfoPort() throws IOException {
        return this.wrappedHbaseAdmin.getMasterInfoPort();
    }

    public boolean equals(Object otherObject) {
        return this.wrappedHbaseAdmin.equals(otherObject);
    }

    public int hashCode() {
        return this.wrappedHbaseAdmin.hashCode();
    }

    public boolean isBalancerEnabled() throws IOException {
        return this.wrappedHbaseAdmin.isBalancerEnabled();
    }

    public long getLastMajorCompactionTimestamp(TableName tn) throws IOException {
        return this.wrappedHbaseAdmin.getLastMajorCompactionTimestamp(tn);
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] bytes) throws IOException {
        return this.wrappedHbaseAdmin.getLastMajorCompactionTimestampForRegion(bytes);
    }

    public void setQuota(QuotaSettings qs) throws IOException {
        this.wrappedHbaseAdmin.setQuota(qs);
    }

    public QuotaRetriever getQuotaRetriever(QuotaFilter qf) throws IOException {
        return this.wrappedHbaseAdmin.getQuotaRetriever(qf);
    }
}

