/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import org.commonvox.hbase_column_manager.ColumnDefinition;
import org.commonvox.hbase_column_manager.MColumnDescriptor;
import org.commonvox.hbase_column_manager.MConfiguration;
import org.commonvox.hbase_column_manager.MConnection;
import org.commonvox.hbase_column_manager.MConnectionFactory;
import org.commonvox.hbase_column_manager.MTableDescriptor;
import org.commonvox.hbase_column_manager.Repository;

class ColumnInvalidityReport
implements Closeable,
AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(ColumnInvalidityReport.class);
    private static final Logger STATIC_LOGGER = Logger.getLogger(ColumnInvalidityReport.class);
    static final CSVFormat SUMMARY_CSV_FORMAT = CSVFormat.DEFAULT.withRecordSeparator("\n").withCommentMarker('#').withHeader(SummaryReportHeader.class);
    static final CSVFormat VERBOSE_CSV_FORMAT = CSVFormat.DEFAULT.withRecordSeparator("\n").withCommentMarker('#').withHeader(VerboseReportHeader.class);
    static final String TEMP_REPORT_NAMESPACE = "__column_manager_temp_reports";
    private static final String TEMP_REPORT_TABLENAME_PREFIX = "temp_report_table_";
    private static final byte[] TEMP_REPORT_CF = Bytes.toBytes((String)"cr");
    private static final byte ROW_ID_DELIMITER = 58;
    private static final String ROW_ID_DELIMITER_STRING = String.valueOf(':');
    private static final String TABLE_NAME_ARG_KEY = "--sourceTable=";
    private final Connection standardConnection;
    private final Admin standardAdmin;
    private final MTableDescriptor sourceMtd;
    private final Table sourceTable;
    private final byte[] sourceColFamily;
    private final Table tempReportTable;
    private final File targetFile;
    private final boolean verboseReport;
    private final boolean includeAllCells;
    private final boolean invokedByMapper;
    private final ReportType reportType;

    ColumnInvalidityReport(ReportType reportType, Connection connection, MTableDescriptor sourceTableDescriptor, byte[] sourceColFamily, File targetFile, boolean verbose, boolean includeAllCells, boolean useMapreduce) throws Exception {
        this.reportType = reportType;
        this.targetFile = targetFile;
        this.standardConnection = MConnection.class.isAssignableFrom(connection.getClass()) ? ((MConnection)connection).getStandardConnection() : connection;
        this.standardAdmin = this.standardConnection.getAdmin();
        ColumnInvalidityReport.createTempReportNamespace(this.standardAdmin);
        this.sourceMtd = sourceTableDescriptor;
        this.sourceTable = connection.getTable(sourceTableDescriptor.getTableName());
        this.sourceColFamily = sourceColFamily;
        TableName tempReportTableName = TableName.valueOf((String)TEMP_REPORT_NAMESPACE, (String)(TEMP_REPORT_TABLENAME_PREFIX + new Timestamp(System.currentTimeMillis()).toString().replaceAll("[\\.\\-: ]", "")));
        this.standardAdmin.createTable(new HTableDescriptor(tempReportTableName).addFamily(new HColumnDescriptor(TEMP_REPORT_CF).setMaxVersions(9999)));
        this.tempReportTable = this.standardConnection.getTable(tempReportTableName);
        this.verboseReport = verbose;
        this.includeAllCells = includeAllCells;
        this.invokedByMapper = false;
        if (useMapreduce) {
            this.collectReportMetadataViaMapreduce();
        } else {
            this.collectReportMetadataViaDirectScan();
        }
    }

    ColumnInvalidityReport(ReportType reportType, Connection connection, MTableDescriptor sourceTableDescriptor, TableName tempReportTableName, boolean verbose, boolean includeAllCells) throws IOException {
        this.reportType = reportType;
        this.targetFile = null;
        this.standardConnection = MConnection.class.isAssignableFrom(connection.getClass()) ? ((MConnection)connection).getStandardConnection() : connection;
        this.standardAdmin = connection.getAdmin();
        this.sourceMtd = sourceTableDescriptor;
        this.sourceTable = this.standardConnection.getTable(sourceTableDescriptor.getTableName());
        this.sourceColFamily = null;
        this.tempReportTable = this.standardConnection.getTable(tempReportTableName);
        this.verboseReport = verbose;
        this.includeAllCells = includeAllCells;
        this.invokedByMapper = true;
    }

    private void collectReportMetadataViaDirectScan() throws IOException {
        Scan scan = new Scan();
        if (!this.verboseReport && !this.reportType.equals((Object)ReportType.VALUE)) {
            scan.setFilter((Filter)new KeyOnlyFilter(true));
        }
        if (this.includeAllCells) {
            scan.setMaxVersions();
        }
        if (this.sourceColFamily != null) {
            scan.addFamily(this.sourceColFamily);
        }
        try (ResultScanner rows = this.sourceTable.getScanner(scan);){
            for (Result row : rows) {
                this.doSourceRowProcessing(row);
            }
        }
    }

    void doSourceRowProcessing(Result row) throws IOException {
        for (Map.Entry familyToColumnsMapEntry : row.getMap().entrySet()) {
            MColumnDescriptor mcd = this.sourceMtd.getMColumnDescriptor((byte[])familyToColumnsMapEntry.getKey());
            if (mcd == null || mcd.getColumnDefinitions().isEmpty()) continue;
            for (Map.Entry colEntry : ((NavigableMap)familyToColumnsMapEntry.getValue()).entrySet()) {
                byte[] colQualifier = (byte[])colEntry.getKey();
                ColumnDefinition colDef = mcd.getColumnDefinition(colQualifier);
                for (Map.Entry cellEntry : ((NavigableMap)colEntry.getValue()).entrySet()) {
                    byte[] cellValue = (byte[])cellEntry.getValue();
                    boolean invalidRow = false;
                    switch (this.reportType) {
                        case QUALIFIER: {
                            if (colDef != null) break;
                            invalidRow = true;
                            break;
                        }
                        case LENGTH: {
                            if (colDef == null || colDef.getColumnLength() <= 0L) break;
                            if (this.verboseReport) {
                                if ((long)cellValue.length <= colDef.getColumnLength()) break;
                                invalidRow = true;
                                break;
                            }
                            if ((long)Bytes.toInt((byte[])cellValue) <= colDef.getColumnLength()) break;
                            invalidRow = true;
                            break;
                        }
                        case VALUE: {
                            if (colDef == null || colDef.getColumnValidationRegex().isEmpty() || Bytes.toString((byte[])cellValue).matches(colDef.getColumnValidationRegex())) break;
                            invalidRow = true;
                        }
                    }
                    if (!invalidRow) continue;
                    this.tempReportTable.put(new Put(this.buildRowId(mcd.getName(), colQualifier)).addColumn(TEMP_REPORT_CF, row.getRow(), ((Long)cellEntry.getKey()).longValue(), cellValue.length < 200 ? cellValue : Bytes.add((byte[])Bytes.head((byte[])cellValue, (int)200), (byte[])Bytes.toBytes((String)"[value-truncated]"))));
                }
            }
        }
    }

    private byte[] buildRowId(byte[] colFamily, byte[] colQualifier) {
        ByteBuffer rowId = ByteBuffer.allocate(3 + this.sourceTable.getName().getNamespace().length + this.sourceTable.getName().getQualifier().length + colFamily.length + colQualifier.length);
        rowId.put(this.sourceTable.getName().getNamespace()).put((byte)58).put(this.sourceTable.getName().getQualifier()).put((byte)58).put(colFamily).put((byte)58).put(colQualifier);
        return rowId.array();
    }

    private String[] parseRowId(byte[] rowId) {
        return Bytes.toString((byte[])rowId).split(ROW_ID_DELIMITER_STRING, 4);
    }

    boolean isEmpty() {
        boolean reportIsEmpty;
        try (ResultScanner pingScan = this.tempReportTable.getScanner(new Scan().setMaxResultSize(1L));){
            reportIsEmpty = pingScan.next() == null;
        }
        catch (IOException e) {
            reportIsEmpty = true;
        }
        return reportIsEmpty;
    }

    private void outputReport() throws IOException {
        CSVFormat csvFormat = this.verboseReport ? VERBOSE_CSV_FORMAT : SUMMARY_CSV_FORMAT;
        try (ResultScanner rows = this.tempReportTable.getScanner(new Scan().setMaxVersions());
             CSVPrinter csvPrinter = csvFormat.withHeaderComments((this.verboseReport ? "VERBOSE" : "SUMMARY") + " Report on Invalid Column " + (Object)((Object)this.reportType) + "S in Table <" + this.sourceTable.getName().getNameAsString() + (this.sourceColFamily == null ? "" : ">, ColumnFamily <" + Bytes.toString((byte[])this.sourceColFamily)) + "> -- Generated by " + "ColumnManagerAPI" + ":" + this.getClass().getSimpleName(), new Date()).print(new FileWriter(this.targetFile));){
            for (Result row : rows) {
                String[] reportLineComponents = this.parseRowId(row.getRow());
                NavigableMap tempReportColumnMap = (NavigableMap)row.getMap().firstEntry().getValue();
                if (this.verboseReport) {
                    for (Map.Entry entry : tempReportColumnMap.entrySet()) {
                        for (Map.Entry tempReportCell : ((NavigableMap)entry.getValue()).entrySet()) {
                            for (String reportLineComponent : reportLineComponents) {
                                csvPrinter.print(reportLineComponent);
                            }
                            csvPrinter.print(Repository.getPrintableString((byte[])entry.getKey()));
                            csvPrinter.print(tempReportCell.getKey());
                            csvPrinter.print(Repository.getPrintableString((byte[])tempReportCell.getValue()));
                            csvPrinter.println();
                        }
                    }
                    continue;
                }
                for (String reportLineComponent : reportLineComponents) {
                    csvPrinter.print(reportLineComponent);
                }
                csvPrinter.print(String.valueOf(tempReportColumnMap.size()));
                csvPrinter.println();
            }
        }
    }

    static void createTempReportNamespace(Admin standardAdmin) throws IOException {
        NamespaceDescriptor tempReportNamespaceDescriptor = NamespaceDescriptor.create((String)TEMP_REPORT_NAMESPACE).build();
        if (!Repository.namespaceExists(standardAdmin, tempReportNamespaceDescriptor)) {
            standardAdmin.createNamespace(tempReportNamespaceDescriptor);
            STATIC_LOGGER.info((Object)("ColumnManager TempReport Namespace has been created (did not already exist): " + tempReportNamespaceDescriptor.getName()));
        }
    }

    static void dropTempReportNamespace(Admin standardAdmin) throws IOException {
        if (!Repository.namespaceExists(standardAdmin, Bytes.toBytes((String)TEMP_REPORT_NAMESPACE))) {
            return;
        }
        STATIC_LOGGER.warn((Object)"DROP (disable/delete) of ColumnManagerAPI TempReport tables and namespace has been requested.");
        ColumnInvalidityReport.dropTempReportTables(standardAdmin);
        standardAdmin.deleteNamespace(TEMP_REPORT_NAMESPACE);
        STATIC_LOGGER.warn((Object)"DROP (disable/delete) of ColumnManagerAPI TempReport tables and namespace has been completed: __column_manager_temp_reports");
    }

    static void dropTempReportTables(Admin standardAdmin) throws IOException {
        standardAdmin.disableTables("__column_manager_temp_reports:.*");
        standardAdmin.deleteTables("__column_manager_temp_reports:.*");
    }

    @Override
    public void close() throws IOException {
        this.sourceTable.close();
        this.tempReportTable.close();
        if (!this.invokedByMapper) {
            this.outputReport();
            this.standardAdmin.disableTable(this.tempReportTable.getName());
            this.standardAdmin.deleteTable(this.tempReportTable.getName());
        }
    }

    private void collectReportMetadataViaMapreduce() throws Exception {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("--colmanager.map.source.table=" + this.sourceMtd.getTableName().getNameAsString());
        if (this.sourceColFamily != null) {
            argList.add("--colmanager.map.source.colfamily=" + Bytes.toString((byte[])this.sourceColFamily));
        }
        argList.add("--colmanager.map.report.type=" + this.reportType.name());
        argList.add("--colmanager.map.report.target.temptable=" + this.tempReportTable.getName());
        argList.add("--colmanager.map.report.verbose=" + this.verboseReport);
        argList.add("--colmanager.map.report.include_all_cells=" + this.includeAllCells);
        int jobCompletionCode = ToolRunner.run((Configuration)MConfiguration.create(), (Tool)new ColumnInvalidityReportTool(), (String[])argList.toArray(new String[argList.size()]));
        if (jobCompletionCode != 0) {
            LOGGER.warn((Object)("Mapreduce process failure in " + this.getClass().getSimpleName()));
        }
    }

    static class ColumnInvalidityReportMapper
    extends TableMapper<Text, Text> {
        private static final Logger LOG = Logger.getLogger(ColumnInvalidityReportMapper.class);
        private MConnection columnManagerConnection = null;
        private Repository repository = null;
        private MTableDescriptor sourceMtd;
        private TableName tempReportTableName;
        private boolean verboseReport;
        private boolean includeAllCells;
        private ReportType reportType;
        private ColumnInvalidityReport columnInvalidityReport;

        ColumnInvalidityReportMapper() {
        }

        protected void setup(Mapper.Context context) {
            try {
                this.columnManagerConnection = (MConnection)MConnectionFactory.createConnection();
                this.repository = this.columnManagerConnection.getRepository();
                Configuration jobConfig = context.getConfiguration();
                this.reportType = ReportType.valueOf(jobConfig.get("colmanager.map.report.type"));
                this.sourceMtd = this.repository.getMTableDescriptor(TableName.valueOf((String)jobConfig.get("colmanager.map.source.table")));
                this.tempReportTableName = TableName.valueOf((String)jobConfig.get("colmanager.map.report.target.temptable"));
                this.verboseReport = jobConfig.get("colmanager.map.report.verbose").equalsIgnoreCase(Boolean.TRUE.toString());
                this.includeAllCells = jobConfig.get("colmanager.map.report.include_all_cells").equalsIgnoreCase(Boolean.TRUE.toString());
                this.columnInvalidityReport = new ColumnInvalidityReport(this.reportType, this.columnManagerConnection.getStandardConnection(), this.sourceMtd, this.tempReportTableName, this.verboseReport, this.includeAllCells);
            }
            catch (Exception e) {
                this.columnManagerConnection = null;
                this.repository = null;
                LOG.warn((Object)(((Object)((Object)this)).getClass().getSimpleName() + " failed to initialize due to: " + e.getMessage()));
            }
        }

        protected void cleanup(Mapper.Context context) {
            if (this.columnInvalidityReport != null) {
                try {
                    this.columnInvalidityReport.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.columnManagerConnection != null) {
                try {
                    this.columnManagerConnection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws InterruptedException, IOException {
            if (this.columnManagerConnection == null || this.columnManagerConnection.isClosed() || this.columnManagerConnection.isAborted() || this.repository == null || this.sourceMtd == null) {
                return;
            }
            this.columnInvalidityReport.doSourceRowProcessing(value);
        }
    }

    static class ColumnInvalidityReportTool
    extends Configured
    implements Tool {
        private static final Logger LOG = Logger.getLogger(ColumnInvalidityReportTool.class);
        static final String REPORT_TYPE_CONF_KEY = "colmanager.map.report.type";
        static final String REPORT_VERBOSE_CONF_KEY = "colmanager.map.report.verbose";
        static final String INCLUDE_ALL_CELLS_CONF_KEY = "colmanager.map.report.include_all_cells";
        static final String REPORT_TEMP_TABLE_CONF_KEY = "colmanager.map.report.target.temptable";
        static final String REPORT_TYPE_ARG_KEY = "--colmanager.map.report.type=";
        static final String REPORT_TEMP_TABLE_ARG_KEY = "--colmanager.map.report.target.temptable=";
        static final String REPORT_VERBOSE_ARG_KEY = "--colmanager.map.report.verbose=";
        static final String INCLUDE_ALL_CELLS_ARG_KEY = "--colmanager.map.report.include_all_cells=";
        private String sourceTableNameString = null;
        private byte[] sourceColFamily = null;
        private boolean verboseReport = false;
        private boolean includeAllCells = false;
        private ReportType reportType;

        ColumnInvalidityReportTool() {
        }

        Job createSubmittableJob(String[] args) throws IOException {
            Configuration configFromArgs = this.parseArguments(args);
            if (configFromArgs == null || this.sourceTableNameString == null) {
                return null;
            }
            this.getConf().addResource(configFromArgs);
            this.getConf().setBoolean("mapreduce.map.speculative", true);
            Job job = Job.getInstance((Configuration)this.getConf(), (String)this.getConf().get("mapreduce.job.name", this.sourceTableNameString));
            TableMapReduceUtil.addDependencyJars((Job)job);
            Scan scan = new Scan();
            scan.setCaching(this.getConf().getInt("hbase.mapreduce.scan.cachedrows", 500));
            scan.setCacheBlocks(false);
            if (!this.verboseReport && !this.reportType.equals((Object)ReportType.VALUE)) {
                scan.setFilter((Filter)new KeyOnlyFilter(true));
            }
            if (this.includeAllCells) {
                scan.setMaxVersions();
            }
            if (this.sourceColFamily != null) {
                scan.addFamily(this.sourceColFamily);
            }
            TableMapReduceUtil.initTableMapperJob((String)this.sourceTableNameString, (Scan)scan, ColumnInvalidityReportMapper.class, null, null, (Job)job);
            job.setOutputFormatClass(NullOutputFormat.class);
            return job;
        }

        private Configuration parseArguments(String[] args) {
            if (args.length < 1) {
                return null;
            }
            Configuration configFromArgs = new Configuration();
            for (String arg : args) {
                String[] keyValuePair = arg.substring("--".length()).split("=");
                if (keyValuePair == null || keyValuePair.length != 2) {
                    LOG.warn((Object)("ERROR in MapReduce " + ((Object)((Object)this)).getClass().getSimpleName() + " submission: Invalid argument '" + arg + "'"));
                    return null;
                }
                switch (keyValuePair[0]) {
                    case "colmanager.map.source.table": {
                        this.sourceTableNameString = keyValuePair[1];
                        break;
                    }
                    case "colmanager.map.source.colfamily": {
                        this.sourceColFamily = Bytes.toBytes((String)keyValuePair[1]);
                        break;
                    }
                    case "colmanager.map.report.verbose": {
                        this.verboseReport = keyValuePair[1].equalsIgnoreCase(Boolean.TRUE.toString());
                        break;
                    }
                    case "colmanager.map.report.include_all_cells": {
                        this.includeAllCells = keyValuePair[1].equalsIgnoreCase(Boolean.TRUE.toString());
                        break;
                    }
                    case "colmanager.map.report.type": {
                        this.reportType = ReportType.valueOf(keyValuePair[1]);
                        break;
                    }
                    case "colmanager.map.report.target.temptable": {
                        break;
                    }
                    default: {
                        LOG.warn((Object)("ERROR in MapReduce " + ((Object)((Object)this)).getClass().getSimpleName() + " submission: Invalid argument '" + arg + "'"));
                        return null;
                    }
                }
                configFromArgs.set(keyValuePair[0], keyValuePair[1]);
            }
            return configFromArgs;
        }

        public static void main(String[] args) throws Exception {
            int ret = ToolRunner.run((Configuration)MConfiguration.create(), (Tool)new ColumnInvalidityReportTool(), (String[])args);
            System.exit(ret);
        }

        public int run(String[] args) throws Exception {
            Job job = this.createSubmittableJob(args);
            if (job == null) {
                return 1;
            }
            if (!job.waitForCompletion(true)) {
                LOG.warn((Object)(ColumnInvalidityReportTool.class.getSimpleName() + " mapreduce job failed!"));
                return 1;
            }
            return 0;
        }
    }

    static enum VerboseReportHeader {
        NAMESPACE,
        TABLE,
        COLUMN_FAMILY,
        COLUMN_QUALIFIER,
        ROW_ID,
        CELL_TIMESTAMP,
        CELL_VALUE;

    }

    static enum SummaryReportHeader {
        NAMESPACE,
        TABLE,
        COLUMN_FAMILY,
        COLUMN_QUALIFIER,
        INVALID_OCCURRENCE_COUNT;

    }

    static enum ReportType {
        QUALIFIER,
        LENGTH,
        VALUE;

    }
}

