/*
 * Decompiled with CFR 0.152.
 */
package org.commonvox.hbase_column_manager;

import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.commonvox.hbase_column_manager.Column;
import org.commonvox.hbase_column_manager.Repository;
import org.commonvox.hbase_column_manager.SchemaEntity;
import org.commonvox.hbase_column_manager.SchemaEntityType;

public class ColumnAuditor
extends Column {
    static final String MAX_VALUE_LENGTH_KEY = "MAX_VALUE_LENGTH_FOUND";
    static final byte[] MAX_VALUE_LENGTH_KEY_BYTES = Bytes.toBytes((String)"MAX_VALUE_LENGTH_FOUND");
    static final String COL_COUNTER_KEY = Bytes.toString((byte[])Repository.COL_COUNTER_QUALIFIER);
    static final String CELL_COUNTER_KEY = Bytes.toString((byte[])Repository.CELL_COUNTER_QUALIFIER);
    static final String COL_COUNTER_TIMESTAMP_KEY_STRING = Bytes.toString((byte[])Repository.COL_COUNTER_TIMESTAMP_KEY);
    static final String CELL_COUNTER_TIMESTAMP_KEY_STRING = Bytes.toString((byte[])Repository.CELL_COUNTER_TIMESTAMP_KEY);

    public ColumnAuditor(byte[] columnQualifier) {
        super(SchemaEntityType.COLUMN_AUDITOR.getRecordType(), columnQualifier);
    }

    public ColumnAuditor(String columnQualifier) {
        super(SchemaEntityType.COLUMN_AUDITOR.getRecordType(), columnQualifier);
    }

    ColumnAuditor(SchemaEntity entity) {
        super(SchemaEntityType.COLUMN_AUDITOR.getRecordType(), entity.getName());
        this.setForeignKey(entity.getForeignKey());
        for (Map.Entry<String, String> valueEntry : entity.getValuesStringMap().entrySet()) {
            this.setValue(valueEntry.getKey(), valueEntry.getValue());
        }
        for (Map.Entry<String, String> configEntry : entity.getConfiguration().entrySet()) {
            this.setConfiguration(configEntry.getKey(), configEntry.getValue());
        }
    }

    @Override
    public final ColumnAuditor setValue(String key, String value) {
        super.setValue(key, value);
        return this;
    }

    @Override
    public final ColumnAuditor setValue(byte[] key, byte[] value) {
        super.setValue(key, value);
        return this;
    }

    @Override
    public final ColumnAuditor setValue(ImmutableBytesWritable key, ImmutableBytesWritable value) {
        super.setValue(key, value);
        return this;
    }

    @Override
    public final ColumnAuditor setConfiguration(String key, String value) {
        super.setConfiguration(key, value);
        return this;
    }

    ColumnAuditor setMaxValueLengthFound(long maxValueLengthFound) {
        return this.setValue(MAX_VALUE_LENGTH_KEY, Long.toString(maxValueLengthFound));
    }

    public long getMaxValueLengthFound() {
        String value = this.getValue(MAX_VALUE_LENGTH_KEY);
        return value == null ? 0L : Long.valueOf(value);
    }

    public long getColumnOccurrencesCount() {
        String value = this.getValue(COL_COUNTER_KEY);
        return value == null ? -1L : Long.valueOf(value);
    }

    public long getColumnOccurrencesTimestamp() {
        String value = this.getValue(COL_COUNTER_TIMESTAMP_KEY_STRING);
        return value == null ? 0L : Long.valueOf(value);
    }

    public long getCellOccurrencesCount() {
        String value = this.getValue(CELL_COUNTER_KEY);
        return value == null ? -1L : Long.valueOf(value);
    }

    public long getCellOccurrencesTimestamp() {
        String value = this.getValue(CELL_COUNTER_TIMESTAMP_KEY_STRING);
        return value == null ? 0L : Long.valueOf(value);
    }
}

