/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.storage.pathmapped.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import org.apache.commons.codec.binary.Hex;

public class ChecksumCalculator {
    private final MessageDigest digester;
    private String digestHex;
    private static Provider provider;

    public ChecksumCalculator(String algorithm) throws NoSuchAlgorithmException {
        if (provider == null) {
            this.digester = MessageDigest.getInstance(algorithm);
            provider = this.digester.getProvider();
        } else {
            this.digester = MessageDigest.getInstance(algorithm, provider);
        }
    }

    public final void update(byte[] data) {
        this.digester.update(data);
    }

    public final void update(byte data) {
        this.digester.update(data);
    }

    public final void update(byte[] data, int offset, int len) {
        this.digester.update(data, offset, len);
    }

    public synchronized String getDigestHex() {
        if (this.digestHex == null) {
            this.digestHex = Hex.encodeHexString((byte[])this.digester.digest());
        }
        return this.digestHex;
    }
}

